#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#

from distutils.core import setup

version = '0.1'

# files to install
inst_desktop = ['fotomovil.desktop']
inst_py = ['fotomovil.py', 'EXIF.py', 'wordpress.py']
pixmaps = ['pixmaps/byn.png', 'pixmaps/ciudad.png', 'pixmaps/img-missing.png', 'pixmaps/macro.png', 'pixmaps/naturaleza.png', 'pixmaps/nocturna.png', 'pixmaps/retrato.png']
inst_dbus = ['fotomovil.service']
inst_icon = ['fotomovil.png']
backup_conf  = ['fotomovil.conf']
sh = ['fotomovil']


data_files = [
  ('share/applications/hildon', inst_desktop),
  ('/opt/fotomovil',   inst_py),
  ('/opt/fotomovil/pixmaps',   pixmaps),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'fotomovil',
  version      = version,
  description  = 'Send photos to fotografiamovil.es',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  license      = 'GPL v2 or later at your election',
  platforms    = 'Maemo',
  data_files   = data_files,
  scripts      = sh
)
