#!/usr/bin/env python
# -*- coding: UTF8 -*-
import gtk
import hildon
import gobject
import thread
import os
import osso

import EXIF


fhsize = gtk.HILDON_SIZE_FINGER_HEIGHT
horbtn = hildon.BUTTON_ARRANGEMENT_HORIZONTAL
winprogind = hildon.hildon_gtk_window_set_progress_indicator

catids = {"Blanco y negro": "6",
"Ciudad": "13",
"Detalle": "8",
"Naturaleza": "5",
"Nocturna": "9",
"Retrato": "7"}

ossoc = osso.Context("org.maemo.fotomovil", "0.1", False)


#detect if is ran locally or not
import sys
runningpath = sys.path[0]

if '/opt' in runningpath:
    locally = False
else:
    locally = True

if locally:
    imgdir = 'pixmaps/'
else:
    appdir = '/opt/fotomovil/'
    imgdir = appdir + 'pixmaps/'

HOME = os.path.expanduser("~")
configdir = HOME + '/.fotomovil/'
configfile = configdir + 'config.xml'

if not os.path.exists(configdir):
    os.mkdir(configdir)

gtk.gdk.threads_init()

class FotomovilUI:

    def __init__(self):
        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name("Fotografia Movil")

        self.window = hildon.StackableWindow()
        self.window.set_default_size(800, 480)
        self.window.connect("destroy", self.quit)
        self.program.add_window(self.window)

        self.initialize_vars()

        menu = self.make_menu()
        self.window.set_app_menu(menu)

        vbox = self.initial_screen()
        self.window.add(vbox)

        data = self.load_data()
        if not data:
            self.nombre = ''
            self.email = ''
            self.web = ''
        else:
            self.nombre = data[0]
            self.email = data[1]
            self.web = data[2]

        self.window.show_all()

    def quit(self, widget):
        self.delete_temp_images()
        self.save_data()

        gtk.main_quit()

    def save_data(self):
        from lxml import etree
        root = etree.Element("fotomovil")
        name = etree.SubElement(root, "name")
        email = etree.SubElement(root, "email")
        web = etree.SubElement(root, "web")
        name.text = self.nombre
        email.text = self.email
        web.text = self.web
        xmltext = etree.tostring(root, pretty_print=True)
        try:
            file_object = open(configfile, "w")
            file_object.write(xmltext)
            file_object.close()
        except IOError, (errno, strerror):
            print "Error saving configuration(%s): %s" % (errno, strerror)

    def load_data(self):
        from lxml import etree
        xmltext = self.open_configfile()
        if xmltext:
            root = etree.XML(xmltext)
            name = root.getchildren()[0].text
            if not name:
                name = ''
            email = root.getchildren()[1].text
            if not email:
                email = ''
            web =  root.getchildren()[2].text
            if not web:
                web = ''
            data = [name, email, web]

            return data

        return False

    def open_configfile(self):
        xmltext = False
        try:
            file_object = open(configfile, "r")
            xmltext = file_object.read()
            file_object.close()
        except IOError, (errno, strerror):
            #print "Error loading configuration(%s): %s" % (errno, strerror)
            return xmltext

        return xmltext

    def initialize_vars(self):
        self.imagefile = False
        self.tag = ''

    def make_menu(self):
        menu = hildon.AppMenu()

        button = gtk.Button(u"Nueva fotografía")
        button.connect("clicked", self.on_new_photo)
        menu.append(button)

        menu.show_all()
        return menu

    def on_new_photo(self, widget):
        self.initialize_vars()
        self.entitle.set_text("")
        self.tag = ""
        self.txtPost.get_buffer().set_text("")
        self.imgbutton.set_value("")
        self.image.set_from_file(imgdir + "img-missing.png")
        self.model = ""
        self.puntof = ""
        self.dfocal = ""
        self.expo = ""
        self.flash = ""
        self.veliso = ""
        self.catbtn.set_value("Blanco y negro")

    def initial_screen(self):
        vbox = gtk.VBox()

        hbox = gtk.HBox()

        self.image = gtk.Image()
        self.image.set_from_file(imgdir + "img-missing.png")
        self.imgbutton = hildon.Button(fhsize, horbtn)
        self.imgbutton.set_title(u"Selecciona fotografía")
        self.imgbutton.connect("clicked", self.select_image)

        hbox.pack_start(self.image, True, True, 0)
        hbox.pack_start(self.imgbutton, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        self.entitle = hildon.Entry(fhsize)

        hbox.pack_start(gtk.Label(u"Título   "), False, False, 0)
        hbox.pack_start(self.entitle, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()

        self.txtPost = hildon.TextView()
        self.txtPost.set_wrap_mode(gtk.WRAP_WORD)
        parea = hildon.PannableArea()
        parea.add(self.txtPost)

        hbox.pack_start(gtk.Label("Mensaje"), False, False, 0)
        hbox.pack_start(parea, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.datos_screen)
        button.set_title("Tus datos")
        hbox.pack_start(button, True, True, 0)

        self.catbtn = hildon.PickerButton(fhsize, horbtn)
        self.catbtn.set_title(u"Categoría")
        selector = self.categories_selector()
        self.catbtn.set_selector(selector)
        hbox.pack_start(self.catbtn, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.exif_screen)
        button.set_title("Exif")
        hbox.pack_start(button, True, True, 0)

        button = hildon.Button(fhsize, horbtn)
        button.connect("clicked", self.uploading_post)
        button.set_title(u"Envíar")
        hbox.pack_start(button, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        return vbox

    def datos_screen(self, widget):
        win = hildon.StackableWindow()
        win.set_title("Tus datos")

        vbox = gtk.VBox()

        hbox = gtk.HBox()
        nombre = hildon.Entry(fhsize)
        nombre.set_text(self.nombre)
        nombre.connect("changed", self.change_nombre)

        hbox.pack_start(gtk.Label(u"Nombre"), False, False, 0)
        hbox.pack_start(nombre, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        email = hildon.Entry(fhsize)
        email.set_text(self.email)
        email.connect("changed", self.change_email)

        hbox.pack_start(gtk.Label("Email    "), False, False, 0)
        hbox.pack_start(email, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        hbox = gtk.HBox()
        web = hildon.Entry(fhsize)
        web.set_text(self.web)
        web.connect("changed", self.change_web)

        hbox.pack_start(gtk.Label("Web (opcional)"), False, False, 0)
        hbox.pack_start(web, True, True, 0)
        vbox.pack_start(hbox, False, False, 0)

        win.add(vbox)
        win.show_all()

    def change_nombre(self, entry):
        self.nombre = entry.get_text()

    def change_email(self, entry):
        self.email = entry.get_text()

    def change_web(self, entry):
        self.web = entry.get_text()


    def categories_selector(self):
        selector = hildon.TouchSelector()

        catlist = [["Blanco y negro", imgdir + "byn.png"],
                    ["Ciudad", imgdir + "ciudad.png"],
                    ["Detalle", imgdir + "macro.png"],
                    ["Naturaleza", imgdir + "naturaleza.png"],
                    ["Nocturna", imgdir + "nocturna.png"],
                    ["Retrato", imgdir + "retrato.png"]]

        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING)

        for item in catlist:
            liter = lstore.append()
            lstore.set(liter, 1, item[0], 0, self.set_pix(item[1]))

        renderer = gtk.CellRendererPixbuf()
        column = selector.append_column(lstore, renderer)
        column.add_attribute(renderer, "pixbuf", 0)

        renderer = gtk.CellRendererText()
        column.pack_start(renderer, True)
        column.add_attribute(renderer, "text", 1)
        column.set_property("text-column", 1)

        return selector

    def set_pix(self, filename):
        import gc
        pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        gc.collect()
        return pixbuf

    def select_image(self, widget):
        filename = self.file_browser(self.window)

        if not filename:
            return

        winprogind(self.window, 1)
        thread.start_new_thread(self._do_select_local_image, (filename, widget))

    def _do_select_local_image(self, filename, widget):
        try:
            thumbnail_pixbuf = self.file_to_pixbuf(filename)
            self.image.set_from_pixbuf(thumbnail_pixbuf)
            self.image.show()

            self.imagefile = filename

            #EXIF Flash Fired
            #Image Model N900
            #EXIF FNumber 14/5
            #EXIF FocalLength 26/5
            #EXIF ExposureTime 1/20
            #Image Make Nokia
            #EXIF ISOSpeedRatings 0

            f = open(filename, 'rb')
            tags = EXIF.process_file(f)
            f.close()

            try:
                self.model = "%s %s" % (tags['Image Make'], tags['Image Model'])
            except KeyError:
                self.model = 'N/A'

            if not self.model == 'N/A':
                self.tag = self.model.replace(" ", "").lower()

            try:
                fnum = "%s" % tags['EXIF FNumber']
                fnum1, fnum2 = fnum.split('/')
                fnum1 = float(fnum1)
                fnum2 = float(fnum2)
                fnum = fnum1/fnum2

                self.puntof = "f/%2.1f" % fnum
            except KeyError:
                self.puntof = 'auto'

            try:
                dfoc = "%s" % tags['EXIF FocalLength']
                dfoc1, dfoc2 = dfoc.split('/')
                dfoc1 = float(dfoc1)
                dfoc2 = float(dfoc2)
                dfoc = dfoc1/dfoc2

                self.dfocal = "%2.1f mm" % dfoc
            except KeyError:
                self.dfocal = 'auto'

            try:
                exp = "%s" % tags['EXIF ExposureTime']
                if exp == '0':
                    self.expo = "auto"
                else:
                    exp1, exp2 = exp.split('/')
                    if exp1 == '1':
                        self.expo = "%s s" % exp
                    else:
                        exp1 = float(exp1)
                        exp2 = float(exp2)
                        exp2 = exp2/exp1
                        exp1 = exp1/exp1
                        exp1 = int(exp1)
                        exp2 = int(exp2)
                        exp = str(exp1) + "/" + str(exp2)
                        self.expo = "%s s" % exp
            except KeyError:
                self.expo = 'auto'

            try:
                flash = "%s" % tags['EXIF Flash']
                if flash in ['Fired', 'Fill Fired', 'Auto Fired', 'Fired (?)',
                            'Fired (!)', 'Fill Fired (?)', 'Fill Fired (!)',
                            'Auto Fired (?)', 'Auto Fired (!)']:
                    self.flash = u'Sí'
                else:
                    self.flash = 'No'

            except KeyError:
                self.flash = 'No / auto'

            try:
                self.veliso = "%s" % tags['EXIF ISOSpeedRatings']
            except:
                self.veliso = 'auto'

            name = os.path.basename(filename)

            if len(name) > 29:
                name = name[:26] + '...'
            else:
                name = name

            widget.set_value(name)

            winprogind(self.window, 0)
        except:
            winprogind(self.window, 0)
            self.show_info_banner(widget, u"Error abriendo la fotografía")


    def file_browser(self, window):
        m = hildon.FileSystemModel()
        file_dialog = hildon.FileChooserDialog(self.window,
                        gtk.FILE_CHOOSER_ACTION_OPEN, m)
        file_dialog.set_title(u"Selecciona fotografía")

        file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
        file_dialog.set_current_folder(HOME + "/MyDocs/.images")


        file_dialog.show_all()
        result = file_dialog.run()

        if result == gtk.RESPONSE_OK:
            namefile = file_dialog.get_filename()
        else:
            namefile = False
        file_dialog.destroy()

        return namefile

    def file_to_pixbuf(self, filename):
        new_pixbuf = gtk.gdk.pixbuf_new_from_file(filename)

        ## Scale pixbuf
        w, h, self.rwidth, self.rheight = self.set_thumbnail_size(new_pixbuf)
        image_pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, int(w), int(h))

        del new_pixbuf

        return image_pixbuf

    def set_thumbnail_size(self, pixbuf,):
        pix_width = pixbuf.get_width()
        pix_height = pixbuf.get_height()

        ##Calculate thumbnail size for vertical and horizontal images
        if pix_width > pix_height:
            w = 75
            h = float(pix_height)/float(pix_width) * 75
        elif pix_height > pix_width:
            h = 75
            w = float(pix_width)/float(pix_height) * 75
        elif pix_height == pix_width:
            h = 75
            w = 75
        else:
            print "Pixbuf size can't be calculated."

        if pix_width > pix_height:
            rwidth = 696
            rheight = float(pix_height)/float(pix_width) * 696
        elif pix_height > pix_width:
            rheight = 696
            rwidth = float(pix_width)/float(pix_height) * 696
        elif pix_height == pix_width:
            rheight = 696
            rwidth = 696

        return w, h, rwidth, rheight

    def exif_screen(self, widget):
        if not self.imagefile:
            self.show_info_banner(widget, u"Debes seleccionar una fotografía")
            return

        win = hildon.StackableWindow()
        win.set_title("Etiquetas Exif")

        vbox = gtk.VBox()

        hbox = gtk.HBox()

        modelo = gtk.Label(self.model)

        hbox.pack_start(gtk.Label("Modelo"), True, True, 0)
        hbox.pack_start(modelo, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        puntof = gtk.Label(self.puntof)

        hbox.pack_start(gtk.Label("Punto F"), True, True, 0)
        hbox.pack_start(puntof, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        exp = gtk.Label(self.expo)

        hbox.pack_start(gtk.Label(u"Exposición"), True, True, 0)
        hbox.pack_start(exp, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        veliso = gtk.Label(self.veliso)

        hbox.pack_start(gtk.Label("Velocidad ISO"), True, True, 0)
        hbox.pack_start(veliso, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        dfocal = gtk.Label(self.dfocal)

        hbox.pack_start(gtk.Label("Distancia focal"), True, True, 0)
        hbox.pack_start(dfocal, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        hbox = gtk.HBox()
        flash = gtk.Label(self.flash)

        hbox.pack_start(gtk.Label("Flash"), True, True, 0)
        hbox.pack_start(flash, True, True, 0)
        vbox.pack_start(hbox, True, True, 0)

        win.add(vbox)
        win.show_all()

    def uploading_post(self, widget):
        title = self.entitle.get_text()
        start, end = self.txtPost.get_buffer().get_bounds()

        if not self.imagefile:
            self.show_info_banner(widget, u"Debes seleccionar una fotografía")
            return

        if not title:
            self.show_info_banner(widget, u"Debes escribir un título")
            return

        if not self.nombre:
            self.show_info_banner(widget,
                        "Debes escribir tu nombre en la ventana de Tus datos")
            return

        if not self.email:
            self.show_info_banner(widget,
                        "Debes escribir tu email en la ventana de Tus datos")
            return

        winprogind(self.window, 1)
        thread.start_new_thread(self._do_upload_post, ())


    def _do_upload_post(self):
        import wordpress
        url = 'http://www.fotografiamovil.es/xmlrpc.php'
        user = 'n900'
        password = 'fmn900'
        #url = 'http://mastorytest.wordpress.com/xmlrpc.php'
        #user = 'mastorytest'
        #password = 'llaranes0'

        wpclient = wordpress.create_wordpress_client(url, user, password)

        if wpclient is None:
            winprogind(self.window, 0)
            self.show_info_banner(self.window,
                                "Error conectando a fotografiamovil.es")
            return None

        try:
            post = wordpress.WordPressPost()

            #Title
            post.title = self.entitle.get_text()
            post.password = ''
            post.tags = self.tag
            rwer
            post.allowPings = 'open'
            post.allowComments = 'open'
            post.status = 'draft'
            post.name = ''

            catname = self.catbtn.get_value()
            post.categories = [catids[catname]]
            #post.categories = ['1']

            posttext = self._make_post_treatment(wpclient)
            post.description = posttext

            newpostid = wpclient.newPost(post)

            winprogind(self.window, 0)

            gtk.gdk.threads_enter()
            self.show_info_banner(self.window, u"Fotografía enviada")
            gtk.gdk.threads_leave()

        except Exception, e:
            winprogind(self.window, 0)
            error =  u"Error enviando fotografía"
            try:
                if e[1] == 'Temporary failure in name resolution':
                        error =  u"Error conectando a fotografiamovil.es"
            except:
                pass
            winprogind(self.window, 0)
            gtk.gdk.threads_enter()
            self.show_info_banner(self.window, error)
            gtk.gdk.threads_leave()

    def _make_post_treatment(self, wpclient):
        # <a=Foto URL><img=Foto source /></a>
        #
        # Nombre de la fotografia:
        # Mensaje:
        # Autor:
        # Email:
        # Web:
        #
        # <u>EXIF tags</u>
        # Modelo:
        # Punto F:
        # Exposición:
        # Velocidad ISO:
        # Distancia focal:
        # Flash:

        titulo = self.entitle.get_text()
        start, end = self.txtPost.get_buffer().get_bounds()
        mensaje = self.txtPost.get_buffer().get_text(start, end)

        imgsrc = self.upload_photo(wpclient)

        if self.web == '':
            if mensaje == '':
                template = ('<a href=\"%s\"><img src=\"%s\" /></a>\n\n'
                        '<ul><li><strong>Modelo</strong>: %s</li>'
                        '<li><strong>Punto F</strong>: %s</li>'
                        '<li><strong>Exposición</strong>: %s</li>'
                        '<li><strong>Velocidad ISO</strong>: %s</li>'
                        '<li><strong>Distancia focal</strong>: %s</li>'
                        '<li><strong>Flash</strong>: %s</li></ul>\n'
                        '<strong>Autor</strong>: %s\n'
                        '<strong>Nombre</strong>: %s\n'
                        '<strong>Email</strong>: %s') % (imgsrc, imgsrc,
                        self.model, self.puntof, self.expo, self.veliso,
                        self.dfocal, self.flash, self.nombre, titulo,
                        self.email)

            else:
                template = ('<a href=\"%s\"><img src=\"%s\" /></a>\n\n'
                        '<strong>Mensaje</strong>: %s\n'
                        '<ul><li><strong>Modelo</strong>: %s</li>'
                        '<li><strong>Punto F</strong>: %s</li>'
                        '<li><strong>Exposición</strong>: %s</li>'
                        '<li><strong>Velocidad ISO</strong>: %s</li>'
                        '<li><strong>Distancia focal</strong>: %s</li>'
                        '<li><strong>Flash</strong>: %s</li></ul>\n'
                        '<strong>Autor</strong>: %s\n'
                        '<strong>Nombre</strong>: %s\n'
                        '<strong>Email</strong>: %s') % (imgsrc, imgsrc,
                        mensaje, self.model, self.puntof, self.expo,
                        self.veliso, self.dfocal, self.flash, self.nombre,
                        titulo, self.email)

        else:
            if mensaje == '':
                template = ('<a href=\"%s\"><img src=\"%s\" /></a>\n\n'
                            '<ul><li><strong>Modelo</strong>: %s</li>'
                            '<li><strong>Punto F</strong>: %s</li>'
                            '<li><strong>Exposición</strong>: %s</li>'
                            '<li><strong>Velocidad ISO</strong>: %s</li>'
                            '<li><strong>Distancia focal</strong>: %s</li>'
                            '<li><strong>Flash</strong>: %s</li></ul>\n'
                            '<strong>Autor</strong>: <a href="%s">%s</a>\n'
                            '<strong>Nombre</strong>: %s\n'
                            '<strong>Email:</strong> %s') % (imgsrc, imgsrc, self.model,
                            self.puntof, self.expo, self.veliso, self.dfocal,
                            self.flash,self.web, self.nombre, titulo, self.email)

            else:
                template = ('<a href=\"%s\"><img src=\"%s\" /></a>\n\n'
                            '<strong>Mensaje</strong>: %s\n'
                            '<ul><li><strong>Modelo</strong>: %s</li>'
                            '<li><strong>Punto F</strong>: %s</li>'
                            '<li><strong>Exposición</strong>: %s</li>'
                            '<li><strong>Velocidad ISO</strong>: %s</li>'
                            '<li><strong>Distancia focal</strong>: %s</li>'
                            '<li><strong>Flash</strong>: %s</li></ul>'
                            '<strong>Autor</strong>: <a href="%s">%s</a>\n'
                            '<strong>Nombre</strong>: %s\n'
                            '<strong>Email</strong>: %s') % (imgsrc, imgsrc, mensaje,
                            self.model, self.puntof, self.expo, self.veliso,
                            self.dfocal, self.flash, self.web, self.nombre,
                            titulo, self.email)

        return template


    def upload_photo(self, wpclient):
        imgpath = self.resize_photo()
        imgsrc = wpclient.newMediaObject(imgpath)
        return imgsrc

    def resize_photo(self):
        pixbuf = gtk.gdk.pixbuf_new_from_file(self.imagefile)
        pixbuf = pixbuf.scale_simple(int(self.rwidth), int(self.rheight),
                gtk.gdk.INTERP_BILINEAR)

        imgpath = self.create_temp_image(pixbuf)
        return imgpath

    def create_temp_image(self, pixbuf):
        # Save as /tmp/mastory-<random>/name.jpg
        import tempfile
        try:
            tmpdir = tempfile.mkdtemp(prefix='fotomovil') + "/"
            tmpfile = tmpdir + self.entitle.get_text() + '.jpg'
            pixbuf.save(tmpfile, "jpeg")
            return tmpfile
        except:
            return None

    def delete_temp_images(self):
        ## Delete temporal edited images ##
        for i in os.listdir("/var/tmp"):
            if i.find("fotomovil") >= 0:
                import shutil
                print "Deleting temp directory: %s" % i
                shutil.rmtree("/var/tmp/" + i)

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)

if __name__ == "__main__":
    UI = FotomovilUI()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
