#ifndef CSMS_H
#define CSMS_H

#include "IRdsText.h"
#include <QtDBus>

#ifndef NOSMS
#include <QMessageManager>
QTM_BEGIN_NAMESPACE
class QMessageManager;
QTM_END_NAMESPACE

QTM_USE_NAMESPACE
#endif

class CSms : public IRdsText
{
    Q_OBJECT;
public:
    CSms(QObject * parent);
    virtual ~CSms();

    static CSms& self(){return *m_self;}

    /// Displayed text format
    void    setFormat(QString value);
    QString getFormat();
    // End time
    void    setTimeout(int value);
    int getTimeout();
    // state plug on or off
    void    setEnable(bool value);
    bool getEnable();
    bool getState();
    // connect plug
    void setConnect(int value);

signals:
    /// emitted when ever the new text is changed
    //void sigChanged(QString,int);

private:
    // Send text to writer
    void sendText(QString text);

    static CSms * m_self;

    /// the format of rds displayed data
    QString format;
    // Formated text
    QString smsText;
    // tiimeout of displayed text
    int timeout;
    // Pluig status
    bool state;
    // Tx connect state
    bool bConnect;
#ifndef NOSMS
    QMessageManager *messageManager;
    QMessageManager::NotificationFilterIdSet m_notifFilterSet;

private slots:
    void slotMessageAdded(QMessageId,QMessageManager::NotificationFilterIdSet);
#endif
};

#endif // CSMS_H
