/**********************************************************************************************
    Copyright (C) 2009 Crohas Fabrice fcrohas@gmail.com 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CRdsBroadcast.h"

#include <QtGui>
#define RDS_PS_PATH "/sys/class/i2c-adapter/i2c-2/2-0063/rds_ps_name"

CRdsBroadcast * CRdsBroadcast::m_self = 0;

CRdsBroadcast::CRdsBroadcast(QObject * parent)
: QObject(parent)
,refresh(5000)
,display(8)
,withDBus(true)
,endTime(60000)
,defText("Maemo FM")
{
   m_self=this;
   QSettings cfg;
   refresh = cfg.value("broadcast/refresh", refresh).toInt();
   display = cfg.value("broadcast/display", display).toInt();
   withDBus = cfg.value("broadcast/withDBus", withDBus).toBool();
   defText = cfg.value("broadcast/defaultText", defText).toString();
   // Create timer's
   timer = new QTimer(this);
   timerTimeout = new QTimer(this);
   // connect timer
   connect(timer, SIGNAL(timeout()), this, SLOT(slotUpdateText()));
   connect(timerTimeout, SIGNAL(timeout()), this, SLOT(slotEndText()));
   // Stop timer
   timer->stop();
   timerTimeout->stop();
   // Init text parts
   textPart = new QStringList();
}


CRdsBroadcast::~CRdsBroadcast()
{
   QSettings cfg;
   cfg.setValue("broadcast/refresh", refresh);
   if (!withDBus) {
   	cfg.setValue("broadcast/display", display);
   } else {
   	cfg.setValue("broadcast/display", 8 );
   }
   cfg.setValue("broadcast/withDBus", withDBus);
   cfg.setValue("broadcast/defaultText", defText);

}

void CRdsBroadcast::slotSetText(QString text, int timeout)
{
     endTime = timeout;
     // Cut text into parts depending of length
     // and call every delay to display each part
     textPart->clear();
     int cur=0;
     while (cur < text.size()-1 ) {
	     textPart->append( text.mid(cur , display) );
	     cur = cur + display;
     }
     textCount=0;
     timer->start(refresh);
}

void CRdsBroadcast::slotEndText()
{
     textPart->clear();	
     textCount=0;
     timer->stop();
     timerTimeout->stop();
     if (withDBus) {
	 setDBusText(defText.leftJustified(8,' ',true) );
     } else
     {
	 setSystemText(defText );
     }	     
}

void CRdsBroadcast::setTimeout(int timeout)
{
    endTime = timeout; 
}

int CRdsBroadcast::getTimeout()
{
    return endTime; 
}

void CRdsBroadcast::setDelay(int delay)
{
    refresh = delay; 
}

int CRdsBroadcast::getDelay()
{
    return refresh; 
}

void CRdsBroadcast::setDisplay(int length)
{
    display = length;
}

int CRdsBroadcast::getDisplay()
{
    return display;
}

void CRdsBroadcast::setDefText(QString text)
{
    defText = text;
}

QString CRdsBroadcast::getDefText()
{
    return defText;
}

void CRdsBroadcast::slotUpdateText()
{
    if (textCount > textPart->size()-1 ) {
	    textCount = 0;
            timerTimeout->start(endTime);
    }
    if (withDBus) {
    	setDBusText(textPart->at(textCount).leftJustified(8,' ',true) );
    } else {
    	setSystemText(textPart->at(textCount) );
    }
    qDebug() << "RDS text" << textPart->at(textCount);
    
    textCount++;
}

void CRdsBroadcast::setDBusText(QString text)
{
     QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx", 
			"/com/nokia/fmtx/default", // FM TX dbus path 
			"org.freedesktop.DBus.Properties",  // FM TX dbus interface
			"Set" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append("rds_ps");
    list.append(QVariant::fromValue(QDBusVariant(text) ) );
    message.setArguments(list);

    QDBusMessage reply = QDBusConnection::systemBus().call(message);
    //qDebug() << "message (" << text <<") sent=" << reply.errorMessage();
}

void CRdsBroadcast::setSystemText(const QString &text)
{
    QFile rdsSys(RDS_PS_PATH);
    if (rdsSys.exists()) {
	    bool bConnect = rdsSys.open(QIODevice::ReadWrite | QIODevice::Text);
	    rdsSys.write(text.toLocal8Bit().constData(), text.size() );
            rdsSys.close();
    }
}
