/**********************************************************************************************
    Copyright (C) 2009 Fabrice Crohas fcrohas@gmail.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CMAFWMETA_H
#define CMAFWMETA_H

#include "IRdsText.h"
#include <QtDBus>


class CMafwMeta : public IRdsText
{
    Q_OBJECT;
    public:
        CMafwMeta(QObject * parent);
        virtual ~CMafwMeta();

        static CMafwMeta& self(){return *m_self;}

        /// Displayed text format
        void    setFormat(QString value);
	QString getFormat();
	// End time
        void    setTimeout(int value);
	int getTimeout();
	// state of plug on or off
        void    setEnable(bool value);
	bool getEnable();
        bool getState();
	// connect plug
        void    setConnect(int value);

        signals:
        /// emitted when ever the new text is changed
        //void sigChanged(QString,int);

    private:
	// Send text to writer
	void sendText(QString text);

        static CMafwMeta * m_self;
        /// the format of rds displayed data
        QString format;
	// Formated text 
        QString song;
	// timeout of data
	int timeout;
	// plug status
	bool state;
        // Tx connect state
        bool connect;

    private slots:
	void slotMetadataChanged(QString meta, uint state,QDBusVariant data);
	void slotPlayerState(int state);
};
#endif                           //CMAFWMETA
