#include "CSms.h"
#include "dbus-strings.h"

#include <QtGui>

CSms * CSms::m_self = 0;

CSms::CSms(QObject * parent)
: IRdsText(parent)
        ,format("%name% %message%")
        ,smsText("")
        ,timeout(30000)
        ,state(true)
{
    m_self = this;

    QSettings cfg;
    format = cfg.value("display/sms/format", format).toString();
    timeout = cfg.value("display/sms/timeout", timeout).toInt();
    state = cfg.value("main/sms", state).toBool();
    connect = false;
}

CSms::~CSms()
{
    QSettings cfg;
    cfg.setValue("display/sms/format", format);
    cfg.setValue("display/sms/timeout", timeout);
    cfg.setValue("main/sms", state);
}

void CSms::setFormat(QString value)
{
    format = value;
}

QString CSms::getFormat()
{
    return format;
}

void CSms::setTimeout(int value)
{
    timeout = value;
}

int CSms::getTimeout()
{
    return timeout;
}

void CSms::setEnable(bool value)
{
    if (value) {
        value = QDBusConnection::systemBus().connect( 0, SMS_CSD_PATH, SMS_CSD_IF,  "MessageReceived", this, SLOT(slotComingChanged(QString,uint,QString,QString,QString,QDBusVariant)));
    } else {
       QDBusConnection::systemBus().disconnect( 0, SMS_CSD_PATH, SMS_CSD_IF,  "MessageReceived", this, SLOT(slotComingChanged(QString,uint,QString,QString,QString,QDBusVariant)));
    }
    state = value;
    qDebug() << "Connected is " << value;
}

bool CSms::getEnable()
{
    return state && connect;
}

bool CSms::getState()
{
    return state;
}

void CSms::slotComingChanged(QString ukn,uint id,QString type,QString from ,QString text,QDBusVariant var)
{
    smsText.clear();
    smsText.append(format);

    smsText.replace("%name%", from);
    smsText.replace("%message%",text);

    sendText(smsText);

    qDebug() << "Sms status received " << from;
}

void CSms::sendText(QString text)
{
    emit sigChanged(text,timeout);
}

void CSms::setConnect(int value)
{
    // If activate check before the internal plug state
    qDebug() << "SetConnect is " << value;
    if (value)
        setEnable(state);
    else {
        QDBusConnection::systemBus().disconnect( 0, SMS_CSD_PATH, SMS_CSD_IF,  "MessageReceived", this, SLOT(slotComingChanged(QString,uint,QString,QString,QString,QDBusVariant)));
    }
    connect = value;
}
