#include "CSms.h"
#include "dbus-strings.h"

#include <QtGui>

CSms * CSms::m_self = 0;

CSms::CSms(QObject * parent)
: IRdsText(parent)
        ,format("%name% %message%")
        ,smsText("")
        ,timeout(30000)
        ,state(true)
{
    m_self = this;

    QSettings cfg;
    format = cfg.value("display/sms/format", format).toString();
    timeout = cfg.value("display/sms/timeout", timeout).toInt();
    state = cfg.value("main/sms", state).toBool();
    bConnect = false;
}

CSms::~CSms()
{
    QSettings cfg;
    cfg.setValue("display/sms/format", format);
    cfg.setValue("display/sms/timeout", timeout);
    cfg.setValue("main/sms", state);
}

void CSms::setFormat(QString value)
{
    format = value;
}

QString CSms::getFormat()
{
    return format;
}

void CSms::setTimeout(int value)
{
    timeout = value;
}

int CSms::getTimeout()
{
    return timeout;
}

void CSms::setEnable(bool value)
{
    if (value) {
        value = QDBusConnection::sessionBus().connect( 0, SMS_CSD_PATH, "org.freedesktop.Telepathy.Connection.Interface.Requests",  "NewChannels", this, SLOT(slotNotify(QList<QVariant>)));
    } else {
       QDBusConnection::sessionBus().disconnect( 0, SMS_CSD_PATH, SMS_CSD_IF_CON,  "NewChannel", this, SLOT(slotComingChanged(QDBusObjectPath, QString,uint,uint,bool)));
    }
    state = value;
    qDebug() << "Connected is " << value;
}

bool CSms::getEnable()
{
    return state && bConnect;
}

bool CSms::getState()
{
    return state;
}

void CSms::slotComingChanged(QDBusObjectPath objPath, QString channel,uint ukn,uint num,bool act)
{
    bool state = QDBusConnection::sessionBus().connect( 0, objPath.path(), channel, "Received", this, SLOT(slotTextReceived(uint ,uint ,uint , uint , uint ,QString )));
    qDebug() << "path=" << objPath.path() << " channel=" << channel << " connected=" << state;
}

void CSms::slotTextReceived(uint ukn,uint time,uint chan, uint ukn2, uint ukn3,QString text)
{
    smsText.clear();
    smsText.append(format);

    smsText.replace("%name%", "");
    smsText.replace("%message%",text);

    sendText(smsText);

    qDebug() << "Sms status received " << smsText;
}

void CSms::sendText(QString text)
{
    emit sigChanged(text,timeout);
}

void CSms::setConnect(int value)
{
    // If activate check before the internal plug state
    qDebug() << "SetConnect is " << value;
    if (value)
        setEnable(state);
    else {
        QDBusConnection::systemBus().disconnect( 0, SMS_CSD_PATH, SMS_CSD_IF_CON,  "NewChannel", this, SLOT(slotComingChanged(QDBusObjectPath, QString,uint,uint,bool)));
    }
    bConnect = value;
}

void CSms::slotNotify(QList<QVariant> var)
{
    qDebug() << "slotNotify=" << var.at(0).typeName();
    QDBusObjectPath objPath = qVariantValue<QDBusObjectPath>(var.at(0));
    QDBusConnection::sessionBus().connect( 0, objPath.path(), "org.freedesktop.Telepathy.Channel.Type.Text", "Received", this, SLOT(slotTextReceived(uint ,uint ,uint , uint , uint ,QString )));
}
