#include "CFMRadio.h"

#include <QtGui>

CFMRadio * CFMRadio::m_self = 0;


CFMRadio::CFMRadio(QObject *parent) :
    QObject(parent)
{
}

CFMRadio::~CFMRadio()
{
}

bool CFMRadio::sendAction(QString action, QString value)
{
    qDebug() << "Send action=" << action << " value=" << value;
    QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx",
                        "/com/nokia/fmtx/default", // FM TX dbus path
                        "org.freedesktop.DBus.Properties",  // FM TX dbus interface
                        "Set" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append(action);
    list.append(QVariant::fromValue(QDBusVariant(value) ) );
    message.setArguments(list);

    QDBusMessage reply = QDBusConnection::systemBus().call(message);
    return true;
}

QVariant CFMRadio::getProperties(QString properties)
{
    QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx",
                        "/com/nokia/fmtx/default", // FM TX dbus path
                        "org.freedesktop.DBus.Properties",  // FM TX dbus interface
                        "Get" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append(properties);
    message.setArguments(list);

    QDBusReply<QDBusVariant> reply = QDBusConnection::systemBus().call(message);
    return reply.value().variant();
}


bool CFMRadio::setFrequency(int freq)
{
    sendAction("frequency", QString("%1").arg(freq) );
}

bool CFMRadio::setState(bool state)
{
    sendAction("state", state==true ? "enabled" : "disabled");
}

QString CFMRadio::getState()
{
    return getProperties("state").toString();
}

double CFMRadio::getFrequency()
{
    return getProperties("frequency").toInt();
}

double CFMRadio::getStep()
{
    return getProperties("freq_step").toInt();
}
