/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef CDESKTOP_H
#define CDESKTOP_H

#include "dbus-strings.h"
#include "CMafwMeta.h"
#include "CRTCom.h"
#include "CRdsBroadcast.h"
#include <QWidget>
#include <QPixmap>

class QPaintEvent;
class QSvgRenderer;
class QResizeEvent;

class CDesktop : public QWidget
{
    Q_OBJECT
public:
    CDesktop();

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);

private:
    QSvgRenderer *renderer;
    QPixmap       cache;
    int state;
    CMafwMeta *rdsMafw;
    CRTCom *rdsRTCom;
    CRdsBroadcast *rdsBroadcast;
    void drawDesktop(QPainter *p);
    void drawStatus(QPainter *p, QRectF rect, bool status);
private slots:
    void slotFMTXChanged(QString type, QString status);
};

#endif
