/**********************************************************************************************
 *  Copyright (C) 2009 Fabrice Crohasi fcrohas@gmail.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 ***********************************************************************************************/

#include "CDlgSetup.h" 

#include "CMafwMeta.h" 
#include "CRTCom.h" 

#include "CDlgMafw.h" 
#include "CDlgRTCom.h" 
#include "CDlgRds.h" 

CDlgSetup::CDlgSetup()
{
    setupUi(this);
    // init plug values
    cMafw->setChecked(CMafwMeta::self().getEnable() );
    cRTCom->setChecked(CRTCom::self().getEnable() );
    
    // connect buttons
    connect(bMain, SIGNAL(clicked()), this, SLOT(slotMainSetup()));
    connect(bCall, SIGNAL(clicked()), this, SLOT(slotCallSetup()));
    connect(bMP3 , SIGNAL(clicked()), this, SLOT(slotMP3Setup() ));
    // connect checkbox
    connect(cMafw  , SIGNAL(stateChanged(int)), this, SLOT(slotMafwActivate(int) ));
    connect(cRTCom , SIGNAL(stateChanged(int)), this, SLOT(slotRTComActivate(int)));

}

CDlgSetup::~CDlgSetup()
{
}

void CDlgSetup::slotCallSetup()
{
   CDlgRTCom *dlgRTCom = new CDlgRTCom(this);
   dlgRTCom->exec();
   delete dlgRTCom;
}

void CDlgSetup::slotMP3Setup()
{
   CDlgMafw *dlgMafw = new CDlgMafw(this);
   dlgMafw->exec();
   delete dlgMafw;
}

void CDlgSetup::slotMainSetup()
{
   CDlgRds *dlgRds = new CDlgRds(this);
   dlgRds->exec();
   delete dlgRds;
}

void CDlgSetup::slotMafwActivate(int status)
{
   CMafwMeta::self().setEnable( (status>0)?true:false); 
}

void CDlgSetup::slotRTComActivate(int status)
{
   CRTCom::self().setEnable( (status>0)?true:false); 
}
