#! /usr/bin/env python

# set proper application name for being allowed to play sound in silent mode
import dl
libc = dl.open("/lib/libc.so.6")
libc.call("prctl", 15, "FMRadio\0", 0, 0, 0)

from com import Container
from utils import logging
import values
import os
import sys
import getopt


_LOG_LEVELS = [logging.OFF, logging.ERROR, logging.WARNING,
               logging.INFO, logging.DEBUG]


try:
    opts, args = getopt.getopt(sys.argv[1:],
                               "vqh", ["help"])
except:
    opts = [("--help", None)]

log_count = 1
for o, v in opts:
    if (o == "-v"):
        log_count += 1
    elif (o == "-q"):
        log_count = 0
    elif (o == "-h" or o == "--help"):
        print "Usage: %s [-v|-q] [-h|--help]" \
              % os.path.basename(sys.argv[0])
        print ""
        print "  -h, --help            Show this help."
        print "  -q                    Turn off logging."
        print "  -v                    Increase logging verbosity. Use up to three -v."
        sys.exit(0)
#end for

logging.set_level(_LOG_LEVELS[min(4, log_count)])


logging.debug("initializing application")
compdir = os.path.join(values.APP_DIR, "components")
print compdir
container = Container([compdir])

logging.debug("running application")
import gtk
gtk.main()

