import mixer
import gobject
import pygst; pygst.require("0.10")
import gst
import os


class SoundPipe(object):
    """
    Class for actually getting sound out of the FM radio.
    """

    def __init__(self):
    
        self.__use_speaker = False
        self.__speaker_volume = 50

        # gstreamer pipeline for capturing sound
        self.__pipe = gst.Pipeline("pipe")
        self.__pipe_source = gst.element_factory_make("pulsesrc", "source")
        self.__pipe_queue = gst.element_factory_make("queue", "queue")
        self.__pipe_sink = gst.element_factory_make("pulsesink", "sink")
        self.__pipe.add(self.__pipe_source, self.__pipe_queue, self.__pipe_sink)
        gst.element_link_many(self.__pipe_source, self.__pipe_queue, self.__pipe_sink)
        
        
    def on(self):

        mixer.set_microphone(False)
        #mixer.set_pga_capture(True)
        mixer.set_pga_line2(True)
        # is this needed?
        #mixer.set_differential_input(True)
        
        #if (self.__use_speaker):
        self.__pipe.set_state(gst.STATE_PLAYING)


    def off(self):

        #mixer.set_pga_bypass(False)
        mixer.set_pga_line2(False)
        mixer.set_microphone(True)
        # is this needed?
        #mixer.set_differential_input(False)
    
        self.__pipe.set_state(gst.STATE_NULL)
        
        
    def use_speaker(self, v):
    
        # PGA Bypass MUST NEVER be used with speakers, ONLY with headphones!
        if (v):
            self.__use_speaker = True
            #mixer.set_pga_bypass(False)
            mixer.set_pga_capture(True)
            mixer.set_speaker(True)

            self.set_speaker_volume(self.__speaker_volume)
            self.__pipe.set_state(gst.STATE_PLAYING)
            
        else:
            self.__use_speaker = False
            mixer.set_speaker(False)
            #mixer.set_pga_bypass(True)
            #mixer.set_pga_bypass(False)
            #mixer.set_pga_capture(False)
            mixer.set_pga_capture(True)

            #self.__pipe.set_state(gst.STATE_NULL)
            self.__pipe.set_state(gst.STATE_PLAYING)
            

    def set_speaker_volume(self, v):
    
        if (self.__use_speaker):
            mixer.set_speaker_volume(v)
        else:
            mixer.set_headphone_volume(v)
        self.__speaker_volume = v

