from utils.Config import Config

_cfg = Config("/apps/fmradio/",
              [("lastfreq", Config.INTEGER, 87500),
               ("frequencies", Config.INTEGER_LIST, []),
               ("stations", Config.STRING_LIST, [])]
             )


def get_lastfreq():

    return _cfg["lastfreq"]
    
    
def set_lastfreq(freq):

    _cfg["lastfreq"] = freq


def get_stations():

    freqs = _cfg["frequencies"]
    stations = _cfg["stations"]
    
    return zip(freqs, stations)
    
    
def set_stations(l):

    freqs = []
    stations = []
    for freq, station in l:
        freqs.append(freq)
        stations.append(station)
        
    _cfg["frequencies"] = freqs
    _cfg["stations"] = stations

