from com import msgs
from storage import Device, File
from ui.dialog import InputDialog
from theme import theme
import maemostations


class FMRadioDevice(Device):
    """
    Storage device for FM radio stations.
    """

    CATEGORY = Device.CATEGORY_WAN
    TYPE = Device.TYPE_AUDIO


    def __init__(self):
    
        Device.__init__(self)
        
        
    def get_name(self):
    
        return "FM Radio Stations"
        
        
    def get_icon(self):
    
        return theme.fmradio_device


    def get_prefix(self):
    
        return "fmradio://"


    def get_root(self):
    
        f = File(self)
        f.path = "/"
        f.mimetype = f.DIRECTORY
        f.name = self.get_name()
        f.info = "Listen to FM radio"
        f.icon = self.get_icon().get_path()
        f.folder_flags = f.ITEMS_ADDABLE
        
        return f


    def get_contents(self, path, begin_at, end_at, cb, *args):

        cnt = 0    
        for freq, name in maemostations.get_stations():
            if (cnt < begin_at): continue
            if (end_at and cnt > end_at): break

            f = File(self)
            f.path = "/" + `freq`
            f.name = name
            f.info = "%0.2f MHz" % (freq / 1000.0)
            f.mimetype = "application/x-fmradio-station"
            f.icon = self.get_icon().get_path()

            cb(f, *args)

            cnt +=1 
        #end for
        
        cb(None, *args)


    def __on_remove_station(self, folder, f):
    
        stations = maemostations.get_stations()
        new_stations = []
        for freq, name in stations:
            if (f.name == name and "/" + `freq` == f.path):
                pass
            else:
                new_stations.append((freq, name))
        #end for
        maemostations.save_stations(new_stations)
        self.emit_message(msgs.CORE_EV_FOLDER_INVALIDATED, self.get_root())
        

    def __on_rename_station(self, folder, f):

        dlg = InputDialog("Rename Radio Station")
        dlg.add_input("Name", f.name)
        
        ret = dlg.run()
        if (ret != 0):
            return
        new_name = dlg.get_values()[0]
    
        stations = maemostations.get_stations()
        new_stations = []
        for freq, name in stations:
            if (f.name == name and "/" + `freq` == f.path):
                new_stations.append((freq, new_name))
            else:
                new_stations.append((freq, name))
        #end for
        maemostations.save_stations(new_stations)
        self.emit_message(msgs.CORE_EV_FOLDER_INVALIDATED, self.get_root())


    def get_file_actions(self, folder, f):
    
        return [(None, "Rename", self.__on_rename_station),
                (None, "Remove", self.__on_remove_station)]



    def add_station(self, freq):
    
        dlg = InputDialog("New Radio Station")
        dlg.add_input("Name", "%0.2f MHz" % freq)
        
        ret = dlg.run()
        if (ret == 0):
            name = dlg.get_values()[0]
            stations = maemostations.get_stations()
            stations.append((freq, name))
            maemostations.save_stations(stations)
            self.emit_message(msgs.CORE_EV_FOLDER_INVALIDATED, self.get_root())
        #end if

