from com import Component, msgs
from utils import logging
#import platforms

#import dbus
import gobject

#_HAL_SERVICE = "org.freedesktop.Hal"
#_HAL_PATH = "/org/freedesktop/Hal/devices/platform_soc_audio_logicaldev_input"
#_HAL_IFACE = "org.freedesktop.Hal.Device"

_HEADPHONE_SYS = "/sys/devices/platform/gpio-switch/headphone/state"


class HeadphonesMonitor(Component):

    def __init__(self):
    
        Component.__init__(self)

        #bus = platforms.get_system_bus()
        #obj = bus.get_object(_HAL_SERVICE, _HAL_PATH)
        #device = dbus.Interface(obj, _HAL_IFACE)
        #device.connect_to_signal("Condition", self.__on_hal_condition)


        # monitor headset status
        try:
            fd = open(_HEADPHONE_SYS, "r")
            self.__on_connect(None, None)            
            self.__watcher = gobject.io_add_watch(fd, gobject.IO_PRI,
                                                  self.__on_connect)
        except:
            print logging.stacktrace()
            logging.warning("unable to monitor headset connection")


    def __on_connect(self, src, cond):
        
        if (src): src.read()

        state = open(_HEADPHONE_SYS, "r").read().strip()
        if (state == "disconnected"):
            self.__is_connected = False
            logging.info("headphones disconnected")
            self.emit_message(msgs.SYSTEM_EV_HEADPHONES_REMOVED)

        elif (state == "connected"):
            self.__is_connected = True
            logging.info("headphones connected")
            self.emit_message(msgs.SYSTEM_EV_HEADPHONES_INSERTED)

        return True

