#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" Handles contacts integration for fMMS

@author: Nick Leppänen Larsson <frals@frals.se>
@license: GNU GPL
"""
import evolution
	
class ContactHandler:
	
	
	""" wouldnt mind some nice patches against this """
	def __init__(self):
		self.ab = evolution.ebook.open_addressbook("default")
		self.contacts = self.ab.get_all_contacts()
		self.phonedict = {}
		for c in self.contacts:
			#print c.get_name(), c.get_property('mobile-phone')
			#print c.get_property('other-phone')
			mb = c.get_property('mobile-phone')
			cp = c.get_property('other-phone')
			self.phonedict[c.get_name()] = (mb, cp)
	
	""" takes a number on international format (ie +46730111111) """
	def get_name_from_number(self, number):
		### do some voodoo here
		# ugly way of removing country code since this
		# can be 2 or 3 chars we remove 4 just in case
		# 3 and the + char = 4
		numberstrip = number[4:-1]
		for person in self.phonedict:	
			for cbnr in self.phonedict[person]:
				if cbnr != None:
					cbnr = cbnr.replace(" ", "")
					cbnr = cbnr.lstrip('0')
					if cbnr == number or numberstrip.endswith(cbnr) or number.endswith(cbnr):
						return person
					
		return None
	
	def get_photo_from_name(self, pname, imgsize):
		res = self.ab.search(pname)
		### do some nice stuff here
		#l = [x.get_name() for x in res]
		#print "search for:", pname, "gave res: ", l
		if res != None:
			return res[0].get_photo(imgsize)
		else:
			return None
		
		
if __name__ == '__main__':
	cb = ContactHandler()
	phonedict = {}
	
	#print cb.get_name_from_number('+46')
	
	#r = ab.search('name') # Returns List of results
	#print r
	#l = [x.get_name() for x in r] # list of results
	#u = r[0].get_name() # name of the first result
	#print r[0].get_vcard_string() # vcard for first result
