from pygame import sprite, image, Surface, Color
from math import sin,  cos

transColor = Color('black')

class Ball(sprite.Sprite):
    """A ball that will move across the screen
    Returns: ball object
    Functions: update, calcnewpos
    Attributes: area, vector"""

    def __init__(self):
        sprite.Sprite.__init__(self)
        self.image = image.load("data/ball-50.png")
        self.image = self.image.convert_alpha()
        self.x, self.y = 0.0, 200.0
        self.rect = self.image.get_rect(center=(self.x, self.y))
        self.bg = Surface(self.rect.size)        
        self.bg.fill(transColor)
        self.bg.convert()
        self.speed = [0.0, 0.0]
        self.touchedTop = False

    def update(self, timestep,  bounding_rect, G, angle):
        self.calcnewpos(self.rect, timestep,  bounding_rect, G, angle)
        #self.rect = newpos

    def calcnewpos(self,rect, timestep,  bounding_rect, G, angle):
        sinA = angle[1]*G*timestep #sin(angle)
        cosA = angle[0]*G*timestep #cos(angle)
        dx = self.speed[0]*timestep + sinA*0.5*timestep
        dy = self.speed[1]*timestep + cosA*0.5*timestep
        #print dx, dy
        self.x = self.x + dx
        self.y = self.y + dy
        self.speed[0] = self.speed[0] + sinA
        self.speed[1] = self.speed[1] + cosA
        self.rect.center = (round(self.x), round(self.y))
        
        # now, check if the Ball is within the bounds of the bounding_rect
        if bounding_rect.contains(self.rect):
            pass # nothing to do here, as the Ball is within bounds
        else: # if the Ball is outside of bounding_rect
            # first, we find which the direction we are getting out of bounds
            if self.rect.top < bounding_rect.top:
                # from the TOP side. we move the Ball to the max top first
                self.rect.top = bounding_rect.top
                # then, we check if the Balls current Y velocity will take
                # it out of bounds again. if it will, we inverse the Y velocity
                # by multiplying it with -1
                if (self.rect.top + self.speed[1]) < bounding_rect.top:
                    self.speed[1] = 0
            elif self.rect.bottom > bounding_rect.bottom:
                # likewise for bottom side
                self.rect.bottom = bounding_rect.bottom
                if (self.rect.bottom + self.speed[1]) > bounding_rect.bottom:
                    self.speed[1] = 0
            # now, we do the same for the left & right side
            if self.rect.left < bounding_rect.left:
                self.rect.left = bounding_rect.left
                if (self.rect.left + self.speed[0]) < bounding_rect.left:
                    self.speed[0] = 0
                    self.touchedTop = True
            elif self.rect.right > bounding_rect.right:
                self.rect.right = bounding_rect.right
                if (self.rect.right + self.speed[0]) > bounding_rect.right:
                    self.speed[0] = -0.6*self.speed[0]
        #(angle,z) = vector
        #(dx,dy) = (z*math.cos(angle),z*math.sin(angle))
        
        #return rect.move(dx,dy)

    def erase(self, surface):
        # erase the Ball object from its current location
        surface.blit(self.bg, self.rect)
    
    def set_vert_speed(self,  speed):
        self.speed[0] = speed
        
    def set_horiz_speed(self,  speed):
        self.speed[1] = speed
        
    def set_pos(self,  dx,  dy):
        self.x = self.x + dx
        self.y = self.y + dy
        self.rect.center = (round(self.x), round(self.y))

class Fruit(Ball):
    def __init__(self,  startX, startY):
        sprite.Sprite.__init__(self)
        self.image = image.load("data/cherry.png")
        self.image = self.image.convert()
        self.x, self.y = startX, startY
        self.rect = self.image.get_rect(center=(self.x, self.y))
        self.bg = Surface(self.rect.size)        
        self.bg.fill(transColor)
        self.bg.convert()
        
    def calcnewpos(self,rect, timestep,  bounding_rect, G, angle):        
        # now, check if the Ball is within the bounds of the bounding_rect
        if bounding_rect.contains(self.rect):
            pass # nothing to do here, as the Ball is within bounds
        else: # if the Ball is outside of bounding_rect
            # first, we find which the direction we are getting out of bounds
            if self.rect.top < bounding_rect.top:
                # from the TOP side. we move the Ball to the max top first
                self.rect.top = bounding_rect.top
            elif self.rect.bottom > bounding_rect.bottom:
                # likewise for bottom side
                self.rect.bottom = bounding_rect.bottom

class Wall:
    def __init__(self, init_coord=(0, 300), init_speed=50, color=Color('white')):
        """
        """
        # create Surface to hold image for both drawing and erasing the Ball
        # init_coord contains the start and end coordinate of the wall, with a width of 10
        self.img = Surface((20, init_coord[1]-init_coord[0]))
        self.bg = Surface((20, init_coord[1]-init_coord[0]))
        # fill both surfaces with the transparent color
        self.img.fill(color)
        self.bg.fill(transColor)
        # set the color key for both surfaces
        #self.img.set_colorkey(transColor)
        #self.bg.set_colorkey(transColor)
        # convert both Surfaces for faster bliting to the screen
        self.img.convert()
        self.bg.convert()
       
        # create rectangle for the Ball image
        # give it the initial position that was passed via init_pos
        self.x, self.y = 800.0 , init_coord[0]+(init_coord[1]-init_coord[0])*0.5
        init_pos=(round(self.x), round(self.y))
        self.rect = self.img.get_rect(center=init_pos)
        # set the speed of this Ball object
        self.speed = -init_speed
    
    def move(self,  timestep, wall_speed):
        dx = -wall_speed * timestep
        self.x = self.x + dx
        #self.rect.move_ip(round(dx), 0)
        self.rect.center = (round(self.x), round(self.y))
        if self.rect.left < 0:
             return False
        return True

    def erase(self, surface):
        # erase the Ball object from its current location
        surface.blit(self.bg, self.rect)
   
    def draw(self, surface):
        surface.blit(self.img, self.rect)