from sys import exit
from pygame import display, init, Color, font, transform, sprite, mouse, time, Surface, event, QUIT, image
from math import sin,  cos,  atan2, sqrt
from random import randint
from pygame.locals import USEREVENT,  KEYDOWN,  FULLSCREEN,  K_q, MOUSEBUTTONDOWN
from Objects import Ball, Wall, Fruit
from os import mkdir, environ
from os.path import isdir

try:
    from osso import Context,  DeviceState
    use_osso = True
except:
    use_osso = False

init()
if use_osso:
    osso_c = Context("Flobby", "0.0.1", False)
    device = DeviceState(osso_c)

G = 9.8*30

angle = (0, 1)
tickConstant = 700. 
friction = 1.

CONFIGDIR = "%s/.flobby/" % environ["HOME"]
SAVEPATH = "%sscoreboard" % CONFIGDIR

def get_rotation():
    try:
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        coords = [int(w) for w in f.readline().split()]
        f.close()
        r = sqrt(coords[0]*coords[0]+coords[1]*coords[1])
        return (-coords[1]/r, -coords[0]/r)  # cos(atan2(x,y))=x/r and sin(atan2(x,y)=y/r
        #return -atan2(coords[0],  -coords[1])
    except:
        return (0, 1)
        #return 3.1415927/2.
 
class Score:
    def __init__(self):
        self.score = 0
        self.textFont = font.Font(None, 30)
        
    def add_score(self,  score):
        self.score += score
        
    def get_score(self):
        return self.score
        
    def erase(self):
        pass
        
    def display(self, screen):
        text=self.textFont.render("Score: %s" %str(self.score), 1, (255,255,255),  (0, 0, 255))
        screen.blit(transform.rotate(text,  90), (15,0))
        
 
def collision_detect(wall_list, ball,  fruitsprite,  score):
     for wall in wall_list:
            if wall.rect.colliderect(ball.rect):
               #ball.rect.move_ip((wall.rect.left-ball.rect.right,  0))
               
               if wall.rect.bottom>ball.rect.top and ball.speed[1]<0 and wall.rect.bottom<ball.rect.center[1]:
                   ball.set_pos(0,  wall.rect.bottom-ball.rect.top)
                   ball.set_horiz_speed(0.0)
               elif  wall.rect.top<ball.rect.bottom and ball.speed[1]>0 and wall.rect.top>ball.rect.center[1]:
                   ball.set_pos(0,  wall.rect.top-ball.rect.bottom)
                   ball.set_horiz_speed(0.0)
               elif wall.rect.collidepoint(ball.rect.bottomleft) or wall.rect.collidepoint(ball.rect.topleft):
                   ball.set_pos(-ball.rect.left+wall.rect.right,  0)
                   ball.set_vert_speed(wall.speed)
               else:
                    ball.set_pos(wall.rect.left-ball.rect.right,  0)
                    ball.set_vert_speed(wall.speed)

            list = sprite.spritecollide(wall,  fruitsprite,  False,  )
            for fruit in list:
                fruit.set_pos(wall.rect.left-fruit.rect.right,  0)
     fruit = sprite.spritecollideany(ball, fruitsprite)
     if fruit != None:
        fruitsprite.remove(fruit)
        score.add_score(100)
 
class InfiniteGame:
    def __init__(self, screen):
        size = self.width, self.height = 800, 480
        #speed = [2, 2]
        #black = 0, 0, 0
         
        #self.screen = display.set_mode(size,  FULLSCREEN)
        self.screen = screen
        mouse.set_visible(False)
        #ball = pygame.image.load("ball.bmp")
        #ballrect = ball.get_rect()
        self.clock = time.Clock()
        
        self.ball = Ball()
        wall1 = Wall(init_coord=(0, 300))
        wall2 = Wall(init_coord=(350, self.height))
        
        self.wall_list = [wall1,  wall2,  ]
        
        # Fill background
        self.background = Surface(self.screen.get_size())
        self.background.fill((0, 0, 0))
        self.background = self.background.convert()
        
        self.ballsprite = sprite.RenderPlain(self.ball)
        self.fruitsprite = sprite.RenderPlain()
        
        # Blit everything to the screen
        self.screen.blit(self.background, (0, 0))
        display.flip()
        
        self.score = Score()

    def run(self):
        wall_speed = 50
        wall_timer = 2000
        
        time.set_timer(USEREVENT+1, wall_timer) # Set timer for wall apparition
        time.set_timer(USEREVENT+2, 10000) # Set timer for display_state_on (prevent screensaver)
        time.set_timer(USEREVENT+3, 5000) # Set timer for fruits
        #time.set_timer(USEREVENT+4, wall_timer) # Set timer for level-up
        
        running = True
        while running:
            for eventItem in event.get():
                if eventItem.type == QUIT:
                    running = False
                elif eventItem.type == USEREVENT+1:
                    self.score.add_score(10)
                    wall_speed += 0.5
                    if wall_timer > 500:
                        wall_timer = 100000./wall_speed # 2000.*50/wall_speed
                    gap = randint(50,150)
                    wallX = randint(0, 440-gap)
                    self.wall_list.append(Wall(init_coord=(0,  wallX)))
                    self.wall_list.append(Wall(init_coord=(wallX+gap,  self.height)))
                    time.set_timer(USEREVENT+1, int(wall_timer))
                elif eventItem.type == USEREVENT+2:
                    if use_osso:
                        device.display_state_on()
                elif eventItem.type == USEREVENT+3:
                    self.fruitsprite.add(Fruit(self.width, randint(20, self.height-20)))
                #elif eventItem.type == USEREVENT+4:
                #    wall_speed += 0.5
                #    if wall_timer > 500:
                #        wall_timer = wall_timer - 100
                #    time.set_timer(USEREVENT+4, wall_timer)
                elif eventItem.type == KEYDOWN and eventItem.key == K_q:
                    running = False
                    
            step = self.clock.tick(60)/tickConstant
            if step > 0.1:
                step = 0.1
            #score.add_score(step)
            angle = get_rotation()
            #ballrect = ballrect.move(speed)
            #if ballrect.left < 0 or ballrect.right > width:
            #    speed[0] = -speed[0]
            #if ballrect.top < 0 or ballrect.bottom > height:
            #    speed[1] = -speed[1] 
            
            self.screen.blit(self.background, self.ball.rect)
            for fruit in self.fruitsprite:
                fruit.erase(self.screen)
            for wall in self.wall_list:
                wall.erase(self.screen)
                if not wall.move(step, wall_speed):
                    self.wall_list.remove(wall)
            #screen.blit(background, player1.rect, player1.rect)
            #screen.blit(background, player2.rect, player2.rect)
            self.ballsprite.update(step, self.screen.get_rect(), G, angle )
            self.fruitsprite.update(step,  self.screen.get_rect(), G, angle )
            
            collision_detect(self.wall_list,  self.ball,  self.fruitsprite,  self.score)
            
            #playersprites.update()
            self.score.display(self.screen)
            self.ballsprite.draw(self.screen)
            self.fruitsprite.draw(self.screen)
            for wall in self.wall_list:
                wall.draw(self.screen)
            #playersprites.draw(screen)
            display.flip()
            if self.ball.touchedTop == True:
                running = False
        return self.score.get_score()

class Intro:
    def __init__(self):
        size = self.width, self.height = 800, 480
        self.screen = display.set_mode(size,  FULLSCREEN)
        if use_osso:
            mouse.set_visible(False)
        self.highscores = HighScore()
        
    def run(self):
        running = True
        score = 0
        self.image = image.load("data/flobby-intro.png")
        self.image = self.image.convert()
        while running:

            self.screen.blit(self.image, self.screen.get_rect())
            self.highscores.display_scores(self.screen)
            display.flip()
            for eventItem in event.get():
                if eventItem.type == QUIT:
                    running = False
                elif eventItem.type == MOUSEBUTTONDOWN:
                    (x, y) = mouse.get_pos()
                    if x<275 and x>200 and y>165 and y<310:
                        game = InfiniteGame(self.screen)
                        score = game.run()
                        self.highscores.check_score(score)
                        if not use_osso:
                            mouse.set_visible(True)
                    elif x>300 and x<360 and y<365 and y>100:
                        ## Display Instructions
                        instructions = image.load("data/flobby-instructions.png")
                        self.screen.blit(instructions, self.screen.get_rect())
                        display.flip()
                        instr = True
                        while instr:
                            for eventItem2 in event.get():
                                if eventItem2.type == MOUSEBUTTONDOWN:
                                    instr=False
                    elif x>0 and x<55 and y>0 and y<55:
                        running = False
        return score

class HighScore:
    def __init__(self):
        #self.scores = range(10)
        self.load_scores()
        self.textFont = font.Font(None, 30)
        
    def save_scores(self):
        import pickle
        
        if not isdir(CONFIGDIR):
            try:
                mkdir(CONFIGDIR)
            except:
                print "Error: Can't create configuration directory"
                from sys import exit
                exit(1)
        file = open(SAVEPATH, "w")
        pickle.dump(self.scores, file)
        pickle.dump(self.latest, file)
        file.close()
        
    def load_scores(self):
        import pickle, os.path
        if os.path.exists(SAVEPATH):
            file = open(SAVEPATH, "r")
            self.scores = pickle.load(file)
            self.latest = pickle.load(file)
            file.close()
        else:
            self.scores = range(10)
            self.latest= 0
            
    def check_score(self, newscore):
        self.scores.append(newscore)
        self.scores = sorted(self.scores, reverse=True)[0:10]
        self.latest = newscore
        self.save_scores()

    def display_scores(self, screen):
        def displayText(text, posY):
            text = self.textFont.render(text, 1, (255,255,0),  (0, 0, 255))
            text = transform.rotate(text,  90)
            posX = 240-(text.get_height()/2)
            screen.blit(text, (420+posY, posX))
        
        displayText("High Scores", 0)
        
        text = range(10)
        for i in range(10):
            posY = 30+i*25
            displayText(str(self.scores[i]), posY)
            #text[i] = self.textFont.render(str(self.scores[i]), 1, (255,255,255),  (0, 0, 0))
            #text[i] = transform.rotate(text[i],  90)
            #posX = 240-(text[i].get_height()/2)
            #screen.blit(text[i], (420+i*25, posX))
        
        displayText("Your latest score: %s" %str(self.latest), 310)
            

if __name__ == "__main__":
    game = Intro()
    game.run()