#include "historyview2.h"
#include "ui_historyview2.h"
#include "historymodel.h"
#include "historydelegate.h"

HistoryView2::HistoryView2(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::HistoryView2)
{
    ui->setupUi(this);

    HistoryModel *model = new HistoryModel(worker);
    listView->setModel(model);
    HistoryDelegate *delegate = new HistoryDelegate(this);
    listView->setItemDelegate(delegate);

    connect(this, SIGNAL(modeChanged(int)), model, SLOT(setMode(int)));

    QActionGroup *filterGroup = new QActionGroup(this);
    filterGroup->setExclusive(true);

    QAction *dayAction = new QAction(tr("Day"), filterGroup);
    dayAction->setCheckable(true);
    dayAction->setChecked(true);

    QAction *weekAction = new QAction(tr("Week"), filterGroup);
    weekAction->setCheckable(true);

    QAction *monthAction = new QAction(tr("Month"), filterGroup);
    monthAction->setCheckable(true);

    menuBar()->addActions(filterGroup->actions());
}

HistoryView2::~HistoryView2()
{
    delete ui;
}

void HistoryView2::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
