/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
#ifndef SETHIST_H
#define SETHIST_H

#include<QSettings>
#include<QVariant>

//a class for settings and history
class SetHist : public QObject {
	Q_OBJECT
public:
	explicit SetHist(QObject* parent = 0);
	SetHist(const SetHist&);
	Q_PROPERTY(QVariantList documents READ documents())
	Q_PROPERTY(QVariantMap curDoc READ curDoc() WRITE setCurDoc())
	
	QVariantList documents();
	QVariantMap curDoc();
	
	
signals:
public slots:
	void newDocument(QVariantMap doc);
	void chooseFile();
	void setCurDoc(QVariantMap doc);
	void clearDocuments();
	
private:
	QSettings qs;
	QVariantList documents_prv;
};
Q_DECLARE_METATYPE (SetHist)
#endif // SETHIST_H
