/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
import QtQuick 1.1

Rectangle {
	id: rect
	border.width: 1
	width: 200
	radius: 2
	property alias text: ipText.text
	signal accepted
	signal focusLost
	
	TextInput{
		id: ipText
		text: ""
		width: parent.width
		font.pointSize: 17
		anchors.verticalCenter: parent.verticalCenter
		anchors.left: parent.left
		anchors.leftMargin: 4
		onAccepted: rect.accepted();
		onFocusChanged: {if(!focus) rect.focusLost()}
	}
}
