/* This file is part of "modern computer flatboat", a pdf viewer.
 * Copyright (C) 2012 Frank Fuhlbrück 
 * License: GPLv3 (or any later version, at your option)
 * See the file "LICENSE".
 */
import QtQuick 1.0

Rectangle {
	id: rect
	color: "#889988"
	border.color: lbl.color
	border.width: 1
	property alias text: lbl.text
	property alias pointSize: lbl.font.pointSize
	property alias wrapMode: lbl.wrapMode
	property bool bstate: state == "active"
	property bool mutex: false
	onMutexChanged:{if(mutex) state = ""}
	signal clicked
	width:  10 + 1.05 * lbl.implicitWidth
	height: 10 + lbl.implicitHeight
	radius: 4
	clip: true
	property bool centerText: true
	Text {
		id: lbl
		color: "#ffffff"
		text: "Button"
		font.pointSize: 22
		font.weight: Font.DemiBold
		style: Text.Raised
		anchors.left : parent.centerText ? undefined : parent.left;
		anchors.margins : 5;
		anchors.verticalCenterOffset: 0
		anchors.horizontalCenterOffset: 1
		anchors.centerIn: parent.centerText ? parent : null
	}
	
	MouseArea {
		id : ma
		anchors.fill: parent
		onClicked: rect.clicked()
	}
	
	function toggleState(){
		if(state == "active")
			state = ""
		else
			state = "active"
	}
	
	states: [
	State {
		name: "active"
		PropertyChanges {target: rect; color: "#ffffff"; }
		PropertyChanges {target: lbl; color: "#889988"; }
	}
	]
}
