import QtQuick 1.1

Rectangle {
	id: rect
	border.width: 1
	width: 200
	radius: 2
	property alias text: ipText.text
	signal accepted
	signal focusLost
	
	TextInput{
		id: ipText
		text: ""
		width: parent.width
		font.pointSize: 17
		anchors.verticalCenter: parent.verticalCenter
		anchors.left: parent.left
		anchors.leftMargin: 4
		onAccepted: rect.accepted();
		onFocusChanged: {if(!focus) rect.focusLost()}
	}
}
