import QtQuick 1.0

Rectangle {
	id: helpScreen
	z: 2
	width: parent.width*0.95
	height: parent.height*0.95
	radius: 10
	clip: true
	anchors.centerIn: parent
	border.width: 4
	visible: false
	focus: visible
	Flickable{
		anchors.centerIn: parent
		width: 0.95*helpScreen.width
		height: 0.95*helpScreen.height 
		contentWidth: helpText.width
		contentHeight: helpText.height
		flickableDirection: Flickable.VerticalFlick
		boundsBehavior: Flickable.StopAtBounds
	Text {
		id: helpText
		//anchors.centerIn: parent
		width: 0.95*helpScreen.width
		wrapMode: Text.Wrap
		text: "\
		<hr>\
		<big><center><b>modern computer flatboat</b><br/>a viewer for the<br/><b>portable document format</b></a></big></center>\
		<hr>\
		<p>\
		© 2012 Frank Fuhlbrück, License: GPLv3 (or later version, at your option)<br>\
		See <a href=\"http://www.gnu.org/licenses/gpl-3.0.txt\">http://www.gnu.org/licenses/gpl-3.0.txt</a><br>\
		flatboat on gitorious: <a href=\"https://gitorious.org/flatboat\">https://gitorious.org/flatboat</a><br>\
		This program uses libfitz, the library of <a href=\"http://http://www.mupdf.com/\">mupdf</a>.\
		</p><hr>\
		<p>\
		<h4>Modes</h4>\
		<h5>normal mode</h5>\
		The normal mode (column mode and text mode switches are off) is page oriented (e.g. next means next page), \
		therefore it's convenient to view images and get the outline of the page.\
		<h5>column mode</h5>\
		Column mode identifies horizontally overlapping text areas as columns and is designed for reading them left to right.\
		The next button, lower tap zone and the keys mapped to them scroll down until the end of the column and then switche to \
		the beginning of the next column. By changing the zoom accordingly, the column mode is best for reading text.\
		<b>Note:</b> Works well even with a single column.\
		<h5>text mode</h5>\
		Text mode is included as an emergency mode only (tiny font, column detection fails etc.), the reading experience is much worse\
		than in column mode in the general case.<b>Note:</b> Search and highlighting don't work in text mode.\
		<h4>Buttons and Input fields</h4>\
		<table border=1>\
		<tr><td>file</td><td>open new file</td></tr>\
		<tr><td>&lt;?</td><td>search previous appearance</td></tr>\
		<tr><td>aA</td><td>case sensitivity on/off</td></tr>\
		<tr><td>search field</td><td>highlight phrase on page (search starts with &lt;? / ?&gt;)</td></tr>\
		<tr><td>| - + 0</td><td>scroll direction(s)</td></tr>\
		<tr><td>[]</td><td>fullscreen on/off</td></tr>\
		<tr><td>help</td><td>You found out about it by now, I expect.</td></tr>\
		<tr><td colspan=2><td></tr>\
		<tr><td>page number</td><td>change it to switch the page</td></tr>\
		<tr><td>&lt;|</td><td>go to first page</td></tr>\
		<tr><td>&lt;</td><td>previous page or (part of) column </td></tr>\
		<tr><td>z+</td><td>zoom in by 3% (of current zoom)</td></tr>\
		<tr><td>z0</td><td>set zoom to 1=100%</td></tr>\
		<tr><td>zoom in percent</td><td>set it explicitly</td></tr>\
		<tr><td>mode switches</td><td>see above</td></tr>\
		<tr><td>quit</td><td>exit the application</td></tr>\
		</table>\
		</p>\
		"
	}
		MouseArea {
			anchors.fill: parent
			onClicked: {helpScreen.visible = false;helpScreen.parent.focus=true}
		}
	}

}