#include "flashlightactiondialog.h"
#include "ui_flashlightactiondialog.h"
#include <QDesktopServices>
#include <QUrl>

FlashlightActionDialog::FlashlightActionDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::FlashlightActionDialog)
{
    ui->setupUi(this);

    this->setWindowTitle(tr("Flashlight-extra"));

    this->connect(this->ui->btnExitDaemon, SIGNAL(pressed()), this, SLOT(buttonQuitPressedSlot()));
    this->connect(this->ui->btnCamera, SIGNAL(pressed()), this, SLOT(buttonLaunchCameraPressedSlot()));
    this->connect(this->ui->btnFlashlight, SIGNAL(pressed()), this, SLOT(buttonLaunchFlashlightPressedSlot()));

    this->connect(this->ui->btnHelp, SIGNAL(pressed()), this, SLOT(buttonHelpPressedSlot()));
}

FlashlightActionDialog::~FlashlightActionDialog()
{
    delete ui;
}


void FlashlightActionDialog::buttonQuitPressedSlot(){
    emit this->buttonQuitPressedSignal();
}

void FlashlightActionDialog::buttonLaunchCameraPressedSlot(){
    emit this->buttonLaunchCameraPressedSignal();
}

void FlashlightActionDialog::buttonLaunchFlashlightPressedSlot(){
    emit this->buttonLaunchFlashlightPressedSignal();
}

void FlashlightActionDialog::buttonHelpPressedSlot(){
     QDesktopServices::openUrl(QUrl("http://thecodecentral.com/flashlight-extra-for-maemo-nokia-n900", QUrl::TolerantMode));
     this->hide();
}
