#ifndef FLASHLIGHTEXTRADAEMO_H
#define FLASHLIGHTEXTRADAEMO_H

#include <QObject>
#include <QThread>

class FlashlightActionDialog;


class FlashlightExtraDaemo : public QThread

{
    Q_OBJECT
public:
    explicit FlashlightExtraDaemo(QObject *parent = 0);

    static const QString DBUS_HAL_DEVICE_SERVER;
    static const QString DBUS_HAL_DEVICE_INTERFACE;

    static const QString DBUS_PATH_PLATFORM_KB_LOCK;
    static const QString DBUS_PATH_PLATFORM_CAM_SHUTTER;

    void setCameraUiEnabled(bool);
    bool isCoverOpened();
    bool isLockKeyPressed();
    void setFlashlightState(bool);
    void lauchCameraApp();

    virtual void run();




    ~FlashlightExtraDaemo();
signals:

public slots:
    void onCamShutterChanged(QString, QString);
    void buttonQuitPressedPressed();
    void buttonLaunchCameraPressed();
    void buttonLaunchFlashlightPressed();

protected:
    FlashlightActionDialog* actionDialog;

};

#endif // FLASHLIGHTEXTRADAEMO_H
