#include "QMaemo5InformationBox"
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <qdir.h>
#include <QSettings>
#include <QMessageBox>
#include "qmaemo5rotator.h"
#include "rename.h"
#include "clipboard.h"
#include "bookmarks.h"
#include "toolsdialog.h"
#include "share.h"
#include "settings.h"
#include "qtfilecopier.h"
#include "qtcopydialog.h"
#include "filedeleter.h"
#include "deletedialog.h"
#include "askdialog.h"
#include "loadimage.h"
#include "error.h"
#include "compressdlg.h"
#include "unzip.h"
#include "about.h"
#include "help.h"
#include "home.h"
#include "selecticon.h"
#include "filedelegate.h"
#include "hildon-mime.h"
#include "sys/vfs.h"

//#include "sharingdialog/sharing-dialog.h"

#include "dbus-1.0/dbus/dbus.h"
#include "libosso.h"


int SymPressed;
int ShPressed;
int StartThread;
QString sPath, lastPath;
QIcon ic1;
QSettings settings("cepiperez", "filemanager");
QSettings fileicons("cepiperez", "filemanager_icons");
QSettings foldericons("cepiperez", "filemanager_folders");
QFileSystemWatcher * watcher;
int multi = 1;
int ordenFile;
QString color1, color2;


MainWindow::MainWindow(QWidget *parent, QString openfolder) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
#endif

    ui->setupUi(this);

    if ( ! QFileInfo("/home/user/.thumbnails/filebox").exists() )
    {
        QDir selected("/home/user/.thumbnails");
        selected.mkdir("filebox");
    }
    QString sended = "chown -R user:users /home/user/.thumbnails/filebox";
    QByteArray ba = sended.toLatin1();
    const char *str1 = ba.data();
    system(str1);
    sended = "chown -R user:users /home/user/.config/cepiperez";
    ba = sended.toLatin1();
    str1 = ba.data();
    system(str1);
    sended = "chown -R user:users /home/user/filebox-terminal";
    ba = sended.toLatin1();
    str1 = ba.data();
    system(str1);


    QString iconSet = settings.value("IconStyle", "Default").toString();

    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/folder_up.png");
    ui->pushButton->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/home.png");
    ui->pushButton_2->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/bookmarks.png");
    ui->h_bookmarks->setIcon( ic1 );
    ui->v_bookmarks->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/clipboard.png");
    ui->h_clipboard->setIcon( ic1 );
    ui->v_clipboard->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/settings.png");
    ui->h_settings->setIcon( ic1 );
    ui->v_settings->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/tools.png");
    ui->h_tools->setIcon( ic1 );
    ui->v_tools->setIcon( ic1 );
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/fullsize.png");
    ui->h_full->setIcon( ic1 );
    ui->v_full->setIcon( ic1 );


    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/close.png");
    ui->qsearch->setIcon( ic1 );
    //ui->swidget->setVisible(false);

    if ( settings.value("Multiselection","No").toString() == "Yes"  ) multi=1; else multi=0;

    watcher = new QFileSystemWatcher(this);

    QFile data( "/etc/hildon/theme/gtk-2.0/gtkrc" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        int start=0;
        QTextStream out(&data);
        while ( !out.atEnd() || start<2 )
        {
            QString line = out.readLine();
            if ( line.indexOf("color[\"DefaultTextColor\"]") != -1 )
            {
                line.replace("color[\"DefaultTextColor\"]","");
                line.replace("=",""); line.replace("\"","");
                line = line.trimmed();
                color1 = line;
                ++start;
            }
            if ( line.indexOf("color[\"SecondaryTextColor\"]") != -1 )
            {
                line.replace("color[\"SecondaryTextColor\"]","");
                line.replace("=",""); line.replace("\"","");
                line = line.trimmed();
                color2 = line;
                ++start;
            }
        }
    }
    data.close();

    FileDelegate *pluginDelegate = new FileDelegate(this,multi,color1,color2);
    ui->listWidget->setItemDelegate(pluginDelegate);

    if ( openfolder != "" )
        CargarBrowser( openfolder );
    else if ( settings.value("Start", "device").toString() == "device" )
        checkDevice();
    else
        CargarBrowser( settings.value("Home", "/home").toString() );

    connect(watcher, SIGNAL(directoryChanged(const QString)), this, SLOT(dirChanged(const QString)));

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    //setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    //orientationChanged();
    checkOrientation();

}

MainWindow::~MainWindow()
{
    QString sended = "chown -R user:users /home/user/.thumbnails/filebox";
    QByteArray ba = sended.toLatin1();
    const char *str1 = ba.data();
    system(str1);
    sended = "chown -R user:users /home/user/.config/cepiperez";
    ba = sended.toLatin1();
    str1 = ba.data();
    system(str1);
    sended = "chown -R user:users /home/user/filebox-terminal";
    ba = sended.toLatin1();
    str1 = ba.data();
    system(str1);
    delete ui;
    settings.remove("FilesToCut");
    settings.remove("FilesToPaste");
    settings.remove("ClipboardSelected");
    settings.remove("arguments");
    if ( QFileInfo("/home/user/MyDocs/.tempfile").exists() ) system("rm /home/user/MyDocs/.tempfile");
}

void MainWindow::checkDevice()
{
    QSettings settings( "/etc/hildon/theme/index.theme", QSettings::IniFormat );
    QString currtheme = settings.value("X-Hildon-Metatheme/IconTheme","hicolor").toString();

    CargarBrowser("_DEVICE_");
    sPath = "/";

    QFile data( "/etc/mtab" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        procesos.clear();
        QTextStream out(&data);
        while ( !out.atEnd() )
        {
            QString line = out.readLine();
            if ( line.startsWith("/dev") )
            {
                QString line2 = line;
                int i = line.indexOf(" ");
                line.remove(i,line.length()-i);
                line2.remove(0,i+1);
                i = line2.indexOf(" ");
                line2.remove(i,line2.length()-i);

                if ( line2 != "/home" )
                {
                    QListWidgetItem *item1 = new QListWidgetItem();
                    item1->setData(Qt::DisplayRole, line);
                    item1->setStatusTip(line2.remove(0,1));
                    item1->setData(Qt::UserRole+10," ");

                    if ( line2 == "home/user/MyDocs" )
                        item1->setData(Qt::UserRole+2,"/usr/share/icons/"+currtheme+"/48x48/hildon/general_device_root_folder.png");
                    else if ( line2.contains("media/mmc") )
                        item1->setData(Qt::UserRole+2,"/usr/share/icons/"+currtheme+"/48x48/hildon/general_removable_memory_card.png");
                    else
                        item1->setData(Qt::UserRole+2,"/usr/share/icons/"+currtheme+"/48x48/hildon/filemanager_removable_storage.png");

                    ui->listWidget->addItem(item1);
                    ui->listWidget->item(ui->listWidget->count()-1)->setHidden(true);

                    procesos += QString("/sbin/blkid " + line);

                }
            }

        }
    }
    data.close();
    execDevice();

}

void MainWindow::execDevice()
{
        proc = new QProcess(this);
        connect ( proc, SIGNAL(finished(int)), this, SLOT(checkFinished(int)) );
        proc->start(procesos.at(0));
        // qDebug() << "Processing: " << procesos.at(0);
}

void MainWindow::checkFinished(int)
{
    QString str = proc->readAllStandardOutput();
    QString str2 = str;

    if ( !str.contains("LABEL=") )
    {
        if ( str.contains("/dev/mmcblk") )
            str = tr("Memory Card");
        else
            str = tr("Removable device");
    }
    else
    {
        int i = str2.indexOf(":");
        str2.remove(i,str2.length()-i);
        i = str.indexOf("LABEL=");
        str.remove(0,i+7);
        i = str.indexOf("\"");
        str.remove(i,str.length()-i);
    }

    for (int i=0; i<ui->listWidget->count(); ++i)
    {
        if ( str2.contains(ui->listWidget->item(i)->data(Qt::DisplayRole).toString()) )
            ui->listWidget->item(i)->setData(Qt::UserRole+10, str);
            QApplication::processEvents();
            ui->listWidget->item(i)->setHidden(false);
    }

    procesos.removeAt(0);
    if ( !procesos.isEmpty() )
        execDevice();

}

void MainWindow::checkOrientation()
{
    QString orient = settings.value("Orientation", "Auto").toString();
    if (orient == "Portrait")
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    else if (orient == "Landscape")
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    else
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    orientationChanged();
}

void MainWindow::orientationChanged()
{
     QRect screenGeometry = QApplication::desktop()->screenGeometry();
     if (screenGeometry.width() > screenGeometry.height())
     {
         ui->widget->setVisible(true);
         ui->widget_3->setVisible(false);
         //ui->listWidget->setMaximumWidth(720);
     }
     else
     {
         ui->widget->setVisible(false);
         ui->widget_3->setVisible(true);
         //ui->listWidget->setMaximumWidth(400);
     }

}


void MainWindow::CargarBrowser(QString directorio)
{
    ordenFile = 0;

    ui->listWidget->clear();
    ui->lineEdit->setVisible(false);
    ui->search->setText("");
    ui->swidget->setVisible(false);

    if ( directorio == "_DEVICE_" )
    {
        ui->listWidget->setSortingEnabled(false);
        ui->pushButton->setEnabled(false);
        ui->v_clipboard->setEnabled(false);
        ui->h_clipboard->setEnabled(false);
        ui->barButton->setText(tr(" Devices"));
        ui->barButton->setValueText("");
        return;

    }
    else
    {
        ui->listWidget->setSortingEnabled(true);
        ui->pushButton->setEnabled(true);
        ui->v_clipboard->setEnabled(true);
        ui->h_clipboard->setEnabled(true);
    }

    sPath = directorio;

    QDir dir ( directorio, "*" );
    if ( !dir.isReadable() )
          return;
    ui->lineEdit->setText(directorio);
    if ( directorio == "/")
    {
        ui->barButton->setText( " /" );
        ui->barButton->setValueText( "" );
    }
    else
    {
        if (directorio.endsWith("/") )
            directorio.left(directorio.length()-1);
        ui->barButton->setText( " " + QFileInfo(directorio).fileName() );
        ui->barButton->setValueText( " " + QFileInfo(directorio).path() );
    }

    ui->barButton->setVisible(true);
    ui->barButton->setIcon( QPixmap() );

    StartThread = 0;

    QStringList entries = dir.entryList();
    entries.sort();
    QStringList::ConstIterator it = entries.begin();

    if ( settings.value("ShowHiddenFiles", "No").toString() == "Yes" ) {
        dir.setFilter( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot | QDir::System );
    } else {
        dir.setFilter( QDir::AllEntries | QDir::NoDotAndDotDot | QDir::System );
    }

    /*int sorder = settings.value("SortIndex", 1).toInt();
    if ( sorder == 1 ) dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 2 ) dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);
    if ( sorder == 3 ) dir.setSorting( QDir::Time | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 4 ) dir.setSorting( QDir::Time | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);
    if ( sorder == 5 ) dir.setSorting( QDir::Size | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 6 ) dir.setSorting( QDir::Size | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);*/


    int sorder = settings.value("SortIndex", 1).toInt();

    if ( sorder==2 ) ui->listWidget->sortItems(Qt::DescendingOrder);
    else ui->listWidget->sortItems(Qt::AscendingOrder);

    QFileInfoList list = dir.entryInfoList();

    for (int i = 0; i < list.size(); ++i)
    {
        agregarArchivo(list.at(i).absoluteFilePath());
    }

    if ( ui->listWidget->count() > 0 ) {
        ui->listWidget->scrollToItem(ui->listWidget->item(0));
        ui->listWidget->clearSelection();
    }

    if ( StartThread == 1 ) {
        Thread *pepe = new Thread(sPath);
        pepe->setPriority(QThread::IdlePriority);
        connect ( pepe, SIGNAL(imgLoaded()), this, SLOT(paintIMG()) );
        pepe->start();
    }

    settings.setValue("CurrentDir", sPath);
    settings.sync();

    QStringList wdirs = watcher->directories();
    if ( wdirs.count() > 0 ) watcher->removePaths(wdirs);
    watcher->addPath( sPath );

}

void MainWindow::dirChanged(const QString directorio)
{
    QApplication::processEvents();

    Thread *pepe = new Thread(directorio);
    pepe->setPriority(QThread::IdlePriority);
    connect ( pepe, SIGNAL(imgLoaded()), this, SLOT(paintIMG()) );
    pepe->start();

    QDir dir ( directorio, "*" );
    StartThread = 0;

    if ( settings.value("ShowHiddenFiles", "No").toString() == "Yes" ) {
        dir.setFilter( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot | QDir::System );
    } else {
        dir.setFilter( QDir::AllEntries | QDir::NoDotAndDotDot | QDir::System );
    }

    /*int sorder = settings.value("SortIndex", 1).toInt();
    if ( sorder == 1 ) dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 2 ) dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);
    if ( sorder == 3 ) dir.setSorting( QDir::Time | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 4 ) dir.setSorting( QDir::Time | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);
    if ( sorder == 5 ) dir.setSorting( QDir::Size | QDir::DirsFirst | QDir::IgnoreCase );
    if ( sorder == 6 ) dir.setSorting( QDir::Size | QDir::DirsFirst | QDir::IgnoreCase | QDir::Reversed);
    */

    QFileInfoList list = dir.entryInfoList();

    for (int j=0; j < ui->listWidget->count(); ++j)
    {
        int borrar=1;
        for (int i = 0; i < list.count(); ++i)
            if ( ui->listWidget->item(j)->statusTip() == list.at(i).fileName() ) borrar=0;
        if ( borrar == 1 ) delete ui->listWidget->takeItem(j);
    }

    QApplication::processEvents();

    for (int i = 0; i < list.count(); ++i)
    {
        int agregar=1;
        for (int j=0; j < ui->listWidget->count(); ++j)
        {
            if ( ui->listWidget->item(j)->statusTip() == list.at(i).fileName() ) agregar=0;
        }
        if ( agregar==1 && list.at(i).fileName()!="filemanager-checking" )
        {
            agregar=0;
            agregarArchivo(list.at(i).absoluteFilePath());
            return;
        }
    }
    //CargarBrowser(sPath);

}

void MainWindow::agregarArchivo(QString archivo)
{
    QFileInfo fileInfo = archivo;

    QString iconSet = settings.value("IconStyle", "Default").toString();
    QString descripcion, icono1;
    QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );

    /*QString itemname = sPath + "/" + fileInfo.fileName();
    if ( itemname == "/home/user/MyDocs/.documents" ) itemname = tr("Documents");
    else if ( itemname == "/home/user/MyDocs/.images" ) itemname = tr("Images");
    else if ( itemname == "/home/user/MyDocs/.sounds" ) itemname = tr("Sounds");
    else if ( itemname == "/home/user/MyDocs/.videos" ) itemname = tr("Videos");
    else if ( itemname == "/home/user/MyDocs/DCIM" ) itemname = tr("Camera");
    else itemname = fileInfo.fileName();*/

    //item1->setData(Qt::DisplayRole, fileInfo.fileName());
    item1->setStatusTip(fileInfo.fileName());

    int sorder = settings.value("SortIndex", 1).toInt();

    if ( fileInfo.isSymLink() ) item1->setData(Qt::UserRole+4, QString("/opt/filebox/icons/" + iconSet + "/link.png") );
    else item1->setData(Qt::UserRole+4, "");

    if ( fileInfo.isDir() )
    {
        QString itemname = fileInfo.fileName();
        QString ficon = foldericons.value(itemname, "general_folder.png").toString();

        if ( ! QFileInfo("/opt/filebox/icons/" + iconSet + "/folders/" + ficon).exists() )
            ficon = "general_folder.png";

        QString prename = " ";
        if ( sorder==2 ) prename = "";

        if ( sorder==1 || sorder==2 ) prename = prename + fileInfo.fileName().toLower();
        else if ( sorder==3 )
        {
            QDateTime now = QDateTime::currentDateTime();
            QDateTime fnow = fileInfo.lastModified();
            int sn = now.secsTo(fnow);
            qint64 val5 = Q_INT64_C(932838457459459);
            val5 = val5 - sn;
            prename = prename + QString("%1").arg(val5);
        }
        else if ( sorder==4 ) prename = prename + fileInfo.lastModified().toString("yyyyMMddHHmmss");
        else if ( sorder==5 )
        {
            qint64 val5 = Q_INT64_C(932838457459459);
            val5 = val5 - fileInfo.size();
            prename = prename + QString("%1").arg(val5);
        }
        else if ( sorder==6 )
        {
            int xi = fileInfo.size();
            QString xp = "000000000000000" + QString("%1").arg(xi);
            while ( xp.length() > 15 ) xp.remove(0,1);
            prename = prename + xp;
        }

        item1->setData(Qt::DisplayRole, prename );

        icono1 = QString("/opt/filebox/icons/" + iconSet + "/folders/" + ficon);
        descripcion = "";


        /*if ( QFileInfo(archivo + "/.mediaartlocal").exists() )
        {
            QDir dir ( archivo + "/.mediaartlocal", "*" );
            dir.setFilter( QDir::Files | QDir::NoDotAndDotDot );
            QStringList entries = dir.entryList();
            item1->setData(Qt::UserRole+5, archivo + "/.mediaartlocal" + "/" + entries[0] );
        }*/


    }
    else
    {
        if ( fileInfo.exists() )
        {
            QString exten = fileInfo.completeSuffix();
            if ( exten != "note.html")
            {
                exten = fileInfo.fileName().toLower();
                int ei = exten.lastIndexOf( "." );
                if ( ei > 0 ) exten.remove ( 0, ei );
            }
            QString extension = fileicons.value( exten, "file_other.png").toString();
            icono1 = QString("/opt/filebox/icons/" + iconSet + "/mime/%1").arg(extension);
            if ( (exten.toLower()==".jpg") || (exten.toLower()==".jpeg") || (exten.toLower()==".png") || (exten.toLower()==".gif") || (exten.toLower()==".bmp") )
            {
                if (settings.value("Thumbnails","No")=="Yes")
                {
                    QString file = sPath + "/" + fileInfo.fileName();
                    file.replace("/","-");
                    QString th1 = "/home/user/.thumbnails/filebox/"+file+".png";
                    if ( QFileInfo( th1 ).exists() )
                    {
                        icono1 = th1;
                    }
                    else
                    {
                        item1->setWhatsThis(" ");
                        icono1 = QString("/opt/filebox/icons/" + iconSet + "/mime/file_loading.png");
                        StartThread = 1;
                    }
                }
            }
        }
        else
        {
            icono1 = QString("/opt/filebox/icons/" + iconSet + "/mime/broken.png");
        }

        QString prename = "";
        if ( sorder==2 ) prename = " ";

        if ( sorder==1 || sorder==2 ) prename = prename + fileInfo.fileName().toLower();
        else if ( sorder==3 )
        {
            QDateTime now = QDateTime::currentDateTime();
            QDateTime fnow = fileInfo.lastModified();
            int sn = now.secsTo(fnow);
            qint64 val5 = Q_INT64_C(932838457459459);
            val5 = val5 - sn;
            prename = prename + QString("%1").arg(val5);
        }
        else if ( sorder==4 ) prename = prename + fileInfo.lastModified().toString("yyyyMMddHHmmss");
        else if ( sorder==5 )
        {
            qint64 val5 = Q_INT64_C(932838457459459);
            val5 = val5 - fileInfo.size();
            prename = prename + QString("%1").arg(val5);
        }
        else if ( sorder==6 )
        {
            int xi = fileInfo.size();
            QString xp = "000000000000" + QString("%1").arg(xi);
            while ( xp.length() > 12 ) xp.remove(0,1);
            prename = prename + xp;
        }

        item1->setData(Qt::DisplayRole, prename );

        if ( settings.value("FilesDetail", "No").toString()=="Yes" )
        {
            if ( ! fileInfo.exists() )
                descripcion = "brokenlink";
            else if ( QLocale::languageToString(QLocale::system().language()) == "English" )
                descripcion = QString("%1 %2 - %3").arg(fileInfo.lastModified().date().toString("MM/dd/yyyy")).arg(fileInfo.lastModified().time().toString("HH:mm:ss")).arg(GetFileSize(fileInfo.size()));
            else
                descripcion = QString("%1 %2 - %3").arg(fileInfo.lastModified().date().toString("dd/MM/yyyy")).arg(fileInfo.lastModified().time().toString("HH:mm:ss")).arg(GetFileSize(fileInfo.size()));
        }
        else descripcion = "";

    }

    if ( multi == 1) {
        item1->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEnabled);
        item1->setCheckState(Qt::Unchecked);
        item1->setData(Qt::UserRole+3, 0);
    }
    item1->setData(Qt::UserRole + 1, descripcion);
    item1->setData(Qt::UserRole + 2, icono1);

    ui->listWidget->insertItem( 0, item1 );

}

QString MainWindow::GetFileSize(int size)
{
    QString ss;
    if (size < 1024) {
      ss = QString("%1 b").arg(size);
    } else if (size < 1024*1024) {
      ss = QString("%1").arg( (double)(size) / 1024);
      size = ss.indexOf(QChar('.')); if ( size > -1 ) { ss.remove(size+3, ss.length()-size-3); }
      ss = ss + " Kb";
    } else {
      ss = QString("%1").arg( (double)(size) / 1024 / 1024);
      size = ss.indexOf(QChar('.')); if ( size > -1 ) { ss.remove(size+3, ss.length()-size-3); }
      ss = ss + " Mb";
    }
    return ss;
}

void MainWindow::paintIMG()
{
    for (int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->whatsThis() == " " )
        {
            QString file = sPath + "/" + ui->listWidget->item(i)->statusTip();
            file.replace("/","-");
            QString th1 = "/home/user/.thumbnails/filebox/"+file+".png";
            if ( QFileInfo( th1 ).exists() )
            {
                QImage result = QImage(th1);
                ui->listWidget->item(i)->setData(Qt::UserRole + 2, th1);
            }
        }
    }

}

void MainWindow::OpenFile(QString file)
{
    QFileInfo fileInfo(file);
    QString exten = fileInfo.fileName().toLower();
    int ei = exten.lastIndexOf( "." );
    exten.remove ( 0, ei );

    QString ex1 = fileInfo.fileName();
    if ( ex1.endsWith(".tar") || ex1.endsWith(".tar.gz") || ex1.endsWith(".tar.bz2") || ex1.endsWith(".tbz2") || ex1.endsWith(".zip") || ex1.endsWith(".rar") )
    {
        int okay;
        if ( ex1.endsWith(".tar") ) okay=1;
        else if ( ex1.endsWith(".tar.gz") ) okay=1;
        else if ( ex1.endsWith(".tar.bz2") ) okay=1;
        else if ( ex1.endsWith(".tbz2") ) okay=1;
        else if ( ex1.endsWith(".zip") && QFileInfo("/usr/bin/unzip").exists() ) okay=1;
        else if ( ex1.endsWith(".rar") && QFileInfo("/usr/bin/unrar").exists() ) okay=1;
        else okay=0;

        if ( okay == 1 )
        {
            settings.remove("NeedToRefresh");
            Unzip* zw = new Unzip(this,file);
            zw->exec();
            settings.remove("NeedToRefresh");
            return;
        }
    }

    DBusConnection *dbus;
    osso_context_t *osso;
    osso = osso_initialize("osso-filemanager", "", TRUE, NULL);
    dbus = (DBusConnection *) osso_get_dbus_connection(osso);

    file = "file://" + file;
    file.replace("#","%2523");
    file.replace(",","%2C");
    file.replace(" ","%20");

    QByteArray ba = file.toUtf8();
    const char *str1 = ba.data();
    //con = dbus_bus_get (DBUS_BUS_SESSION, NULL);
    hildon_mime_open_file(dbus,str1);



}

void MainWindow::on_listWidget_itemClicked(QListWidgetItem* item)
{
    if ( multi == 0 )
    {
        QString temp = sPath;
        if ( temp != "/" ) temp.append("/");
        temp.append( item->statusTip() );

        if ( QFileInfo(temp).isFile() )
        {
            OpenFile( temp );
        }
        else if ( QFileInfo(temp).isDir() )
        {
            CargarBrowser( temp );
        }
    }
    else
    {
        if ( ui->listWidget->currentItem()->checkState()==Qt::Checked) {
            ui->listWidget->currentItem()->setCheckState(Qt::Unchecked);
            ui->listWidget->currentItem()->setData(Qt::UserRole+3, 0);
        } else {
            ui->listWidget->currentItem()->setCheckState(Qt::Checked);
            ui->listWidget->currentItem()->setData(Qt::UserRole+3, 1);
        }
    }
}

void MainWindow::on_listWidget_itemDoubleClicked(QListWidgetItem* item)
{
    if ( multi == 1 )
    {
        QString temp = sPath;
        if ( temp != "/" ) temp.append("/");
        temp.append( item->statusTip() );

        if ( QFileInfo(temp).isFile() )
        {
            OpenFile( temp );
        }
        else if ( QFileInfo(temp).isDir() )
        {
            QApplication::processEvents();
            CargarBrowser( temp );
            ui->listWidget->clearSelection();
        }
    }
}

void MainWindow::on_pushButton_clicked()
{
    if ( sPath == "/" )
    {
        checkDevice();
        return;
    }
    lastPath = sPath;
    QString nPath = sPath;
    int i = nPath.lastIndexOf( "/" );
    nPath.remove ( i, nPath.length() - i );
    if ( nPath == "" ) nPath = "/";
    CargarBrowser( nPath );
    for (i=0; i < ui->listWidget->count(); ++i)
    {
        QString temp = sPath + "/" + ui->listWidget->item(i)->statusTip();
        if ( temp == lastPath )
        {
            ui->listWidget->scrollToItem(ui->listWidget->item(i),QAbstractItemView::PositionAtCenter);
        }

    }

}

void MainWindow::on_pushButton_2_clicked()
{
    QString nPath = settings.value( "Home", "/home").toString();
    CargarBrowser( nPath );
}

void MainWindow::on_lineEdit_returnPressed()
{
    QString add = ui->lineEdit->text();
    if ( (add.right(1)=="/") && (add.length()>1) ) add.remove(add.length()-1,1);
    if ( QFileInfo(add).isDir() )
        CargarBrowser( add );
    ui->lineEdit->setVisible(false);
    ui->barButton->setVisible(true);
}

void MainWindow::on_v_tools_clicked()
{
    on_h_tools_clicked();
}

void MainWindow::on_h_tools_clicked()
{
    settings.remove("FilesToCut");
    settings.remove("FilesToPaste");
    settings.remove("AddSymlink");
    ToolsDialog* td = new ToolsDialog(this, sPath);
    td->exec();
    if ( settings.value("AddSymlink", "No").toString()=="Yes" ) addSymlink();
    if ( settings.value("NeedToRefresh","Yes").toString() == "Yes" ) CargarBrowser(sPath);
    settings.remove("NeedToRefresh");
    checkClipboard();
}

void MainWindow::addSymlink()
{
    settings.remove("Symlink");
    Home* hw = new Home(this, "Symlink", sPath, true);
    hw->exec();
    QString ls1 = settings.value("Symlink","").toString();
    if ( ls1 != "")
    {
        int errores = 0;
        QString tf = sPath + "/filemanager-checking";
        QFile destFile(tf);
        if (!destFile.open(QIODevice::WriteOnly))
        {
            Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;
        QFile::remove(tf);

        QString lss = "ln -s " + ls1 + " " + sPath + "/" + QFileInfo(ls1).fileName();
        QByteArray ba = lss.toLatin1();
        const char *str1 = ba.data();
        system(str1);

        if ( ! QFileInfo(sPath + "/" + QFileInfo(ls1).fileName()).exists() )
        {
            Error* ed = new Error( this, tr("Cannot create symlink in this folder") );
            ed->exec();
        }
        else
        {
            dirChanged(sPath);
        }

        settings.remove("Symlink");
    }
    settings.remove("AddSymlink");

}

void MainWindow::on_listWidget_customContextMenuRequested(QPoint pos)
{
    if ( ui->listWidget->count() == 0 ) return;
    if ( ui->listWidget->selectedItems().count() == 0 ) return;

    int seleccionados=0;
    QString item = sPath + "/" + ui->listWidget->currentItem()->statusTip();

    if ( multi == 1 )
    {
        for (int mi=0; mi < ui->listWidget->count(); ++mi)
        {
            if ( ui->listWidget->item(mi)->checkState()==Qt::Checked ) seleccionados=seleccionados+1;
        }
        if (seleccionados==0) return;
        if (seleccionados>=1 && ui->listWidget->currentItem()->checkState()==Qt::Unchecked ) return;
    }

    QMenu *contextMenu = new QMenu(this);
    contextMenu->addAction(ic1, tr("Copy"), this, SLOT(addToClipboard()));

    if ( (multi==0) || (multi==1 && seleccionados==1 && ui->listWidget->currentItem()->checkState()==Qt::Checked ) )
        contextMenu->addAction(ic1, tr("Rename"), this, SLOT(renameSel()));

    contextMenu->addAction(ic1, tr("Delete"), this, SLOT(removeSel()));

    if ( ( multi==1 && seleccionados==1 && ui->listWidget->currentItem()->checkState()==Qt::Checked && QFileInfo(item).isFile() ) || ( multi==0 && QFileInfo(item).isFile() ) )
    {
        contextMenu->addAction(ic1, tr("Edit"), this, SLOT(editSel()));
    }

    if ( ( multi==1 && seleccionados==1 && ui->listWidget->currentItem()->checkState()==Qt::Checked && QFileInfo(item).isDir() ) ||  ( multi==0 && QFileInfo(item).isDir() ) )
    {
        contextMenu->addSeparator();
        contextMenu->addAction(ic1, tr("Change icon"), this, SLOT(changeIcon()));
    }
    contextMenu->addAction(ic1, tr("Compress"), this, SLOT(compressSel()));

    if ( ( multi==1 && seleccionados>0 ) ||  ( multi==0 && QFileInfo(item).isFile() ) )
    {
        contextMenu->addSeparator();
        contextMenu->addAction(ic1, tr("Share"), this, SLOT(shareBT()));
    }

    /*if ( (multi==0) || (multi==1 && ui->listWidget->selectedItems().count()==1) )
    {
        contextMenu->addSeparator();
        contextMenu->addAction(ic1, tr("Permissions"), this, SLOT(permissionSel()));
    }*/


    contextMenu->exec(mapToGlobal(pos));

}

void MainWindow::changeIcon()
{
    QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
    selectIcon* sw = new selectIcon(this, clip);
    sw->exec();

    QString iconSet = settings.value("IconStyle", "Default").toString();
    QString ficon = foldericons.value( QFileInfo(clip).fileName(), "general_folder.png").toString();
    ui->listWidget->currentItem()->setData(Qt::UserRole + 2, "/opt/filebox/icons/" + iconSet + "/folders/" + ficon);

}

void MainWindow::compressSel()
{
    settings.remove("NeedToRefresh");
    settings.remove("arguments");
    QStringList list;
    if ( multi == 0 )
    {
        QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        list.append(clip);
    }
    else
    {
        for (int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( ui->listWidget->item(i)->checkState() == Qt::Checked )
            {
                QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                list.append(clip);
            }
        }
    }
    settings.setValue("CompressFolder",sPath);

    CompressDlg* cf = new CompressDlg(this, sPath, list);
    cf->exec();
    if ( settings.value("NeedToRefresh","No").toString() == "Yes" ) CargarBrowser(sPath);
    settings.remove("NeedToRefresh");
    settings.remove("arguments");


}


void MainWindow::permissionSel()
{
    //QString file = sPath + "/" + ui->listWidget->currentItem()->statusTip();
    //Permissions* cw = new Permissions(this,file);
    //cw->exec();

}

void MainWindow::editSel()
{
    if ( settings.value("TextEditor", "-").toString() == "PyGTKEditor" && QFileInfo("/usr/bin/pygtkeditor").exists() )
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        QString sended;
        if ( QFileInfo(file1).isWritable() ) sended = "/usr/bin/pygtkeditor \"" + file1 + "\"&";
        else
        {
            if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
                sended = "sudo /usr/bin/run-standalone.sh /usr/bin/pygtkeditor \"" + file1 + "\"&";
            else
                sended = "/usr/bin/pygtkeditor \"" + file1 + "\"&";
        }

        QByteArray ba = sended.toLatin1();
        const char *str1 = ba.data();
        system(str1);
    }
    else if ( settings.value("TextEditor", "-").toString() == "Leafpad" && QFileInfo("/usr/bin/leafpad").exists() )
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        QString sended;
        if ( QFileInfo(file1).isWritable() ) sended = "/usr/bin/leafpad \"" + file1 + "\"&";
        else
        {
            if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
                sended = "sudo /usr/bin/run-standalone.sh /usr/bin/leafpad \"" + file1 + "\"&";
            else
                sended = "/usr/bin/leafpad \"" + file1 + "\"&";
        }

        QByteArray ba = sended.toLatin1();
        const char *str1 = ba.data();
        system(str1);
    }
    else if ( settings.value("TextEditor", "-").toString() == "Nano" && QFileInfo("/usr/bin/nano").exists() )
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        QString sended;
        if ( QFileInfo(file1).isWritable() ) sended = "osso-xterm \"sudo /usr/bin/nano "+ file1 + "\"&";
        else
        {
            if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
                sended = "osso-xterm \"sudo /usr/bin/nano "+ file1 + "\"&";
            else
                sended = "osso-xterm \"sudo /usr/bin/nano "+ file1 + "\"&";
        }

        QByteArray ba = sended.toLatin1();
        const char *str1 = ba.data();
        system(str1);
    }
    else if ( settings.value("TextEditor", "-").toString() == "Vim" && QFileInfo("/usr/bin/vim").exists() )
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        QString sended;
        if ( QFileInfo(file1).isWritable() ) sended = "osso-xterm \"sudo /usr/bin/vim "+ file1 + "\"&";
        else
        {
            if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
                sended = "osso-xterm \"sudo /usr/bin/vim "+ file1 + "\"&";
            else
                sended = "osso-xterm \"sudo /usr/bin/vim "+ file1 + "\"&";
        }

        QByteArray ba = sended.toLatin1();
        const char *str1 = ba.data();
        system(str1);
    }
    else if ( settings.value("TextEditor", "-").toString() == "Vi" )
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        QString sended;
        if ( QFileInfo(file1).isWritable() ) sended = "osso-xterm \"sudo /usr/bin/vi "+ file1 + "\"&";
        else
        {
            if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
                sended = "osso-xterm \"sudo /usr/bin/vi "+ file1 + "\"&";
            else
                sended = "osso-xterm \"sudo /usr/bin/vi "+ file1 + "\"&";
        }

        QByteArray ba = sended.toLatin1();
        const char *str1 = ba.data();
        system(str1);
    }
    else
    {
        QString file1 = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        DBusConnection *dbus;
        osso_context_t *osso;
        osso = osso_initialize("osso-mime-common", "0.1", TRUE, NULL);
        dbus = (DBusConnection *) osso_get_dbus_connection(osso);
        QByteArray ba = file1.toUtf8();
        const char *str1 = ba.data();
        hildon_mime_open_file_with_mime_type(dbus,str1,"text/plain");
    }

}

void MainWindow::on_h_clipboard_clicked()
{
    on_v_clipboard_clicked();
}

void MainWindow::on_v_clipboard_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
    settings.remove("FilesToPaste");
    settings.remove("FilesToCut");
    Clipboard* cw = new Clipboard(this,sPath);
    cw->exec();
    checkClipboard();
}

int  MainWindow::GetFolderSize (const QString &path )
{
  //recursive
  QDir dir ( path );
  QStringList::Iterator it;
  int size = 0;
  QStringList files = dir.entryList ( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot );
  it = files.begin();
  while ( it != files.end() ) {
    size += QFileInfo ( path, *it ).size();
    ++it;
  }
  QStringList dirs = dir.entryList ( QDir::Dirs );
  it = dirs.begin();
  while ( it != dirs.end() ) {
    if ( *it != "." && *it != ".." )
      size += GetFolderSize ( path + "/" + *it );
    ++it;
  }

  return size;
}

void MainWindow::checkClipboard()
{
    int errores=0;
    settings.remove("CopiedFiles");
    QStringList temp = settings.value("FilesToPaste", QStringList() ).toStringList();
    if ( temp.count() > 0 )
    {
        struct statfs stat;
        unsigned long freeSize = 0;
        int TargetSize = 0;
        QByteArray ba = sPath.toLatin1();
        const char *str1 = ba.data();
        statfs ( str1, &stat );
        freeSize = stat.f_bsize*stat.f_bfree;
        for (int fi=0; fi < temp.count(); ++fi)
        {
            if ( QFileInfo(temp[fi]).isFile() ) TargetSize += QFileInfo(temp[fi]).size();
            else TargetSize += GetFolderSize( temp[fi] );
        }

        if ( freeSize < TargetSize )
        {
            Error* ed = new Error( this, tr("Not enough space to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;

        QString tf = sPath + "/filemanager-checking";
        QFile destFile(tf);
        if (!destFile.open(QIODevice::WriteOnly))
        {
            Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;
        QFile::remove(tf);


        QtFileCopier fileCopier;
        QtCopyDialog d(&fileCopier, this);
        fileCopier.copyFiles(temp, sPath);
        d.exec();

        if ( settings.value("DeleteOnPaste", "No").toString() == "Yes" ) {
            QStringList copiado = settings.value("CopiedFiles", QStringList()).toStringList();
            if ( copiado.count() > 0 )
            {
                for ( int i=0; i < copiado.count(); ++i)
                {
                    QStringList books; QString tempx;
                    QStringList list = settings.value("Clipboard","").toStringList();
                    for (int j=0; j < list.count(); ++j)
                    {
                        tempx = copiado[i];
                        if ( QFileInfo(list[j]).isDir() )
                        {
                            if ( tempx.indexOf(list[j]) == -1 ) books.append( list[j] );

                        }
                        else if ( list[j] != copiado[i] ) {
                            books.append( list[j] );
                        }
                    }

                    if ( books.count() > 0) settings.setValue( "Clipboard", books );
                    else settings.remove( "Clipboard" );
                    settings.sync();
                }
            }
            settings.remove("FilesToPaste");
        }
        //settings.remove("CopiedFiles");
        //CargarBrowser(sPath);
        dirChanged(sPath);

    }

    temp = settings.value("FilesToCut", QStringList() ).toStringList();
    if ( temp.count() > 0 )
    {
        struct statfs stat;
        unsigned long freeSize = 0;
        int TargetSize = 0;
        QByteArray ba = sPath.toLatin1();
        const char *str1 = ba.data();
        statfs ( str1, &stat );
        freeSize = stat.f_bsize*stat.f_bfree;
        for (int fi=0; fi < temp.count(); ++fi)
        {
            if ( QFileInfo(temp[fi]).isFile() ) TargetSize += QFileInfo(temp[fi]).size();
            else TargetSize += GetFolderSize( temp[fi] );
        }

        if ( freeSize < TargetSize )
        {
            Error* ed = new Error( this, tr("Not enough space to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;

        QString tf = sPath + "/filemanager-checking";
        QFile destFile(tf);
        if (!destFile.open(QIODevice::WriteOnly))
        {
            Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;
        destFile.close();
        QFile::remove(tf);

        QtFileCopier fileCopier;
        QtCopyDialog d(&fileCopier, this);
        fileCopier.moveFiles(temp, sPath);
        d.exec();
        settings.remove("FilesToCut");
        //CargarBrowser(sPath);
        dirChanged(sPath);
    }

    QStringList books;
    QStringList lista = settings.value("Clipboard","").toStringList();
    for (int j=0; j < lista.count(); ++j)
    {
        QFileInfo fileInfo1 = lista[j];
        if ( fileInfo1.exists() ) {
            if ( books.indexOf(lista[j]) ==-1 ) books.append( lista[j] );
        }
    }
    if ( books.count() > 0) settings.setValue( "Clipboard", books );
    else settings.remove( "Clipboard" );
    settings.sync();

    books.clear();
    lista = settings.value("ClipboardSelected","").toStringList();
    for (int j=0; j < lista.count(); ++j)
    {
        QFileInfo fileInfo1 = lista[j];
        if ( fileInfo1.exists() ) {
            if ( books.indexOf(lista[j]) ==-1 ) books.append( lista[j] );
        }
    }
    if ( books.count() > 0) settings.setValue( "ClipboardSelected", books );
    else settings.remove( "ClipboardSelected" );
    settings.sync();

}


void MainWindow::removeSel()
{
    /*QMessageBox::StandardButton reply;

    reply = QMessageBox::question(this, tr("Deleting"),
             tr("Are you sure you want to delete %1?").arg(ui->listWidget->currentItem()->statusTip()),
             QMessageBox::Yes | QMessageBox::No );

    if (reply == QMessageBox::Yes)*/

    settings.remove("DeleteAsk");
    int errores=0;
    QString tf = sPath + "/filemanager-checking";
    QFile destFile(tf);
    if (!destFile.open(QIODevice::WriteOnly))
    {
        Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
        ed->exec();
        errores=1;
    }
    if ( errores == 1 ) return;
    destFile.close();
    QFile::remove(tf);

    QStringList lista; lista.clear();
    if ( multi == 0 )
    {
        QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        lista.append(clip);
    }
    else
    {
        for (int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( ui->listWidget->item(i)->checkState() == Qt::Checked )
            {
                QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                lista.append(clip);
            }
        }
    }
    AskDialog* ask = new AskDialog(this, lista, "DeleteAsk" );
    ask->exec();


    if ( settings.value("DeleteAsk", "No").toString() == "Yes" )

    {
        QFileInfoList lista;
        if ( multi == 0 )
        {
            QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
            lista.append(clip);
        }
        else
        {
            for (int i=0; i < ui->listWidget->count(); ++i)
            {
                if ( ui->listWidget->item(i)->checkState() == Qt::Checked )
                {
                    QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                    lista.append(clip);
                }
            }
        }
        FileDeleter deleter(lista, this);
        DeleteDialog dialog(&deleter, this);
        deleter.start();
        dialog.exec();
        //CargarBrowser(sPath);
        dirChanged(sPath);
    }
}

void MainWindow::on_h_bookmarks_clicked()
{
    on_v_bookmarks_clicked();
}

void MainWindow::on_v_bookmarks_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
    Bookmarks* bw = new Bookmarks(this, color1, color2);
    bw->exec();
    settings.sync();
    QString temp = settings.value("CurrentDir", sPath).toString();
    if ( temp != sPath ) CargarBrowser(temp);
}

void MainWindow::addToClipboard()
{

    QStringList list = settings.value("Clipboard", QStringList() ).toStringList();
    QStringList list1;
    if ( multi == 0 )
    {
        QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        list.append(clip); list1.append(clip);
    }
    else
    {
        for (int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( ui->listWidget->item(i)->checkState() == Qt::Checked )
            {
                QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                if ( list.indexOf(clip) == -1 ) { list.append(clip); list1.append(clip); }
            }
        }
    }
    settings.setValue("Clipboard", list);

    if ( settings.value("AutoSelect","No").toString() == "Yes" )
    {
        QStringList list2 = settings.value("ClipboardSelected", QStringList() ).toStringList();
        for (int i=0; i < list1.count(); ++i ) list2.append(list1.at(i));
        settings.setValue("ClipboardSelected", list2);
    }

    settings.sync();

}

void MainWindow::shareBT()
{

    QStringList list;
    if ( multi == 0 )
    {
        QString clip = sPath + "/" + ui->listWidget->currentItem()->statusTip();
        list.append(clip);
    }
    else
    {
        for (int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( ui->listWidget->item(i)->checkState() == Qt::Checked )
            {
                QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                list.append(clip);
            }
        }
    }

    Share* sw = new Share(this, list);
    sw->exec();

    /*QString file = sPath + "/" + ui->listWidget->currentItem()->statusTip();
    QByteArray ba = file.toUtf8();
    char *str1 = ba.data();
    osso_context_t *osso;
    osso = osso_initialize("osso-filemanager", "1.0", TRUE, NULL);
    gchar *filename = str1;
    sharing_dialog_with_file(osso, NULL, filename);*/

}

void MainWindow::on_h_settings_clicked()
{
    on_v_settings_clicked();
}

void MainWindow::on_v_settings_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
    Settings* sw = new Settings(this);
    sw->exec();
    if ( settings.value("Multiselection","No").toString() == "Yes"  ) multi=1; else multi=0;
    if ( settings.value("NeedToRefresh","No").toString() == "Yes" ) CargarBrowser(sPath);
    settings.remove("NeedToRefresh");
    checkOrientation();
}

void MainWindow::renameSel()
{
    settings.setValue("NeedToRefresh", "No");
    QString source = sPath + "/" + ui->listWidget->currentItem()->statusTip();
    Rename* rd = new Rename( this, sPath, ui->listWidget->currentItem()->statusTip() );
    rd->exec();
    //if ( settings.value("NeedToRefresh","Yes").toString() == "Yes" ) CargarBrowser(sPath);
    settings.remove("NeedToRefresh");
    dirChanged(sPath);
}


void MainWindow::keyPressEvent(QKeyEvent* k)
{
    if ( ui->lineEdit->isVisible() ) return;

    if ( k->key() == 16777249 ) SymPressed=1;
    if ( k->key() == 16777248 ) ShPressed=1;

}

void MainWindow::keyReleaseEvent(QKeyEvent* k)
{
    //ui->barButton->setText( QString("%1").arg(k->key()) );

    if ( ui->lineEdit->isVisible() ) return;

    if ( k->key() == 16777221 || k->key() == 16777234 || k->key() == 16777235 || k->key() == 16777236 || k->key() == 16777237 ) return;

    if ( k->key() == 16777249 ) { SymPressed=0; return; }
    if ( k->key() == 16777248 ) { ShPressed=0; return; }

    if ( ( k->key() == 72 ) && ( SymPressed==1 ) )
    {
        if ( settings.value("ShowHiddenFiles", "No").toString() == "Yes" )
            settings.setValue("ShowHiddenFiles", "No");
        else
            settings.setValue("ShowHiddenFiles", "Yes");
        CargarBrowser(sPath);
    }
    else if ( ( k->key() == 86 ) && ( SymPressed==1 ) )
    {
        QStringList temp = settings.value("ClipboardSelected", QStringList() ).toStringList();
        if ( temp.count() > 0 )
        {
            settings.setValue("FilesToPaste",temp);
            settings.sync();
            checkClipboard();
        }
        else
        {
            QString msg = QString(tr("ERROR: Nothing selected to paste"));
            QMaemo5InformationBox::information(this, msg, QMaemo5InformationBox::DefaultTimeout);
        }
    }
    else if ( ( k->key() == 88 ) && ( SymPressed==1 ) )
    {
        QStringList temp = settings.value("ClipboardSelected", QStringList() ).toStringList();
        if ( temp.count() > 0 )
        {
            settings.setValue("FilesToCut",temp);
            settings.sync();
            checkClipboard();
        }
        else
        {
            QString msg = QString(tr("ERROR: Nothing selected to paste"));
            QMaemo5InformationBox::information(this, msg, QMaemo5InformationBox::DefaultTimeout);
        }
    }
    else if ( ( k->key() == 82 ) && ( SymPressed==1 ) )
    {
        QString sended2 = "rm /home/user/.thumbnails/filebox/*";
        QByteArray ba2 = sended2.toLatin1();
        const char *str2 = ba2.data();
        system(str2);
        CargarBrowser(sPath);
    }
    else if ( ( k->key() == 65 ) && ( SymPressed==1 ) && ( multi==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i) {
            ui->listWidget->item(i)->setCheckState(Qt::Checked);
            ui->listWidget->item(i)->setData(Qt::UserRole+3, 1);
        }
    }
    else if ( ( k->key() == 68 ) && ( SymPressed==1 ) && ( multi==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i) {
            ui->listWidget->item(i)->setCheckState(Qt::Unchecked);
            ui->listWidget->item(i)->setData(Qt::UserRole+3, 0);
        }
    }
    else if ( ( k->key() == 67 ) && ( SymPressed==1 ) && ( multi==1 ) )
    {
        QStringList list = settings.value("Clipboard", QStringList() ).toStringList();
        int added = 0;
        for ( int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( ui->listWidget->item(i)->checkState()==Qt::Checked)
            {
                QString clip = sPath + "/" + ui->listWidget->item(i)->statusTip();
                if ( list.indexOf(clip) == -1 ) {
                    list.append(clip);
                    added=added+1;
                    if ( settings.value("AutoSelect","No").toString() == "Yes" )
                    {
                        QStringList list2 = settings.value("ClipboardSelected", QStringList() ).toStringList();
                        list2.append(clip);
                        settings.setValue("ClipboardSelected", list2);
                    }
                }
            }
        }
        settings.setValue("Clipboard", list);
        settings.sync();
        if ( added > 0 )
        {
            QString msg = QString(tr("Added to Clipboard"));
            QMaemo5InformationBox::information(this, msg, QMaemo5InformationBox::DefaultTimeout);
        }
    }
    else if ( ( k->key() == 71 ) && ( SymPressed==1 ) && ( multi==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( QFileInfo(sPath+"/"+ui->listWidget->item(i)->statusTip()).isFile() ) {
                ui->listWidget->item(i)->setCheckState(Qt::Checked);
                ui->listWidget->item(i)->setData(Qt::UserRole+3, 1);
            } else {
                ui->listWidget->item(i)->setCheckState(Qt::Unchecked);
                ui->listWidget->item(i)->setData(Qt::UserRole+3, 0);
            }

        }
    }
    else if ( ( k->key() == 70 ) && ( SymPressed==1 ) && ( multi==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i)
        {
            if ( QFileInfo(sPath+"/"+ui->listWidget->item(i)->statusTip()).isFile() )
            {
                ui->listWidget->item(i)->setCheckState(Qt::Unchecked);
                ui->listWidget->item(i)->setData(Qt::UserRole+3, 0);
            }
            else {
                ui->listWidget->item(i)->setCheckState(Qt::Checked);
                ui->listWidget->item(i)->setData(Qt::UserRole+3, 1);
            }

        }
    }
    else if ( SymPressed==0 && ui->search->hasFocus()==false )
    {
        if ( !ui->pushButton->isEnabled() )
            return;
        ui->swidget->setVisible(true);
        ui->search->setFocus();
        if ( k->key() == 16777219 )
        {
            QString pepe = ui->search->text();
            if ( pepe.length() > 0 ) pepe.remove(pepe.length()-1,1);
            ui->search->setFocus(); ui->search->setText(pepe);
            return;
        }
        else
        {
            ui->search->setText( ui->search->text() + k->text() );
        }
    }


}

void MainWindow::on_lineEdit_textChanged(QString texto)
{
    if ( texto == "" ) ui->lineEdit->setText("/");

    int i = texto.lastIndexOf( "/" );
    texto.remove ( i, texto.length() - i );
    if ( texto == "" ) texto = "/";

    QDir dir ( texto, "*" );
    dir.setFilter( QDir::Dirs | QDir::Hidden | QDir::NoDotAndDotDot );
    if ( !dir.isReadable() ) return;

    QStringList entries;
    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
        entries.append( QFileInfo(list.at(i)).absoluteFilePath()+"/" );
    }


    QCompleter *completer = new QCompleter(entries, this);
    completer->setCompletionMode(QCompleter::InlineCompletion);
    //completer->setCaseSensitivity(Qt::CaseInsensitive);

    ui->lineEdit->setCompleter(completer);

}

void MainWindow::on_barButton_clicked()
{
    ui->lineEdit->setText(sPath);
    ui->barButton->setVisible(false);
    ui->lineEdit->setVisible(true);
    ui->lineEdit->setFocus();
}

void MainWindow::on_lineEdit_editingFinished()
{
    ui->lineEdit->setVisible(false);
    ui->barButton->setVisible(true);
}

void MainWindow::on_actionAbout_triggered()
{
    About* ad = new About(this);
    ad->exec();
}

void MainWindow::on_actionHelp_triggered()
{
    Help* hp = new Help(this);
    hp->exec();
}

void MainWindow::on_qsearch_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
}

void MainWindow::on_search_textChanged(QString filter)
{
    ui->search->setText( ui->search->text().toLower() );
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->statusTip().toLower().indexOf( filter.toLower() )  == -1 )
        {
            ui->listWidget->item(i)->setHidden(true);
        }
        else
        {
            ui->listWidget->item(i)->setHidden(false);
        }
    }
}

void MainWindow::on_v_full_clicked()
{
    on_h_full_clicked();
}

void MainWindow::on_h_full_clicked()
{
    if ( this->windowState() == Qt::WindowFullScreen )
        this->setWindowState(Qt::WindowMaximized);
    else
        this->setWindowState(Qt::WindowFullScreen);
}

void MainWindow::on_pushButton_customContextMenuRequested(QPoint)
{
    checkDevice();
}
