#include "options.h"
#include "ui_options.h"
#include "qmaemo5rotator.h"

Options::Options(QWidget *parent, QStringList files) :
    QDialog(parent),
    ui(new Ui::Options)
{

    ui->setupUi(this);

    QSettings settings("cepiperez", "filemanager");
    QString iconSet = settings.value("IconStyle", "Default").toString();

    QIcon ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/clipboard.png");
    ui->copy->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/paste.png");
    ui->paste->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/cut.png");
    ui->cut->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/delete.png");
    ui->del->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/edit.png");
    ui->edit->setIcon(ic1); ui->edit2->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/rename.png");
    ui->rename->setIcon(ic1); ui->rename2->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/share.png");
    ui->share->setIcon(ic1); ui->share2->setIcon(ic1);
    ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/compress.png");
    ui->compress->setIcon(ic1); ui->compress2->setIcon(ic1);

    if ( settings.value("ClipboardSelected",QStringList()).toStringList().count() > 0 )
    {
        ui->paste->setEnabled(true);
        ui->cut->setEnabled(true);
    }
    else
    {
        ui->paste->setEnabled(false);
        ui->cut->setEnabled(false);
    }

    if ( files.count() == 0 )
    {
        ui->copy->setEnabled(false); ui->del->setEnabled(false);
        ui->edit->setEnabled(false); ui->edit2->setEnabled(false);
        ui->rename->setEnabled(false); ui->rename2->setEnabled(false);
        ui->compress->setEnabled(false); ui->compress2->setEnabled(false);
        ui->share->setEnabled(false); ui->share2->setEnabled(false);
    }
    else if ( files.count() == 1 )
    {
        ui->copy->setEnabled(true); ui->del->setEnabled(true);
        ui->rename->setEnabled(true); ui->rename2->setEnabled(true);
        ui->compress->setEnabled(true); ui->compress2->setEnabled(true);
        if ( QFileInfo(files.at(0)).isFile() )
        {
            ui->edit->setEnabled(true); ui->edit2->setEnabled(true);
            ui->share->setEnabled(true); ui->share2->setEnabled(true);
        }
        else
        {
            ui->edit->setEnabled(false); ui->edit2->setEnabled(false);
            ui->share->setEnabled(false); ui->share2->setEnabled(false);
        }
    }
    else if ( files.count() > 1 )
    {
        ui->copy->setEnabled(true); ui->del->setEnabled(true);
        ui->edit->setEnabled(true); ui->edit2->setEnabled(true);
        ui->rename->setEnabled(true); ui->rename2->setEnabled(true);
        ui->compress->setEnabled(true); ui->compress2->setEnabled(true);
        ui->share->setEnabled(true); ui->share2->setEnabled(true);
    }

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QCoreApplication::processEvents();
    orientationChanged();
}

Options::~Options()
{
    delete ui;
}

void Options::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() < screenGeometry.height())
    {
        ui->edit->setVisible(true); ui->edit2->setVisible(false);
        ui->rename->setVisible(true); ui->rename2->setVisible(false);
        ui->compress->setVisible(true); ui->compress2->setVisible(false);
        ui->share->setVisible(true); ui->share2->setVisible(false);
    }
    else
    {
        ui->edit->setVisible(false); ui->edit2->setVisible(true);
        ui->rename->setVisible(false); ui->rename2->setVisible(true);
        ui->compress->setVisible(false); ui->compress2->setVisible(true);
        ui->share->setVisible(false); ui->share2->setVisible(true);
    }
    QCoreApplication::processEvents();
    if ( ui->edit->isVisible() ) this->setMaximumHeight(150);
    else this->setMaximumHeight(70);
    this->adjustSize();

}
