import Qt 4.7

Item {
    //anchors.fill: parent;
    width: parent.width;
    property string feedid : ""
    property alias count: articles.count
    property alias url: articles.source

    x: parent.width; height: parent.height;
    anchors.top: parent.top; anchors.bottom: parent.bottom

    function getArticleid(index) {
        return articles.get(index).articleid
    }

    function reload() {
        articles.reload()
    }

    ListView {
        id: articleList; model: articles; delegate: articleDelegate; z: 6
        width: parent.width; height: parent.height; /*x: 0;*/
        cacheBuffer: 100;
        flickDeceleration: 1500
    }

    XmlListModel {
        id: articles

        source: feedid == "" ? "" : "http://localhost:8000/articles/" + feedid + "?onlyUnread=" + hideReadArticles
        query: "/xml/article"

        XmlRole { name: "title"; query: "title/string()" }
        XmlRole { name: "articleid"; query: "articleid/string()"; isKey: true }
        XmlRole { name: "path"; query: "path/string()" }
        XmlRole { name: "unread"; query: "unread/string()"; isKey: true}
    }

    Component {
        id: articleDelegate

        Item {
            id: wrapper; width: wrapper.ListView.view.width; height: 86
            Item {
                id: moveMe
                Rectangle { id: backRect; color: "black"; opacity: index % 2 ? 0.2 : 0.4; height: 84; width: wrapper.width; y: 1 }
                Text {
                    anchors.fill: backRect
                    anchors.margins: 5
                    verticalAlignment: Text.AlignVCenter; text: title; color: (unread=="True") ? "white" : "#7b97fd";
                    width: wrapper.width; wrapMode: Text.WordWrap; font.bold: false;
                }
//                Rectangle {
//                    x: 3; y: 4; width: 77; height: 77; color: "#ff0000"; smooth: true

//                }

//                Column {
//                    x: 3;

//                    width: wrapper.width - 3; y: 5; spacing: 2
//                    height: parent.height;
//                    Text { Rectangle {anchors.fill: parent; color: "white"; opacity: 0.5;}
//                         verticalAlignment: Text.AlignVCenter; text: title; color: (unread=="True") ? "white" : "#7b97fd"; width: parent.width; wrapMode: Text.WordWrap; font.bold: false; /*elide: Text.ElideRight;*/ /*style: Text.Raised;*/ styleColor: "black"; }
//                    //Text { text: feedname; width: parent.width; elide: Text.ElideLeft; color: "#cccccc"; style: Text.Raised; styleColor: "black" }
//                }
            }
            MouseArea { anchors.fill: wrapper; onClicked: { container.articleClicked(articleid, index) } }
        }

    }

}
