import Qt 4.7

Rectangle {
    id: confirmationMessage
    signal okClicked
    signal cancelClicked

    property alias text: question.text

    border.color: "black";
    border.width : 4;
    radius: 10;
    color: "white"
    height: 160;
    width: 160;
    z: 10;
    anchors.fill: parent

    Text {
        id: question
        text: qsTr("Are you sure?")
        width: parent.width; height: 80
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        anchors.top: parent.top
        //anchors.bottom: parent.bottom
        anchors.margins: 10;
        //anchors.verticalCenter: parent.verticalCenter
    }

    Button {
        id: ok
        text: qsTr("OK")
        width: parent.width/2 - 10;
        anchors.left: parent.left; anchors.margins: 5; y: 3; height: 60
        anchors.top: question.bottom
        //anchors.bottom: parent.bottom
        onClicked: confirmationMessage.okClicked()
    }

    Button {
        id: cancel
        text: qsTr("Cancel")
        width: parent.width/2 - 10;
        anchors.right: parent.right; anchors.margins: 5; y: 3; height: 60
        anchors.top: question.bottom
        //anchors.bottom: parent.bottom
        anchors.left: ok.right
        onClicked: confirmationMessage.cancelClicked()
    }

}
