/*
 * This file is part of hildon-input-method-plugins-example 
 *
 * Copyright (C) 2006-2007 Nokia Corporation. All rights reserved.
 *
 * Author: Joaquim Rocha <jrocha@igalia.com>
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of Nokia Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
*/

#include "py.c"
#include <hildon-im-plugin.h>
#include <hildon-im-ui.h>

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "conn.h"

#define HILDON_IM_KEYBOARD_DECORATOR_TYPE hildon_im_keyboard_decorator_get_type ()
#define HILDON_IM_KEYBOARD_DECORATOR(obj) GTK_CHECK_CAST(obj, hildon_im_keyboard_decorator_get_type (), HildonIMKeyboardDecorator)
#define HILDON_IM_KEYBOARD_DECORATOR_CLASS(klass) \
        GTK_CHECK_CLASS_CAST(klass, hildon_im_keyboard_decorator_get_type, \
                             HildonIMKeyboardDecoratorClass)
#define HILDON_IS_IM_KEYBOARD_DECORATOR(obj) \
        GTK_CHECK_TYPE(obj, hildon_im_keyboard_decorator_get_type ())
#define HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE(obj) \
        (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HILDON_IM_KEYBOARD_DECORATOR_TYPE,\
                                      HildonIMKeyboardDecoratorPrivate))

typedef struct
{
  GtkContainerClass parent;
}
HildonIMKeyboardDecoratorClass;

typedef struct
{
  GtkContainer parent;
}
HildonIMKeyboardDecorator;

typedef struct
{
  HildonIMUI *ui;
}
HildonIMKeyboardDecoratorPrivate;
static fcitm_kbd* conn = NULL;
static HildonIMUI *client = NULL;
static GtkWidget *window = NULL, *label = NULL;
static GtkWidget* buttons[5];
static gint candword_index = 2;
static gboolean chinese_mode = FALSE, bquotedbl = TRUE, bquotright = TRUE, bparen = TRUE;

static GType hildon_im_keyboard_decorator_type = 0;
static GtkWidgetClass *parent_class = NULL;

GType hildon_im_keyboard_decorator_get_type (void);
GtkWidget *hildon_im_keyboard_decorator_new (HildonIMUI *kbd);

/* 
 * HildonIMPlugin interface
 */
static void hildon_im_keyboard_decorator_iface_init (HildonIMPluginIface *iface);

static void hildon_im_keyboard_decorator_enable (HildonIMPlugin *plugin, gboolean init);
static void hildon_im_keyboard_decorator_disable (HildonIMPlugin *plugin);
static void hildon_im_keyboard_decorator_surrounding_received (HildonIMPlugin *plugin,
                                                       const gchar *surrounding,
                                                       gint offset);
static void hildon_im_keyboard_decorator_key_event(HildonIMPlugin *plugin,
                                                   GdkEventType type,
                                                   guint state,
                                                   guint keyval,
                                                   guint hardware_keycode);
static void create_window(void);
static gboolean fake_key_press(guint keyval, guint state, gchar **str, gboolean *ret);
/*
 * GObject functions
 */
static void hildon_im_keyboard_decorator_finalize     (GObject *obj);
static void hildon_im_keyboard_decorator_get_property (GObject *object,
                                                guint prop_id,
                                                GValue *value,
                                                GParamSpec *pspec);
static void hildon_im_keyboard_decorator_set_property (GObject *object,
                                                guint prop_id,
                                                const GValue *value,
                                                GParamSpec *pspec);

static void hildon_im_keyboard_decorator_class_init (HildonIMKeyboardDecoratorClass *klass);
static void hildon_im_keyboard_decorator_init       (HildonIMKeyboardDecorator *self);

/*
 * Module functions
 */
HildonIMPlugin* module_create (HildonIMUI *keyboard);
void module_exit(void);
void module_init(GTypeModule *module);
const HildonIMPluginInfo *hildon_im_plugin_get_info(void);
gchar ** hildon_im_plugin_get_available_languages (gboolean *free);

HildonIMPlugin* 
module_create (HildonIMUI *keyboard)
{
  return HILDON_IM_PLUGIN (hildon_im_keyboard_decorator_new (keyboard));
}

void
module_exit(void)
{
  /* empty */
}

void
module_init(GTypeModule *module)
{
  static const GTypeInfo type_info = {
    sizeof(HildonIMKeyboardDecoratorClass),
    NULL, /* base_init */
    NULL, /* base_finalize */
    (GClassInitFunc) hildon_im_keyboard_decorator_class_init,
    NULL, /* class_finalize */
    NULL, /* class_data */
    sizeof(HildonIMKeyboardDecorator),
    0,    /* n_preallocs */
    (GInstanceInitFunc) hildon_im_keyboard_decorator_init,
  };

  static const GInterfaceInfo plugin_info = {
    (GInterfaceInitFunc) hildon_im_keyboard_decorator_iface_init,
    NULL, /* interface_finalize */
    NULL, /* interface_data */
  };

  hildon_im_keyboard_decorator_type =
          g_type_module_register_type(module,
                                      GTK_TYPE_CONTAINER, "HildonIMKeyboardDecorator",
                                      &type_info,
                                      0);
  
  g_type_module_add_interface(module,
                              HILDON_IM_KEYBOARD_DECORATOR_TYPE,
                              HILDON_IM_TYPE_PLUGIN,
                              &plugin_info);
  if(conn==NULL)
    conn = fcitm_kbd_new();
}

/*
 * This is used to know the plugin's information when loading the module
 */
const HildonIMPluginInfo *
hildon_im_plugin_get_info(void)
{
  static const HildonIMPluginInfo info =
  {
    "HIM Fcitm KeyBoard",               /* description */
    "hildon_im_keyboard_fcitm",         /* name */
    NULL,                               /* menu title */
    NULL,                               /* gettext domain */
    TRUE,                               /* visible in menu */
    TRUE,                               /* cached */
    HILDON_IM_TYPE_PERSISTENT,          /* UI type */
    HILDON_IM_GROUP_CJK,                /* group */
    HILDON_IM_DEFAULT_PLUGIN_PRIORITY,  /* priority */
    "hildon_keyboard_assistant_scv",    /* special character plugin */
    NULL,                               /* help page */
    TRUE,                               /* disable common UI buttons */
    0,                                  /* plugin height */
    HILDON_IM_TRIGGER_KEYBOARD          /* trigger */
  };

  return &info;
}

/*
 * This function returns the list of available languages supported
 * by the plugin.
 */
gchar ** 
hildon_im_plugin_get_available_languages (gboolean *free)
{
  static gchar *langs[] = {"zh_CN", NULL};
  *free = FALSE;

  return langs;
}

GType
hildon_im_keyboard_decorator_get_type (void)
{
  return hildon_im_keyboard_decorator_type;
}

/*
 * Implement the interface.
 */
static void
hildon_im_keyboard_decorator_iface_init (HildonIMPluginIface *iface)
{
  iface->enable = hildon_im_keyboard_decorator_enable;
  iface->disable = hildon_im_keyboard_decorator_disable;
  iface->surrounding_received = hildon_im_keyboard_decorator_surrounding_received;
  iface->key_event = hildon_im_keyboard_decorator_key_event;
}

static void
hildon_im_keyboard_decorator_class_init (HildonIMKeyboardDecoratorClass *klass)
{
  GObjectClass *object_class;
  GtkObjectClass *gtk_object_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;

  parent_class = g_type_class_peek_parent (klass);
  g_type_class_add_private (klass, sizeof (HildonIMKeyboardDecoratorPrivate));

  object_class = G_OBJECT_CLASS(klass);
  gtk_object_class = GTK_OBJECT_CLASS(klass);
  widget_class = GTK_WIDGET_CLASS(klass);
  container_class = GTK_CONTAINER_CLASS(klass);

  object_class->set_property  = hildon_im_keyboard_decorator_set_property;
  object_class->get_property  = hildon_im_keyboard_decorator_get_property;
  object_class->finalize      = hildon_im_keyboard_decorator_finalize;
  
  g_object_class_install_property (object_class, HILDON_IM_PROP_UI,
                                   g_param_spec_object (HILDON_IM_PROP_UI_DESCRIPTION, 
                                                        HILDON_IM_PROP_UI_DESCRIPTION,
                                                        "UI that uses plugin",
                                                        HILDON_IM_TYPE_UI,
                                                        G_PARAM_READWRITE
                                                        | G_PARAM_CONSTRUCT_ONLY));
}

static void
hildon_im_keyboard_decorator_init (HildonIMKeyboardDecorator *self)
{
  HildonIMKeyboardDecoratorPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR (self));
  priv = HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE (self);
}

static void 
hildon_im_keyboard_decorator_finalize(GObject *obj)
{
  if (G_OBJECT_CLASS (parent_class)->finalize)
  {
    G_OBJECT_CLASS (parent_class)->finalize (obj);
  }
}

GtkWidget *
hildon_im_keyboard_decorator_new (HildonIMUI *kbd)
{
  return g_object_new (HILDON_IM_KEYBOARD_DECORATOR_TYPE,
                       HILDON_IM_PROP_UI_DESCRIPTION, kbd, NULL);
}

static void
hildon_im_keyboard_decorator_get_property (GObject *object,
                                    guint prop_id,
                                    GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMKeyboardDecoratorPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR(object));
  priv = HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      g_value_set_object(value, priv->ui);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}

static void
hildon_im_keyboard_decorator_set_property (GObject *object,
                                    guint prop_id,
                                    const GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMKeyboardDecoratorPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR (object));
  priv = HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      priv->ui = g_value_get_object(value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
      break;
  }
}
#ifndef G_DEBUG_DISABLE
static void LogToFile (const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data)
{
  FILE *logfile = fopen ("/tmp/fcitm_kbd.log", "a");
  if (logfile == NULL)
  {
    /*  Fall  back  to  console  output  if  unable  to  open  file  */
    printf ("Rerouted to console: %s\n", message);
    return;
  }
  fprintf (logfile, "%s\n", message);
  fclose (logfile);
}
#endif
static void commit_text(HildonIMUI *ui, const gchar *str, gchar **ret)
{
  if(hildon_im_ui_get_commit_mode(ui) == HILDON_IM_COMMIT_REDIRECT){
    hildon_im_ui_send_utf8(ui, str);
  }else if(hildon_im_ui_get_commit_mode(ui) == HILDON_IM_COMMIT_SURROUNDING && strlen(str) > 0){
    *ret=dbus_new0(gchar, strlen(str)+1);
    strcpy(*ret, str);
  }
}
static void
window_destroy (GtkWidget* widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(window));
  window = NULL;
}
static void show_candwords()
{
  gchar tmp[MAX_USER_INPUT + 1];
  gchar *wd = tmp;
  tmp[0] = '\0';
  if(iPYInsertPoint){
    if(window == NULL)
      create_window();
    PYGetSelectedText(wd);
    g_strlcat(wd,(const gchar *)(&strFindString),-1);
    gtk_label_set_text(GTK_LABEL(label), (const gchar *)wd);
    if (!GTK_WIDGET_VISIBLE(GTK_WIDGET(window))){
      gtk_widget_show(GTK_WIDGET(window));
      gtk_toggle_button_set_active((GtkToggleButton *)buttons[2], TRUE);
    }
  }else{
    candword_index = 2;
    gtk_widget_hide(GTK_WIDGET(window));
    return;
  }
  PYGetCandText(0,wd);
  gtk_button_set_label(GTK_BUTTON(buttons[2]),(const gchar *)wd);
  PYGetCandText(1,wd);
  gtk_button_set_label(GTK_BUTTON(buttons[3]),(const gchar *)wd);
  PYGetCandText(2,wd);
  gtk_button_set_label(GTK_BUTTON(buttons[1]),(const gchar *)wd);
  PYGetCandText(3,wd);
  gtk_button_set_label(GTK_BUTTON(buttons[4]),(const gchar *)wd);
  PYGetCandText(4,wd);
  gtk_button_set_label(GTK_BUTTON(buttons[0]),(const gchar *)wd);
}
static void
send_fake_key (guint key_val, gboolean is_press)
{
  GdkKeymapKey *keys=NULL;
  gint n_keys=0;

  if(gdk_keymap_get_entries_for_keyval (NULL, key_val, &keys, &n_keys))
  {
    XTestFakeKeyEvent(GDK_DISPLAY(),keys->keycode, is_press, 0);
  }
  g_free(keys);
}
static gboolean text_button_clicked_cb(GtkButton *button, GdkEventButton *event, gpointer user_data)
{
  strStringGet[0] = '\0';
  candword_index = (guint32)GPOINTER_TO_INT (user_data);

  switch (candword_index){
    case 2:
      DoPYInput('1');
      break;
    case 3:
      DoPYInput('2');
      break;
    case 1:
      DoPYInput('3');
      break;
    case 4:
      DoPYInput('4');
      break;
    case 0:
      DoPYInput('5');
      break;
  }
  if(strStringGet[0] == '\0'){
    show_candwords();
    return FALSE;
  }
  if(hildon_im_ui_get_commit_mode(client) == HILDON_IM_COMMIT_REDIRECT){
    hildon_im_ui_send_utf8(client, strStringGet);
    ResetPYStatus();
    show_candwords();
  }else{
    send_fake_key(GDK_space, TRUE);
    send_fake_key(GDK_space, FALSE);
  }
  return FALSE;
}
static void create_window()
{
  window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
  gtk_window_set_decorated (GTK_WINDOW (window), FALSE);
  gtk_window_set_accept_focus(GTK_WINDOW (window), FALSE);
  gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_move(GTK_WINDOW(window), 0, 378);

  GtkWidget *vbox  = gtk_vbox_new(FALSE, 0);
  label = gtk_label_new("fcitm");
  gtk_widget_set_size_request(label, 800, 32);
  GtkWidget *hbox  = gtk_hbox_new(FALSE, 0);
  GtkRadioButton *radio_group = NULL;
  gint i;
  for ( i = 0; i < 5; i++ )
  {
     buttons[i] = hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT,radio_group);
     radio_group = (GtkRadioButton *) buttons[i];
     gtk_toggle_button_set_mode ((GtkToggleButton *)radio_group, FALSE);
     gtk_box_pack_start(GTK_BOX(hbox), GTK_WIDGET(buttons[i]), TRUE, TRUE, 0);
     g_signal_connect(G_OBJECT(buttons[i]), "button-release-event", G_CALLBACK(text_button_clicked_cb), GINT_TO_POINTER (i));
  }
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER(window), vbox);
  gtk_widget_show_all(GTK_WIDGET(window));
  gtk_widget_hide(GTK_WIDGET(window));
  gtk_toggle_button_set_active((GtkToggleButton *)buttons[2], TRUE);
  candword_index = 2;
  g_signal_connect (G_OBJECT (window), "destroy",
                    G_CALLBACK (window_destroy), NULL);
  PYInit();
}
static void
hildon_im_keyboard_decorator_enable(HildonIMPlugin *plugin, gboolean init)
{
#ifndef G_DEBUG_DISABLE
  g_log_set_handler (NULL, G_LOG_LEVEL_DEBUG, LogToFile, NULL);
#endif
  HildonIMKeyboardDecoratorPrivate *priv = HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE (plugin);

  client = priv->ui;
  if (window == NULL){
    fcitm_kbd_set_key_func( conn, fake_key_press);
    create_window();
  }
  hildon_im_ui_send_communication_message(priv->ui,
                                          HILDON_IM_CONTEXT_REQUEST_SURROUNDING_FULL);
}
static void
hildon_im_keyboard_decorator_disable(HildonIMPlugin *plugin)
{
  if(window){
    gtk_widget_destroy(GTK_WIDGET(window));
    window = NULL;
  }
}
static void
hildon_im_keyboard_decorator_surrounding_received(HildonIMPlugin *plugin,
                                                  const gchar *surrounding,
                                                  gint offset)
{
}

gboolean fake_key_press(guint keyval, guint state, gchar **str, gboolean *ret)
{
  *str = NULL;
  *ret = FALSE;
  if(keyval == ' ' && state == 4){
    chinese_mode = !chinese_mode;
    *ret = TRUE;
    return TRUE;
  }
  if(!chinese_mode || hildon_im_ui_get_shift_locked(client) || hildon_im_ui_get_level_locked(client))
    return TRUE;
  if(((keyval >= 'a' && keyval <= 'z') || ((keyval == ',' || keyval == '.') && iPYInsertPoint)) && state == 0){
      DoPYInput(keyval);
      show_candwords();
      *ret = TRUE;
  }else if(keyval == ' ' && state == 0 && iPYInsertPoint){
    if(strStringGet[0] == '\0'){ /* 点击屏幕选词跳过此段 */
      switch(candword_index){
        case 2:
          DoPYInput('1');
          break;
        case 3:
          DoPYInput('2');
          break;
        case 1:
          DoPYInput('3');
          break;
        case 4:
          DoPYInput('4');
          break;
        case 0:
          DoPYInput('5');
          break;
      }
      if(strStringGet[0] == '\0'){
        show_candwords();
        *ret = TRUE;
        return TRUE;
      }
    }
    commit_text(client,strStringGet,str);
    ResetPYStatus();
    show_candwords();
    *ret = TRUE;
  }else if((keyval == ',' || keyval =='.') && iPYInsertPoint == 0){
    gchar *val = NULL;
    switch(keyval){
      case ',':
        val = "，";
        break;
      case '.':
        val = "。";
        break;
    }
    *ret = TRUE;
    commit_text(client,val,str);
  }else if((keyval == ';' || keyval == ':') && iPYInsertPoint == 0){
    gchar *val = NULL;
    switch(keyval){
      case ';':
        val = "；";
        break;
      case ':':
        val = "：";
        break;
    }
    *ret = TRUE;
    commit_text(client,val,str);
  }else if(keyval == GDK_BackSpace && iPYInsertPoint){
    if(IRV_CLEAN  == DoPYInput(8))
      ResetPYStatus();
    show_candwords();
    *ret = TRUE;
  }else if(keyval == GDK_Up && iPYInsertPoint){
    PYGetCandWords(SM_PREV);
    show_candwords();
    *ret = TRUE;
  }else if(keyval == GDK_Down && iPYInsertPoint){
    PYGetCandWords(SM_NEXT);
    show_candwords();
    *ret = TRUE;
  }else if(keyval == GDK_Left && iPYInsertPoint){
    if(candword_index >0){
      candword_index--;
      gtk_toggle_button_set_active((GtkToggleButton *)buttons[candword_index], TRUE);
    }
    *ret = TRUE;
  }else if(keyval == GDK_Right && iPYInsertPoint){
    if(candword_index <4){
      candword_index++;
      gtk_toggle_button_set_active((GtkToggleButton *)buttons[candword_index], TRUE);
    }
    *ret = TRUE;
  }else if(iPYInsertPoint && (keyval == GDK_Return   ||
                              keyval == GDK_KP_Enter ||
                              keyval == GDK_ISO_Enter)){
    commit_text(client,strCodeInput,str);
    ResetPYStatus();
    show_candwords();
    *ret = TRUE;
  }else if(iPYInsertPoint && state == 0 && (keyval == GDK_Shift_L ||
                              keyval == GDK_Control_L ||
                              keyval == GDK_ISO_Level3_Shift)){
      ResetPYStatus();
      show_candwords();
      *ret = FALSE;
  }else if(iPYInsertPoint == 0){
    gchar *val = NULL;
    switch(keyval){
      case '?':
        val = "？";
        *ret = TRUE;
        break;
      case '!':
        val = "！";
        *ret = TRUE;
        break;
      case '(':
        val = "（";
        *ret = TRUE;
        break;
      case ')':
        val = "）";
        *ret = TRUE;
        break;
      case '\\':
        val = "、";
        *ret = TRUE;
        break;
      case '\"':
        val = bquotedbl?"“":"”";
        bquotedbl = !bquotedbl;
        *ret = TRUE;
        break;
      case '\'':
        val = bquotright?"‘":"’";
        bquotright = !bquotright;
        *ret = TRUE;
        break;
      case '+':
        val = "·";
        *ret = TRUE;
        break;
      case '-':
        val = "——";
        *ret = TRUE;
        break;
      case '_':
        val = "……";
        *ret = TRUE;
        break;
      case '&':
        val = bparen?"《":"》";
        bparen = !bparen;
        *ret = TRUE;
        break;
    }
    if(*ret && val)
      commit_text(client,val,str);
  }
  return TRUE;
}
static void
hildon_im_keyboard_decorator_key_event(HildonIMPlugin *plugin,
                                       GdkEventType type,
                                       guint state,
                                       guint keyval,
                                       guint hardware_keycode)
{
  if(type == GDK_KEY_RELEASE)
    return;
  HildonIMKeyboardDecoratorPrivate *priv = HILDON_IM_KEYBOARD_DECORATOR_GET_PRIVATE (plugin);
  client = priv->ui;
//  g_debug("state:%d keyval:%d code:%d",state,keyval,hardware_keycode);
}
