#include "conn.h"

gboolean dbus_conn_key_press( dbus_conn* obj, guint keyval, guint state, gboolean *ret, gchar **str, GError **error){
    obj->key_press( keyval, state, str, ret);
    return TRUE;
}

#include "bind.h"

static void dbus_conn_class_init( dbus_conn_class* klass );
static void dbus_conn_init( dbus_conn* obj );

GType dbus_conn_get_type( void ){
    static GType dbus_conn_type = 0;
    if ( !dbus_conn_type ) {
        static const GTypeInfo dbus_conn_info = {
            sizeof( dbus_conn_class ),
            NULL,
            NULL,
            (GClassInitFunc)dbus_conn_class_init,
            NULL,
            NULL,
            sizeof( dbus_conn ),
            0,
            (GInstanceInitFunc)dbus_conn_init
        };
        dbus_conn_type = g_type_register_static( G_TYPE_OBJECT, "dbus_conn", &dbus_conn_info, 0 );
    }
    return dbus_conn_type;
}

static void dbus_conn_class_init( dbus_conn_class* klass ){
    g_debug("dbus_conn_class_init");
    dbus_g_object_type_install_info( DBUS_CONN_TYPE, &dbus_glib_dbus_conn_object_info );
}
static void dbus_conn_init( dbus_conn* obj ){
    g_debug("dbus_conn_init");

    DBusGConnection* conn;
    DBusGProxy* proxy;
    GError *error = NULL;
    guint request_name_result;

    conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
    proxy = dbus_g_proxy_new_for_name( conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus" );
    dbus_g_proxy_call ( proxy, "RequestName", &error, G_TYPE_STRING, "org.fcitm.im", G_TYPE_UINT, 0, G_TYPE_INVALID, G_TYPE_UINT, &request_name_result, G_TYPE_INVALID );
    dbus_g_connection_register_g_object ( conn, "/im", G_OBJECT(obj) );
}

dbus_conn* dbus_conn_new(void){
    g_debug("dbus_conn_new");
    dbus_conn* obj;
    obj = g_object_new( DBUS_CONN_TYPE, NULL );
    return obj;
}

void dbus_conn_set_key_func( dbus_conn* conn, key_press_func func ){
    conn->key_press = func;
}
