import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

# Some global variables
FceuGuiVersion = "0.0.1-6"
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
FceuGui_CfgFile = Home + '/.config/fceu-gui/fceu-gui.cfg'
LastPlayed_File = Home + '/.config/fceu-gui/last_played.txt'
RomPath = ""
RomPath2 = ""
ExecPath = ""
RomPathActive = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options



class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	'''
	Check for required files
	'''
	# Load config
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + FceuGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/fceu"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/fceu' not found!")
        	widget = pathWindow(self)
		widget.show()
	if not os.path.isdir(self.gui_opts["rom_path"]):
		QMessageBox.critical(self, "Critical",  "rom_path" + " '" + self.gui_opts["rom_path"] + "' not found!")
       		widget = pathWindow(self)
		widget.show()

	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/fceu-gui/nes_controller.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rom_path
	if self.gui_opts["rom_path_active"] == "1":
		ListCmd = "cd '" + self.gui_opts["rom_path"] + "' 2>/dev/null;ls -1 *.zip *.ZIP *.gz *.GZ *.NES *.nes *.nsf *.NSF *.fds *.FDS *.unf *.UNF *.nez *.NEZ *.unif *.UNIF 2>/dev/null|sort -f" 
	else:
		if not os.path.isdir(self.gui_opts["rom2_path"]):
			QMessageBox.critical(self, "Critical",  "rom2_path" + " '" + self.gui_opts["rom2_path"] + "' not found!")
       			widget = pathWindow(self)
			widget.show()
		ListCmd = "cd '" + self.gui_opts["rom2_path"] + "' 2>/dev/null;ls -1 *.zip *.ZIP *.gz *.GZ *.NES *.nes *.nsf *.NSF *.fds *.FDS *.unf *.UNF *.nez *.NEZ *.unif *.UNIF 2>/dev/null|sort -f" 
	fin,fout = os.popen4(ListCmd)
	romList = fout.read()
	fin.close()
	romList = romList.split('\n')
	romList = romList[:-1]
	if not romList:
		romList = ['No roms found']

        self.combo = QComboBox(self)
        self.combo.setStyleSheet( \
	"QComboBox { color: gray; \
	 border: 6px solid #045FB4; \
	 border-radius: 3px; \
	 min-width: 6em; \
	 }" )
	self.combo.setGeometry(QRect(20, 180, 750, 60))
	# Read last started file
	try:
		playedFile = open(LastPlayed_File,"r")
	except:
		last_game = "dummy"
	else:
		last_game = playedFile.readlines()
	maxLength=63
	for Game in romList:
		space=""
		spacecount=maxLength-len(Game)
		for x in range(0,spacecount):
			space=space+" "
       		self.combo.addItem(space+Game)
	self.GameFile=[[t] for t in romList if t]
	# Set last file as current
	if last_game[0] in romList:
		self.combo.setCurrentIndex(romList.index(last_game[0]))

	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)
	self.romPath1Action = QAction( '&Use RomPath1', self)
	self.romPath1Action.setCheckable(True)
        self.romPath1Action.triggered.connect(self.slotRomPath1)
	self.romPath2Action = QAction( '&Use RomPath2', self)
	self.romPath2Action.setCheckable(True)
        self.romPath2Action.triggered.connect(self.slotRomPath2)
	if self.gui_opts["rom_path_active"] == "1":
		self.romPath1Action.setChecked(True)
	else:
		self.romPath2Action.setChecked(True)
		

        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)
        fileMenu.addAction(self.romPath1Action)
        fileMenu.addAction(self.romPath2Action)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
           self.onesmutePushButton.setChecked(False)
	else:
            self.onesmutePushButton.setChecked(True)


    def on_start_clicked(self):
	gameNbr = self.combo.currentIndex()
	self.gameFile = str(self.GameFile[gameNbr]).strip("['']")

	# Add all the options
	# but first, re-read all settings
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        if self.onesmutePushButton.isChecked():
		ALL_OPTS="-sound 0 " 
        else:  ALL_OPTS="-sound 1 "
        if self.gui_opts["fs"] == "false":
		ALL_OPTS = ALL_OPTS + "-fs 0 "
        else:  ALL_OPTS= ALL_OPTS + "-fs 1 "
        if self.gui_opts["game_genie"] == "false":
		ALL_OPTS = ALL_OPTS + "-gg 0 "
        else:  ALL_OPTS= ALL_OPTS + "-gg 1 "
        if self.gui_opts["tv_blur"] == "false":
        	if self.gui_opts["fs"] == "false":
			ALL_OPTS = ALL_OPTS + "-efx 0 "
		else:
			ALL_OPTS = ALL_OPTS + "-efxfs 0 "
	else:
        	if self.gui_opts["fs"] == "false":
			ALL_OPTS = ALL_OPTS + "-efxfs 2 "
		else:
			ALL_OPTS = ALL_OPTS + "-efxfs 2 "
	ALL_OPTS = ALL_OPTS + "-bpp " + self.gui_opts["bpp"] + " "

	if not (self.gameFile == "No roms found" ):
		# Write as last played game
		playedFile = open(LastPlayed_File,"w")
		playedFile.write(self.gameFile)
		playedFile.close()
		# Start emulator with parameters
		print self.gui_opts["exec_path"] + "/fceu "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile +  '"'
		if RomPathActive != "":
			self.gui_opts["rom_path_active"] = RomPathActive
		if self.gui_opts["rom_path_active"] == "1":
			QProcess.startDetached(self.gui_opts["exec_path"] + "/fceu "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + self.gameFile + '"' )
		else:
			QProcess.startDetached(self.gui_opts["exec_path"] + "/fceu "+ALL_OPTS+ " " + '"' + self.gui_opts["rom2_path"] + "/" + self.gameFile + '"' )

		if (self.gui_opts["exit_after_launch"] == "true"):
			time.sleep(5)
			os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

    def slotRomPath1(self):
	# Load config
	global RomPathActive
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        if self.romPath1Action.isChecked():
		self.romPath2Action.setChecked(False)
		self.combo.clear()
		RomPathActive = "1"
		ListCmd = "cd '" + self.gui_opts["rom_path"] + "';ls -1 *.zip *.ZIP *.gz *.GZ *.NES *.nes *.nsf *.NSF *.fds *.FDS *.unf *.UNF *.nez *.NEZ *.unif *.UNIF 2>/dev/null|sort -f" 
		fin,fout = os.popen4(ListCmd)
		romList = fout.read()
		fin.close()
		romList = romList.split('\n')
		romList = romList[:-1]
		if not romList:
			romList = ['No roms found']
		# Read last started file
		try:
			playedFile = open(LastPlayed_File,"r")
		except:
			last_game = "dummy"
		else:
			last_game = playedFile.readlines()
		maxLength=63
		for Game in romList:
			space=""
			spacecount=maxLength-len(Game)
			for x in range(0,spacecount):
				space=space+" "
       			self.combo.addItem(space+Game)
		self.GameFile=[[t] for t in romList if t]
		# Set last file as current
		if last_game[0] in romList:
			self.combo.setCurrentIndex(romList.index(last_game[0]))
        else:
		self.romPath2Action.setChecked(True)

    def slotRomPath2(self):
	global RomPathActive
	# Load config
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        if self.romPath2Action.isChecked():
		self.romPath1Action.setChecked(False)
		self.combo.clear()
		RomPathActive = "2"
		if not os.path.isdir(self.gui_opts["rom2_path"]):
			QMessageBox.critical(self, "Critical",  "rom2_path" + " '" + self.gui_opts["rom2_path"] + "' not found!")
       			widget = pathWindow(self)
			widget.show()
		ListCmd = "cd '" + self.gui_opts["rom2_path"] + "' 2>/dev/null;ls -1 *.zip *.ZIP *.gz *.GZ *.NES *.nes *.nsf *.NSF *.fds *.FDS *.unf *.UNF *.nez *.NEZ *.unif *.UNIF 2>/dev/null|sort -f" 
		fin,fout = os.popen4(ListCmd)
		romList = fout.read()
		fin.close()
		romList = romList.split('\n')
		romList = romList[:-1]
		if not romList:
			romList = ['No roms found']
		# Read last started file
		try:
			playedFile = open(LastPlayed_File,"r")
		except:
			last_game = "dummy"
		else:
			last_game = playedFile.readlines()
		maxLength=63
		for Game in romList:
			space=""
			spacecount=maxLength-len(Game)
			for x in range(0,spacecount):
				space=space+" "
       			self.combo.addItem(space+Game)
		self.GameFile=[[t] for t in romList if t]
		# Set last file as current
		if last_game[0] in romList:
			self.combo.setCurrentIndex(romList.index(last_game[0]))
        else:
		self.romPath1Action.setChecked(True)

    def slotJoyconf(self):
        a = JoyconfWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.label = QLabel(self)
	AboutTxt = "<h3>Fceu-gui " + FceuGuiVersion + "</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/fceu_gui.png /><br>" \
                   "Fceu-gui is a Graphical User Interface for FCE Ultra<p> " \
                   "FCE Ultra emulates the Nintendo NES/Famicom &#174;</p>" \
                   "<p>Fceu-gui is written in PySide by <i>Arno Dekker</i> 2012<p>" \
                   "<u>Ingame keys:</u><br>" \
                   "f = toggle fullscreen<br>" \
                   "q = quit<br>" \
                   "o = save state<br>" \
                   "l = load state<br>" \
                   "r = reset" %dict()
        self.label.setText(AboutTxt)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration Fceu-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(794,400);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# Full screen
        self.showfsPushButton = QPushButton("full screen",self)
	self.showfsPushButton.setCheckable(True)
        grid.addWidget(self.showfsPushButton,0,0)
        self.showfsPushButton.setFont(font)
	if self.gui_opts["fs"] == "true":
            self.showfsPushButton.setChecked(True)
	# sound
        self.soundPushButton = QPushButton("sound",self)
	self.soundPushButton.setCheckable(True)
        grid.addWidget(self.soundPushButton,0,1)
        self.soundPushButton.setFont(font)
	if self.gui_opts["sound"] == "true":
            self.soundPushButton.setChecked(True)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,0,2)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# GameGenie
        self.ggPushButton = QPushButton("GameGenie",self)
	self.ggPushButton.setCheckable(True)
        grid.addWidget(self.ggPushButton,1,0)
	if os.path.exists(Home + "/.fceultra/gg.rom"):
		if self.gui_opts["game_genie"] == "true":
			self.ggPushButton.setChecked(True)
		else:
			self.ggPushButton.setChecked(False)
	else:
		self.ggPushButton.setEnabled(False)
	# TV Blur
        self.blurPushButton = QPushButton("TV blur",self)
	self.blurPushButton.setCheckable(True)
        grid.addWidget(self.blurPushButton,1,1)
	if self.gui_opts["bpp"] == "8":
		self.blurPushButton.setEnabled(False)
	else:
		if self.gui_opts["tv_blur"] == "true":
			self.blurPushButton.setChecked(True)
		else:
			self.blurPushButton.setChecked(False)
	# BPP
	grid.addWidget(QLabel("<center>Bits per pixel (fs):</center>"), 3, 0)
        self.comboBPP = QComboBox(self)
        grid.addWidget(self.comboBPP,4,0)
	BPPs = self.listDefaultFirst("bpp",['8','16','32'])
	for bpp in BPPs:
		self.comboBPP.addItem(bpp)
	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,4,1)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("key def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,4,2)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,6,0,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
        if self.soundPushButton.isChecked():
           self.gui_opts["sound"] = "true"
        else: self.gui_opts["sound"] = "false" 
        if self.showfsPushButton.isChecked():
           self.gui_opts["fs"] = "true"
        else: self.gui_opts["fs"] = "false" 
        if self.exitPushButton.isChecked():
           self.gui_opts["exit_after_launch"] = "true"
        else: self.gui_opts["exit_after_launch"] = "false" 
        if self.ggPushButton.isChecked():
           self.gui_opts["game_genie"] = "true"
        else: self.gui_opts["game_genie"] = "false" 
        if self.blurPushButton.isChecked():
           self.gui_opts["tv_blur"] = "true"
        else: self.gui_opts["tv_blur"] = "false" 
	self.gui_opts["bpp"] = self.comboBPP.currentText()
        if RomPath != "":
           self.gui_opts["rom_path"] = RomPath
        if RomPath2 != "":
           self.gui_opts["rom2_path"] = RomPath2
        if RomPathActive != "":
           self.gui_opts["rom_path_active"] = RomPathActive
	

        orgConfigFile = open(FceuGui_CfgFile,"r")
	try:
	        copyFile = open(FceuGui_CfgFile + ".old" ,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + FceuGui_CfgFile + ".old")
	else:
		# Write the copy (.old)
		for line in orgConfigFile.readlines():
			copyFile.write(line)
		orgConfigFile.close()
		copyFile.close()
		try:
			newConfigFile = open(FceuGui_CfgFile,"w")
		except:
			QMessageBox.critical(self, "Warning",  "Cannot write " + FceuGui_CfgFile)
		else:
			newConfigFile.write("# Generated by fceu-gui\n")
			for option in self.gui_opts:
				newConfigFile.write(option + " " + self.gui_opts[option] + "\n")
			newConfigFile.close()
			os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
			           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
			           string:"Configuration is succesfully saved"')


    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.gui_opts[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
	QProcess.startDetached(self.gui_opts["exec_path"] + "/fceu -inputcfg gamepad1 dummy")

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("Fceu-gui path configuration")
        self.gui_opts = parse_config(self,FceuGui_CfgFile)
	if RomPath == "":
		self.romPath=self.gui_opts["rom_path"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	if RomPath2 == "":
		self.romPath2=self.gui_opts["rom2_path"]
	else:
		self.romPath2=RomPath2
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,300);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms 1"), 1, 0)
	grid.addWidget(self.pushRomButton, 1, 1)
	# rom2 path
	self.pushRomButton2 = QPushButton(self.romPath2,self)
        self.pushRomButton2.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms 2"), 2, 0)
	grid.addWidget(self.pushRomButton2, 2, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("fceu"), 3, 0)
	grid.addWidget(self.pushExecButton, 3, 1)

	self.setLayout(grid)

	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushRomButton2
		, SIGNAL("clicked()")
		, self.on_rom2_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_rom_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom2_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms2 location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom2_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom2_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom_homebutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom2_homebutton_clicked(self):
	global RomPath2
	RomPath2 = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom_rootbutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom2_rootbutton_clicked(self):
	global RomPath2
	RomPath2 = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/fceu")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/fceu")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
