#include "ExtendedSettings.h"

#include <QLabel>
#include <QTabBar>
#include <QFrame>
#include <QGridLayout>
#include <QPushButton>
#include <QDesktopServices>
#include <QUrl>

#include "UserDefaults.h"



ExtendedSettings::ExtendedSettings(QWidget * parent) : QTabWidget(parent) {
    //this->tabBar()->setExpanding(TRUE);
    ignoreSignals = FALSE;
    
    QFrame * visualization = new QFrame();
    visualization->setFrameShape(QFrame::StyledPanel);
    QVBoxLayout * visLayout = new QVBoxLayout();
    intensityHistogram = new QCheckBox("Show intensity histogram    ");
    visLayout->addWidget(intensityHistogram);    
    ruleOfThirds = new QCheckBox("Show rule of thirds guide    ");
    visLayout->addWidget(ruleOfThirds);
    
    visLayout->addStretch(1);
    visualization->setLayout(visLayout);
    this->addTab(visualization, "Visualizations");

    QFrame * fileManagement = new QFrame();
    fileManagement->setFrameShape(QFrame::StyledPanel);
    QGridLayout * layout = new QGridLayout();
    int row = 0;
    layout->addWidget(new QLabel("RAW Path:"), row, 0);
    rawPath = new QLineEdit();    
    
    //rawPath->setAcceptRichText(FALSE);
    //rawPath->setMaximumSize(QWIDGETSIZE_MAX, 64);
    layout->addWidget(rawPath, row, 1);
    row++;
    
    layout->addWidget(new QLabel("Filename Prefix:"), row, 0);
    filePrefix = new QLineEdit();
    //filePrefix->setMaximumSize(QWIDGETSIZE_MAX, 64);

    layout->addWidget(filePrefix, row, 1);
    row++;
    
    
    QGridLayout * suffixRowLayout = new QGridLayout();
    suffixRowLayout->addWidget(new QLabel("Filename Suffix:"), 0, 0);
    timestamp = new QRadioButton("Timestamp");
    index = new QRadioButton("Index");
    suffixRowLayout->addWidget(timestamp, 0,0);
    suffixRowLayout->addWidget(index, 0,1);
    layout->addWidget(new QLabel("Filename Suffix:"), row, 0);
    layout->addLayout(suffixRowLayout, row, 1);
    row++;
    
    // Add extra spaces at the end of checkbox title due to silly bug autosizing
    autosaveJPGs = new QCheckBox("Autosave JPGs to N900 gallery    ");
    autosaveJPGs->setMaximumSize(QWIDGETSIZE_MAX, 64);
    layout->addWidget(autosaveJPGs, row, 0, 1, 2, Qt::AlignLeft);
    row++;
    
    QPushButton * resetSettings = new QPushButton("Restore Defaults");
    layout->addWidget(resetSettings, row, 1, Qt::AlignRight);

    fileManagement->setLayout(layout);
            
    
    this->addTab(fileManagement, "File Management");


    QFrame * aboutFCamera = new QFrame();
    aboutFCamera->setFrameShape(QFrame::StyledPanel);
    QVBoxLayout * aboutLayout = new QVBoxLayout();
    QLabel * whatIsFCam = new QLabel(
        "FCamera is a completely open-source N900 camera implementation\n"
        "written using the FCam camera control API. We think you should be\n"
        "able to program your camera to behave any way you want it to.\n\n"
        "Don't like our exposure metering algorithm? Change it.\n"
        "Want a mode for doing time-lapse photography? Write it.\n"
        "Do you desperately want a sepia toned viewfinder? Go nuts.\n\n"
        "With FCamera, you can. To get started, check out our webpage at"        
    );
    whatIsFCam->setAlignment(Qt::AlignJustify);
    QPushButton * url = new QPushButton("http://fcam.garage.maemo.org");
    QObject::connect(url, SIGNAL(clicked()),
                     this, SLOT(launchBrowserForFCamWebsite()));
    url->setFlat(TRUE);
    aboutLayout->addStretch(1);
    aboutLayout->addWidget(whatIsFCam);
    aboutLayout->addWidget(url);
    aboutLayout->addStretch(1);    
    aboutFCamera->setLayout(aboutLayout);
    this->addTab(aboutFCamera, "About FCamera");    


    
    this->refreshWidgetsFromDefaults();
    
    QObject::connect(rawPath, SIGNAL(editingFinished()),
                    this, SLOT(settingChanged()));
    QObject::connect(filePrefix, SIGNAL(editingFinished()),
                    this, SLOT(settingChanged()));
    QObject::connect(timestamp, SIGNAL(toggled(bool)),
                    this, SLOT(settingChanged()));
    QObject::connect(index, SIGNAL(toggled(bool)),
                    this, SLOT(settingChanged()));
    QObject::connect(autosaveJPGs, SIGNAL(toggled(bool)),
                    this, SLOT(settingChanged()));
    QObject::connect(resetSettings, SIGNAL(clicked()),
                    this, SLOT(restoreSettingsToDefault()));
    QObject::connect(intensityHistogram, SIGNAL(toggled(bool)),
                    this, SLOT(settingChanged()));
    QObject::connect(ruleOfThirds, SIGNAL(toggled(bool)),
                this, SLOT(settingChanged()));
    
    
    
    
}

void ExtendedSettings::refreshWidgetsFromDefaults(){
    UserDefaults &userDefaults = UserDefaults::instance();
    if (!userDefaults["rawPath"].valid()) {
        userDefaults["rawPath"] = "/home/user/MyDocs/FCamera/";    
    } 
    if (!userDefaults["filenamePrefix"].valid()) {
        userDefaults["filenamePrefix"] = "photo";
    }
    if (!userDefaults["filenameSuffix"].valid()){
        userDefaults["filenameSuffix"] = "timestamp";
    } 
    if (!userDefaults["autosaveJPGs"].valid()) {
        userDefaults["autosaveJPGs"] = FALSE;
    }
    if (!userDefaults["intensityHistogram"].valid()){
        userDefaults["intensityHistogram"] = TRUE;
    }
    if (!userDefaults["ruleOfThirds"].valid()){
        userDefaults["ruleOfThirds"] = FALSE;
    }
    
    // Block signals temporarily so that all the changes get to propagate
    ignoreSignals = TRUE;
    
    rawPath->setText(userDefaults["rawPath"].asString().c_str());
    filePrefix->setText(userDefaults["filenamePrefix"].asString().c_str());
    if (userDefaults["filenameSuffix"].asString() == "timestamp") {
        timestamp->setChecked(TRUE);
    } else {
        index->setChecked(TRUE);
    }     
    autosaveJPGs->setChecked(userDefaults["autosaveJPGs"].asInt());
    intensityHistogram->setChecked(userDefaults["intensityHistogram"].asInt());
    ruleOfThirds->setChecked(userDefaults["ruleOfThirds"].asInt());
    // Reactivate signals
    ignoreSignals = FALSE;

    userDefaults.commit();
}


void ExtendedSettings::settingChanged(){
    if (ignoreSignals) return;

    UserDefaults &userDefaults = UserDefaults::instance();
    
    userDefaults["rawPath"] = rawPath->text().toStdString();
    userDefaults["filenamePrefix"] = filePrefix->text().toStdString();    
    
    if (timestamp->isChecked()){
        userDefaults["filenameSuffix"] = "timestamp";
    } else {
        userDefaults["filenameSuffix"] = "index";
    }
    
    userDefaults["autosaveJPGs"] = autosaveJPGs->isChecked();
    userDefaults["intensityHistogram"] = intensityHistogram->isChecked();
    userDefaults["ruleOfThirds"] = ruleOfThirds->isChecked();

    userDefaults.commit();
}

void ExtendedSettings::restoreSettingsToDefault() {
    UserDefaults &userDefaults = UserDefaults::instance();
    userDefaults.clear();
    userDefaults.commit();
    //printf("after clear, defaults has %d items\n", userDefaults.count());
    
    this->refreshWidgetsFromDefaults();
    //printf("after refresh, defaults has %d items\n", userDefaults.count());

}

void ExtendedSettings::launchBrowserForFCamWebsite() {
    QDesktopServices::openUrl(QUrl("http://fcam.garage.maemo.org"));
}
