#ifndef FCAM_N900_PLATFORM
#define FCAM_N900_PLATFORM

#include <string>
#include "FCam/Base.h"

namespace FCam { namespace N900 {

    class _Frame;
    class Sensor;

    // private static platform data used by the frame and the sensor to report on properties of the N900
    class Platform {
        // the color matrices for this sensor and a method to interpolate them
        static float RawToRGBColorMatrix3200K[];
        static float RawToRGBColorMatrix7000K[];
        static void rawToRGBColorMatrix(int kelvin, float *matrix);
        
        // A manufacturer and model string
        static std::string manufacturer;
        static std::string model;
        
        // Details about the sensor
        static unsigned short minRawValue, maxRawValue;
        static BayerPattern bayerPattern;
        
        // grant the N900::_Frame and N900::Sensor access to this
        // static platform data
        friend class FCam::N900::_Frame;            
        friend class FCam::N900::Sensor;        
    };
}}

#endif
