#ifndef FCAM_DEMOSAIC_H
#define FCAM_DEMOSAIC_H

/** \file
 * Converting RAW data to RGB24 by demosiacking and gamma correcting. */

#include "../Frame.h"

namespace FCam {

    /** Demosaic, white balance, and gamma correct a raw frame, and
     * return a slightly smaller RGB24 format image. At least four
     * pixels are lost from each side of the image, more if necessary
     * to maintain the following constraint on the output size: The
     * output will have a width that is a multiple of 40, and a height
     * which is a multiple of 24. In order to color correct, this uses
     * the frame's \ref Frame::rawToRGBColorMatrix method to retrieve
     * the correct white-balanced color conversion matrix. */
    Image demosaic(Frame src, float contrast = 50.0f,
                   bool denoise = true, int blackLevel = 25, 
                   float gamma = 2.2f);


    /** Create a low-resolution representation of the input image
     * frame. For a RAW image, this means a fast combined
     * demosaic/downsample and the application of the full
     * post-processing pipeline to create a representative image. */
    Image makeThumbnail(Frame src, const Size &thumbSize = Size(640,480),
                        float contrast = 50.0f, int blackLevel = 25, 
                        float gamma = 2.2f);
}

#endif
