#include "FCam/N900/Frame.h"
#include "FCam/processing/Color.h"

#include "Platform.h"

namespace FCam { namespace N900 {
            
    // Implementations of the static platform data
    // accessors. We just redirect all queries to the
    // N900::Platform class
    
    void _Frame::rawToRGBColorMatrix(int kelvin, float *matrix) const {
        N900::Platform::rawToRGBColorMatrix(kelvin, matrix);
    }
    
    const std::string &_Frame::manufacturer() const {;
        return N900::Platform::manufacturer;
    }
    
    const std::string &_Frame::model() const {
        return N900::Platform::model;
    }
    
    BayerPattern _Frame::bayerPattern() const {
        return N900::Platform::bayerPattern;
    }
    
    unsigned short _Frame::minRawValue() const {
        return N900::Platform::minRawValue;
    }
    
    unsigned short _Frame::maxRawValue() const {
        return N900::Platform::maxRawValue;
    }

}}
