#include <QLabel>
#include <QHBoxLayout>
#include "wndabout.h"

const QString wndAbout::version = QString("0.1.0");

wndAbout::wndAbout(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle(tr("About"));

    QString author = QString("Robin Hill <a href='mailto:maemo@robinhill.me.uk'>&lt;maemo@robinhill.me.uk&gt;</a>");
    QString tmo = QString("<a href='http://talk.maemo.org/'>t.m.o</a>");
    QString versionInfo = QString("FBReader Customiser v%1").arg(version);
    QString description = QString(tr("Customisation tool for FBReader"));
    QString writtenBy = QString(tr("Written by %1")).arg(author);
    QString support = QString(tr("Please email or post to %1 for support")).arg(tmo);

    QString aboutText = QString("<h2>%1</h2><p>%2</p><p>%3<br/>%4</p>").arg(versionInfo).arg(description).arg(writtenBy).arg(support);

    QLabel *txt = new QLabel();
    txt->openExternalLinks();
    txt->setTextFormat(Qt::RichText);
    txt->setText(aboutText);

    QHBoxLayout *lyt = new QHBoxLayout(this);
    lyt->addWidget(txt);
}
