#include "mydraglistwidget.h"
#include "wndconfigcustomisation.h"
#include <QDebug>

myDragListWidget::myDragListWidget(QWidget *window, QWidget *parent) :
    QListWidget(parent), myWindow(window)
{
    this->setEditTriggers(QAbstractItemView::NoEditTriggers);
    this->setDragEnabled(true);
    this->setDragDropMode(QAbstractItemView::DragDrop);
    this->setDefaultDropAction(Qt::MoveAction);
    this->setUniformItemSizes(true);
}

void myDragListWidget::mousePressEvent(QMouseEvent *event) {
    if (this->dragDropMode() == QAbstractItemView::DropOnly) {
        myAllowDrag = true;
    } else if (event->button() == Qt::LeftButton) {
        myDragStartPosition = event->pos();
        myAllowDrag = false;
    }

    QListWidget::mousePressEvent(event);
}

void myDragListWidget::mouseMoveEvent(QMouseEvent *event) {
    if (!myAllowDrag) {
        if (event->buttons() & Qt::LeftButton) {
            QPoint move = event->pos() - myDragStartPosition;
            if (move.y() == 0)
                move.setY(1);

            if (move.x() / move.y() >= 5)
                myAllowDrag = true;
        }

        if (myAllowDrag)
            this->setState(DraggingState);
        else
            this->setState(NoState);
    }

    QListWidget::mouseMoveEvent(event);
}

void myDragListWidget::dropEvent(QDropEvent *event) {
    QListView::dropEvent(event);
    ((wndConfigCustomisation *)myWindow)->dropDone(this, event->source());
}

