#include <QButtonGroup>
#include <QPushButton>
#include <QVBoxLayout>
#include <QMenuBar>
#include <QPointer>

#include "mainwindow.h"
#include "wndabout.h"
#include "fbmainmenuconfig.h"
#include "fbpopupmenuconfig.h"

wndFBReaderCustomiser::wndFBReaderCustomiser(QWidget *parent) :
    QMainWindow(parent)
{
    this->setGeometry(0, 0, 800, 480);
    this->setWindowTitle("FBReader Customiser");
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    QMenuBar *menu = new QMenuBar();
    QAction *act = menu->addAction(tr("About"));
    connect(act, SIGNAL(triggered()), this, SLOT(showAbout()));
    this->layout()->setMenuBar(menu);

    QWidget *centralWidget = new QWidget();
    this->setCentralWidget(centralWidget);

    QPushButton *systemMenu = new QPushButton(tr("Main Menu"));
    QPushButton *popupMenu = new QPushButton(tr("Popup Menu"));

    QButtonGroup *buttons = new QButtonGroup();
    buttons->addButton(systemMenu, SYSTEM_MENU);
    buttons->addButton(popupMenu, POPUP_MENU);

    QVBoxLayout *lyt = new QVBoxLayout();
    lyt->addWidget(systemMenu);
    lyt->addWidget(popupMenu);

    connect(buttons, SIGNAL(buttonClicked(int)), this, SLOT(showEditWindow(int)));

    centralWidget->setLayout(lyt);
}

wndFBReaderCustomiser::~wndFBReaderCustomiser()
{
}

void wndFBReaderCustomiser::showEditWindow(int selected) {
    QString title;
    QPointer<fbConfig> config;

    switch (selected) {
    case SYSTEM_MENU:
        config = new fbMainMenuConfig();
        title = tr("Main Menu");
        break;
    case POPUP_MENU:
        config = new fbPopupMenuConfig();
        title = tr("Popup Menu");
        break;
    case TOOLBAR:
    default:
        break;
    }

    if (config) {
        if (!editWindow) {
#ifdef Q_WS_MAEMO_5
            setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
            editWindow = new wndConfigCustomisation(this);
#ifdef Q_WS_MAEMO_5
            setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
        }

        editWindow->setWindowTitle(title);
        editWindow->setConfig(config);
        editWindow->show();
    }
}

void wndFBReaderCustomiser::showAbout() {
    wndAbout about(this);
    about.exec();
}
