#include <QDomDocument>
#include <QFile>
#include <QTextStream>

#include "fbmenuconfig.h"

fbMenuConfig::fbMenuConfig(QObject *parent) : fbConfig(parent)
{
    myResourceQuery = "(/resources/node[@name=\"menu\"]/node[@name and @value][not(node)]/@name|/resources/node[@name=\"menu\"]/node[@name and @value][not(node)]/@value)/string()";
    myConfigQuery = "/menubar/item/@id/string()";
}

void fbMenuConfig::setConfigFilePath(const QString file_name) {
    myConfigFilePath = getUserConfigDir() + "/" + file_name;

    if (!QFile::exists(myConfigFilePath)) {
        myConfigFilePath = getSystemConfigDir() + "/" + file_name;
    }
}

bool fbMenuConfig::writeConfig(const QStringList *selected) {
    QFile write_file(getUserConfigDir() + "/" + myConfigFileName);

    if (!write_file.open(QIODevice::Text | QIODevice::WriteOnly | QIODevice::Truncate)) {
        return false;
    }

    QDomDocument xmldoc;
    xmldoc.setContent(QString("<?xml version='1.0' encoding='UTF-8'?>"));
    QDomElement menubar = xmldoc.createElement("menubar");
    xmldoc.appendChild(menubar);

    for (int i = 0; i < selected->count(); i++) {
        QDomElement item = xmldoc.createElement("item");
        item.setAttribute("id", getItemName(selected->at(i)));
        menubar.appendChild(item);
    }

    QTextStream output(&write_file);
    output << xmldoc;

    write_file.close();

    return true;
}
