/*
 * Copyright (C) 2004-2010 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <iostream>
#include <ZLFile.h>
#include <ZLDir.h>
#include <ZLibrary.h>
#include <ZLStringUtil.h>

#include "FBColorSchemeFileHandler.h"

const std::string COLOR_SCHEME_DIR = "color_schemes";

FBColorSchemeOpenHandler::FBColorSchemeOpenHandler() : myIsUpToDate(false), mySelectedIndex(0) {
	myDir = ZLFile(ZLibrary::ApplicationWritableDirectory() +
	               ZLibrary::FileNameDelimiter +
	               COLOR_SCHEME_DIR).directory(true);
}

FBColorSchemeOpenHandler::~FBColorSchemeOpenHandler() {
}

const std::string FBColorSchemeOpenHandler::stateDisplayName() const {
	return ZLFile::fileNameToUtf8(myDir->path());
}

const std::vector<ZLTreeNodePtr> &FBColorSchemeOpenHandler::subnodes() const {
	if (!myIsUpToDate) {
		std::map<std::string,ZLTreeNodePtr> fileNodes;

		std::vector<std::string> names;
		std::vector<std::string>::const_iterator it;

		myDir->collectFiles(names, true);
		for (it = names.begin(); it != names.end(); ++it) {
			if (it->empty()) {
				continue;
			}
			ZLFile file(myDir->itemPath(*it));
			const std::string displayName = ZLFile::fileNameToUtf8(file.name(true));
			if (displayName.empty()) {
				continue;
			}

			fileNodes[displayName] = new ZLTreeNode(*it, displayName, "unknown", false);
		}

		std::map<std::string,ZLTreeNodePtr>::const_iterator jt;
		for (jt = fileNodes.begin(); jt != fileNodes.end(); ++jt) {
			mySubnodes.push_back(jt->second);
		}
		myIsUpToDate = true;
	}
	return mySubnodes;
}

int FBColorSchemeOpenHandler::selectedIndex() const {
	return mySelectedIndex;
}

bool FBColorSchemeOpenHandler::accept(const ZLTreeNode &node) {
	myFile = myDir->itemPath(node.id());
	return true;
}

std::string FBColorSchemeOpenHandler::selected() const {
	return myFile;
}

FBColorSchemeSaveHandler::FBColorSchemeSaveHandler() : myIsUpToDate(false), mySelectedIndex(0) {
	myDir = ZLFile(ZLibrary::ApplicationWritableDirectory() +
	               ZLibrary::FileNameDelimiter +
	               COLOR_SCHEME_DIR).directory(true);
}

FBColorSchemeSaveHandler::~FBColorSchemeSaveHandler() {
}

const std::string FBColorSchemeSaveHandler::stateDisplayName() const {
	return myDisplayName;
}

const std::vector<ZLTreeNodePtr> &FBColorSchemeSaveHandler::subnodes() const {
	if (!myIsUpToDate) {
		std::map<std::string,ZLTreeNodePtr> fileNodes;

		std::vector<std::string> names;
		std::vector<std::string>::const_iterator it;

		myDir->collectFiles(names, true);
		for (it = names.begin(); it != names.end(); ++it) {
			if (it->empty()) {
				continue;
			}
			ZLFile file(myDir->itemPath(*it));
			const std::string displayName = ZLFile::fileNameToUtf8(file.name(true));
			if (displayName.empty()) {
				continue;
			}

			fileNodes[displayName] = new ZLTreeNode(*it, displayName, "unknown", false);
		}

		std::map<std::string,ZLTreeNodePtr>::const_iterator jt;
		for (jt = fileNodes.begin(); jt != fileNodes.end(); ++jt) {
			mySubnodes.push_back(jt->second);
		}

		myIsUpToDate = true;
	}
	return mySubnodes;
}

int FBColorSchemeSaveHandler::selectedIndex() const {
	return mySelectedIndex;
}

bool FBColorSchemeSaveHandler::accept(const std::string &state) {
	if (state.empty())
		return false;

	myFile = myDir->itemPath(state + ".xml");
	return true;
}

std::string FBColorSchemeSaveHandler::selected() const {
	return myFile;
}

void FBColorSchemeSaveHandler::processNode(const ZLTreeNode &node) {
	myDisplayName = node.displayName();
	addUpdateInfo(ZLTreeHandler::UPDATE_STATE);
}
