#include "burnint.h"
#include "megadrive.h"

// Driver generated by database on http://www.barryharris.me.uk

static struct BurnInputInfo MegadriveInputList[] = {
	{"P1 Start",		BIT_DIGITAL,	MegadriveJoy1 +  7, "p1 start"  },
	{"P1 Up",		BIT_DIGITAL,	MegadriveJoy1 +  0, "p1 up"     },
	{"P1 Down",		BIT_DIGITAL,	MegadriveJoy1 +  1, "p1 down"   },
	{"P1 Left",		BIT_DIGITAL,	MegadriveJoy1 +  2, "p1 left"   },
	{"P1 Right",		BIT_DIGITAL,	MegadriveJoy1 +  3, "p1 right"  },
	{"P1 Button A",		BIT_DIGITAL,	MegadriveJoy1 +  6, "p1 fire 1" },
	{"P1 Button B",		BIT_DIGITAL,	MegadriveJoy1 +  4, "p1 fire 2" },
	{"P1 Button C",		BIT_DIGITAL,	MegadriveJoy1 +  5, "p1 fire 3" },
	{"P1 Button X",		BIT_DIGITAL,	MegadriveJoy1 + 10, "p1 fire 4" },
	{"P1 Button Y",		BIT_DIGITAL,	MegadriveJoy1 +  9, "p1 fire 5" },
	{"P1 Button Z",		BIT_DIGITAL,	MegadriveJoy1 +  8, "p1 fire 6" },
	{"P1 Mode",		BIT_DIGITAL,	MegadriveJoy1 + 11, "p1 select" },

	{"P2 Start",		BIT_DIGITAL,	MegadriveJoy2 +  7, "p2 start"  },
	{"P2 Up",		BIT_DIGITAL,	MegadriveJoy2 +  0, "p2 up"     },
	{"P2 Down",		BIT_DIGITAL,	MegadriveJoy2 +  1, "p2 down"   },
	{"P2 Left",		BIT_DIGITAL,	MegadriveJoy2 +  2, "p2 left"   },
	{"P2 Right",		BIT_DIGITAL,	MegadriveJoy2 +  3, "p2 right"  },
	{"P2 Button A",		BIT_DIGITAL,	MegadriveJoy2 +  6, "p2 fire 1" },
	{"P2 Button B",		BIT_DIGITAL,	MegadriveJoy2 +  4, "p2 fire 2" },
	{"P2 Button C",		BIT_DIGITAL,	MegadriveJoy2 +  5, "p2 fire 3" },
	{"P2 Button X",		BIT_DIGITAL,	MegadriveJoy2 + 10, "p2 fire 4" },
	{"P2 Button Y",		BIT_DIGITAL,	MegadriveJoy2 +  9, "p2 fire 5" },
	{"P2 Button Z",		BIT_DIGITAL,	MegadriveJoy2 +  8, "p2 fire 6" },
	{"P2 Mode",		BIT_DIGITAL,	MegadriveJoy2 + 11, "p2 select" },

	{"Reset",		BIT_DIGITAL,	&MegadriveReset,     "reset"    },
	{"Dip A",		BIT_DIPSWITCH,	MegadriveDIP  + 0,   "dip"      },
	{"Dip B",		BIT_DIPSWITCH,	MegadriveDIP  + 1,   "dip"      },
};

STDINPUTINFO(Megadrive)

static struct BurnInputInfo Megadrive4pInputList[] = {
	{"P1 Start",		BIT_DIGITAL,	MegadriveJoy1 +  7, "p1 start"  },
	{"P1 Up",		BIT_DIGITAL,	MegadriveJoy1 +  0, "p1 up"     },
	{"P1 Down",		BIT_DIGITAL,	MegadriveJoy1 +  1, "p1 down"   },
	{"P1 Left",		BIT_DIGITAL,	MegadriveJoy1 +  2, "p1 left"   },
	{"P1 Right",		BIT_DIGITAL,	MegadriveJoy1 +  3, "p1 right"  },
	{"P1 Button A",		BIT_DIGITAL,	MegadriveJoy1 +  6, "p1 fire 1" },
	{"P1 Button B",		BIT_DIGITAL,	MegadriveJoy1 +  4, "p1 fire 2" },
	{"P1 Button C",		BIT_DIGITAL,	MegadriveJoy1 +  5, "p1 fire 3" },
	{"P1 Button X",		BIT_DIGITAL,	MegadriveJoy1 + 10, "p1 fire 4" },
	{"P1 Button Y",		BIT_DIGITAL,	MegadriveJoy1 +  9, "p1 fire 5" },
	{"P1 Button Z",		BIT_DIGITAL,	MegadriveJoy1 +  8, "p1 fire 6" },
	{"P1 Mode",		BIT_DIGITAL,	MegadriveJoy1 + 11, "p1 select" },

	{"P2 Start",		BIT_DIGITAL,	MegadriveJoy2 +  7, "p2 start"  },
	{"P2 Up",		BIT_DIGITAL,	MegadriveJoy2 +  0, "p2 up"     },
	{"P2 Down",		BIT_DIGITAL,	MegadriveJoy2 +  1, "p2 down"   },
	{"P2 Left",		BIT_DIGITAL,	MegadriveJoy2 +  2, "p2 left"   },
	{"P2 Right",		BIT_DIGITAL,	MegadriveJoy2 +  3, "p2 right"  },
	{"P2 Button A",		BIT_DIGITAL,	MegadriveJoy2 +  6, "p2 fire 1" },
	{"P2 Button B",		BIT_DIGITAL,	MegadriveJoy2 +  4, "p2 fire 2" },
	{"P2 Button C",		BIT_DIGITAL,	MegadriveJoy2 +  5, "p2 fire 3" },
	{"P2 Button X",		BIT_DIGITAL,	MegadriveJoy2 + 10, "p2 fire 4" },
	{"P2 Button Y",		BIT_DIGITAL,	MegadriveJoy2 +  9, "p2 fire 5" },
	{"P2 Button Z",		BIT_DIGITAL,	MegadriveJoy2 +  8, "p2 fire 6" },
	{"P2 Mode",		BIT_DIGITAL,	MegadriveJoy2 + 11, "p2 select" },

	{"P3 Start",		BIT_DIGITAL,	MegadriveJoy3 +  7, "p3 start"  },
	{"P3 Up",		BIT_DIGITAL,	MegadriveJoy3 +  0, "p3 up"     },
	{"P3 Down",		BIT_DIGITAL,	MegadriveJoy3 +  1, "p3 down"   },
	{"P3 Left",		BIT_DIGITAL,	MegadriveJoy3 +  2, "p3 left"   },
	{"P3 Right",		BIT_DIGITAL,	MegadriveJoy3 +  3, "p3 right"  },
	{"P3 Button A",		BIT_DIGITAL,	MegadriveJoy3 +  6, "p3 fire 1" },
	{"P3 Button B",		BIT_DIGITAL,	MegadriveJoy3 +  4, "p3 fire 2" },
	{"P3 Button C",		BIT_DIGITAL,	MegadriveJoy3 +  5, "p3 fire 3" },
	{"P3 Button X",		BIT_DIGITAL,	MegadriveJoy3 + 10, "p3 fire 4" },
	{"P3 Button Y",		BIT_DIGITAL,	MegadriveJoy3 +  9, "p3 fire 5" },
	{"P3 Button Z",		BIT_DIGITAL,	MegadriveJoy3 +  8, "p3 fire 6" },
	{"P3 Mode",		BIT_DIGITAL,	MegadriveJoy3 + 11, "p3 select" },

	{"P4 Start",		BIT_DIGITAL,	MegadriveJoy4 +  7, "p4 start"  },
	{"P4 Up",		BIT_DIGITAL,	MegadriveJoy4 +  0, "p4 up"     },
	{"P4 Down",		BIT_DIGITAL,	MegadriveJoy4 +  1, "p4 down"   },
	{"P4 Left",		BIT_DIGITAL,	MegadriveJoy4 +  2, "p4 left"   },
	{"P4 Right",		BIT_DIGITAL,	MegadriveJoy4 +  3, "p4 right"  },
	{"P4 Button A",		BIT_DIGITAL,	MegadriveJoy4 +  6, "p4 fire 1" },
	{"P4 Button B",		BIT_DIGITAL,	MegadriveJoy4 +  4, "p4 fire 2" },
	{"P4 Button C",		BIT_DIGITAL,	MegadriveJoy4 +  5, "p4 fire 3" },
	{"P4 Button X",		BIT_DIGITAL,	MegadriveJoy4 + 10, "p4 fire 4" },
	{"P4 Button Y",		BIT_DIGITAL,	MegadriveJoy4 +  9, "p4 fire 5" },
	{"P4 Button Z",		BIT_DIGITAL,	MegadriveJoy4 +  8, "p4 fire 6" },
	{"P4 Mode",		BIT_DIGITAL,	MegadriveJoy4 + 11, "p4 select" },

	{"Reset",		BIT_DIGITAL,	&MegadriveReset,     "reset"    },
	{"Dip A",		BIT_DIPSWITCH,	MegadriveDIP  + 0,   "dip"      },
	{"Dip B",		BIT_DIPSWITCH,	MegadriveDIP  + 1,   "dip"      },
};

STDINPUTINFO(Megadrive4p)

static struct BurnDIPInfo MegadriveDIPList[] = {
	{0x1a,	0xff, 0xff, 0x01,  NULL               },

	{0,	0xfe, 0,       5, "Hardware"          },
	{0x19,	0x01, 0xc1, 0x01, "Auto Detect"       },
	{0x19,	0x01, 0xc1, 0x00, "Japan NTSC"        },
	{0x19,	0x01, 0xc1, 0x40, "Japan PAL"         },
	{0x19,	0x01, 0xc1, 0x80, "USA"               },
	{0x19,	0x01, 0xc1, 0xc0, "Europe"            },

	{0,	0xfe, 0,       2, "CD-ROM"            },
	{0x19,	0x01, 0x20, 0x20, "No"                },
	{0x19,	0x01, 0x20, 0x00, "Yes"               },

	{0,	0xfe, 0,       3, "32-Col Mode Draw"  },
	{0x1a,	0x01, 0x03, 0x00, "No Change"         },
	{0x1a,	0x01, 0x03, 0x01, "Center"            },
	{0x1a,	0x01, 0x03, 0x02, "Inner Zoom"        },
};

static struct BurnDIPInfo AutoDetectRegionDIPList[] = {
	{0x19,	0xff,  0xff,	0x21,   NULL},
};

static struct BurnDIPInfo Megadrive4pDIPList[] = {
	{0x32,	0xff, 0xff, 0x01,  NULL               },

	{0,	0xfe, 0,       5, "Hardware"          },
	{0x31,	0x01, 0xc1, 0x01, "Auto Detect"       },
	{0x31,	0x01, 0xc1, 0x00, "Japan NTSC"        },
	{0x31,	0x01, 0xc1, 0x40, "Japan PAL"         },
	{0x31,	0x01, 0xc1, 0x80, "USA"               },
	{0x31,	0x01, 0xc1, 0xc0, "Europe"            },

	{0,	0xfe, 0,       2, "CD-ROM"            },
	{0x31,	0x01, 0x20, 0x20, "No"                },
	{0x31,	0x01, 0x20, 0x00, "Yes"               },

	{0,	0xfe, 0,       3, "32-Col Mode Draw"  },
	{0x32,	0x01, 0x03, 0x00, "No Change"         },
	{0x32,	0x01, 0x03, 0x01, "Center"            },
	{0x32,	0x01, 0x03, 0x02, "Inner Zoom"        },
};

	static struct BurnDIPInfo AutoDetectRegion4pDIPList[] = {
	{0x31,	0xff,  0xff,	0x21,   NULL},
};

STDDIPINFOEXT(Megadrive, AutoDetectRegion, Megadrive)
STDDIPINFOEXT(Megadrive4p, AutoDetectRegion4p, Megadrive4p)

INT32 MegadriveGetZipName(char** pszName, UINT32 i)
{
	static char szFilename[MAX_PATH];
	char* pszGameName = NULL;

	if (pszName == NULL) {
		return 1;
	}

	if (i == 0) {
		pszGameName = BurnDrvGetTextA(DRV_NAME);
	} else {
		pszGameName = BurnDrvGetTextA(DRV_PARENT);
	}

	if (pszGameName == NULL) {
		*pszName = NULL;
		return 1;
	}

	// remove the "md_"
	for (UINT32 j = 0; j < strlen(pszGameName); j++) {
		szFilename[j] = pszGameName[j + 3];
	}
	strcat(szFilename, ".zip");

	*pszName = szFilename;

	return 0;
}

// F-22 Interceptor (Euro, USA, 199109)
static struct BurnRomInfo md_f22aRomDesc[] = {
	{ "f-22_intercept_f-202-4.u1", 0x080000, 0x649771f8, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "f-22_intercept_f-202-1.u2", 0x020000, 0xd3d7cbb8, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_080000 },
};

STD_ROM_PICK(md_f22a)
STD_ROM_FN(md_f22a)

struct BurnDriver BurnDrvmd_f22a = {
	"md_f22a", "md_f22", NULL, NULL, "1991",
	"F-22 Interceptor (Euro, USA, 199109)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f22aRomInfo, md_f22aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA 97 Gold Edition (Euro, USA)
static struct BurnRomInfo md_fifa97RomDesc[] = {
	{ "fifa_97_b1", 0x200000, 0x2bedb061, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa97)
STD_ROM_FN(md_fifa97)

struct BurnDriver BurnDrvmd_fifa97 = {
	"md_fifa97", NULL, NULL, NULL, "1996",
	"FIFA 97 Gold Edition (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa97RomInfo, md_fifa97RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Bond 007 - The Duel (Euro, Rev. A)
static struct BurnRomInfo md_jb007RomDesc[] = {
	{ "mpr-15312a", 0x080000, 0x66635364, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jb007)
STD_ROM_FN(md_jb007)

struct BurnDriver BurnDrvmd_jb007 = {
	"md_jb007", NULL, NULL, NULL, "1992",
	"James Bond 007 - The Duel (Euro, Rev. A)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jb007RomInfo, md_jb007RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond - Underwater Agent (Euro, USA)
static struct BurnRomInfo md_jpondRomDesc[] = {
	{ "james_pond_u1_jam03", 0x080000, 0xd0e7b466, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpond)
STD_ROM_FN(md_jpond)

struct BurnDriver BurnDrvmd_jpond = {
	"md_jpond", NULL, NULL, NULL, "1993",
	"James Pond - Underwater Agent (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpondRomInfo, md_jpondRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond II - Codename Robocod (Euro, USA)
static struct BurnRomInfo md_jpond2RomDesc[] = {
	{ "pond_ii_robocod_ro_b02", 0x080000, 0xc32b5d66, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpond2)
STD_ROM_FN(md_jpond2)

struct BurnDriver BurnDrvmd_jpond2 = {
	"md_jpond2", NULL, NULL, NULL, "1991",
	"James Pond II - Codename Robocod (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpond2RomInfo, md_jpond2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus Turbo Challenge (Euro, USA)
static struct BurnRomInfo md_lotustRomDesc[] = {
	{ "lotus_turbo_lot03", 0x100000, 0xb83ccb7a, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lotust)
STD_ROM_FN(md_lotust)

struct BurnDriver BurnDrvmd_lotust = {
	"md_lotust", NULL, NULL, NULL, "1992",
	"Lotus Turbo Challenge (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lotustRomInfo, md_lotustRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL '94 (Euro, USA)
static struct BurnRomInfo md_nhl94RomDesc[] = {
	{ "nhl94_hl9402", 0x100000, 0xacecd225, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhl94)
STD_ROM_FN(md_nhl94)

struct BurnDriver BurnDrvmd_nhl94 = {
	"md_nhl94", NULL, NULL, NULL, "1993",
	"NHL '94 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhl94RomInfo, md_nhl94RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (Euro, USA)
static struct BurnRomInfo md_pga2aRomDesc[] = {
	{ "pga_tour_golf_pgt04", 0x100000, 0x8d980bb4, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga2a)
STD_ROM_FN(md_pga2a)

struct BurnDriver BurnDrvmd_pga2a = {
	"md_pga2a", "md_pga2", NULL, NULL, "1992",
	"PGA Tour Golf II (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pga2aRomInfo, md_pga2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rise of the Robots (Euro)
static struct BurnRomInfo md_riserbotRomDesc[] = {
	{ "es133-1_rise_of_the_robots.u1", 0x200000, 0xed583ef7, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "es133-2_rise_of_the_robots.u2", 0x100000, 0xfcf18470, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_200000 },
};

STD_ROM_PICK(md_riserbot)
STD_ROM_FN(md_riserbot)

struct BurnDriver BurnDrvmd_riserbot = {
	"md_riserbot", NULL, NULL, NULL, "1994",
	"Rise of the Robots (Euro)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_riserbotRomInfo, md_riserbotRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Splatterhouse Part 2 (Jpn)
static struct BurnRomInfo md_splatt2jRomDesc[] = {
	{ "sh2j", 0x100000, 0xadbd991b, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_splatt2j)
STD_ROM_FN(md_splatt2j)

struct BurnDriver BurnDrvmd_splatt2j = {
	"md_splatt2j", "md_splatt2", NULL, NULL, "1992",
	"Splatterhouse Part 2 (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_splatt2jRomInfo, md_splatt2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Zero Tolerance (Euro, USA)
static struct BurnRomInfo md_zerotolRomDesc[] = {
	{ "zetsg_lo_7500-00034a.u2", 0x100000, 0xb9c2d518, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000000 },
	{ "zetsg_hi_7500-00033a.u1", 0x100000, 0xaf362b8c, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000001 },
};

STD_ROM_PICK(md_zerotol)
STD_ROM_FN(md_zerotol)

struct BurnDriver BurnDrvmd_zerotol = {
	"md_zerotol", NULL, NULL, NULL, "1994",
	"Zero Tolerance (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_zerotolRomInfo, md_zerotolRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Euro)
static struct BurnRomInfo md_advbatrRomDesc[] = {
	{ "mpr-18019.ic1", 0x200000, 0x355e8c39, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatr)
STD_ROM_FN(md_advbatr)

struct BurnDriver BurnDrvmd_advbatr = {
	"md_advbatr", NULL, NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrRomInfo, md_advbatrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Mighty Max (Euro)
static struct BurnRomInfo md_mightmaxRomDesc[] = {
	{ "mpr-17434.ic1", 0x100000, 0x24f1a3bb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mightmax)
STD_ROM_FN(md_mightmax)

struct BurnDriver BurnDrvmd_mightmax = {
	"md_mightmax", NULL, NULL, NULL, "1994",
	"The Adventures of Mighty Max (Euro)\0", NULL, "Ocean", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mightmaxRomInfo, md_mightmaxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (Euro, Rev. A)
static struct BurnRomInfo md_alexkiddRomDesc[] = {
	{ "mpr-12608a.ic1", 0x040000, 0x778a0f00, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alexkidd)
STD_ROM_FN(md_alexkidd)

struct BurnDriver BurnDrvmd_alexkidd = {
	"md_alexkidd", NULL, NULL, NULL, "1990",
	"Alex Kidd in the Enchanted Castle (Euro, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alexkiddRomInfo, md_alexkiddRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (Euro)
static struct BurnRomInfo md_alisiadRomDesc[] = {
	{ "mpr-14680.ic1", 0x100000, 0x28165bd1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alisiad)
STD_ROM_FN(md_alisiad)

struct BurnDriver BurnDrvmd_alisiad = {
	"md_alisiad", NULL, NULL, NULL, "1992",
	"Alisia Dragoon (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alisiadRomInfo, md_alisiadRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (Euro)
static struct BurnRomInfo md_agassiRomDesc[] = {
	{ "mpr-15488.ic1", 0x080000, 0x224256c7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_agassi)
STD_ROM_FN(md_agassi)

struct BurnDriver BurnDrvmd_agassi = {
	"md_agassi", NULL, NULL, NULL, "1992",
	"Andre Agassi Tennis (Euro)\0", NULL, "TecMagik", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_agassiRomInfo, md_agassiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Another World (Euro)
static struct BurnRomInfo md_anotherwRomDesc[] = {
	{ "mpr-15498.ic1", 0x100000, 0xe9742041, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_anotherw)
STD_ROM_FN(md_anotherw)

struct BurnDriver BurnDrvmd_anotherw = {
	"md_anotherw", NULL, NULL, NULL, "1993",
	"Another World (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_anotherwRomInfo, md_anotherwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcade Classics (Euro, USA)
static struct BurnRomInfo md_arcadeclRomDesc[] = {
	{ "mpr-18815.ic1", 0x080000, 0x8aed2090, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arcadecl)
STD_ROM_FN(md_arcadecl)

struct BurnDriver BurnDrvmd_arcadecl = {
	"md_arcadecl", NULL, NULL, NULL, "1996",
	"Arcade Classics (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arcadeclRomInfo, md_arcadeclRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art Alive (World)
static struct BurnRomInfo md_artaliveRomDesc[] = {
	{ "mpr-14384.ic1", 0x020000, 0xf1b72cdd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_artalive)
STD_ROM_FN(md_artalive)

struct BurnDriver BurnDrvmd_artalive = {
	"md_artalive", NULL, NULL, NULL, "1991",
	"Art Alive (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_artaliveRomInfo, md_artaliveRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Streets of Rage (Euro, USA, Rev. A) ~ Bare Knuckle - Ikari no Tetsuken (Jpn, Rev. A)
static struct BurnRomInfo md_sorRomDesc[] = {
	{ "mpr-14125a.ic1", 0x080000, 0x4052e845, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sor)
STD_ROM_FN(md_sor)

struct BurnDriver BurnDrvmd_sor = {
	"md_sor", NULL, NULL, NULL, "1991",
	"Streets of Rage (Euro, USA, Rev. A) ~ Bare Knuckle - Ikari no Tetsuken (Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_sorRomInfo, md_sorRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Streets of Rage (Euro, USA) ~ Bare Knuckle - Ikari no Tetsuken (Jpn)
static struct BurnRomInfo md_soraRomDesc[] = {
	{ "mpr-14125.ic1", 0x080000, 0xbff227c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sora)
STD_ROM_FN(md_sora)

struct BurnDriver BurnDrvmd_sora = {
	"md_sora", "md_sor", NULL, NULL, "1991",
	"Streets of Rage (Euro, USA) ~ Bare Knuckle - Ikari no Tetsuken (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_soraRomInfo, md_soraRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (Euro)
static struct BurnRomInfo md_batmanRomDesc[] = {
	{ "mpr-14561.ic1", 0x080000, 0x61c60c35, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batman)
STD_ROM_FN(md_batman)

struct BurnDriver BurnDrvmd_batman = {
	"md_batman", NULL, NULL, NULL, "1990",
	"Batman (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanRomInfo, md_batmanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (Euro, Rev. A)
static struct BurnRomInfo md_ferrariRomDesc[] = {
	{ "mpr-14770a.ic1", 0x100000, 0x250111df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ferrari)
STD_ROM_FN(md_ferrari)

struct BurnDriver BurnDrvmd_ferrari = {
	"md_ferrari", NULL, NULL, NULL, "1992",
	"Ferrari Grand Prix Challenge (Euro, Rev. A)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ferrariRomInfo, md_ferrariRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game Toshokan (Jpn, Rev. A)
static struct BurnRomInfo md_gametoRomDesc[] = {
	{ "mpr-12750a.ic1", 0x020000, 0xc185c819, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gameto)
STD_ROM_FN(md_gameto)

struct BurnDriver BurnDrvmd_gameto = {
	"md_gameto", NULL, NULL, NULL, "1990",
	"Game Toshokan (Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_gametoRomInfo, md_gametoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghouls 'n Ghosts (Euro, USA, Kor, Rev. A)
static struct BurnRomInfo md_ghoulsRomDesc[] = {
	{ "mpr-12605a.ic1", 0x020000, 0xd367c3cc, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "mpr-12606a.ic2", 0x080000, 0xf56444c6, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_020000 },
};

STD_ROM_PICK(md_ghouls)
STD_ROM_FN(md_ghouls)

struct BurnDriver BurnDrvmd_ghouls = {
	"md_ghouls", NULL, NULL, NULL, "1989",
	"Ghouls 'n Ghosts (Euro, USA, Kor, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ghoulsRomInfo, md_ghoulsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghouls 'n Ghosts (Euro, USA)
static struct BurnRomInfo md_ghouls1RomDesc[] = {
	{ "mpr-12605.ic1", 0x020000, 0x1066c6ab, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "mpr-12606.ic2", 0x080000, 0xceebc56f, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_020000 },
};

STD_ROM_PICK(md_ghouls1)
STD_ROM_FN(md_ghouls1)

struct BurnDriver BurnDrvmd_ghouls1 = {
	"md_ghouls1", "md_ghouls", NULL, NULL, "1989",
	"Ghouls 'n Ghosts (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ghouls1RomInfo, md_ghouls1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (Euro)
static struct BurnRomInfo md_ghwRomDesc[] = {
	{ "mpr-16211.ic1", 0x200000, 0x9778c181, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ghw)
STD_ROM_FN(md_ghw)

struct BurnDriver BurnDrvmd_ghw = {
	"md_ghw", NULL, NULL, NULL, "1994",
	"Greatest Heavyweights (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_ghwRomInfo, md_ghwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone (Euro, USA)
static struct BurnRomInfo md_homeaRomDesc[] = {
	{ "mpr-14996.ic1", 0x080000, 0xaa0d4387, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_homea)
STD_ROM_FN(md_homea)

struct BurnDriver BurnDrvmd_homea = {
	"md_homea", NULL, NULL, NULL, "1992",
	"Home Alone (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_homeaRomInfo, md_homeaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana II Sports Talk Football (World)
static struct BurnRomInfo md_joemont2aRomDesc[] = {
	{ "mpr-14356.ic1", 0x100000, 0xf2363a4a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_joemont2a)
STD_ROM_FN(md_joemont2a)

struct BurnDriver BurnDrvmd_joemont2a = {
	"md_joemont2a", "md_joemont2", NULL, NULL, "1991",
	"Joe Montana II Sports Talk Football (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_joemont2aRomInfo, md_joemont2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Talmit's Adventure (Euro)
static struct BurnRomInfo md_talmitRomDesc[] = {
	{ "lrog453-eta.bin", 0x100000, 0x05dc3ffc, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_talmit)
STD_ROM_FN(md_talmit)

struct BurnDriver BurnDrvmd_talmit = {
	"md_talmit", NULL, NULL, NULL, "1991",
	"Talmit's Adventure (Euro)\0", NULL, "Namco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_talmitRomInfo, md_talmitRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marvel Land (Jpn)
static struct BurnRomInfo md_mvlndjRomDesc[] = {
	{ "lrog452-mml.bin", 0x100000, 0x5d162d21, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mvlndj)
STD_ROM_FN(md_mvlndj)

struct BurnDriver BurnDrvmd_mvlndj = {
	"md_mvlndj", "md_talmit", NULL, NULL, "1991",
	"Marvel Land (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mvlndjRomInfo, md_mvlndjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman (Euro, Kor)
static struct BurnRomInfo md_megabombRomDesc[] = {
	{ "mpr-17108.ic1", 0x100000, 0x54ab3beb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megabomb)
STD_ROM_FN(md_megabomb)

struct BurnDriver BurnDrvmd_megabomb = {
	"md_megabomb", NULL, NULL, NULL, "1994",
	"Mega Bomberman (Euro, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megabombRomInfo, md_megabombRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 3 (Euro)
static struct BurnRomInfo md_megaga63RomDesc[] = {
	{ "mpr-18871.ic1", 0x300000, 0xfe3e7e4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga63)
STD_ROM_FN(md_megaga63)

struct BurnDriver BurnDrvmd_megaga63 = {
	"md_megaga63", NULL, NULL, NULL, "1995",
	"Mega Games 6 Vol. 3 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga63RomInfo, md_megaga63RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines 2 - Turbo Tournament (Euro, J-Cart)
static struct BurnRomInfo md_microm2RomDesc[] = {
	{ "mdm_2bead.bin", 0x100000, 0x42bfb7eb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_microm2)
STD_ROM_FN(md_microm2)

struct BurnDriver BurnDrvmd_microm2 = {
	"md_microm2", NULL, NULL, NULL, "1994",
	"Micro Machines 2 - Turbo Tournament (Euro, J-Cart)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART_SEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_microm2RomInfo, md_microm2RomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Turbo Tournament 96 (Euro, v1.1, J-Cart)
static struct BurnRomInfo md_micro96RomDesc[] = {
	{ "mm96mdeddb.bin", 0x100000, 0x23319d0d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_micro96)
STD_ROM_FN(md_micro96)

struct BurnDriver BurnDrvmd_micro96 = {
	"md_micro96", NULL, NULL, NULL, "1995",
	"Micro Machines Turbo Tournament 96 (Euro, v1.1, J-Cart)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART_SEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_micro96RomInfo, md_micro96RomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (Euro, USA, J-Cart)
static struct BurnRomInfo md_psamprasRomDesc[] = {
	{ "mdst6636.bin", 0x100000, 0x94e505b2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_psampras)
STD_ROM_FN(md_psampras)

struct BurnDriver BurnDrvmd_psampras = {
	"md_psampras", NULL, NULL, NULL, "1994",
	"Pete Sampras Tennis (Euro, USA, J-Cart)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART, GBF_MISC, 0,
	MegadriveGetZipName, md_psamprasRomInfo, md_psamprasRomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (Euro, USA, Rev. A)
static struct BurnRomInfo md_pstar2RomDesc[] = {
	{ "mpr-12851a.ic1", 0x080000, 0x74714110, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "mpr-12852a.ic2", 0x080000, 0xe304231a, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_080000 },
};

STD_ROM_PICK(md_pstar2)
STD_ROM_FN(md_pstar2)

struct BurnDriver BurnDrvmd_pstar2 = {
	"md_pstar2", NULL, NULL, NULL, "1989",
	"Phantasy Star II (Euro, USA, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pstar2RomInfo, md_pstar2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Shining Force II (Euro)
static struct BurnRomInfo md_shinfrc2RomDesc[] = {
	{ "mpr-16933.ic1", 0x200000, 0x83cb46d1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_shinfrc2)
STD_ROM_FN(md_shinfrc2)

struct BurnDriver BurnDrvmd_shinfrc2 = {
	"md_shinfrc2", NULL, NULL, NULL, "1994",
	"Shining Force II (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_shinfrc2RomInfo, md_shinfrc2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Smurfs (Euro, Rev. A)
static struct BurnRomInfo md_smurfsRomDesc[] = {
	{ "mpr-17019a.ic1", 0x100000, 0x88b30eff, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_smurfs)
STD_ROM_FN(md_smurfs)

struct BurnDriver BurnDrvmd_smurfs = {
	"md_smurfs", NULL, NULL, NULL, "1995",
	"The Smurfs (Euro, Rev. A)\0", NULL, "Infogrames", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_smurfsRomInfo, md_smurfsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Soleil (Spa)
static struct BurnRomInfo md_soleilsRomDesc[] = {
	{ "mpr-17512.ic1", 0x200000, 0x9ed4c323, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_soleils)
STD_ROM_FN(md_soleils)

struct BurnDriver BurnDrvmd_soleils = {
	"md_soleils", "md_soleil", NULL, NULL, "1994",
	"Soleil (Spa)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_soleilsRomInfo, md_soleilsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Soleil (Fra)
static struct BurnRomInfo md_soleilfRomDesc[] = {
	{ "mpr-17513.ic1", 0x200000, 0x08dc1ead, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_soleilf)
STD_ROM_FN(md_soleilf)

struct BurnDriver BurnDrvmd_soleilf = {
	"md_soleilf", "md_soleil", NULL, NULL, "1994",
	"Soleil (Fra)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_soleilfRomInfo, md_soleilfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Soleil (Ger)
static struct BurnRomInfo md_soleilgRomDesc[] = {
	{ "mpr-17514.ic1", 0x200000, 0x332b9ecd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_soleilg)
STD_ROM_FN(md_soleilg)

struct BurnDriver BurnDrvmd_soleilg = {
	"md_soleilg", "md_soleil", NULL, NULL, "1994",
	"Soleil (Ger)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_soleilgRomInfo, md_soleilgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sonic the Hedgehog 3 (Euro)
static struct BurnRomInfo md_sonic3RomDesc[] = {
	{ "mpr-16342.ic1", 0x200000, 0x6a632503, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sonic3)
STD_ROM_FN(md_sonic3)

struct BurnDriver BurnDrvmd_sonic3 = {
	"md_sonic3", NULL, NULL, NULL, "1994",
	"Sonic the Hedgehog 3 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_FRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_sonic3RomInfo, md_sonic3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sonic the Hedgehog 3 (Jpn, Kor)
static struct BurnRomInfo md_sonic3jRomDesc[] = {
	{ "mpr-16343.ic1", 0x200000, 0xf4951d1f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sonic3j)
STD_ROM_FN(md_sonic3j)

struct BurnDriver BurnDrvmd_sonic3j = {
	"md_sonic3j", "md_sonic3", NULL, NULL, "1994",
	"Sonic the Hedgehog 3 (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_FRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_sonic3jRomInfo, md_sonic3jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sonic Compilation (Euro, Earlier)
static struct BurnRomInfo md_soniccmp1RomDesc[] = {
	{ "mpr-18203.ic1", 0x200000, 0xfe61c79e, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "mpr-18204.ic2", 0x100000, 0x21d42146, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_200000 },
};

STD_ROM_PICK(md_soniccmp1)
STD_ROM_FN(md_soniccmp1)

struct BurnDriver BurnDrvmd_soniccmp1 = {
	"md_soniccmp1", "md_soniccmp", NULL, NULL, "1995",
	"Sonic Compilation (Euro, Earlier)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_soniccmp1RomInfo, md_soniccmp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sonic Spinball (Euro)
static struct BurnRomInfo md_sspinRomDesc[] = {
	{ "mpr-16077.ic1", 0x100000, 0xaea0786d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sspin)
STD_ROM_FN(md_sspin)

struct BurnDriver BurnDrvmd_sspin = {
	"md_sspin", NULL, NULL, NULL, "1993",
	"Sonic Spinball (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_sspinRomInfo, md_sspinRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Space Harrier II (World)
static struct BurnRomInfo md_sharrRomDesc[] = {
	{ "mpr-12355.ic1", 0x080000, 0xe5c9cbb0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_sharr)
STD_ROM_FN(md_sharr)

struct BurnDriver BurnDrvmd_sharr = {
	"md_sharr", NULL, NULL, NULL, "1989",
	"Space Harrier II (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_sharrRomInfo, md_sharrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Story of Thor - A Successor of The Light (Fra)
static struct BurnRomInfo md_thorfRomDesc[] = {
	{ "mpr-17720.ic1", 0x200000, 0x5385f970, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_000000 },
	{ "mpr-17721.ic2", 0x100000, 0x158fa2aa, BRF_PRG | SEGA_MD_ROM_LOAD_NORMAL | SEGA_MD_ROM_OFFS_200000 },
};

STD_ROM_PICK(md_thorf)
STD_ROM_FN(md_thorf)

struct BurnDriver BurnDrvmd_thorf = {
	"md_thorf", "md_thor", NULL, NULL, "1995",
	"The Story of Thor - A Successor of The Light (Fra)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_thorfRomInfo, md_thorfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Super Monaco GP (Euro, Jpn, Rev. A)
static struct BurnRomInfo md_smgpRomDesc[] = {
	{ "mpr-13250a.ic1", 0x080000, 0xbe91b28a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_smgp)
STD_ROM_FN(md_smgp)

struct BurnDriver BurnDrvmd_smgp = {
	"md_smgp", NULL, NULL, NULL, "1990",
	"Super Monaco GP (Euro, Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_smgpRomInfo, md_smgpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Super Smash TV (Euro, USA)
static struct BurnRomInfo md_ssmashtvRomDesc[] = {
	{ "mpr-15040.ic1", 0x080000, 0xf22412b6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ssmashtv)
STD_ROM_FN(md_ssmashtv)

struct BurnDriver BurnDrvmd_ssmashtv = {
	"md_ssmashtv", NULL, NULL, NULL, "1992",
	"Super Smash TV (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ssmashtvRomInfo, md_ssmashtvRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Addams Family (Euro, USA)
static struct BurnRomInfo md_addfamRomDesc[] = {
	{ "mpr-16147.ic1", 0x100000, 0x71f58614, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_addfam)
STD_ROM_FN(md_addfam)

struct BurnDriver BurnDrvmd_addfam = {
	"md_addfam", NULL, NULL, NULL, "1994",
	"The Addams Family (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_addfamRomInfo, md_addfamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Euro)
static struct BurnRomInfo md_lightcRomDesc[] = {
	{ "mpr-18090.ic1", 0x200000, 0x52c7252b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lightc)
STD_ROM_FN(md_lightc)

struct BurnDriver BurnDrvmd_lightc = {
	"md_lightc", NULL, NULL, NULL, "1995",
	"Light Crusader (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lightcRomInfo, md_lightcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Speed World (USA, Prototype)
static struct BurnRomInfo md_espnsppRomDesc[] = {
	{ "u4.bin", 0x080000, 0x525788b1, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000000 },
	{ "u5.bin", 0x080000, 0xada9c9a8, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000001 },
	{ "u1.bin", 0x080000, 0xe8ee1029, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_100000 },
	{ "u2.bin", 0x080000, 0x0f3ec491, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_100001 },
};

STD_ROM_PICK(md_espnspp)
STD_ROM_FN(md_espnspp)

struct BurnDriver BurnDrvmd_espnspp = {
	"md_espnspp", "md_espnsp", NULL, NULL, "1994",
	"ESPN Speed World (USA, Prototype)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_espnsppRomInfo, md_espnsppRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Sunday Night NFL (USA, Prototype)
static struct BurnRomInfo md_espnnflpRomDesc[] = {
	{ "u4.bin", 0x080000, 0x9f427221, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000000 },
	{ "u5.bin", 0x080000, 0x3445f0e8, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_000001 },
	{ "u1.bin", 0x080000, 0x5d05efc5, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_100000 },
	{ "u2.bin", 0x080000, 0x7ae6fd4b, BRF_PRG | SEGA_MD_ROM_LOAD16_BYTE | SEGA_MD_ROM_OFFS_100001 },
};

STD_ROM_PICK(md_espnnflp)
STD_ROM_FN(md_espnnflp)

struct BurnDriver BurnDrvmd_espnnflp = {
	"md_espnnflp", "md_espnnfl", NULL, NULL, "1994",
	"ESPN Sunday Night NFL (USA, Prototype)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_espnnflpRomInfo, md_espnnflpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Incredible Crash Dummies (Euro, USA)
static struct BurnRomInfo md_crashdumRomDesc[] = {
	{ "mpr-16259.ic1", 0x100000, 0x1f6e574a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crashdum)
STD_ROM_FN(md_crashdum)

struct BurnDriver BurnDrvmd_crashdum = {
	"md_crashdum", NULL, NULL, NULL, "1993",
	"The Incredible Crash Dummies (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crashdumRomInfo, md_crashdumRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESWAT - City Under Siege (Euro, USA, Rev. A)
static struct BurnRomInfo md_eswatRomDesc[] = {
	{ "mpr-13192a.ic1", 0x080000, 0xe72f8a36, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eswat)
STD_ROM_FN(md_eswat)

struct BurnDriver BurnDrvmd_eswat = {
	"md_eswat", NULL, NULL, NULL, "1990",
	"ESWAT - City Under Siege (Euro, USA, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eswatRomInfo, md_eswatRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Evander Holyfield's 'Real Deal' Boxing (World)
static struct BurnRomInfo md_evanderRomDesc[] = {
	{ "mpr-14860.ic1", 0x080000, 0x4fef37c8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_evander)
STD_ROM_FN(md_evander)

struct BurnDriver BurnDrvmd_evander = {
	"md_evander", NULL, NULL, NULL, "1992",
	"Evander Holyfield's 'Real Deal' Boxing (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_evanderRomInfo, md_evanderRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ex-Mutants (Euro, USA)
static struct BurnRomInfo md_exmutantRomDesc[] = {
	{ "mpr-15225.ic1", 0x100000, 0x33b1979f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exmutant)
STD_ROM_FN(md_exmutant)

struct BurnDriver BurnDrvmd_exmutant = {
	"md_exmutant", NULL, NULL, NULL, "1992",
	"Ex-Mutants (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_exmutantRomInfo, md_exmutantRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Galaxy Force II (World, Rev. B)
static struct BurnRomInfo md_gforce2RomDesc[] = {
	{ "mpr-14248b.ic1", 0x100000, 0xd15f5c3c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gforce2)
STD_ROM_FN(md_gforce2)

struct BurnDriver BurnDrvmd_gforce2 = {
	"md_gforce2", NULL, NULL, NULL, "1991",
	"Galaxy Force II (World, Rev. B)\0", NULL, "CRI ~ Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gforce2RomInfo, md_gforce2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Football (Euro, USA)
static struct BurnRomInfo md_mutantlfRomDesc[] = {
	{ "mlf03.u1", 0x100000, 0xdce29c9d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mutantlf)
STD_ROM_FN(md_mutantlf)

struct BurnDriver BurnDrvmd_mutantlf = {
	"md_mutantlf", NULL, NULL, NULL, "1993",
	"Mutant League Football (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mutantlfRomInfo, md_mutantlfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pink Goes to Hollywood (Euro, USA)
static struct BurnRomInfo md_pinkRomDesc[] = {
	{ "mpr-16065.ic1", 0x100000, 0xb5804771, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pink)
STD_ROM_FN(md_pink)

struct BurnDriver BurnDrvmd_pink = {
	"md_pink", NULL, NULL, NULL, "1993",
	"Pink Goes to Hollywood (Euro, USA)\0", NULL, "TecMagik", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pinkRomInfo, md_pinkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Spider-Man and X-Men - Arcade's Revenge (Euro, USA)
static struct BurnRomInfo md_spidxmenRomDesc[] = {
	{ "mpr-15709.ic1", 0x100000, 0x4a4414ea, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_spidxmen)
STD_ROM_FN(md_spidxmen)

struct BurnDriver BurnDrvmd_spidxmen = {
	"md_spidxmen", NULL, NULL, NULL, "1994",
	"Spider-Man and X-Men - Arcade's Revenge (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_spidxmenRomInfo, md_spidxmenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Zoom! (World)
static struct BurnRomInfo md_zoomRomDesc[] = {
	{ "mpr-12807.ic1", 0x040000, 0x724d6965, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_zoom)
STD_ROM_FN(md_zoom)

struct BurnDriver BurnDrvmd_zoom = {
	"md_zoom", NULL, NULL, NULL, "1990",
	"Zoom! (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_zoomRomInfo, md_zoomRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Zany Golf (Euro, USA, v1.1)
static struct BurnRomInfo md_zanygolfRomDesc[] = {
	{ "zany golf (euro, usa) (v1.1).bin", 0x080000, 0x74ed7607, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_zanygolf)
STD_ROM_FN(md_zanygolf)

struct BurnDriver BurnDrvmd_zanygolf = {
	"md_zanygolf", NULL, NULL, NULL, "1990",
	"Zany Golf (Euro, USA, v1.1)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_zanygolfRomInfo, md_zanygolfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bugs Bunny in Double Trouble (Euro)
static struct BurnRomInfo md_bugsbunRomDesc[] = {
	{ "mpr-18887.ic1", 0x200000, 0xcec0a0bb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bugsbun)
STD_ROM_FN(md_bugsbun)

struct BurnDriver BurnDrvmd_bugsbun = {
	"md_bugsbun", NULL, NULL, NULL, "1996",
	"Bugs Bunny in Double Trouble (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bugsbunRomInfo, md_bugsbunRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kid Chameleon (Euro, Korea, USA)
static struct BurnRomInfo md_kidchamRomDesc[] = {
	{ "mpr-14557.ic1", 0x100000, 0xce36e6cc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kidcham)
STD_ROM_FN(md_kidcham)

struct BurnDriver BurnDrvmd_kidcham = {
	"md_kidcham", NULL, NULL, NULL, "1992",
	"Kid Chameleon (Euro, Korea, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kidchamRomInfo, md_kidchamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 95 (Kor)
static struct BurnRomInfo md_fifa95kRomDesc[] = {
	{ "lh5370hd.bin", 0x200000, 0x012591f9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa95k)
STD_ROM_FN(md_fifa95k)

struct BurnDriver BurnDrvmd_fifa95k = {
	"md_fifa95k", "md_fifa95", NULL, NULL, "1994",
	"FIFA Soccer 95 (Kor)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa95kRomInfo, md_fifa95kRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 13 Ma Jiang - 98 Mei Shao Nu Pian (Chi)
static struct BurnRomInfo md_13mahjanRomDesc[] = {
	{ "13 mahjong 98 (unl).bin", 0x0a0000, 0x68b372f6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_13mahjan)
STD_ROM_FN(md_13mahjan)

struct BurnDriver BurnDrvmd_13mahjan = {
	"md_13mahjan", NULL, NULL, NULL, "1998",
	"13 Ma Jiang - 98 Mei Shao Nu Pian (Chi)\0", NULL, "BBD", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_13mahjanRomInfo, md_13mahjanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16 Ton (Jpn, SegaNet)
static struct BurnRomInfo md_16tonRomDesc[] = {
	{ "16 ton (jpn) (sn).bin", 0x040000, 0x537f04b6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_16ton)
STD_ROM_FN(md_16ton)

struct BurnDriver BurnDrvmd_16ton = {
	"md_16ton", NULL, NULL, NULL, "1991",
	"16 Ton (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_16tonRomInfo, md_16tonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16 Ton (Jpn, Game no Kandume MegaCD Rip)
static struct BurnRomInfo md_16tongnkRomDesc[] = {
	{ "16 ton (jpn) (gnk).bin", 0x040000, 0x98149eaf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_16tongnk)
STD_ROM_FN(md_16tongnk)

struct BurnDriver BurnDrvmd_16tongnk = {
	"md_16tongnk", "md_16ton", NULL, NULL, "1991",
	"16 Ton (Jpn, Game no Kandume MegaCD Rip)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_16tongnkRomInfo, md_16tongnkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16 Zhang Ma Jiang (Chi)
static struct BurnRomInfo md_16zhanRomDesc[] = {
	{ "16 zhang ma jiang (chi) (unl).bin", 0x100000, 0x36407c82, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_16zhan)
STD_ROM_FN(md_16zhan)

struct BurnDriver BurnDrvmd_16zhan = {
	"md_16zhan", NULL, NULL, NULL, "199?",
	"16 Zhang Ma Jiang (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_16zhanRomInfo, md_16zhanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3 Ninjas Kick Back (USA)
static struct BurnRomInfo md_3ninjaRomDesc[] = {
	{ "3 ninjas kick back (usa).bin", 0x200000, 0xe5a24999, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_3ninja)
STD_ROM_FN(md_3ninja)

struct BurnDriver BurnDrvmd_3ninja = {
	"md_3ninja", NULL, NULL, NULL, "1994",
	"3 Ninjas Kick Back (USA)\0", NULL, "Psygnosis", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_3ninjaRomInfo, md_3ninjaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3 in 1 Flashback - World Champ. Soccer - Tecmo World Cup 92 (Pirate)
static struct BurnRomInfo md_3in1flRomDesc[] = {
	{ "3-in-1 flashback - world champ. soccer - tecmo world cup 92 (pirate).bin", 0x200000, 0xa8fd28d7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_3in1fl)
STD_ROM_FN(md_3in1fl)

struct BurnDriver BurnDrvmd_3in1fl = {
	"md_3in1fl", NULL, NULL, NULL, "199?",
	"3 in 1 Flashback - World Champ. Soccer - Tecmo World Cup 92 (Pirate)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_3in1flRomInfo, md_3in1flRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3 in 1 Road Rash - Ms. Pac-Man - Block Out (Pirate)
static struct BurnRomInfo md_3in1roRomDesc[] = {
	{ "3-in-1 road rash - ms. pac-man - block out (pirate).bin", 0x100000, 0x13c96154, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_3in1ro)
STD_ROM_FN(md_3in1ro)

struct BurnDriver BurnDrvmd_3in1ro = {
	"md_3in1ro", NULL, NULL, NULL, "199?",
	"3 in 1 Road Rash - Ms. Pac-Man - Block Out (Pirate)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_3in1roRomInfo, md_3in1roRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 6-Pak (USA)
static struct BurnRomInfo md_6pakRomDesc[] = {
	{ "6-pak (usa).bin", 0x300000, 0x1a6f45dc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_6pak)
STD_ROM_FN(md_6pak)

struct BurnDriver BurnDrvmd_6pak = {
	"md_6pak", NULL, NULL, NULL, "1996",
	"6-Pak (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_6pakRomInfo, md_6pakRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 688 Attack Sub (Euro, USA)
static struct BurnRomInfo md_688atsubRomDesc[] = {
	{ "mpr-13956.bin", 0x100000, 0xf2c58bf7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_688atsub)
STD_ROM_FN(md_688atsub)

struct BurnDriver BurnDrvmd_688atsub = {
	"md_688atsub", NULL, NULL, NULL, "1991",
	"688 Attack Sub (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_688atsubRomInfo, md_688atsubRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// A Ressha de Ikou MD - Take the "A" Train (Jpn)
static struct BurnRomInfo md_aresshikRomDesc[] = {
	{ "a ressha de ikou md (jpn).bin", 0x080000, 0x3d45de4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aresshik)
STD_ROM_FN(md_aresshik)

struct BurnDriver BurnDrvmd_aresshik = {
	"md_aresshik", NULL, NULL, NULL, "1992",
	"A Ressha de Ikou MD - Take the 'A' Train (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_aresshikRomInfo, md_aresshikRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aa Harimanada (Jpn)
static struct BurnRomInfo md_aaharimaRomDesc[] = {
	{ "aa harimanada (jpn).bin", 0x200000, 0x065f6021, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aaharima)
STD_ROM_FN(md_aaharima)

struct BurnDriver BurnDrvmd_aaharima = {
	"md_aaharima", NULL, NULL, NULL, "1993",
	"Aa Harimanada (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aaharimaRomInfo, md_aaharimaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AAAHH!!! Real Monsters (Euro)
static struct BurnRomInfo md_aaahhrmRomDesc[] = {
	{ "aaahh!!! real monsters (euro).bin", 0x200000, 0x7ad115ff, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aaahhrm)
STD_ROM_FN(md_aaahhrm)

struct BurnDriver BurnDrvmd_aaahhrm = {
	"md_aaahhrm", NULL, NULL, NULL, "1995",
	"AAAHH!!! Real Monsters (Euro)\0", NULL, "Viacom New Media", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aaahhrmRomInfo, md_aaahhrmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AAAHH!!! Real Monsters (USA)
static struct BurnRomInfo md_aaahhrmuRomDesc[] = {
	{ "aaahh!!! real monsters (usa).bin", 0x200000, 0xfdc80bfc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aaahhrmu)
STD_ROM_FN(md_aaahhrmu)

struct BurnDriver BurnDrvmd_aaahhrmu = {
	"md_aaahhrmu", "md_aaahhrm", NULL, NULL, "1995",
	"AAAHH!!! Real Monsters (USA)\0", NULL, "Viacom New Media", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aaahhrmuRomInfo, md_aaahhrmuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Action 52 (USA)
static struct BurnRomInfo md_action52RomDesc[] = {
	{ "action 52 (usa) (unl).bin", 0x200000, 0x29ff58ae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_action52)
STD_ROM_FN(md_action52)

struct BurnDriver BurnDrvmd_action52 = {
	"md_action52", NULL, NULL, NULL, "1993",
	"Action 52 (USA)\0", NULL, "Active Enterprises", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_action52RomInfo, md_action52RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Action 52 (USA, Alt)
static struct BurnRomInfo md_action52aRomDesc[] = {
	{ "action 52 (usa) (alt) (unl).bin", 0x200000, 0x8809d666, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_action52a)
STD_ROM_FN(md_action52a)

struct BurnDriver BurnDrvmd_action52a = {
	"md_action52a", "md_action52", NULL, NULL, "1993",
	"Action 52 (USA, Alt)\0", NULL, "Active Enterprises", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_action52aRomInfo, md_action52aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Addams Family Values (Euro)
static struct BurnRomInfo md_addfamvRomDesc[] = {
	{ "addams family values (euro).bin", 0x200000, 0xb906b992, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_addfamv)
STD_ROM_FN(md_addfamv)

struct BurnDriver BurnDrvmd_addfamv = {
	"md_addfamv", NULL, NULL, NULL, "1994",
	"Addams Family Values (Euro)\0", NULL, "Ocean", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_addfamvRomInfo, md_addfamvRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Addams Family (USA, Prototype)
static struct BurnRomInfo md_addfamp1RomDesc[] = {
	{ "addams family, the (usa) (beta).bin", 0x100000, 0x2803a5ca, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_addfamp1)
STD_ROM_FN(md_addfamp1)

struct BurnDriver BurnDrvmd_addfamp1 = {
	"md_addfamp1", "md_addfam", NULL, NULL, "1994",
	"The Addams Family (USA, Prototype)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_addfamp1RomInfo, md_addfamp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Addams Family (USA, Prototype, Alt)
static struct BurnRomInfo md_addfamp2RomDesc[] = {
	{ "addams family, the (usa) (beta) (alt).bin", 0x100000, 0x3a173e1f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_addfamp2)
STD_ROM_FN(md_addfamp2)

struct BurnDriver BurnDrvmd_addfamp2 = {
	"md_addfamp2", "md_addfam", NULL, NULL, "1994",
	"The Addams Family (USA, Prototype, Alt)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_addfamp2RomInfo, md_addfamp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Advanced Daisenryaku - Deutsch Dengeki Sakusen (Jpn, Rev. A)
static struct BurnRomInfo md_advdaiRomDesc[] = {
	{ "mpr-13842a.bin", 0x100000, 0xe0d5e18a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advdai)
STD_ROM_FN(md_advdai)

struct BurnDriver BurnDrvmd_advdai = {
	"md_advdai", NULL, NULL, NULL, "1991",
	"Advanced Daisenryaku - Deutsch Dengeki Sakusen (Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_advdaiRomInfo, md_advdaiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950406)
static struct BurnRomInfo md_advbatrp12RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 06, 1995).bin", 0x200000, 0xf05cf389, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp12)
STD_ROM_FN(md_advbatrp12)

struct BurnDriver BurnDrvmd_advbatrp12 = {
	"md_advbatrp12", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950406)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp12RomInfo, md_advbatrp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950410)
static struct BurnRomInfo md_advbatrp11RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 10, 1995).bin", 0x200000, 0xd4f3a070, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp11)
STD_ROM_FN(md_advbatrp11)

struct BurnDriver BurnDrvmd_advbatrp11 = {
	"md_advbatrp11", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950410)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp11RomInfo, md_advbatrp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950411)
static struct BurnRomInfo md_advbatrp10RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 11, 1995).bin", 0x200000, 0xb5b5a290, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp10)
STD_ROM_FN(md_advbatrp10)

struct BurnDriver BurnDrvmd_advbatrp10 = {
	"md_advbatrp10", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950411)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp10RomInfo, md_advbatrp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950418)
static struct BurnRomInfo md_advbatrp09RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 18, 1995).bin", 0x200000, 0x6874142b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp09)
STD_ROM_FN(md_advbatrp09)

struct BurnDriver BurnDrvmd_advbatrp09 = {
	"md_advbatrp09", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950418)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp09RomInfo, md_advbatrp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950419)
static struct BurnRomInfo md_advbatrp08RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 19, 1995).bin", 0x200000, 0x7002da56, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp08)
STD_ROM_FN(md_advbatrp08)

struct BurnDriver BurnDrvmd_advbatrp08 = {
	"md_advbatrp08", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950419)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp08RomInfo, md_advbatrp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950421)
static struct BurnRomInfo md_advbatrp07RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 21, 1995).bin", 0x200000, 0x61f02f13, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp07)
STD_ROM_FN(md_advbatrp07)

struct BurnDriver BurnDrvmd_advbatrp07 = {
	"md_advbatrp07", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950421)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp07RomInfo, md_advbatrp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950422)
static struct BurnRomInfo md_advbatrp06RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 22, 1995).bin", 0x200000, 0xeb8236b2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp06)
STD_ROM_FN(md_advbatrp06)

struct BurnDriver BurnDrvmd_advbatrp06 = {
	"md_advbatrp06", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950422)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp06RomInfo, md_advbatrp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950424)
static struct BurnRomInfo md_advbatrp05RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 24, 1995).bin", 0x200000, 0x253947f8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp05)
STD_ROM_FN(md_advbatrp05)

struct BurnDriver BurnDrvmd_advbatrp05 = {
	"md_advbatrp05", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950424)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp05RomInfo, md_advbatrp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950426)
static struct BurnRomInfo md_advbatrp04RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 26, 1995).bin", 0x200000, 0xbc79f7ee, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp04)
STD_ROM_FN(md_advbatrp04)

struct BurnDriver BurnDrvmd_advbatrp04 = {
	"md_advbatrp04", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950426)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp04RomInfo, md_advbatrp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950427)
static struct BurnRomInfo md_advbatrp03RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 27, 1995).bin", 0x200000, 0xfdac8190, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp03)
STD_ROM_FN(md_advbatrp03)

struct BurnDriver BurnDrvmd_advbatrp03 = {
	"md_advbatrp03", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950427)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp03RomInfo, md_advbatrp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950428)
static struct BurnRomInfo md_advbatrp02RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 28, 1995).bin", 0x200000, 0x27a1524b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp02)
STD_ROM_FN(md_advbatrp02)

struct BurnDriver BurnDrvmd_advbatrp02 = {
	"md_advbatrp02", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950428)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp02RomInfo, md_advbatrp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (Prototype, 19950501)
static struct BurnRomInfo md_advbatrp01RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - may 01, 1995).bin", 0x200000, 0x589aa203, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatrp01)
STD_ROM_FN(md_advbatrp01)

struct BurnDriver BurnDrvmd_advbatrp01 = {
	"md_advbatrp01", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (Prototype, 19950501)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatrp01RomInfo, md_advbatrp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Batman & Robin (USA)
static struct BurnRomInfo md_advbatruRomDesc[] = {
	{ "adventures of batman & robin, the (usa).bin", 0x200000, 0x0caaa4ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_advbatru)
STD_ROM_FN(md_advbatru)

struct BurnDriver BurnDrvmd_advbatru = {
	"md_advbatru", "md_advbatr", NULL, NULL, "1995",
	"The Adventures of Batman & Robin (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_advbatruRomInfo, md_advbatruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Mighty Max (USA)
static struct BurnRomInfo md_mightmaxuRomDesc[] = {
	{ "adventures of mighty max, the (usa).bin", 0x100000, 0x55f13a00, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mightmaxu)
STD_ROM_FN(md_mightmaxu)

struct BurnDriver BurnDrvmd_mightmaxu = {
	"md_mightmaxu", "md_mightmax", NULL, NULL, "1994",
	"The Adventures of Mighty Max (USA)\0", NULL, "Ocean", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mightmaxuRomInfo, md_mightmaxuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Adventures of Rocky and Bullwinkle and Friends (USA)
static struct BurnRomInfo md_rockybwRomDesc[] = {
	{ "adventures of rocky and bullwinkle and friends, the (usa).bin", 0x100000, 0xef02d57b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_rockybw)
STD_ROM_FN(md_rockybw)

struct BurnDriver BurnDrvmd_rockybw = {
	"md_rockybw", NULL, NULL, NULL, "1993",
	"The Adventures of Rocky and Bullwinkle and Friends (USA)\0", NULL, "Absolute Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_rockybwRomInfo, md_rockybwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventurous Boy - Mao Xian Xiao Zi (Chi)
static struct BurnRomInfo md_adveboyRomDesc[] = {
	{ "adventurous boy - mao xian xiao zi (chi) (unl).bin", 0x080000, 0xd4403913, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_adveboy)
STD_ROM_FN(md_adveboy)

struct BurnDriver BurnDrvmd_adveboy = {
	"md_adveboy", NULL, NULL, NULL, "199?",
	"Adventurous Boy - Mao Xian Xiao Zi (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_adveboyRomInfo, md_adveboyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (Euro)
static struct BurnRomInfo md_aeroRomDesc[] = {
	{ "mpr-16603.bin", 0x100000, 0x1a3eaf57, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aero)
STD_ROM_FN(md_aero)

struct BurnDriver BurnDrvmd_aero = {
	"md_aero", NULL, NULL, NULL, "1993",
	"Aero the Acro-Bat (Euro)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aeroRomInfo, md_aeroRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (Prototype)
static struct BurnRomInfo md_aeropRomDesc[] = {
	{ "aero the acro-bat (beta).bin", 0x100000, 0xdcd14b10, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aerop)
STD_ROM_FN(md_aerop)

struct BurnDriver BurnDrvmd_aerop = {
	"md_aerop", "md_aero", NULL, NULL, "1993",
	"Aero the Acro-Bat (Prototype)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aeropRomInfo, md_aeropRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (USA)
static struct BurnRomInfo md_aerouRomDesc[] = {
	{ "aero the acro-bat (usa).bin", 0x100000, 0xa3a7a8b5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aerou)
STD_ROM_FN(md_aerou)

struct BurnDriver BurnDrvmd_aerou = {
	"md_aerou", "md_aero", NULL, NULL, "1993",
	"Aero the Acro-Bat (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aerouRomInfo, md_aerouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat 2 (Euro)
static struct BurnRomInfo md_aero2RomDesc[] = {
	{ "mpr-17303.bin", 0x200000, 0xa451f9a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aero2)
STD_ROM_FN(md_aero2)

struct BurnDriver BurnDrvmd_aero2 = {
	"md_aero2", NULL, NULL, NULL, "1994",
	"Aero the Acro-Bat 2 (Euro)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aero2RomInfo, md_aero2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat 2 (USA)
static struct BurnRomInfo md_aero2uRomDesc[] = {
	{ "aero the acro-bat 2 (usa).bin", 0x200000, 0x39eb74eb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aero2u)
STD_ROM_FN(md_aero2u)

struct BurnDriver BurnDrvmd_aero2u = {
	"md_aero2u", "md_aero2", NULL, NULL, "1994",
	"Aero the Acro-Bat 2 (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aero2uRomInfo, md_aero2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aerobiz (USA)
static struct BurnRomInfo md_aerobizRomDesc[] = {
	{ "aerobiz (usa).bin", 0x100000, 0xcfaa9bce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aerobiz)
STD_ROM_FN(md_aerobiz)

struct BurnDriver BurnDrvmd_aerobiz = {
	"md_aerobiz", NULL, NULL, NULL, "1992",
	"Aerobiz (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_aerobizRomInfo, md_aerobizRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Management - Oozora ni Kakeru (Jpn)
static struct BurnRomInfo md_airmanagRomDesc[] = {
	{ "air management - oozora ni kakeru (jpn).bin", 0x100000, 0xb3db0c71, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_airmanag)
STD_ROM_FN(md_airmanag)

struct BurnDriver BurnDrvmd_airmanag = {
	"md_airmanag", "md_aerobiz", NULL, NULL, "1992",
	"Air Management - Oozora ni Kakeru (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_airmanagRomInfo, md_airmanagRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aerobiz Supersonic (USA)
static struct BurnRomInfo md_aerobizsRomDesc[] = {
	{ "aerobiz supersonic (usa).bin", 0x100000, 0x9377f1b5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aerobizs)
STD_ROM_FN(md_aerobizs)

struct BurnDriver BurnDrvmd_aerobizs = {
	"md_aerobizs", NULL, NULL, NULL, "1994",
	"Aerobiz Supersonic (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_aerobizsRomInfo, md_aerobizsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Management II - Koukuuou o Mezase (Jpn)
static struct BurnRomInfo md_airmang2RomDesc[] = {
	{ "air management ii - koukuuou o mezase (jpn).bin", 0x100000, 0x4582817b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_airmang2)
STD_ROM_FN(md_airmang2)

struct BurnDriver BurnDrvmd_airmang2 = {
	"md_airmang2", "md_aerobizs", NULL, NULL, "1994",
	"Air Management II - Koukuuou o Mezase (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_airmang2RomInfo, md_airmang2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// After Burner II (Euro, USA)
static struct BurnRomInfo md_aburner2RomDesc[] = {
	{ "mpr-13261.bin", 0x080000, 0xccafe00e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aburner2)
STD_ROM_FN(md_aburner2)

struct BurnDriver BurnDrvmd_aburner2 = {
	"md_aburner2", NULL, NULL, NULL, "1990",
	"After Burner II (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aburner2RomInfo, md_aburner2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// After Burner II (Jpn)
static struct BurnRomInfo md_aburner2jRomDesc[] = {
	{ "mpr-12941.bin", 0x080000, 0x4ff37e66, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aburner2j)
STD_ROM_FN(md_aburner2j)

struct BurnDriver BurnDrvmd_aburner2j = {
	"md_aburner2j", "md_aburner2", NULL, NULL, "1990",
	"After Burner II (Jpn)\0", NULL, "Denpa Shinbunsha", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aburner2jRomInfo, md_aburner2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Buster: Trouble Specialty Raid Unit (USA)
static struct BurnRomInfo md_airbustrRomDesc[] = {
	{ "air buster (usa).bin", 0x080000, 0xf3d65baa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_airbustr)
STD_ROM_FN(md_airbustr)

struct BurnDriver BurnDrvmd_airbustr = {
	"md_airbustr", NULL, NULL, NULL, "1991",
	"Air Buster: Trouble Specialty Raid Unit (USA)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_airbustrRomInfo, md_airbustrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero Blasters: Trouble Specialty Raid Unit (Jpn)
static struct BurnRomInfo md_aeroblstRomDesc[] = {
	{ "aero blasters (jpn).bin", 0x080000, 0xa00da987, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aeroblst)
STD_ROM_FN(md_aeroblst)

struct BurnDriver BurnDrvmd_aeroblst = {
	"md_aeroblst", "md_airbustr", NULL, NULL, "1991",
	"Aero Blasters: Trouble Specialty Raid Unit (Jpn)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aeroblstRomInfo, md_aeroblstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Diver (USA)
static struct BurnRomInfo md_airdiverRomDesc[] = {
	{ "air diver (usa).bin", 0x080000, 0x2041885e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_airdiver)
STD_ROM_FN(md_airdiver)

struct BurnDriver BurnDrvmd_airdiver = {
	"md_airdiver", NULL, NULL, NULL, "1990",
	"Air Diver (USA)\0", NULL, "Seismic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_airdiverRomInfo, md_airdiverRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Diver (Jpn)
static struct BurnRomInfo md_airdiverjRomDesc[] = {
	{ "air diver (jpn).bin", 0x080000, 0x9e2d5b91, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_airdiverj)
STD_ROM_FN(md_airdiverj)

struct BurnDriver BurnDrvmd_airdiverj = {
	"md_airdiverj", "md_airdiver", NULL, NULL, "1990",
	"Air Diver (Jpn)\0", NULL, "Asmik Ace", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_airdiverjRomInfo, md_airdiverjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Aladdin (Euro)
static struct BurnRomInfo md_aladdinRomDesc[] = {
	{ "mpr-15939.bin", 0x200000, 0xd1845e8f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aladdin)
STD_ROM_FN(md_aladdin)

struct BurnDriver BurnDrvmd_aladdin = {
	"md_aladdin", NULL, NULL, NULL, "1993",
	"Disney's Aladdin (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aladdinRomInfo, md_aladdinRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Aladdin (Jpn)
static struct BurnRomInfo md_aladdinjRomDesc[] = {
	{ "aladdin (jpn).bin", 0x200000, 0xfb5aacf0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aladdinj)
STD_ROM_FN(md_aladdinj)

struct BurnDriver BurnDrvmd_aladdinj = {
	"md_aladdinj", "md_aladdin", NULL, NULL, "1993",
	"Disney's Aladdin (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aladdinjRomInfo, md_aladdinjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Aladdin (USA)
static struct BurnRomInfo md_aladdinuRomDesc[] = {
	{ "aladdin (usa).bin", 0x200000, 0xed427ea9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aladdinu)
STD_ROM_FN(md_aladdinu)

struct BurnDriver BurnDrvmd_aladdinu = {
	"md_aladdinu", "md_aladdin", NULL, NULL, "1993",
	"Disney's Aladdin (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aladdinuRomInfo, md_aladdinuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Aladdin (USA, Prototype)
static struct BurnRomInfo md_aladdinupRomDesc[] = {
	{ "aladdin (usa) (beta).bin", 0x200000, 0x8c60ef73, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aladdinup)
STD_ROM_FN(md_aladdinup)

struct BurnDriver BurnDrvmd_aladdinup = {
	"md_aladdinup", "md_aladdin", NULL, NULL, "1993",
	"Disney's Aladdin (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aladdinupRomInfo, md_aladdinupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin II
static struct BurnRomInfo md_aladdin2RomDesc[] = {
	{ "aladdin ii (unl).bin", 0x200000, 0xbe5f9397, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aladdin2)
STD_ROM_FN(md_aladdin2)

struct BurnDriver BurnDrvmd_aladdin2 = {
	"md_aladdin2", NULL, NULL, NULL, "199?",
	"Aladdin II\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aladdin2RomInfo, md_aladdin2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (Euro)
static struct BurnRomInfo md_alexkidd1RomDesc[] = {
	{ "alex kidd in the enchanted castle (euro).bin", 0x040000, 0xc3a52529, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alexkidd1)
STD_ROM_FN(md_alexkidd1)

struct BurnDriver BurnDrvmd_alexkidd1 = {
	"md_alexkidd1", "md_alexkidd", NULL, NULL, "1990",
	"Alex Kidd in the Enchanted Castle (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alexkidd1RomInfo, md_alexkidd1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (Jpn)
static struct BurnRomInfo md_alexkiddjRomDesc[] = {
	{ "alex kidd - tenkuu majou (jpn).bin", 0x040000, 0x8a5ed856, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alexkiddj)
STD_ROM_FN(md_alexkiddj)

struct BurnDriver BurnDrvmd_alexkiddj = {
	"md_alexkiddj", "md_alexkidd", NULL, NULL, "1989",
	"Alex Kidd in the Enchanted Castle (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alexkiddjRomInfo, md_alexkiddjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd - Cheongong Maseong (Kor)
static struct BurnRomInfo md_alexkiddkRomDesc[] = {
	{ "alex kidd - cheongong maseong (kor).bin", 0x040000, 0x5b0678fb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alexkiddk)
STD_ROM_FN(md_alexkiddk)

struct BurnDriver BurnDrvmd_alexkiddk = {
	"md_alexkiddk", "md_alexkidd", NULL, NULL, "1990",
	"Alex Kidd - Cheongong Maseong (Kor)\0", NULL, "Samsung", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alexkiddkRomInfo, md_alexkiddkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (USA)
static struct BurnRomInfo md_alexkidduRomDesc[] = {
	{ "alex kidd in the enchanted castle (usa).bin", 0x040000, 0x47dba0ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alexkiddu)
STD_ROM_FN(md_alexkiddu)

struct BurnDriver BurnDrvmd_alexkiddu = {
	"md_alexkiddu", "md_alexkidd", NULL, NULL, "1989",
	"Alex Kidd in the Enchanted Castle (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alexkidduRomInfo, md_alexkidduRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien (Euro, USA, Rev. A)
static struct BurnRomInfo md_alien3RomDesc[] = {
	{ "mpr-15061a.bin", 0x080000, 0xb327fd1b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alien3)
STD_ROM_FN(md_alien3)

struct BurnDriver BurnDrvmd_alien3 = {
	"md_alien3", NULL, NULL, NULL, "1993",
	"Alien3 (Euro, USA, Rev. A)\0", NULL, "Arena Entertainment", "Sega Megadrive",
	L"Alien\u00b3 (Euro, USA, Rev. A)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alien3RomInfo, md_alien3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien (Euro, USA)
static struct BurnRomInfo md_alien3aRomDesc[] = {
	{ "mpr-15061.bin", 0x080000, 0xa3b00d6e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alien3a)
STD_ROM_FN(md_alien3a)

struct BurnDriver BurnDrvmd_alien3a = {
	"md_alien3a", "md_alien3", NULL, NULL, "1993",
	"Alien3 (Euro, USA)\0", NULL, "Arena Entertainment", "Sega Megadrive",
	L"Alien\u00b3 (Euro, USA)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alien3aRomInfo, md_alien3aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Soldier (Euro)
static struct BurnRomInfo md_aliensRomDesc[] = {
	{ "alien soldier (euro).bin", 0x200000, 0x0496e06c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aliens)
STD_ROM_FN(md_aliens)

struct BurnDriver BurnDrvmd_aliens = {
	"md_aliens", NULL, NULL, NULL, "1995",
	"Alien Soldier (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aliensRomInfo, md_aliensRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Soldier (Jpn)
static struct BurnRomInfo md_aliensjRomDesc[] = {
	{ "alien soldier (jpn).bin", 0x200000, 0x90fa1539, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aliensj)
STD_ROM_FN(md_aliensj)

struct BurnDriver BurnDrvmd_aliensj = {
	"md_aliensj", "md_aliens", NULL, NULL, "1995",
	"Alien Soldier (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aliensjRomInfo, md_aliensjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Storm (World)
static struct BurnRomInfo md_alienstmRomDesc[] = {
	{ "mpr-13941.bin", 0x080000, 0xf5ac8de5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alienstm)
STD_ROM_FN(md_alienstm)

struct BurnDriver BurnDrvmd_alienstm = {
	"md_alienstm", NULL, NULL, NULL, "1991",
	"Alien Storm (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alienstmRomInfo, md_alienstmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (Jpn)
static struct BurnRomInfo md_alisiadjRomDesc[] = {
	{ "alisia dragoon (jpn).bin", 0x100000, 0x4d476722, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alisiadj)
STD_ROM_FN(md_alisiadj)

struct BurnDriver BurnDrvmd_alisiadj = {
	"md_alisiadj", "md_alisiad", NULL, NULL, "1992",
	"Alisia Dragoon (Jpn)\0", NULL, "Game Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alisiadjRomInfo, md_alisiadjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (USA)
static struct BurnRomInfo md_alisiaduRomDesc[] = {
	{ "alisia dragoon (usa).bin", 0x100000, 0xd28d5c40, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_alisiadu)
STD_ROM_FN(md_alisiadu)

struct BurnDriver BurnDrvmd_alisiadu = {
	"md_alisiadu", "md_alisiad", NULL, NULL, "1992",
	"Alisia Dragoon (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_alisiaduRomInfo, md_alisiaduRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Altered Beast (Euro, USA)
static struct BurnRomInfo md_altbeastRomDesc[] = {
	{ "mpr-12538.bin", 0x080000, 0x154d59bb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_altbeast)
STD_ROM_FN(md_altbeast)

struct BurnDriver BurnDrvmd_altbeast = {
	"md_altbeast", NULL, NULL, NULL, "1989",
	"Altered Beast (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_altbeastRomInfo, md_altbeastRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Juuouki (Jpn, v1.1)
static struct BurnRomInfo md_juuoukiRomDesc[] = {
	{ "juuouki (jpn) (v1.1).bin", 0x080000, 0xb2233e87, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_juuouki)
STD_ROM_FN(md_juuouki)

struct BurnDriver BurnDrvmd_juuouki = {
	"md_juuouki", "md_altbeast", NULL, NULL, "1988",
	"Juuouki (Jpn, v1.1)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_juuoukiRomInfo, md_juuoukiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Juuouki (Jpn)
static struct BurnRomInfo md_juuouki1RomDesc[] = {
	{ "juuouki (jpn).bin", 0x080000, 0x1b7c96c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_juuouki1)
STD_ROM_FN(md_juuouki1)

struct BurnDriver BurnDrvmd_juuouki1 = {
	"md_juuouki1", "md_altbeast", NULL, NULL, "1988",
	"Juuouki (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_juuouki1RomInfo, md_juuouki1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// American Gladiators (USA)
static struct BurnRomInfo md_amergladRomDesc[] = {
	{ "american gladiators (usa).bin", 0x100000, 0x9952fa85, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_amerglad)
STD_ROM_FN(md_amerglad)

struct BurnDriver BurnDrvmd_amerglad = {
	"md_amerglad", NULL, NULL, NULL, "1992",
	"American Gladiators (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_amergladRomInfo, md_amergladRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (USA)
static struct BurnRomInfo md_agassiuRomDesc[] = {
	{ "andre agassi tennis (usa).bin", 0x080000, 0xe755dd51, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_agassiu)
STD_ROM_FN(md_agassiu)

struct BurnDriver BurnDrvmd_agassiu = {
	"md_agassiu", "md_agassi", NULL, NULL, "1992",
	"Andre Agassi Tennis (USA)\0", NULL, "TecMagik", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_agassiuRomInfo, md_agassiuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (USA, Prototype)
static struct BurnRomInfo md_agassiupRomDesc[] = {
	{ "andre agassi tennis (usa) (beta).bin", 0x080000, 0x3bbf700d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_agassiup)
STD_ROM_FN(md_agassiup)

struct BurnDriver BurnDrvmd_agassiup = {
	"md_agassiup", "md_agassi", NULL, NULL, "1992",
	"Andre Agassi Tennis (USA, Prototype)\0", NULL, "TecMagik", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_agassiupRomInfo, md_agassiupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Animaniacs (Euro)
static struct BurnRomInfo md_animanRomDesc[] = {
	{ "fx014a1.bin", 0x100000, 0x92b6f255, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_animan)
STD_ROM_FN(md_animan)

struct BurnDriver BurnDrvmd_animan = {
	"md_animan", NULL, NULL, NULL, "1994",
	"Animaniacs (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_animanRomInfo, md_animanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Animaniacs (USA)
static struct BurnRomInfo md_animanuRomDesc[] = {
	{ "animaniacs (usa).bin", 0x100000, 0x86224d86, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_animanu)
STD_ROM_FN(md_animanu)

struct BurnDriver BurnDrvmd_animanu = {
	"md_animanu", "md_animan", NULL, NULL, "1994",
	"Animaniacs (USA)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_animanuRomInfo, md_animanuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Out of This World (USA)
static struct BurnRomInfo md_ootwRomDesc[] = {
	{ "out of this world (usa).bin", 0x100000, 0x2da36e01, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ootw)
STD_ROM_FN(md_ootw)

struct BurnDriver BurnDrvmd_ootw = {
	"md_ootw", "md_anotherw", NULL, NULL, "1993",
	"Out of This World (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ootwRomInfo, md_ootwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Out of this World (Prototype)
static struct BurnRomInfo md_ootwpRomDesc[] = {
	{ "out of this world (beta).bin", 0x100000, 0x3aad905a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ootwp)
STD_ROM_FN(md_ootwp)

struct BurnDriver BurnDrvmd_ootwp = {
	"md_ootwp", "md_anotherw", NULL, NULL, "1993",
	"Out of this World (Prototype)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ootwpRomInfo, md_ootwpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aq Renkan Awa (Chi)
static struct BurnRomInfo md_aqrenkRomDesc[] = {
	{ "aq renkan awa (chi) (unl).bin", 0x100000, 0x2c6cbd77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aqrenk)
STD_ROM_FN(md_aqrenk)

struct BurnDriver BurnDrvmd_aqrenk = {
	"md_aqrenk", NULL, NULL, NULL, "1995",
	"Aq Renkan Awa (Chi)\0", NULL, "C&E", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aqrenkRomInfo, md_aqrenkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Aquatic Games Starring James Pond and the Aquabats (Euro, USA)
static struct BurnRomInfo md_aquaticgRomDesc[] = {
	{ "aqua01.bin", 0x080000, 0x400f4ba7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aquaticg)
STD_ROM_FN(md_aquaticg)

struct BurnDriver BurnDrvmd_aquaticg = {
	"md_aquaticg", NULL, NULL, NULL, "1992",
	"The Aquatic Games Starring James Pond and the Aquabats (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aquaticgRomInfo, md_aquaticgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arch Rivals (Euro, USA)
static struct BurnRomInfo md_archrivlRomDesc[] = {
	{ "mpr-14764.bin", 0x080000, 0xe389d7e7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_archrivl)
STD_ROM_FN(md_archrivl)

struct BurnDriver BurnDrvmd_archrivl = {
	"md_archrivl", NULL, NULL, NULL, "1992",
	"Arch Rivals (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_archrivlRomInfo, md_archrivlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcus Odyssey (USA)
static struct BurnRomInfo md_arcusRomDesc[] = {
	{ "arcus odyssey (usa).bin", 0x100000, 0xbc4d9b20, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arcus)
STD_ROM_FN(md_arcus)

struct BurnDriver BurnDrvmd_arcus = {
	"md_arcus", NULL, NULL, NULL, "1991",
	"Arcus Odyssey (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arcusRomInfo, md_arcusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcus Odyssey (Jpn)
static struct BurnRomInfo md_arcusjRomDesc[] = {
	{ "arcus odyssey (jpn).bin", 0x100000, 0x41c5fb4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arcusj)
STD_ROM_FN(md_arcusj)

struct BurnDriver BurnDrvmd_arcusj = {
	"md_arcusj", "md_arcus", NULL, NULL, "1991",
	"Arcus Odyssey (Jpn)\0", NULL, "Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arcusjRomInfo, md_arcusjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Ariel the Little Mermaid (Euro, USA)
static struct BurnRomInfo md_arielRomDesc[] = {
	{ "mpr-15153.bin", 0x080000, 0x58e297df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ariel)
STD_ROM_FN(md_ariel)

struct BurnDriver BurnDrvmd_ariel = {
	"md_ariel", NULL, NULL, NULL, "1992",
	"Disney's Ariel the Little Mermaid (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arielRomInfo, md_arielRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arnold Palmer Tournament Golf (Euro, USA)
static struct BurnRomInfo md_arnoldpRomDesc[] = {
	{ "mpr-12645.bin", 0x080000, 0x35b995ef, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arnoldp)
STD_ROM_FN(md_arnoldp)

struct BurnDriver BurnDrvmd_arnoldp = {
	"md_arnoldp", NULL, NULL, NULL, "1989",
	"Arnold Palmer Tournament Golf (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arnoldpRomInfo, md_arnoldpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Naomichi Ozaki no Super Masters (Jpn)
static struct BurnRomInfo md_smastersRomDesc[] = {
	{ "naomichi ozaki no super masters (jpn).bin", 0x080000, 0x088ba825, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_smasters)
STD_ROM_FN(md_smasters)

struct BurnDriver BurnDrvmd_smasters = {
	"md_smasters", "md_arnoldp", NULL, NULL, "1989",
	"Naomichi Ozaki no Super Masters (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_smastersRomInfo, md_smastersRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arrow Flash (World)
static struct BurnRomInfo md_arrowRomDesc[] = {
	{ "mpr-13396.bin", 0x080000, 0xd49f8444, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arrow)
STD_ROM_FN(md_arrow)

struct BurnDriver BurnDrvmd_arrow = {
	"md_arrow", NULL, NULL, NULL, "1990",
	"Arrow Flash (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arrowRomInfo, md_arrowRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arrow Flash (World, Alt)
static struct BurnRomInfo md_arrow1RomDesc[] = {
	{ "arrow flash (world) (alt).bin", 0x080000, 0x4d89e66b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_arrow1)
STD_ROM_FN(md_arrow1)

struct BurnDriver BurnDrvmd_arrow1 = {
	"md_arrow1", "md_arrow", NULL, NULL, "1990",
	"Arrow Flash (World, Alt)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_arrow1RomInfo, md_arrow1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (Euro)
static struct BurnRomInfo md_aofRomDesc[] = {
	{ "art of fighting (euro).bin", 0x200000, 0x9970c422, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aof)
STD_ROM_FN(md_aof)

struct BurnDriver BurnDrvmd_aof = {
	"md_aof", NULL, NULL, NULL, "1994",
	"Art of Fighting (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aofRomInfo, md_aofRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (Prototype, 19940711)
static struct BurnRomInfo md_aofpRomDesc[] = {
	{ "art of fighting (prototype - jul 11, 1994).bin", 0x200000, 0x19ce567d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aofp)
STD_ROM_FN(md_aofp)

struct BurnDriver BurnDrvmd_aofp = {
	"md_aofp", "md_aof", NULL, NULL, "1994",
	"Art of Fighting (Prototype, 19940711)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aofpRomInfo, md_aofpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (USA)
static struct BurnRomInfo md_aofuRomDesc[] = {
	{ "art of fighting (usa).bin", 0x200000, 0xc9a57e07, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aofu)
STD_ROM_FN(md_aofu)

struct BurnDriver BurnDrvmd_aofu = {
	"md_aofu", "md_aof", NULL, NULL, "1994",
	"Art of Fighting (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aofuRomInfo, md_aofuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ryuuko no Ken (Jpn)
static struct BurnRomInfo md_ryuukoRomDesc[] = {
	{ "ryuuko no ken (jpn).bin", 0x200000, 0x054cf5f6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ryuuko)
STD_ROM_FN(md_ryuuko)

struct BurnDriver BurnDrvmd_ryuuko = {
	"md_ryuuko", "md_aof", NULL, NULL, "1994",
	"Ryuuko no Ken (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ryuukoRomInfo, md_ryuukoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Astrix and the Great Rescue (Euro)
static struct BurnRomInfo md_asterixRomDesc[] = {
	{ "mpr-15961+mpr-15962.bin", 0x200000, 0x4735fee6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_asterix)
STD_ROM_FN(md_asterix)

struct BurnDriver BurnDrvmd_asterix = {
	"md_asterix", NULL, NULL, NULL, "1993",
	"Asterix and the Great Rescue (Euro)\0", NULL, "Sega", "Sega Megadrive",
	L"Ast\u00e9rix and the Great Rescue (Euro)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_asterixRomInfo, md_asterixRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Astrix and the Great Rescue (USA)
static struct BurnRomInfo md_asterixuRomDesc[] = {
	{ "asterix and the great rescue (usa).bin", 0x200000, 0x7f112cd8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_asterixu)
STD_ROM_FN(md_asterixu)

struct BurnDriver BurnDrvmd_asterixu = {
	"md_asterixu", "md_asterix", NULL, NULL, "1994",
	"Asterix and the Great Rescue (USA)\0", NULL, "Sega", "Sega Megadrive",
	L"Ast\u00e9rix and the Great Rescue (USA)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_asterixuRomInfo, md_asterixuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Astrix and the Power of the Gods (Euro)
static struct BurnRomInfo md_asterpgRomDesc[] = {
	{ "mpr-17719.bin", 0x200000, 0x4ff1d83f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_asterpg)
STD_ROM_FN(md_asterpg)

struct BurnDriver BurnDrvmd_asterpg = {
	"md_asterpg", NULL, NULL, NULL, "1995",
	"Asterix and the Power of the Gods (Euro)\0", NULL, "Sega", "Sega Megadrive",
	L"Ast\u00e9rix and the Power of the Gods (Euro)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_asterpgRomInfo, md_asterpgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Astrix and the Power of the Gods (Euro, Prototype)
static struct BurnRomInfo md_asterpgpRomDesc[] = {
	{ "asterix and the power of the gods (euro) (beta).bin", 0x200000, 0x45c8b5b7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_asterpgp)
STD_ROM_FN(md_asterpgp)

struct BurnDriver BurnDrvmd_asterpgp = {
	"md_asterpgp", "md_asterpg", NULL, NULL, "1995",
	"Asterix and the Power of the Gods (Euro, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	L"Ast\u00e9rix and the Power of the Gods (Euro, Prototype)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_asterpgpRomInfo, md_asterpgpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Robo-Kid (USA)
static struct BurnRomInfo md_atomroboRomDesc[] = {
	{ "atomic robo-kid (usa).bin", 0x080000, 0x7cd8169e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atomrobo)
STD_ROM_FN(md_atomrobo)

struct BurnDriver BurnDrvmd_atomrobo = {
	"md_atomrobo", NULL, NULL, NULL, "1990",
	"Atomic Robo-Kid (USA)\0", NULL, "Treco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_atomroboRomInfo, md_atomroboRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Robo-Kid (Jpn)
static struct BurnRomInfo md_atomrobojRomDesc[] = {
	{ "mpr-13483.bin", 0x080000, 0xe833067e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atomroboj)
STD_ROM_FN(md_atomroboj)

struct BurnDriver BurnDrvmd_atomroboj = {
	"md_atomroboj", "md_atomrobo", NULL, NULL, "1990",
	"Atomic Robo-Kid (Jpn)\0", NULL, "Treco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_atomrobojRomInfo, md_atomrobojRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Runner (Euro)
static struct BurnRomInfo md_atomrunRomDesc[] = {
	{ "mpr-15286.bin", 0x100000, 0xb3c05418, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atomrun)
STD_ROM_FN(md_atomrun)

struct BurnDriver BurnDrvmd_atomrun = {
	"md_atomrun", NULL, NULL, NULL, "1992",
	"Atomic Runner (Euro)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_atomrunRomInfo, md_atomrunRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Runner (USA)
static struct BurnRomInfo md_atomrunuRomDesc[] = {
	{ "atomic runner (usa).bin", 0x100000, 0x0677c210, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atomrunu)
STD_ROM_FN(md_atomrunu)

struct BurnDriver BurnDrvmd_atomrunu = {
	"md_atomrunu", "md_atomrun", NULL, NULL, "1992",
	"Atomic Runner (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_atomrunuRomInfo, md_atomrunuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chelnov (Jpn)
static struct BurnRomInfo md_chelnovRomDesc[] = {
	{ "chelnov (jpn).bin", 0x100000, 0xb2fe74d8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chelnov)
STD_ROM_FN(md_chelnov)

struct BurnDriver BurnDrvmd_chelnov = {
	"md_chelnov", "md_atomrun", NULL, NULL, "1992",
	"Chelnov (Jpn)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chelnovRomInfo, md_chelnovRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour (Euro)
static struct BurnRomInfo md_atptourRomDesc[] = {
	{ "atp tour (euro).bin", 0x200000, 0x1a3da8c5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptour)
STD_ROM_FN(md_atptour)

struct BurnDriver BurnDrvmd_atptour = {
	"md_atptour", NULL, NULL, NULL, "1995",
	"ATP Tour (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourRomInfo, md_atptourRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940802)
static struct BurnRomInfo md_atptourp4RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 02, 1994).bin", 0x200000, 0x686a9fa1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp4)
STD_ROM_FN(md_atptourp4)

struct BurnDriver BurnDrvmd_atptourp4 = {
	"md_atptourp4", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940802)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp4RomInfo, md_atptourp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940805)
static struct BurnRomInfo md_atptourp3RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 05, 1994).bin", 0x200000, 0xa1fef967, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp3)
STD_ROM_FN(md_atptourp3)

struct BurnDriver BurnDrvmd_atptourp3 = {
	"md_atptourp3", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940805)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp3RomInfo, md_atptourp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940808)
static struct BurnRomInfo md_atptourp2RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 08, 1994).bin", 0x200000, 0xe6398864, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp2)
STD_ROM_FN(md_atptourp2)

struct BurnDriver BurnDrvmd_atptourp2 = {
	"md_atptourp2", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940808)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp2RomInfo, md_atptourp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940719)
static struct BurnRomInfo md_atptourp6RomDesc[] = {
	{ "atp tour championship tennis (prototype - jul 19, 1994).bin", 0x200000, 0xcb927488, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp6)
STD_ROM_FN(md_atptourp6)

struct BurnDriver BurnDrvmd_atptourp6 = {
	"md_atptourp6", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940719)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp6RomInfo, md_atptourp6RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940723)
static struct BurnRomInfo md_atptourp5RomDesc[] = {
	{ "atp tour championship tennis (prototype - jul 23, 1994).bin", 0x200000, 0xa15d5051, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp5)
STD_ROM_FN(md_atptourp5)

struct BurnDriver BurnDrvmd_atptourp5 = {
	"md_atptourp5", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940723)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp5RomInfo, md_atptourp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940509)
static struct BurnRomInfo md_atptourp7RomDesc[] = {
	{ "atp tour championship tennis (prototype - may 09, 1994).bin", 0x200000, 0xb17a8dbc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp7)
STD_ROM_FN(md_atptourp7)

struct BurnDriver BurnDrvmd_atptourp7 = {
	"md_atptourp7", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940509)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp7RomInfo, md_atptourp7RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype, 19940908)
static struct BurnRomInfo md_atptourp1RomDesc[] = {
	{ "atp tour championship tennis (prototype - sep 08, 1994).bin", 0x200000, 0xb83f4ca4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptourp1)
STD_ROM_FN(md_atptourp1)

struct BurnDriver BurnDrvmd_atptourp1 = {
	"md_atptourp1", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (Prototype, 19940908)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptourp1RomInfo, md_atptourp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (USA)
static struct BurnRomInfo md_atptouruRomDesc[] = {
	{ "atp tour championship tennis (usa).bin", 0x200000, 0x8c822884, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_atptouru)
STD_ROM_FN(md_atptouru)

struct BurnDriver BurnDrvmd_atptouru = {
	"md_atptouru", "md_atptour", NULL, NULL, "1994",
	"ATP Tour Championship Tennis (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_atptouruRomInfo, md_atptouruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Australian Rugby League (Euro)
static struct BurnRomInfo md_austrarlRomDesc[] = {
	{ "australian rugby league (euro).bin", 0x200000, 0xac5bc26a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_austrarl)
STD_ROM_FN(md_austrarl)

struct BurnDriver BurnDrvmd_austrarl = {
	"md_austrarl", NULL, NULL, NULL, "1994",
	"Australian Rugby League (Euro)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_austrarlRomInfo, md_austrarlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Awesome Possum (USA)
static struct BurnRomInfo md_awepossmRomDesc[] = {
	{ "awesome possum (usa).bin", 0x200000, 0x1f07577f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_awepossm)
STD_ROM_FN(md_awepossm)

struct BurnDriver BurnDrvmd_awepossm = {
	"md_awepossm", NULL, NULL, NULL, "1993",
	"Awesome Possum (USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_awepossmRomInfo, md_awepossmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Awesome Possum (USA, Prototype)
static struct BurnRomInfo md_awepossmpRomDesc[] = {
	{ "awesome possum (usa) (beta).bin", 0x200000, 0x0158dc53, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_awepossmp)
STD_ROM_FN(md_awepossmp)

struct BurnDriver BurnDrvmd_awepossmp = {
	"md_awepossmp", "md_awepossm", NULL, NULL, "1993",
	"Awesome Possum (USA, Prototype)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_awepossmpRomInfo, md_awepossmpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aworg (Jpn, SegaNet)
static struct BurnRomInfo md_aworgRomDesc[] = {
	{ "aworg (jpn) (sn).bin", 0x040000, 0x069c27c1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aworg)
STD_ROM_FN(md_aworg)

struct BurnDriver BurnDrvmd_aworg = {
	"md_aworg", NULL, NULL, NULL, "1991",
	"Aworg (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_aworgRomInfo, md_aworgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AWS Pro Moves Soccer (USA)
static struct BurnRomInfo md_awsproRomDesc[] = {
	{ "aws pro moves soccer (usa).bin", 0x080000, 0x707017e5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_awspro)
STD_ROM_FN(md_awspro)

struct BurnDriver BurnDrvmd_awspro = {
	"md_awspro", NULL, NULL, NULL, "1993",
	"AWS Pro Moves Soccer (USA)\0", NULL, "ASCII Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_awsproRomInfo, md_awsproRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ayrton Senna's Super Monaco GP II (Euro, Jpn)
static struct BurnRomInfo md_smgp2RomDesc[] = {
	{ "mpr-14861.bin", 0x100000, 0x60af0f76, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_smgp2)
STD_ROM_FN(md_smgp2)

struct BurnDriver BurnDrvmd_smgp2 = {
	"md_smgp2", NULL, NULL, NULL, "1992",
	"Ayrton Senna's Super Monaco GP II (Euro, Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_smgp2RomInfo, md_smgp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ayrton Senna's Super Monaco GP II (USA)
static struct BurnRomInfo md_smgp2uRomDesc[] = {
	{ "ayrton senna's super monaco gp ii (usa).bin", 0x100000, 0xeac8ded6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_smgp2u)
STD_ROM_FN(md_smgp2u)

struct BurnDriver BurnDrvmd_smgp2u = {
	"md_smgp2u", "md_smgp2", NULL, NULL, "1992",
	"Ayrton Senna's Super Monaco GP II (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_smgp2uRomInfo, md_smgp2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// B.O.B. (Euro, USA)
static struct BurnRomInfo md_bobRomDesc[] = {
	{ "b.o.b. (euro, usa).bin", 0x100000, 0xeaa2acb7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bob)
STD_ROM_FN(md_bob)

struct BurnDriver BurnDrvmd_bob = {
	"md_bob", NULL, NULL, NULL, "1993",
	"B.O.B. (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bobRomInfo, md_bobRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// B.O.B. (USA, Prototype)
static struct BurnRomInfo md_bobpRomDesc[] = {
	{ "b.o.b. (usa) (beta).bin", 0x100000, 0xe3e8421e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bobp)
STD_ROM_FN(md_bobp)

struct BurnDriver BurnDrvmd_bobp = {
	"md_bobp", "md_bob", NULL, NULL, "1993",
	"B.O.B. (USA, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bobpRomInfo, md_bobpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Space Funky B.O.B. (Jpn)
static struct BurnRomInfo md_spacefbRomDesc[] = {
	{ "space funky b.o.b. (jpn).bin", 0x100000, 0xe9310d3b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_spacefb)
STD_ROM_FN(md_spacefb)

struct BurnDriver BurnDrvmd_spacefb = {
	"md_spacefb", "md_bob", NULL, NULL, "1993",
	"Space Funky B.O.B. (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_spacefbRomInfo, md_spacefbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype, 19940811)
static struct BurnRomInfo md_babyboomRomDesc[] = {
	{ "baby boom (prototype - aug 11, 1994).bin", 0x200000, 0xbd697054, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_babyboom)
STD_ROM_FN(md_babyboom)

struct BurnDriver BurnDrvmd_babyboom = {
	"md_babyboom", NULL, NULL, NULL, "199?",
	"Baby Boom (Prototype, 19940811)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_babyboomRomInfo, md_babyboomRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype, 19940603)
static struct BurnRomInfo md_babyboom1RomDesc[] = {
	{ "baby boom (prototype - jun 03, 1994).bin", 0x200000, 0xc0d97f6f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_babyboom1)
STD_ROM_FN(md_babyboom1)

struct BurnDriver BurnDrvmd_babyboom1 = {
	"md_babyboom1", "md_babyboom", NULL, NULL, "199?",
	"Baby Boom (Prototype, 19940603)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_babyboom1RomInfo, md_babyboom1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype, 19940606)
static struct BurnRomInfo md_babyboom2RomDesc[] = {
	{ "baby boom (prototype - jun 06, 1994).bin", 0x200000, 0x6e0cf48d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_babyboom2)
STD_ROM_FN(md_babyboom2)

struct BurnDriver BurnDrvmd_babyboom2 = {
	"md_babyboom2", "md_babyboom", NULL, NULL, "199?",
	"Baby Boom (Prototype, 19940606)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_babyboom2RomInfo, md_babyboom2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby's Day Out (USA, Prototype)
static struct BurnRomInfo md_babydRomDesc[] = {
	{ "baby's day out (usa) (prototype).bin", 0x100000, 0xb2e7cc49, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_babyd)
STD_ROM_FN(md_babyd)

struct BurnDriver BurnDrvmd_babyd = {
	"md_babyd", NULL, NULL, NULL, "199?",
	"Baby's Day Out (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_babydRomInfo, md_babydRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby's Day Out (USA, Prototype, Earlier)
static struct BurnRomInfo md_babydoRomDesc[] = {
	{ "baby's day out (usa) (prototype) (earlier).bin", 0x100000, 0x459b891c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_babydo)
STD_ROM_FN(md_babydo)

struct BurnDriver BurnDrvmd_babydo = {
	"md_babydo", "md_babyd", NULL, NULL, "199?",
	"Baby's Day Out (USA, Prototype, Earlier)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_babydoRomInfo, md_babydoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Back to the Future Part III (Euro)
static struct BurnRomInfo md_backtof3RomDesc[] = {
	{ "mpr-14328.bin", 0x080000, 0x2737f92e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_backtof3)
STD_ROM_FN(md_backtof3)

struct BurnDriver BurnDrvmd_backtof3 = {
	"md_backtof3", NULL, NULL, NULL, "1991",
	"Back to the Future Part III (Euro)\0", NULL, "Imageworks", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_backtof3RomInfo, md_backtof3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Back to the Future Part III (USA)
static struct BurnRomInfo md_backtof3uRomDesc[] = {
	{ "back to the future part iii (usa).bin", 0x080000, 0x66a388c3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_backtof3u)
STD_ROM_FN(md_backtof3u)

struct BurnDriver BurnDrvmd_backtof3u = {
	"md_backtof3u", "md_backtof3", NULL, NULL, "1991",
	"Back to the Future Part III (USA)\0", NULL, "Arena Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_backtof3uRomInfo, md_backtof3uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bahamut Senki (Jpn)
static struct BurnRomInfo md_bahamutsRomDesc[] = {
	{ "mpr-13677.bin", 0x080000, 0xb1e268da, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bahamuts)
STD_ROM_FN(md_bahamuts)

struct BurnDriver BurnDrvmd_bahamuts = {
	"md_bahamuts", NULL, NULL, NULL, "1991",
	"Bahamut Senki (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_bahamutsRomInfo, md_bahamutsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ball Jacks (Euro, Jpn)
static struct BurnRomInfo md_balljackRomDesc[] = {
	{ "ball jacks (euro, jpn).bin", 0x040000, 0xf5c3c54f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_balljack)
STD_ROM_FN(md_balljack)

struct BurnDriver BurnDrvmd_balljack = {
	"md_balljack", NULL, NULL, NULL, "1993",
	"Ball Jacks (Euro, Jpn)\0", NULL, "Namco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_balljackRomInfo, md_balljackRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ballz 3D (Euro, USA)
static struct BurnRomInfo md_ballz3dRomDesc[] = {
	{ "ballz 3d - fighting at its ballziest (euro, usa).bin", 0x200000, 0xb362b705, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ballz3d)
STD_ROM_FN(md_ballz3d)

struct BurnDriver BurnDrvmd_ballz3d = {
	"md_ballz3d", NULL, NULL, NULL, "1994",
	"Ballz 3D (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ballz3dRomInfo, md_ballz3dRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barbie Super Model (USA)
static struct BurnRomInfo md_barbiesmRomDesc[] = {
	{ "barbie super model (usa).bin", 0x100000, 0x81c9662b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barbiesm)
STD_ROM_FN(md_barbiesm)

struct BurnDriver BurnDrvmd_barbiesm = {
	"md_barbiesm", NULL, NULL, NULL, "1992",
	"Barbie Super Model (USA)\0", NULL, "Hi Tech Expressions", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barbiesmRomInfo, md_barbiesmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barbie Vacation Adventure (USA, Prototype)
static struct BurnRomInfo md_barbvacRomDesc[] = {
	{ "barbie vacation adventure (usa) (prototype).bin", 0x100000, 0x10e0ba69, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barbvac)
STD_ROM_FN(md_barbvac)

struct BurnDriver BurnDrvmd_barbvac = {
	"md_barbvac", NULL, NULL, NULL, "1994",
	"Barbie Vacation Adventure (USA, Prototype)\0", NULL, "Hi Tech Expressions", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barbvacRomInfo, md_barbvacRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! (Euro, USA)
static struct BurnRomInfo md_barkleyRomDesc[] = {
	{ "barkley shut up and jam! (euro, usa).bin", 0x100000, 0x63fbf497, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barkley)
STD_ROM_FN(md_barkley)

struct BurnDriver BurnDrvmd_barkley = {
	"md_barkley", NULL, NULL, NULL, "1993",
	"Barkley Shut Up and Jam! (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barkleyRomInfo, md_barkleyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! 2 (USA)
static struct BurnRomInfo md_barkley2RomDesc[] = {
	{ "barkley shut up and jam! 2 (usa).bin", 0x200000, 0x321bb6bd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barkley2)
STD_ROM_FN(md_barkley2)

struct BurnDriver BurnDrvmd_barkley2 = {
	"md_barkley2", NULL, NULL, NULL, "1995",
	"Barkley Shut Up and Jam! 2 (USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_barkley2RomInfo, md_barkley2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! 2 (USA, Prototype)
static struct BurnRomInfo md_barkley2pRomDesc[] = {
	{ "barkley shut up and jam! 2 (usa) (beta).bin", 0x200000, 0xde27357b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barkley2p)
STD_ROM_FN(md_barkley2p)

struct BurnDriver BurnDrvmd_barkley2p = {
	"md_barkley2p", "md_barkley2", NULL, NULL, "1995",
	"Barkley Shut Up and Jam! 2 (USA, Prototype)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barkley2pRomInfo, md_barkley2pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barney's Hide & Seek Game (USA)
static struct BurnRomInfo md_barneyRomDesc[] = {
	{ "barney's hide & seek game (usa).bin", 0x100000, 0x1efa9d53, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barney)
STD_ROM_FN(md_barney)

struct BurnDriver BurnDrvmd_barney = {
	"md_barney", NULL, NULL, NULL, "1993",
	"Barney's Hide & Seek Game (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barneyRomInfo, md_barneyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barver Battle Saga - Tai Kong Zhan Shi (Chi)
static struct BurnRomInfo md_barverRomDesc[] = {
	{ "barver battle saga - tai kong zhan shi (chi) (unl).bin", 0x200000, 0xd37a37c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_barver)
STD_ROM_FN(md_barver)

struct BurnDriver BurnDrvmd_barver = {
	"md_barver", NULL, NULL, NULL, "199?",
	"Barver Battle Saga - Tai Kong Zhan Shi (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_barverRomInfo, md_barverRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bass Masters Classic (USA)
static struct BurnRomInfo md_bassmaRomDesc[] = {
	{ "bass masters classic (usa).bin", 0x200000, 0xcf1ff00a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bassma)
STD_ROM_FN(md_bassma)

struct BurnDriver BurnDrvmd_bassma = {
	"md_bassma", NULL, NULL, NULL, "1995",
	"Bass Masters Classic (USA)\0", NULL, "Black Pearl", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bassmaRomInfo, md_bassmaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bass Masters Classic - Pro Edition (USA)
static struct BurnRomInfo md_bassmpRomDesc[] = {
	{ "bass masters classic - pro edition (usa).bin", 0x200000, 0x9eddeb3d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bassmp)
STD_ROM_FN(md_bassmp)

struct BurnDriver BurnDrvmd_bassmp = {
	"md_bassmp", NULL, NULL, NULL, "1996",
	"Bass Masters Classic - Pro Edition (USA)\0", NULL, "THQ", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bassmpRomInfo, md_bassmpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (Jpn)
static struct BurnRomInfo md_batmanjRomDesc[] = {
	{ "batman (jpn).bin", 0x080000, 0xd7b4febf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batmanj)
STD_ROM_FN(md_batmanj)

struct BurnDriver BurnDrvmd_batmanj = {
	"md_batmanj", "md_batman", NULL, NULL, "1990",
	"Batman (Jpn)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanjRomInfo, md_batmanjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (USA)
static struct BurnRomInfo md_batmanuRomDesc[] = {
	{ "batman (usa).bin", 0x080000, 0x017410ae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batmanu)
STD_ROM_FN(md_batmanu)

struct BurnDriver BurnDrvmd_batmanu = {
	"md_batmanu", "md_batman", NULL, NULL, "1990",
	"Batman (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanuRomInfo, md_batmanuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman - Revenge of the Joker (USA)
static struct BurnRomInfo md_batmanrjRomDesc[] = {
	{ "batman - revenge of the joker (usa).bin", 0x100000, 0xcaa044a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batmanrj)
STD_ROM_FN(md_batmanrj)

struct BurnDriver BurnDrvmd_batmanrj = {
	"md_batmanrj", NULL, NULL, NULL, "1992",
	"Batman - Revenge of the Joker (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanrjRomInfo, md_batmanrjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman Forever (World)
static struct BurnRomInfo md_batmanfrRomDesc[] = {
	{ "batman forever (world).bin", 0x300000, 0x8b723d01, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batmanfr)
STD_ROM_FN(md_batmanfr)

struct BurnDriver BurnDrvmd_batmanfr = {
	"md_batmanfr", NULL, NULL, NULL, "1995",
	"Batman Forever (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanfrRomInfo, md_batmanfrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman Returns (World)
static struct BurnRomInfo md_batmanrtRomDesc[] = {
	{ "mpr-14998.bin", 0x100000, 0x4a3225c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_batmanrt)
STD_ROM_FN(md_batmanrt)

struct BurnDriver BurnDrvmd_batmanrt = {
	"md_batmanrt", NULL, NULL, NULL, "1992",
	"Batman Returns (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_batmanrtRomInfo, md_batmanrtRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Golfer Yui (Jpn)
static struct BurnRomInfo md_battlyuiRomDesc[] = {
	{ "battle golfer yui (jpn).bin", 0x080000, 0x4aa03e4e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_battlyui)
STD_ROM_FN(md_battlyui)

struct BurnDriver BurnDrvmd_battlyui = {
	"md_battlyui", NULL, NULL, NULL, "1991",
	"Battle Golfer Yui (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_battlyuiRomInfo, md_battlyuiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Mania Daiginjou (Jpn, Kor)
static struct BurnRomInfo md_btlmanidRomDesc[] = {
	{ "battle mania daiginjou (jpn, kor).bin", 0x100000, 0x312fa0f2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_btlmanid)
STD_ROM_FN(md_btlmanid)

struct BurnDriver BurnDrvmd_btlmanid = {
	"md_btlmanid", NULL, NULL, NULL, "1993",
	"Battle Mania Daiginjou (Jpn, Kor)\0", NULL, "Vic Tokai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_btlmanidRomInfo, md_btlmanidRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Squadron (Euro, USA)
static struct BurnRomInfo md_battlesqRomDesc[] = {
	{ "battle squadron (euro, usa).bin", 0x080000, 0x0feaa8bf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_battlesq)
STD_ROM_FN(md_battlesq)

struct BurnDriver BurnDrvmd_battlesq = {
	"md_battlesq", NULL, NULL, NULL, "1990",
	"Battle Squadron (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_battlesqRomInfo, md_battlesqRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battlemaster (USA)
static struct BurnRomInfo md_battlemsRomDesc[] = {
	{ "battlemaster (usa).bin", 0x080000, 0xfd2b35e3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_battlems)
STD_ROM_FN(md_battlems)

struct BurnDriver BurnDrvmd_battlems = {
	"md_battlems", NULL, NULL, NULL, "1991",
	"Battlemaster (USA)\0", NULL, "Arena Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_battlemsRomInfo, md_battlemsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// BattleTech (USA)
static struct BurnRomInfo md_battletcRomDesc[] = {
	{ "battletech - a game of armored combat (usa).bin", 0x200000, 0x409e5d14, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_battletc)
STD_ROM_FN(md_battletc)

struct BurnDriver BurnDrvmd_battletc = {
	"md_battletc", NULL, NULL, NULL, "1994",
	"BattleTech (USA)\0", NULL, "Extreme Entertainment Group", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_battletcRomInfo, md_battletcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battletoads & Double Dragon - The Ultimate Team (USA)
static struct BurnRomInfo md_btoadsddRomDesc[] = {
	{ "battletoads & double dragon (usa).bin", 0x100000, 0x8239dd17, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_btoadsdd)
STD_ROM_FN(md_btoadsdd)

struct BurnDriver BurnDrvmd_btoadsdd = {
	"md_btoadsdd", NULL, NULL, NULL, "1993",
	"Battletoads & Double Dragon - The Ultimate Team (USA)\0", NULL, "Tradewest", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_btoadsddRomInfo, md_btoadsddRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battletoads (World)
static struct BurnRomInfo md_btoadsRomDesc[] = {
	{ "battletoads (world).bin", 0x080000, 0xd10e103a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_btoads)
STD_ROM_FN(md_btoads)

struct BurnDriver BurnDrvmd_btoads = {
	"md_btoads", NULL, NULL, NULL, "1991",
	"Battletoads (World)\0", NULL, "Tradewest", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_btoadsRomInfo, md_btoadsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beastball (Prototype)
static struct BurnRomInfo md_beastbalRomDesc[] = {
	{ "beast ball.bin", 0x0fb8e0, 0x6a176576, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beastbal)
STD_ROM_FN(md_beastbal)

struct BurnDriver BurnDrvmd_beastbal = {
	"md_beastbal", NULL, NULL, NULL, "199?",
	"Beastball (Prototype)\0", NULL, "Spectrum Holobyte", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beastbalRomInfo, md_beastbalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beast Wrestler (USA)
static struct BurnRomInfo md_beastwRomDesc[] = {
	{ "beast wrestler (usa).bin", 0x100000, 0x0ca5bb64, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beastw)
STD_ROM_FN(md_beastw)

struct BurnDriver BurnDrvmd_beastw = {
	"md_beastw", NULL, NULL, NULL, "1991",
	"Beast Wrestler (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beastwRomInfo, md_beastwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beast Warriors (Jpn)
static struct BurnRomInfo md_beastwjRomDesc[] = {
	{ "beast warriors (jpn).bin", 0x100000, 0x4646c694, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beastwj)
STD_ROM_FN(md_beastwj)

struct BurnDriver BurnDrvmd_beastwj = {
	"md_beastwj", "md_beastw", NULL, NULL, "1991",
	"Beast Warriors (Jpn)\0", NULL, "Riot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beastwjRomInfo, md_beastwjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Beauty and the Beast - Belle's Quest (USA)
static struct BurnRomInfo md_beautyRomDesc[] = {
	{ "beauty and the beast - belle's quest (usa).bin", 0x100000, 0xbefb6fae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beauty)
STD_ROM_FN(md_beauty)

struct BurnDriver BurnDrvmd_beauty = {
	"md_beauty", NULL, NULL, NULL, "1993",
	"Disney's Beauty and the Beast - Belle's Quest (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beautyRomInfo, md_beautyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's Beauty and the Beast - Roar of the Beast (USA)
static struct BurnRomInfo md_beautyrbRomDesc[] = {
	{ "beauty and the beast - roar of the beast (usa).bin", 0x100000, 0x13e7b519, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beautyrb)
STD_ROM_FN(md_beautyrb)

struct BurnDriver BurnDrvmd_beautyrb = {
	"md_beautyrb", NULL, NULL, NULL, "1993",
	"Disney's Beauty and the Beast - Roar of the Beast (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beautyrbRomInfo, md_beautyrbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (Euro)
static struct BurnRomInfo md_beavisRomDesc[] = {
	{ "beavis and butt-head (euro).bin", 0x200000, 0xc7b6435e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beavis)
STD_ROM_FN(md_beavis)

struct BurnDriver BurnDrvmd_beavis = {
	"md_beavis", NULL, NULL, NULL, "1994",
	"Beavis and Butt-Head (Euro)\0", NULL, "Viacom New Media", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beavisRomInfo, md_beavisRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (USA)
static struct BurnRomInfo md_beavisuRomDesc[] = {
	{ "beavis and butt-head (usa).bin", 0x200000, 0xf5d7b948, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beavisu)
STD_ROM_FN(md_beavisu)

struct BurnDriver BurnDrvmd_beavisu = {
	"md_beavisu", "md_beavis", NULL, NULL, "1994",
	"Beavis and Butt-Head (USA)\0", NULL, "Viacom New Media", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beavisuRomInfo, md_beavisuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (USA, Prototype)
static struct BurnRomInfo md_beavisupRomDesc[] = {
	{ "beavis and butt-head (usa) (beta).bin", 0x200000, 0x81ed5335, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beavisup)
STD_ROM_FN(md_beavisup)

struct BurnDriver BurnDrvmd_beavisup = {
	"md_beavisup", "md_beavis", NULL, NULL, "1994",
	"Beavis and Butt-Head (USA, Prototype)\0", NULL, "Viacom New Media", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beavisupRomInfo, md_beavisupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (USA)
static struct BurnRomInfo md_berensRomDesc[] = {
	{ "berenstain bears' camping adventure, the (usa).bin", 0x100000, 0x1f86237b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berens)
STD_ROM_FN(md_berens)

struct BurnDriver BurnDrvmd_berens = {
	"md_berens", NULL, NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensRomInfo, md_berensRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940428)
static struct BurnRomInfo md_berensp19RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - apr 28, 1994).bin", 0x100000, 0xf222e946, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp19)
STD_ROM_FN(md_berensp19)

struct BurnDriver BurnDrvmd_berensp19 = {
	"md_berensp19", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940428)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp19RomInfo, md_berensp19RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940429)
static struct BurnRomInfo md_berensp18RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - apr 29, 1994).bin", 0x100000, 0xe21493b4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp18)
STD_ROM_FN(md_berensp18)

struct BurnDriver BurnDrvmd_berensp18 = {
	"md_berensp18", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940429)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp18RomInfo, md_berensp18RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940801)
static struct BurnRomInfo md_berensp05RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 01, 1994).bin", 0x100000, 0xb7cd465c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp05)
STD_ROM_FN(md_berensp05)

struct BurnDriver BurnDrvmd_berensp05 = {
	"md_berensp05", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940801)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp05RomInfo, md_berensp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940802)
static struct BurnRomInfo md_berensp04RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 02, 1994).bin", 0x100000, 0x383ad564, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp04)
STD_ROM_FN(md_berensp04)

struct BurnDriver BurnDrvmd_berensp04 = {
	"md_berensp04", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940802)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp04RomInfo, md_berensp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940803)
static struct BurnRomInfo md_berensp03RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 03, 1994).bin", 0x100000, 0x18f268a6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp03)
STD_ROM_FN(md_berensp03)

struct BurnDriver BurnDrvmd_berensp03 = {
	"md_berensp03", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940803)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp03RomInfo, md_berensp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940805)
static struct BurnRomInfo md_berensp02RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 05, 1994).bin", 0x100000, 0x24159b6f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp02)
STD_ROM_FN(md_berensp02)

struct BurnDriver BurnDrvmd_berensp02 = {
	"md_berensp02", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940805)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp02RomInfo, md_berensp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940808)
static struct BurnRomInfo md_berensp01RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 08, 1994).bin", 0x100000, 0x58b6b0fc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp01)
STD_ROM_FN(md_berensp01)

struct BurnDriver BurnDrvmd_berensp01 = {
	"md_berensp01", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940808)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp01RomInfo, md_berensp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940709)
static struct BurnRomInfo md_berensp08RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 09, 1994).bin", 0x100000, 0xbf6aa405, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp08)
STD_ROM_FN(md_berensp08)

struct BurnDriver BurnDrvmd_berensp08 = {
	"md_berensp08", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940709)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp08RomInfo, md_berensp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940716)
static struct BurnRomInfo md_berensp07RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 16, 1994).bin", 0x100000, 0xc84aad8e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp07)
STD_ROM_FN(md_berensp07)

struct BurnDriver BurnDrvmd_berensp07 = {
	"md_berensp07", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940716)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp07RomInfo, md_berensp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940720)
static struct BurnRomInfo md_berensp06RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 20, 1994).bin", 0x100000, 0xabee4c5e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp06)
STD_ROM_FN(md_berensp06)

struct BurnDriver BurnDrvmd_berensp06 = {
	"md_berensp06", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940720)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp06RomInfo, md_berensp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940602)
static struct BurnRomInfo md_berensp10RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jun 02, 1994).bin", 0x100000, 0x83cf19e4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp10)
STD_ROM_FN(md_berensp10)

struct BurnDriver BurnDrvmd_berensp10 = {
	"md_berensp10", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940602)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp10RomInfo, md_berensp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940610)
static struct BurnRomInfo md_berensp09RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jun 10, 1994).bin", 0x100000, 0xa748e2cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp09)
STD_ROM_FN(md_berensp09)

struct BurnDriver BurnDrvmd_berensp09 = {
	"md_berensp09", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940610)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp09RomInfo, md_berensp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940323)
static struct BurnRomInfo md_berensp20RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - mar 23, 1994).bin", 0x100000, 0xbfbcd7cc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp20)
STD_ROM_FN(md_berensp20)

struct BurnDriver BurnDrvmd_berensp20 = {
	"md_berensp20", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940323)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp20RomInfo, md_berensp20RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940506)
static struct BurnRomInfo md_berensp17RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 06, 1994).bin", 0x100000, 0x713c14d8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp17)
STD_ROM_FN(md_berensp17)

struct BurnDriver BurnDrvmd_berensp17 = {
	"md_berensp17", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940506)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp17RomInfo, md_berensp17RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940511)
static struct BurnRomInfo md_berensp16RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 11, 1994).bin", 0x100000, 0xf7b81c6a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp16)
STD_ROM_FN(md_berensp16)

struct BurnDriver BurnDrvmd_berensp16 = {
	"md_berensp16", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940511)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp16RomInfo, md_berensp16RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940517)
static struct BurnRomInfo md_berensp15RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 17, 1994).bin", 0x100000, 0xe1855ade, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp15)
STD_ROM_FN(md_berensp15)

struct BurnDriver BurnDrvmd_berensp15 = {
	"md_berensp15", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940517)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp15RomInfo, md_berensp15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940519)
static struct BurnRomInfo md_berensp14RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 19, 1994).bin", 0x100000, 0x07c9f71f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp14)
STD_ROM_FN(md_berensp14)

struct BurnDriver BurnDrvmd_berensp14 = {
	"md_berensp14", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940519)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp14RomInfo, md_berensp14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940523)
static struct BurnRomInfo md_berensp13RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 23, 1994).bin", 0x100000, 0x913887b7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp13)
STD_ROM_FN(md_berensp13)

struct BurnDriver BurnDrvmd_berensp13 = {
	"md_berensp13", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940523)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp13RomInfo, md_berensp13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940526)
static struct BurnRomInfo md_berensp12RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 26, 1994).bin", 0x100000, 0xd33c0fa4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp12)
STD_ROM_FN(md_berensp12)

struct BurnDriver BurnDrvmd_berensp12 = {
	"md_berensp12", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940526)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp12RomInfo, md_berensp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Berenstain Bears' Camping Adventure (Prototype, 19940530)
static struct BurnRomInfo md_berensp11RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 30, 1994).bin", 0x100000, 0x9c3bf429, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_berensp11)
STD_ROM_FN(md_berensp11)

struct BurnDriver BurnDrvmd_berensp11 = {
	"md_berensp11", "md_berens", NULL, NULL, "1994",
	"The Berenstain Bears' Camping Adventure (Prototype, 19940530)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_berensp11RomInfo, md_berensp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Best of the Best - Championship Karate (USA)
static struct BurnRomInfo md_bestofRomDesc[] = {
	{ "best of the best - championship karate (usa).bin", 0x100000, 0xc3d6a5d4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bestof)
STD_ROM_FN(md_bestof)

struct BurnDriver BurnDrvmd_bestof = {
	"md_bestof", NULL, NULL, NULL, "1993",
	"Best of the Best - Championship Karate (USA)\0", NULL, "Electro Brain", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bestofRomInfo, md_bestofRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Best of the Best - Championship Karate (Euro, Prototype)
static struct BurnRomInfo md_bestofpRomDesc[] = {
	{ "best of the best - championship karate (euro) (beta).bin", 0x100000, 0xf842240b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bestofp)
STD_ROM_FN(md_bestofp)

struct BurnDriver BurnDrvmd_bestofp = {
	"md_bestofp", "md_bestof", NULL, NULL, "1993",
	"Best of the Best - Championship Karate (Euro, Prototype)\0", NULL, "Electro Brain", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bestofpRomInfo, md_bestofpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Kick Boxing (Jpn, Kor)
static struct BurnRomInfo md_kickboxRomDesc[] = {
	{ "mpr-15333.bin", 0x100000, 0x9bdc230c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kickbox)
STD_ROM_FN(md_kickbox)

struct BurnDriver BurnDrvmd_kickbox = {
	"md_kickbox", "md_bestof", NULL, NULL, "1993",
	"The Kick Boxing (Jpn, Kor)\0", NULL, "Micro World", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kickboxRomInfo, md_kickboxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beyond Zero Tolerance (USA, Prototype)
static struct BurnRomInfo md_beyondztRomDesc[] = {
	{ "beyond zero tolerance (usa) (prototype).bin", 0x200000, 0xc61ed2ed, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_beyondzt)
STD_ROM_FN(md_beyondzt)

struct BurnDriver BurnDrvmd_beyondzt = {
	"md_beyondzt", NULL, NULL, NULL, "1995",
	"Beyond Zero Tolerance (USA, Prototype)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_beyondztRomInfo, md_beyondztRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bible Adventures (USA)
static struct BurnRomInfo md_bibleadvRomDesc[] = {
	{ "bible adventures (usa) (unl).bin", 0x080000, 0x64446b77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bibleadv)
STD_ROM_FN(md_bibleadv)

struct BurnDriver BurnDrvmd_bibleadv = {
	"md_bibleadv", NULL, NULL, NULL, "1995",
	"Bible Adventures (USA)\0", NULL, "Wisdom Tree", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bibleadvRomInfo, md_bibleadvRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bill Walsh College Football (Euro, USA)
static struct BurnRomInfo md_billwlshRomDesc[] = {
	{ "bwcf01.bin", 0x100000, 0x3ed83362, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_billwlsh)
STD_ROM_FN(md_billwlsh)

struct BurnDriver BurnDrvmd_billwlsh = {
	"md_billwlsh", NULL, NULL, NULL, "1993",
	"Bill Walsh College Football (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_billwlshRomInfo, md_billwlshRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bill Walsh College Football 95 (USA)
static struct BurnRomInfo md_billwl95RomDesc[] = {
	{ "bill walsh college football 95 (usa).bin", 0x200000, 0xa582f45a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_billwl95)
STD_ROM_FN(md_billwl95)

struct BurnDriver BurnDrvmd_billwl95 = {
	"md_billwl95", NULL, NULL, NULL, "1994",
	"Bill Walsh College Football 95 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_billwl95RomInfo, md_billwl95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bimini Run (USA)
static struct BurnRomInfo md_biminiRomDesc[] = {
	{ "bimini run (usa).bin", 0x080000, 0xd4dc5188, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bimini)
STD_ROM_FN(md_bimini)

struct BurnDriver BurnDrvmd_bimini = {
	"md_bimini", NULL, NULL, NULL, "1990",
	"Bimini Run (USA)\0", NULL, "Nuvision Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_biminiRomInfo, md_biminiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bio Hazard Battle (Euro, USA)
static struct BurnRomInfo md_biohazrbRomDesc[] = {
	{ "mpr-15204.bin", 0x100000, 0x95b0ea2b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_biohazrb)
STD_ROM_FN(md_biohazrb)

struct BurnDriver BurnDrvmd_biohazrb = {
	"md_biohazrb", NULL, NULL, NULL, "1992",
	"Bio Hazard Battle (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_biohazrbRomInfo, md_biohazrbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bio Hazard Battle (USA, Prototype)
static struct BurnRomInfo md_biohazrbpRomDesc[] = {
	{ "bio hazard battle (usa) (beta).bin", 0x100000, 0xdd10dd1a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_biohazrbp)
STD_ROM_FN(md_biohazrbp)

struct BurnDriver BurnDrvmd_biohazrbp = {
	"md_biohazrbp", "md_biohazrb", NULL, NULL, "1992",
	"Bio Hazard Battle (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_biohazrbpRomInfo, md_biohazrbpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crying - Aseimei Sensou (Jpn)
static struct BurnRomInfo md_cryingRomDesc[] = {
	{ "crying - aseimei sensou (jpn).bin", 0x100000, 0x4aba1d6a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crying)
STD_ROM_FN(md_crying)

struct BurnDriver BurnDrvmd_crying = {
	"md_crying", "md_biohazrb", NULL, NULL, "1992",
	"Crying - Aseimei Sensou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cryingRomInfo, md_cryingRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blades of Vengeance (Euro, USA)
static struct BurnRomInfo md_bladevenRomDesc[] = {
	{ "blades of vengeance (euro, usa).bin", 0x100000, 0x74c65a49, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bladeven)
STD_ROM_FN(md_bladeven)

struct BurnDriver BurnDrvmd_bladeven = {
	"md_bladeven", NULL, NULL, NULL, "1993",
	"Blades of Vengeance (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bladevenRomInfo, md_bladevenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blaster Master 2 (USA)
static struct BurnRomInfo md_blastRomDesc[] = {
	{ "blaster master 2 (usa).bin", 0x100000, 0xc11e4ba1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_blast)
STD_ROM_FN(md_blast)

struct BurnDriver BurnDrvmd_blast = {
	"md_blast", NULL, NULL, NULL, "1993",
	"Blaster Master 2 (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_blastRomInfo, md_blastRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blaster Master 2 (USA, Prototype)
static struct BurnRomInfo md_blastpRomDesc[] = {
	{ "blaster master 2 (usa) (beta).bin", 0x100000, 0x08f78c70, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_blastp)
STD_ROM_FN(md_blastp)

struct BurnDriver BurnDrvmd_blastp = {
	"md_blastp", "md_blast", NULL, NULL, "1993",
	"Blaster Master 2 (USA, Prototype)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_blastpRomInfo, md_blastpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blockbuster World Video Game Championship II (USA)
static struct BurnRomInfo md_blockbRomDesc[] = {
	{ "blockbuster world video game championship ii (usa).bin", 0x400000, 0x4385e366, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_blockb)
STD_ROM_FN(md_blockb)

struct BurnDriver BurnDrvmd_blockb = {
	"md_blockb", NULL, NULL, NULL, "1995",
	"Blockbuster World Video Game Championship II (USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_blockbRomInfo, md_blockbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blockout (World)
static struct BurnRomInfo md_blockoRomDesc[] = {
	{ "bloc-u1_blo03+bloc-u2_blo03.bin,mpr-14247.bin", 0x020000, 0x5e2966f1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_blocko)
STD_ROM_FN(md_blocko)

struct BurnDriver BurnDrvmd_blocko = {
	"md_blocko", NULL, NULL, NULL, "1991",
	"Blockout (World)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_blockoRomInfo, md_blockoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bloodshot ~ Battle Frenzy (Euro)
static struct BurnRomInfo md_bloodshtRomDesc[] = {
	{ "es210.bin", 0x200000, 0xf9f2bceb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bloodsht)
STD_ROM_FN(md_bloodsht)

struct BurnDriver BurnDrvmd_bloodsht = {
	"md_bloodsht", NULL, NULL, NULL, "1994",
	"Bloodshot ~ Battle Frenzy (Euro)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bloodshtRomInfo, md_bloodshtRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blue Almanac (Jpn)
static struct BurnRomInfo md_bluealmaRomDesc[] = {
	{ "blue almanac (jpn).bin", 0x100000, 0x7222ebb3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bluealma)
STD_ROM_FN(md_bluealma)

struct BurnDriver BurnDrvmd_bluealma = {
	"md_bluealma", NULL, NULL, NULL, "1991",
	"Blue Almanac (Jpn)\0", NULL, "Kodansha", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_bluealmaRomInfo, md_bluealmaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Euro)
static struct BurnRomInfo md_bodycoRomDesc[] = {
	{ "body count (euro).bin", 0x100000, 0x3575a030, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodyco)
STD_ROM_FN(md_bodyco)

struct BurnDriver BurnDrvmd_bodyco = {
	"md_bodyco", NULL, NULL, NULL, "1994",
	"Body Count (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycoRomInfo, md_bodycoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Euro, Prototype)
static struct BurnRomInfo md_bodycopRomDesc[] = {
	{ "body count (euro) (beta).bin", 0x100000, 0xb4ffb6ce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop)
STD_ROM_FN(md_bodycop)

struct BurnDriver BurnDrvmd_bodycop = {
	"md_bodycop", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Euro, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycopRomInfo, md_bodycopRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype, 19940208)
static struct BurnRomInfo md_bodycop4RomDesc[] = {
	{ "body count (prototype - feb 08, 1994).bin", 0x0ff900, 0xc5fed897, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop4)
STD_ROM_FN(md_bodycop4)

struct BurnDriver BurnDrvmd_bodycop4 = {
	"md_bodycop4", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Prototype, 19940208)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycop4RomInfo, md_bodycop4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype, 19940127)
static struct BurnRomInfo md_bodycop5RomDesc[] = {
	{ "body count (prototype - jan 27, 1994).bin", 0x100000, 0x66ca4e71, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop5)
STD_ROM_FN(md_bodycop5)

struct BurnDriver BurnDrvmd_bodycop5 = {
	"md_bodycop5", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Prototype, 19940127)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycop5RomInfo, md_bodycop5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype, 19940303)
static struct BurnRomInfo md_bodycop3RomDesc[] = {
	{ "body count (prototype - mar 03, 1994).bin", 0x100000, 0x6abc6e77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop3)
STD_ROM_FN(md_bodycop3)

struct BurnDriver BurnDrvmd_bodycop3 = {
	"md_bodycop3", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Prototype, 19940303)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycop3RomInfo, md_bodycop3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype, 19940308)
static struct BurnRomInfo md_bodycop2RomDesc[] = {
	{ "body count (prototype - mar 08, 1994).bin", 0x100000, 0x8965213f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop2)
STD_ROM_FN(md_bodycop2)

struct BurnDriver BurnDrvmd_bodycop2 = {
	"md_bodycop2", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Prototype, 19940308)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycop2RomInfo, md_bodycop2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype, 19940309)
static struct BurnRomInfo md_bodycop1RomDesc[] = {
	{ "body count (prototype - mar 09, 1994).bin", 0x100000, 0x649607d1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bodycop1)
STD_ROM_FN(md_bodycop1)

struct BurnDriver BurnDrvmd_bodycop1 = {
	"md_bodycop1", "md_bodyco", NULL, NULL, "1994",
	"Body Count (Prototype, 19940309)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bodycop1RomInfo, md_bodycop1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (Euro, Jpn, Rev. A)
static struct BurnRomInfo md_bnzabrosRomDesc[] = {
	{ "mpr-13905a.bin", 0x080000, 0xc6aac589, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bnzabros)
STD_ROM_FN(md_bnzabros)

struct BurnDriver BurnDrvmd_bnzabros = {
	"md_bnzabros", NULL, NULL, NULL, "1991",
	"Bonanza Bros. (Euro, Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bnzabrosRomInfo, md_bnzabrosRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (Euro, Jpn)
static struct BurnRomInfo md_bnzabros1RomDesc[] = {
	{ "bonanza bros. (euro, jpn).bin", 0x080000, 0xadf6476c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bnzabros1)
STD_ROM_FN(md_bnzabros1)

struct BurnDriver BurnDrvmd_bnzabros1 = {
	"md_bnzabros1", "md_bnzabros", NULL, NULL, "1991",
	"Bonanza Bros. (Euro, Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bnzabros1RomInfo, md_bnzabros1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (USA, Kor)
static struct BurnRomInfo md_bnzabrosuRomDesc[] = {
	{ "bonanza bros. (usa, kor).bin", 0x080000, 0x20d1ad4c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bnzabrosu)
STD_ROM_FN(md_bnzabrosu)

struct BurnDriver BurnDrvmd_bnzabrosu = {
	"md_bnzabrosu", "md_bnzabros", NULL, NULL, "1991",
	"Bonanza Bros. (USA, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bnzabrosuRomInfo, md_bnzabrosuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Euro, USA)
static struct BurnRomInfo md_bonkersRomDesc[] = {
	{ "bonkers (euro, usa).bin", 0x100000, 0xd1e66017, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkers)
STD_ROM_FN(md_bonkers)

struct BurnDriver BurnDrvmd_bonkers = {
	"md_bonkers", NULL, NULL, NULL, "1994",
	"Bonkers (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersRomInfo, md_bonkersRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype, 19940328)
static struct BurnRomInfo md_bonkersp5RomDesc[] = {
	{ "bonkers (prototype - mar 28, 1994).bin", 0x100000, 0xcd67c588, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkersp5)
STD_ROM_FN(md_bonkersp5)

struct BurnDriver BurnDrvmd_bonkersp5 = {
	"md_bonkersp5", "md_bonkers", NULL, NULL, "1994",
	"Bonkers (Prototype, 19940328)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersp5RomInfo, md_bonkersp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype, 19940503)
static struct BurnRomInfo md_bonkersp4RomDesc[] = {
	{ "bonkers (prototype - may 03, 1994).bin", 0x100000, 0xe4cd0d61, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkersp4)
STD_ROM_FN(md_bonkersp4)

struct BurnDriver BurnDrvmd_bonkersp4 = {
	"md_bonkersp4", "md_bonkers", NULL, NULL, "1994",
	"Bonkers (Prototype, 19940503)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersp4RomInfo, md_bonkersp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype, 19941004)
static struct BurnRomInfo md_bonkersp3RomDesc[] = {
	{ "bonkers (prototype - oct 04, 1994).bin", 0x100000, 0x913cc834, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkersp3)
STD_ROM_FN(md_bonkersp3)

struct BurnDriver BurnDrvmd_bonkersp3 = {
	"md_bonkersp3", "md_bonkers", NULL, NULL, "1994",
	"Bonkers (Prototype, 19941004)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersp3RomInfo, md_bonkersp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype, 19941025)
static struct BurnRomInfo md_bonkersp2RomDesc[] = {
	{ "bonkers (prototype - oct 25, 1994).bin", 0x100000, 0x3e5edc4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkersp2)
STD_ROM_FN(md_bonkersp2)

struct BurnDriver BurnDrvmd_bonkersp2 = {
	"md_bonkersp2", "md_bonkers", NULL, NULL, "1994",
	"Bonkers (Prototype, 19941025)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersp2RomInfo, md_bonkersp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype, 19941029)
static struct BurnRomInfo md_bonkersp1RomDesc[] = {
	{ "bonkers (prototype - oct 29, 1994).bin", 0x100000, 0x7b84793e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bonkersp1)
STD_ROM_FN(md_bonkersp1)

struct BurnDriver BurnDrvmd_bonkersp1 = {
	"md_bonkersp1", "md_bonkers", NULL, NULL, "1994",
	"Bonkers (Prototype, 19941029)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bonkersp1RomInfo, md_bonkersp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogerman - A Pick and Flick Adventure (Euro)
static struct BurnRomInfo md_boogerRomDesc[] = {
	{ "boogerman - a pick and flick adventure (euro).bin", 0x300000, 0xdbc4340c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_booger)
STD_ROM_FN(md_booger)

struct BurnDriver BurnDrvmd_booger = {
	"md_booger", NULL, NULL, NULL, "1994",
	"Boogerman - A Pick and Flick Adventure (Euro)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_boogerRomInfo, md_boogerRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogerman - A Pick and Flick Adventure (USA)
static struct BurnRomInfo md_boogeruRomDesc[] = {
	{ "boogerman - a pick and flick adventure (usa).bin", 0x300000, 0x1a7a2bec, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_boogeru)
STD_ROM_FN(md_boogeru)

struct BurnDriver BurnDrvmd_boogeru = {
	"md_boogeru", "md_booger", NULL, NULL, "1994",
	"Boogerman - A Pick and Flick Adventure (USA)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_boogeruRomInfo, md_boogeruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boxing Legends of the Ring (USA)
static struct BurnRomInfo md_boxlgndRomDesc[] = {
	{ "boxing legends of the ring (usa).bin", 0x100000, 0x00f225ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_boxlgnd)
STD_ROM_FN(md_boxlgnd)

struct BurnDriver BurnDrvmd_boxlgnd = {
	"md_boxlgnd", NULL, NULL, NULL, "1993",
	"Boxing Legends of the Ring (USA)\0", NULL, "Electro Brain", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_boxlgndRomInfo, md_boxlgndRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chavez II (USA)
static struct BurnRomInfo md_chavezRomDesc[] = {
	{ "chavez ii (usa).bin", 0x100000, 0x5bc0dbb8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chavez)
STD_ROM_FN(md_chavez)

struct BurnDriver BurnDrvmd_chavez = {
	"md_chavez", "md_boxlgnd", NULL, NULL, "1993",
	"Chavez II (USA)\0", NULL, "American Softworks", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chavezRomInfo, md_chavezRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bram Stoker's Dracula (Euro)
static struct BurnRomInfo md_draculaRomDesc[] = {
	{ "bram stoker's dracula (euro).bin", 0x100000, 0x9ba5a063, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dracula)
STD_ROM_FN(md_dracula)

struct BurnDriver BurnDrvmd_dracula = {
	"md_dracula", NULL, NULL, NULL, "1993",
	"Bram Stoker's Dracula (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_draculaRomInfo, md_draculaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bram Stoker's Dracula (USA)
static struct BurnRomInfo md_draculauRomDesc[] = {
	{ "bram stoker's dracula (usa).bin", 0x100000, 0x077084a6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_draculau)
STD_ROM_FN(md_draculau)

struct BurnDriver BurnDrvmd_draculau = {
	"md_draculau", "md_dracula", NULL, NULL, "1993",
	"Bram Stoker's Dracula (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_draculauRomInfo, md_draculauRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brett Hull Hockey '95 (USA)
static struct BurnRomInfo md_bretthulRomDesc[] = {
	{ "brett hull hockey '95 (usa).bin", 0x200000, 0xf7775a09, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bretthul)
STD_ROM_FN(md_bretthul)

struct BurnDriver BurnDrvmd_bretthul = {
	"md_bretthul", NULL, NULL, NULL, "1994",
	"Brett Hull Hockey '95 (USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_bretthulRomInfo, md_bretthulRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket (Euro, 199506)
static struct BurnRomInfo md_brianlarRomDesc[] = {
	{ "brian lara cricket (euro) (june 1995).bin", 0x100000, 0x408cf5c3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brianlar)
STD_ROM_FN(md_brianlar)

struct BurnDriver BurnDrvmd_brianlar = {
	"md_brianlar", NULL, NULL, NULL, "1995",
	"Brian Lara Cricket (Euro, 199506)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_brianlarRomInfo, md_brianlarRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket (Euro, 199503)
static struct BurnRomInfo md_brianlar1RomDesc[] = {
	{ "brian lara cricket (euro) (march 1995).bin", 0x100000, 0x90f5c2b7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brianlar1)
STD_ROM_FN(md_brianlar1)

struct BurnDriver BurnDrvmd_brianlar1 = {
	"md_brianlar1", "md_brianlar", NULL, NULL, "1995",
	"Brian Lara Cricket (Euro, 199503)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_brianlar1RomInfo, md_brianlar1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket 96 (Euro, 199604)
static struct BurnRomInfo md_brianl96RomDesc[] = {
	{ "brian lara cricket 96 (euro) (april 1996).bin", 0x100000, 0xfe52f7e1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brianl96)
STD_ROM_FN(md_brianl96)

struct BurnDriver BurnDrvmd_brianl96 = {
	"md_brianl96", NULL, NULL, NULL, "1996",
	"Brian Lara Cricket 96 (Euro, 199604)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CODE_MASTERS, GBF_MISC, 0,
	MegadriveGetZipName, md_brianl96RomInfo, md_brianl96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket 96 (Euro, 199603)
static struct BurnRomInfo md_brianl96aRomDesc[] = {
	{ "mdbl_9844.bin", 0x100000, 0xfa3024af, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brianl96a)
STD_ROM_FN(md_brianl96a)

struct BurnDriver BurnDrvmd_brianl96a = {
	"md_brianl96a", "md_brianl96", NULL, NULL, "1996",
	"Brian Lara Cricket 96 (Euro, 199603)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CODE_MASTERS, GBF_MISC, 0,
	MegadriveGetZipName, md_brianl96aRomInfo, md_brianl96aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brutal - Paws of Fury (Euro)
static struct BurnRomInfo md_brutalRomDesc[] = {
	{ "brutal - paws of fury (euro).bin", 0x200000, 0x7e9a8d32, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brutal)
STD_ROM_FN(md_brutal)

struct BurnDriver BurnDrvmd_brutal = {
	"md_brutal", NULL, NULL, NULL, "1994",
	"Brutal - Paws of Fury (Euro)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_brutalRomInfo, md_brutalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brutal - Paws of Fury (USA)
static struct BurnRomInfo md_brutaluRomDesc[] = {
	{ "brutal - paws of fury (usa).bin", 0x200000, 0x98d502cd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_brutalu)
STD_ROM_FN(md_brutalu)

struct BurnDriver BurnDrvmd_brutalu = {
	"md_brutalu", "md_brutal", NULL, NULL, "1994",
	"Brutal - Paws of Fury (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_brutaluRomInfo, md_brutaluRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix (Euro)
static struct BurnRomInfo md_bubbaRomDesc[] = {
	{ "bubba'n'stix (euro).bin", 0x100000, 0xb467432e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubba)
STD_ROM_FN(md_bubba)

struct BurnDriver BurnDrvmd_bubba = {
	"md_bubba", NULL, NULL, NULL, "1994",
	"Bubba'n'Stix (Euro)\0", NULL, "Core Design", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubbaRomInfo, md_bubbaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix (Euro, Prototype)
static struct BurnRomInfo md_bubbabRomDesc[] = {
	{ "bubba'n'stix (euro) (beta).bin", 0x100000, 0xa8731cb4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubbab)
STD_ROM_FN(md_bubbab)

struct BurnDriver BurnDrvmd_bubbab = {
	"md_bubbab", "md_bubba", NULL, NULL, "1994",
	"Bubba'n'Stix (Euro, Prototype)\0", NULL, "Core Design", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubbabRomInfo, md_bubbabRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix (USA)
static struct BurnRomInfo md_bubbauRomDesc[] = {
	{ "bubba'n'stix - a strategy adventure (usa).bin", 0x100000, 0xd45cb46f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubbau)
STD_ROM_FN(md_bubbau)

struct BurnDriver BurnDrvmd_bubbau = {
	"md_bubbau", "md_bubba", NULL, NULL, "1993",
	"Bubba'n'Stix (USA)\0", NULL, "Core Design", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubbauRomInfo, md_bubbauRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubble and Squeak (Euro)
static struct BurnRomInfo md_bubbleRomDesc[] = {
	{ "bubble and squeak (euro).bin", 0x080000, 0x86151bf1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubble)
STD_ROM_FN(md_bubble)

struct BurnDriver BurnDrvmd_bubble = {
	"md_bubble", NULL, NULL, NULL, "1994",
	"Bubble and Squeak (Euro)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubbleRomInfo, md_bubbleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubble and Squeak (USA)
static struct BurnRomInfo md_bubbleuRomDesc[] = {
	{ "bubble and squeak (usa).bin", 0x080000, 0x28c4a006, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubbleu)
STD_ROM_FN(md_bubbleu)

struct BurnDriver BurnDrvmd_bubbleu = {
	"md_bubbleu", "md_bubble", NULL, NULL, "1994",
	"Bubble and Squeak (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubbleuRomInfo, md_bubbleuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubsy in Claws Encounters of the Furred Kind (Euro, USA)
static struct BurnRomInfo md_bubsyRomDesc[] = {
	{ "bubsy in claws encounters of the furred kind (euro, usa).bin", 0x200000, 0x3e30d365, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubsy)
STD_ROM_FN(md_bubsy)

struct BurnDriver BurnDrvmd_bubsy = {
	"md_bubsy", NULL, NULL, NULL, "1993",
	"Bubsy in Claws Encounters of the Furred Kind (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubsyRomInfo, md_bubsyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubsy II (Euro, USA)
static struct BurnRomInfo md_bubsy2RomDesc[] = {
	{ "bu2sg.bin", 0x200000, 0xf8beff56, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bubsy2)
STD_ROM_FN(md_bubsy2)

struct BurnDriver BurnDrvmd_bubsy2 = {
	"md_bubsy2", NULL, NULL, NULL, "1994",
	"Bubsy II (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bubsy2RomInfo, md_bubsy2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Buck Rogers - Countdown to Doomsday (Euro, USA)
static struct BurnRomInfo md_buckrogRomDesc[] = {
	{ "buc05.bin", 0x100000, 0x44e3bfff, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_buckrog)
STD_ROM_FN(md_buckrog)

struct BurnDriver BurnDrvmd_buckrog = {
	"md_buckrog", NULL, NULL, NULL, "1991",
	"Buck Rogers - Countdown to Doomsday (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_buckrogRomInfo, md_buckrogRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Budokan - The Martial Spirit (Euro)
static struct BurnRomInfo md_budokanRomDesc[] = {
	{ "budokan - the martial spirit (euro).bin", 0x080000, 0x97add5bd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_budokan)
STD_ROM_FN(md_budokan)

struct BurnDriver BurnDrvmd_budokan = {
	"md_budokan", NULL, NULL, NULL, "1990",
	"Budokan - The Martial Spirit (Euro)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_budokanRomInfo, md_budokanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Budokan - The Martial Spirit (USA)
static struct BurnRomInfo md_budokanuRomDesc[] = {
	{ "budokan - the martial spirit (usa).bin", 0x080000, 0xacd9f5fc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_budokanu)
STD_ROM_FN(md_budokanu)

struct BurnDriver BurnDrvmd_budokanu = {
	"md_budokanu", "md_budokan", NULL, NULL, "1990",
	"Budokan - The Martial Spirit (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_budokanuRomInfo, md_budokanuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bugs Bunny in Double Trouble (USA)
static struct BurnRomInfo md_bugsbunuRomDesc[] = {
	{ "bugs bunny in double trouble (usa).bin", 0x200000, 0x365305a2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bugsbunu)
STD_ROM_FN(md_bugsbunu)

struct BurnDriver BurnDrvmd_bugsbunu = {
	"md_bugsbunu", "md_bugsbun", NULL, NULL, "1996",
	"Bugs Bunny in Double Trouble (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bugsbunuRomInfo, md_bugsbunuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bulls versus Blazers and the NBA Playoffs (Euro, USA)
static struct BurnRomInfo md_bullvsblRomDesc[] = {
	{ "bulls versus blazers and the nba playoffs (euro, usa).bin", 0x100000, 0xd4e4b4e8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bullvsbl)
STD_ROM_FN(md_bullvsbl)

struct BurnDriver BurnDrvmd_bullvsbl = {
	"md_bullvsbl", NULL, NULL, NULL, "1993",
	"Bulls versus Blazers and the NBA Playoffs (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bullvsblRomInfo, md_bullvsblRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bulls Vs Lakers and the NBA Playoffs (Euro, USA)
static struct BurnRomInfo md_bullvslaRomDesc[] = {
	{ "bulls vs lakers and the nba playoffs (euro, usa).bin", 0x100000, 0xe56023a0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bullvsla)
STD_ROM_FN(md_bullvsla)

struct BurnDriver BurnDrvmd_bullvsla = {
	"md_bullvsla", NULL, NULL, NULL, "1992",
	"Bulls Vs Lakers and the NBA Playoffs (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bullvslaRomInfo, md_bullvslaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (Euro)
static struct BurnRomInfo md_burnforcRomDesc[] = {
	{ "burning force (euro).bin", 0x080000, 0x776ff6ff, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_burnforc)
STD_ROM_FN(md_burnforc)

struct BurnDriver BurnDrvmd_burnforc = {
	"md_burnforc", NULL, NULL, NULL, "1991",
	"Burning Force (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_burnforcRomInfo, md_burnforcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (Jpn)
static struct BurnRomInfo md_burnforcjRomDesc[] = {
	{ "burning force (jpn).bin", 0x080000, 0x0c1deb47, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_burnforcj)
STD_ROM_FN(md_burnforcj)

struct BurnDriver BurnDrvmd_burnforcj = {
	"md_burnforcj", "md_burnforc", NULL, NULL, "1990",
	"Burning Force (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_burnforcjRomInfo, md_burnforcjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (USA)
static struct BurnRomInfo md_burnforcuRomDesc[] = {
	{ "burning force (usa).bin", 0x080000, 0xbdc8f02c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_burnforcu)
STD_ROM_FN(md_burnforcu)

struct BurnDriver BurnDrvmd_burnforcu = {
	"md_burnforcu", "md_burnforc", NULL, NULL, "1990",
	"Burning Force (USA)\0", NULL, "Namco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_burnforcuRomInfo, md_burnforcuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cadash (USA, Asia, Kor)
static struct BurnRomInfo md_cadashRomDesc[] = {
	{ "cadash (usa, asia, kor).bin", 0x080000, 0x13bdf374, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cadash)
STD_ROM_FN(md_cadash)

struct BurnDriver BurnDrvmd_cadash = {
	"md_cadash", NULL, NULL, NULL, "1992",
	"Cadash (USA, Asia, Kor)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cadashRomInfo, md_cadashRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Caesars Palace (USA)
static struct BurnRomInfo md_caesarsRomDesc[] = {
	{ "caesars palace (usa).bin", 0x080000, 0x8fdaa9bb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_caesars)
STD_ROM_FN(md_caesars)

struct BurnDriver BurnDrvmd_caesars = {
	"md_caesars", NULL, NULL, NULL, "1993",
	"Caesars Palace (USA)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_caesarsRomInfo, md_caesarsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cal Ripken Jr. Baseball (USA)
static struct BurnRomInfo md_calripRomDesc[] = {
	{ "cal ripken jr. baseball (usa).bin", 0x100000, 0x9b1c96c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_calrip)
STD_ROM_FN(md_calrip)

struct BurnDriver BurnDrvmd_calrip = {
	"md_calrip", NULL, NULL, NULL, "1992",
	"Cal Ripken Jr. Baseball (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_calripRomInfo, md_calripRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cal.50 - Caliber Fifty (USA)
static struct BurnRomInfo md_cal50RomDesc[] = {
	{ "caliber .50 (usa).bin", 0x100000, 0x44f4fa05, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cal50)
STD_ROM_FN(md_cal50)

struct BurnDriver BurnDrvmd_cal50 = {
	"md_cal50", NULL, NULL, NULL, "1991",
	"Cal.50 - Caliber Fifty (USA)\0", NULL, "Mentrix Software", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cal50RomInfo, md_cal50RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// California Games (Euro, USA)
static struct BurnRomInfo md_calgamesRomDesc[] = {
	{ "mpr-14372.bin", 0x080000, 0x43b1b672, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_calgames)
STD_ROM_FN(md_calgames)

struct BurnDriver BurnDrvmd_calgames = {
	"md_calgames", NULL, NULL, NULL, "1991",
	"California Games (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_calgamesRomInfo, md_calgamesRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cannon Fodder (Euro)
static struct BurnRomInfo md_cannonRomDesc[] = {
	{ "cannon fodder (euro).bin", 0x180000, 0xad217654, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cannon)
STD_ROM_FN(md_cannon)

struct BurnDriver BurnDrvmd_cannon = {
	"md_cannon", NULL, NULL, NULL, "1994",
	"Cannon Fodder (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cannonRomInfo, md_cannonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (Euro)
static struct BurnRomInfo md_captavenRomDesc[] = {
	{ "mpr-15499.bin", 0x100000, 0x43225612, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_captaven)
STD_ROM_FN(md_captaven)

struct BurnDriver BurnDrvmd_captaven = {
	"md_captaven", NULL, NULL, NULL, "1992",
	"Captain America and the Avengers (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_captavenRomInfo, md_captavenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (USA)
static struct BurnRomInfo md_captavenuRomDesc[] = {
	{ "captain america and the avengers (usa).bin", 0x100000, 0xe0639ca2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_captavenu)
STD_ROM_FN(md_captavenu)

struct BurnDriver BurnDrvmd_captavenu = {
	"md_captavenu", "md_captaven", NULL, NULL, "1992",
	"Captain America and the Avengers (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_captavenuRomInfo, md_captavenuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (USA, Prototype)
static struct BurnRomInfo md_captavenupRomDesc[] = {
	{ "captain america and the avengers (usa) (beta).bin", 0x100000, 0xbaac59c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_captavenup)
STD_ROM_FN(md_captavenup)

struct BurnDriver BurnDrvmd_captavenup = {
	"md_captavenup", "md_captaven", NULL, NULL, "1992",
	"Captain America and the Avengers (USA, Prototype)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_captavenupRomInfo, md_captavenupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain Planet and the Planeteers (Euro)
static struct BurnRomInfo md_captplanRomDesc[] = {
	{ "captain planet and the planeteers (euro).bin", 0x080000, 0x7672efa5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_captplan)
STD_ROM_FN(md_captplan)

struct BurnDriver BurnDrvmd_captplan = {
	"md_captplan", NULL, NULL, NULL, "1993",
	"Captain Planet and the Planeteers (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_captplanRomInfo, md_captplanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain Planet and the Planeteers (USA)
static struct BurnRomInfo md_captplanuRomDesc[] = {
	{ "captain planet and the planeteers (usa).bin", 0x080000, 0xbf2cbd3a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_captplanu)
STD_ROM_FN(md_captplanu)

struct BurnDriver BurnDrvmd_captplanu = {
	"md_captplanu", "md_captplan", NULL, NULL, "1993",
	"Captain Planet and the Planeteers (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_captplanuRomInfo, md_captplanuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castle of Illusion Starring Mickey Mouse (Euro, USA)
static struct BurnRomInfo md_castlillRomDesc[] = {
	{ "castle of illusion starring mickey mouse (euro, usa).bin", 0x080000, 0xba4e9fd0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_castlill)
STD_ROM_FN(md_castlill)

struct BurnDriver BurnDrvmd_castlill = {
	"md_castlill", NULL, NULL, NULL, "1990",
	"Castle of Illusion Starring Mickey Mouse (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_castlillRomInfo, md_castlillRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castle of Illusion - Fushigi no Oshiro Daibouken (Jpn)
static struct BurnRomInfo md_castlilljRomDesc[] = {
	{ "mpr-13498.bin", 0x080000, 0xce8333c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_castlillj)
STD_ROM_FN(md_castlillj)

struct BurnDriver BurnDrvmd_castlillj = {
	"md_castlillj", "md_castlill", NULL, NULL, "1990",
	"Castle of Illusion - Fushigi no Oshiro Daibouken (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_castlilljRomInfo, md_castlilljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - The New Generation (Euro)
static struct BurnRomInfo md_cvaniaRomDesc[] = {
	{ "castlevania - the new generation (euro).bin", 0x100000, 0x4dd4e4a5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cvania)
STD_ROM_FN(md_cvania)

struct BurnDriver BurnDrvmd_cvania = {
	"md_cvania", NULL, NULL, NULL, "1994",
	"Castlevania - The New Generation (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cvaniaRomInfo, md_cvaniaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - The New Generation (Euro, Prototype)
static struct BurnRomInfo md_cvaniapRomDesc[] = {
	{ "castlevania - the new generation (euro) (beta).bin", 0x100000, 0x84cd103a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cvaniap)
STD_ROM_FN(md_cvaniap)

struct BurnDriver BurnDrvmd_cvaniap = {
	"md_cvaniap", "md_cvania", NULL, NULL, "1994",
	"Castlevania - The New Generation (Euro, Prototype)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cvaniapRomInfo, md_cvaniapRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - Bloodlines (USA)
static struct BurnRomInfo md_cvaniauRomDesc[] = {
	{ "castlevania - bloodlines (usa).bin", 0x100000, 0xfb1ea6df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cvaniau)
STD_ROM_FN(md_cvaniau)

struct BurnDriver BurnDrvmd_cvaniau = {
	"md_cvaniau", "md_cvania", NULL, NULL, "1994",
	"Castlevania - Bloodlines (USA)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cvaniauRomInfo, md_cvaniauRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Akumajou Dracula - Vampire Killer (Jpn)
static struct BurnRomInfo md_akumajouRomDesc[] = {
	{ "akumajou dracula - vampire killer (jpn).bin", 0x100000, 0x91b57d2b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_akumajou)
STD_ROM_FN(md_akumajou)

struct BurnDriver BurnDrvmd_akumajou = {
	"md_akumajou", "md_cvania", NULL, NULL, "1994",
	"Akumajou Dracula - Vampire Killer (Jpn)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_akumajouRomInfo, md_akumajouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Centurion - Defender of Rome (Euro, USA)
static struct BurnRomInfo md_centurRomDesc[] = {
	{ "centurion - defender of rome (euro, usa).bin", 0x0c0000, 0x21283b14, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_centur)
STD_ROM_FN(md_centur)

struct BurnDriver BurnDrvmd_centur = {
	"md_centur", NULL, NULL, NULL, "1991",
	"Centurion - Defender of Rome (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_centurRomInfo, md_centurRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chakan (Euro, USA)
static struct BurnRomInfo md_chakanRomDesc[] = {
	{ "chakan (euro, usa).bin", 0x100000, 0x046a48de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chakan)
STD_ROM_FN(md_chakan)

struct BurnDriver BurnDrvmd_chakan = {
	"md_chakan", NULL, NULL, NULL, "1992",
	"Chakan (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chakanRomInfo, md_chakanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Champions World Class Soccer (World)
static struct BurnRomInfo md_champwcsRomDesc[] = {
	{ "s357.bin", 0x100000, 0x883e33db, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_champwcs)
STD_ROM_FN(md_champwcs)

struct BurnDriver BurnDrvmd_champwcs = {
	"md_champwcs", NULL, NULL, NULL, "1993",
	"Champions World Class Soccer (World)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_champwcsRomInfo, md_champwcsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Bowling (USA)
static struct BurnRomInfo md_champbowRomDesc[] = {
	{ "championship bowling (usa).bin", 0x080000, 0x1bf92520, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_champbow)
STD_ROM_FN(md_champbow)

struct BurnDriver BurnDrvmd_champbow = {
	"md_champbow", NULL, NULL, NULL, "1993",
	"Championship Bowling (USA)\0", NULL, "Mentrix Software", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_champbowRomInfo, md_champbowRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogie Woogie Bowling (Jpn)
static struct BurnRomInfo md_boogieRomDesc[] = {
	{ "boogie woogie bowling (jpn).bin", 0x080000, 0xccf52828, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_boogie)
STD_ROM_FN(md_boogie)

struct BurnDriver BurnDrvmd_boogie = {
	"md_boogie", "md_champbow", NULL, NULL, "1993",
	"Boogie Woogie Bowling (Jpn)\0", NULL, "Visco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_boogieRomInfo, md_boogieRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Pool (USA)
static struct BurnRomInfo md_champlRomDesc[] = {
	{ "championship pool (usa).bin", 0x100000, 0x253512cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_champl)
STD_ROM_FN(md_champl)

struct BurnDriver BurnDrvmd_champl = {
	"md_champl", NULL, NULL, NULL, "1993",
	"Championship Pool (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_champlRomInfo, md_champlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Pro-Am (USA)
static struct BurnRomInfo md_cproamRomDesc[] = {
	{ "championship pro-am (usa).bin", 0x040000, 0xb496de28, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cproam)
STD_ROM_FN(md_cproam)

struct BurnDriver BurnDrvmd_cproam = {
	"md_cproam", NULL, NULL, NULL, "1992",
	"Championship Pro-Am (USA)\0", NULL, "Tradewest", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cproamRomInfo, md_cproamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chao Ji Da Fu Weng (Chi)
static struct BurnRomInfo md_cjfuwengRomDesc[] = {
	{ "chao ji da fu weng (chi) (unl).bin", 0x100000, 0x2e2ea687, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cjfuweng)
STD_ROM_FN(md_cjfuweng)

struct BurnDriver BurnDrvmd_cjfuweng = {
	"md_cjfuweng", NULL, NULL, NULL, "199?",
	"Chao Ji Da Fu Weng (Chi)\0", NULL, "Gametec?", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cjfuwengRomInfo, md_cjfuwengRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Chaos Engine (Euro)
static struct BurnRomInfo md_chaosengRomDesc[] = {
	{ "chaos engine, the (euro).bin", 0x180000, 0xbd9eecf4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chaoseng)
STD_ROM_FN(md_chaoseng)

struct BurnDriver BurnDrvmd_chaoseng = {
	"md_chaoseng", NULL, NULL, NULL, "1992",
	"The Chaos Engine (Euro)\0", NULL, "Microprose", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chaosengRomInfo, md_chaosengRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Soldiers of Fortune (USA)
static struct BurnRomInfo md_soldfortRomDesc[] = {
	{ "soldiers of fortune (usa).bin", 0x180000, 0xa84d28a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_soldfort)
STD_ROM_FN(md_soldfort)

struct BurnDriver BurnDrvmd_soldfort = {
	"md_soldfort", "md_chaoseng", NULL, NULL, "1993",
	"Soldiers of Fortune (USA)\0", NULL, "Spectrum Holobyte", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_soldfortRomInfo, md_soldfortRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Chaos Engine 2 (Euro, Prototype)
static struct BurnRomInfo md_chaosen2RomDesc[] = {
	{ "chaos engine 2, the (euro) (prototype).bin", 0x100000, 0x3fb045c2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chaosen2)
STD_ROM_FN(md_chaosen2)

struct BurnDriver BurnDrvmd_chaosen2 = {
	"md_chaosen2", NULL, NULL, NULL, "199?",
	"The Chaos Engine 2 (Euro, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chaosen2RomInfo, md_chaosen2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chase H.Q. II (USA)
static struct BurnRomInfo md_chasehq2RomDesc[] = {
	{ "chase h.q. ii (usa).bin", 0x080000, 0xf39e4bf2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chasehq2)
STD_ROM_FN(md_chasehq2)

struct BurnDriver BurnDrvmd_chasehq2 = {
	"md_chasehq2", NULL, NULL, NULL, "1992",
	"Chase H.Q. II (USA)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chasehq2RomInfo, md_chasehq2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Super H.Q. (Jpn)
static struct BurnRomInfo md_superhqRomDesc[] = {
	{ "super h.q. (jpn).bin", 0x080000, 0xab2c52b0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_superhq)
STD_ROM_FN(md_superhq)

struct BurnDriver BurnDrvmd_superhq = {
	"md_superhq", "md_chasehq2", NULL, NULL, "1992",
	"Super H.Q. (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_superhqRomInfo, md_superhqRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cheese Cat-Astrophe Starring Speedy Gonzales (Euro)
static struct BurnRomInfo md_cheeseRomDesc[] = {
	{ "cheese cat-astrophe starring speedy gonzales (euro).bin", 0x200000, 0xff634b28, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cheese)
STD_ROM_FN(md_cheese)

struct BurnDriver BurnDrvmd_cheese = {
	"md_cheese", NULL, NULL, NULL, "1995",
	"Cheese Cat-Astrophe Starring Speedy Gonzales (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cheeseRomInfo, md_cheeseRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chester Cheetah - Too Cool to Fool (USA)
static struct BurnRomInfo md_chesterRomDesc[] = {
	{ "chester cheetah - too cool to fool (usa).bin", 0x100000, 0x250e3ec3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chester)
STD_ROM_FN(md_chester)

struct BurnDriver BurnDrvmd_chester = {
	"md_chester", NULL, NULL, NULL, "1992",
	"Chester Cheetah - Too Cool to Fool (USA)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chesterRomInfo, md_chesterRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chester Cheetah - Wild Wild Quest (USA)
static struct BurnRomInfo md_chesterwRomDesc[] = {
	{ "chester cheetah - wild wild quest (usa).bin", 0x100000, 0xb97b735d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chesterw)
STD_ROM_FN(md_chesterw)

struct BurnDriver BurnDrvmd_chesterw = {
	"md_chesterw", NULL, NULL, NULL, "1992",
	"Chester Cheetah - Wild Wild Quest (USA)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chesterwRomInfo, md_chesterwRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chi Chi's Pro Challenge Golf (USA)
static struct BurnRomInfo md_chichiRomDesc[] = {
	{ "chi chi's pro challenge golf (usa).bin", 0x100000, 0x9c3973a4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chichi)
STD_ROM_FN(md_chichi)

struct BurnDriver BurnDrvmd_chichi = {
	"md_chichi", NULL, NULL, NULL, "1993",
	"Chi Chi's Pro Challenge Golf (USA)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chichiRomInfo, md_chichiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chibi Maruko-chan - Wakuwaku Shopping (Jpn)
static struct BurnRomInfo md_chibimarRomDesc[] = {
	{ "chibi maruko-chan - wakuwaku shopping (jpn).bin", 0x080000, 0x91a144b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chibimar)
STD_ROM_FN(md_chibimar)

struct BurnDriver BurnDrvmd_chibimar = {
	"md_chibimar", NULL, NULL, NULL, "1992",
	"Chibi Maruko-chan - Wakuwaku Shopping (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chibimarRomInfo, md_chibimarRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chiki Chiki Boys (Euro, USA)
static struct BurnRomInfo md_chikiRomDesc[] = {
	{ "chiki chiki boys (euro, usa).bin", 0x100000, 0x813a7d62, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chiki)
STD_ROM_FN(md_chiki)

struct BurnDriver BurnDrvmd_chiki = {
	"md_chiki", NULL, NULL, NULL, "1992",
	"Chiki Chiki Boys (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chikiRomInfo, md_chikiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chiki Chiki Boys (Jpn, Kor)
static struct BurnRomInfo md_chikijRomDesc[] = {
	{ "chiki chiki boys (jpn, kor).bin", 0x100000, 0x06918c17, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chikij)
STD_ROM_FN(md_chikij)

struct BurnDriver BurnDrvmd_chikij = {
	"md_chikij", "md_chiki", NULL, NULL, "1992",
	"Chiki Chiki Boys (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chikijRomInfo, md_chikijRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chinese Chess
static struct BurnRomInfo md_chinesecRomDesc[] = {
	{ "chinese chess (unl).bin", 0x080000, 0x475215a0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chinesec)
STD_ROM_FN(md_chinesec)

struct BurnDriver BurnDrvmd_chinesec = {
	"md_chinesec", NULL, NULL, NULL, "199?",
	"Chinese Chess\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chinesecRomInfo, md_chinesecRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock (Euro)
static struct BurnRomInfo md_chuckrckRomDesc[] = {
	{ "chuck rock (euro).bin", 0x100000, 0x7cd40bea, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chuckrck)
STD_ROM_FN(md_chuckrck)

struct BurnDriver BurnDrvmd_chuckrck = {
	"md_chuckrck", NULL, NULL, NULL, "1992",
	"Chuck Rock (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chuckrckRomInfo, md_chuckrckRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock (USA)
static struct BurnRomInfo md_chuckrckuRomDesc[] = {
	{ "chuck rock (usa).bin", 0x100000, 0xf8ac454a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chuckrcku)
STD_ROM_FN(md_chuckrcku)

struct BurnDriver BurnDrvmd_chuckrcku = {
	"md_chuckrcku", "md_chuckrck", NULL, NULL, "1992",
	"Chuck Rock (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chuckrckuRomInfo, md_chuckrckuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (Euro)
static struct BurnRomInfo md_chukrck2RomDesc[] = {
	{ "chuck rock ii - son of chuck (euro).bin", 0x100000, 0x1ade9488, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chukrck2)
STD_ROM_FN(md_chukrck2)

struct BurnDriver BurnDrvmd_chukrck2 = {
	"md_chukrck2", NULL, NULL, NULL, "1993",
	"Chuck Rock II - Son of Chuck (Euro)\0", NULL, "Core Design", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chukrck2RomInfo, md_chukrck2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II (Jpn)
static struct BurnRomInfo md_chukrck2jRomDesc[] = {
	{ "chuck rock ii (jpn).bin", 0x100000, 0xbfd24be8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chukrck2j)
STD_ROM_FN(md_chukrck2j)

struct BurnDriver BurnDrvmd_chukrck2j = {
	"md_chukrck2j", "md_chukrck2", NULL, NULL, "1994",
	"Chuck Rock II (Jpn)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chukrck2jRomInfo, md_chukrck2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (USA)
static struct BurnRomInfo md_chukrck2uRomDesc[] = {
	{ "chuck rock ii - son of chuck (usa).bin", 0x100000, 0x408b1cdb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chukrck2u)
STD_ROM_FN(md_chukrck2u)

struct BurnDriver BurnDrvmd_chukrck2u = {
	"md_chukrck2u", "md_chukrck2", NULL, NULL, "1993",
	"Chuck Rock II - Son of Chuck (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chukrck2uRomInfo, md_chukrck2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (USA, Prototype)
static struct BurnRomInfo md_chukrck2upRomDesc[] = {
	{ "chuck rock ii - son of chuck (usa) (beta).bin", 0x100000, 0xd6a3b324, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chukrck2up)
STD_ROM_FN(md_chukrck2up)

struct BurnDriver BurnDrvmd_chukrck2up = {
	"md_chukrck2up", "md_chukrck2", NULL, NULL, "1993",
	"Chuck Rock II - Son of Chuck (USA, Prototype)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chukrck2upRomInfo, md_chukrck2upRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck's Excellent Art Tool Animator (USA)
static struct BurnRomInfo md_chucksRomDesc[] = {
	{ "chuck's excellent art tool animator (usa) (unl).bin", 0x060000, 0x6360ee58, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_chucks)
STD_ROM_FN(md_chucks)

struct BurnDriver BurnDrvmd_chucks = {
	"md_chucks", NULL, NULL, NULL, "199?",
	"Chuck's Excellent Art Tool Animator (USA)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_chucksRomInfo, md_chucksRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Classic Collection (Euro)
static struct BurnRomInfo md_classiccRomDesc[] = {
	{ "classic collection (euro).bin", 0x200000, 0x73f948b1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_classicc)
STD_ROM_FN(md_classicc)

struct BurnDriver BurnDrvmd_classicc = {
	"md_classicc", NULL, NULL, NULL, "1994",
	"Classic Collection (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_classiccRomInfo, md_classiccRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clay Fighter (Euro)
static struct BurnRomInfo md_clayRomDesc[] = {
	{ "mpr-17510.bin", 0x200000, 0x1aaf7707, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_clay)
STD_ROM_FN(md_clay)

struct BurnDriver BurnDrvmd_clay = {
	"md_clay", NULL, NULL, NULL, "1994",
	"Clay Fighter (Euro)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_clayRomInfo, md_clayRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clay Fighter (USA)
static struct BurnRomInfo md_clayuRomDesc[] = {
	{ "clay fighter (usa).bin", 0x200000, 0xb12c1bc1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_clayu)
STD_ROM_FN(md_clayu)

struct BurnDriver BurnDrvmd_clayu = {
	"md_clayu", "md_clay", NULL, NULL, "1994",
	"Clay Fighter (USA)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_clayuRomInfo, md_clayuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (Euro)
static struct BurnRomInfo md_cliffRomDesc[] = {
	{ "cliffhanger (euro).bin", 0x100000, 0x35bff1fd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cliff)
STD_ROM_FN(md_cliff)

struct BurnDriver BurnDrvmd_cliff = {
	"md_cliff", NULL, NULL, NULL, "1993",
	"Cliffhanger (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cliffRomInfo, md_cliffRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (Prototype)
static struct BurnRomInfo md_cliffpRomDesc[] = {
	{ "cliffhanger (beta).bin", 0x100000, 0x628251fd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cliffp)
STD_ROM_FN(md_cliffp)

struct BurnDriver BurnDrvmd_cliffp = {
	"md_cliffp", "md_cliff", NULL, NULL, "1993",
	"Cliffhanger (Prototype)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cliffpRomInfo, md_cliffpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (USA)
static struct BurnRomInfo md_cliffuRomDesc[] = {
	{ "cliffhanger (usa).bin", 0x100000, 0x9cbf44d3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cliffu)
STD_ROM_FN(md_cliffu)

struct BurnDriver BurnDrvmd_cliffu = {
	"md_cliffu", "md_cliff", NULL, NULL, "1993",
	"Cliffhanger (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cliffuRomInfo, md_cliffuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clue (USA)
static struct BurnRomInfo md_clueRomDesc[] = {
	{ "clue (usa).bin", 0x080000, 0x7753a296, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_clue)
STD_ROM_FN(md_clue)

struct BurnDriver BurnDrvmd_clue = {
	"md_clue", NULL, NULL, NULL, "1992",
	"Clue (USA)\0", NULL, "Parker Brothers", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_clueRomInfo, md_clueRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Coach K College Basketball (USA)
static struct BurnRomInfo md_coachkRomDesc[] = {
	{ "coach k college basketball (usa).bin", 0x200000, 0x67c309c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_coachk)
STD_ROM_FN(md_coachk)

struct BurnDriver BurnDrvmd_coachk = {
	"md_coachk", NULL, NULL, NULL, "1995",
	"Coach K College Basketball (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_coachkRomInfo, md_coachkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football USA 96 (USA)
static struct BurnRomInfo md_colleg96RomDesc[] = {
	{ "college football usa 96 (usa).bin", 0x200000, 0xb9075385, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_colleg96)
STD_ROM_FN(md_colleg96)

struct BurnDriver BurnDrvmd_colleg96 = {
	"md_colleg96", NULL, NULL, NULL, "1995",
	"College Football USA 96 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_colleg96RomInfo, md_colleg96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football USA 97 (USA)
static struct BurnRomInfo md_colleg97RomDesc[] = {
	{ "college football usa 97 (usa).bin", 0x200000, 0x2ebb90a3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_colleg97)
STD_ROM_FN(md_colleg97)

struct BurnDriver BurnDrvmd_colleg97 = {
	"md_colleg97", NULL, NULL, NULL, "1996",
	"College Football USA 97 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_colleg97RomInfo, md_colleg97RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (USA)
static struct BurnRomInfo md_collncRomDesc[] = {
	{ "college football's national championship (usa).bin", 0x200000, 0x172c5dbb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnc)
STD_ROM_FN(md_collnc)

struct BurnDriver BurnDrvmd_collnc = {
	"md_collnc", NULL, NULL, NULL, "1994",
	"College Football's National Championship (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncRomInfo, md_collncRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940413)
static struct BurnRomInfo md_collncp19RomDesc[] = {
	{ "college football's national championship (prototype - apr 13, 1994).bin", 0x200000, 0xd9772def, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp19)
STD_ROM_FN(md_collncp19)

struct BurnDriver BurnDrvmd_collncp19 = {
	"md_collncp19", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940413)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp19RomInfo, md_collncp19RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940418)
static struct BurnRomInfo md_collncp18RomDesc[] = {
	{ "college football's national championship (prototype - apr 18, 1994).bin", 0x200000, 0xe0a1705f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp18)
STD_ROM_FN(md_collncp18)

struct BurnDriver BurnDrvmd_collncp18 = {
	"md_collncp18", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940418)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp18RomInfo, md_collncp18RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940419)
static struct BurnRomInfo md_collncp17RomDesc[] = {
	{ "college football's national championship (prototype - apr 19, 1994).bin", 0x200000, 0xd5fe66c3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp17)
STD_ROM_FN(md_collncp17)

struct BurnDriver BurnDrvmd_collncp17 = {
	"md_collncp17", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940419)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp17RomInfo, md_collncp17RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940429)
static struct BurnRomInfo md_collncp16RomDesc[] = {
	{ "college football's national championship (prototype - apr 29, 1994).bin", 0x200000, 0x99da1973, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp16)
STD_ROM_FN(md_collncp16)

struct BurnDriver BurnDrvmd_collncp16 = {
	"md_collncp16", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940429)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp16RomInfo, md_collncp16RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940601)
static struct BurnRomInfo md_collncp08RomDesc[] = {
	{ "college football's national championship (prototype - jun 01, 1994).bin", 0x200000, 0x994dbc8f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp08)
STD_ROM_FN(md_collncp08)

struct BurnDriver BurnDrvmd_collncp08 = {
	"md_collncp08", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940601)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp08RomInfo, md_collncp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940603)
static struct BurnRomInfo md_collncp07RomDesc[] = {
	{ "college football's national championship (prototype - jun 03, 1994).bin", 0x200000, 0x9ca29321, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp07)
STD_ROM_FN(md_collncp07)

struct BurnDriver BurnDrvmd_collncp07 = {
	"md_collncp07", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940603)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp07RomInfo, md_collncp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940607)
static struct BurnRomInfo md_collncp06RomDesc[] = {
	{ "college football's national championship (prototype - jun 07, 1994).bin", 0x200000, 0xb40b791e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp06)
STD_ROM_FN(md_collncp06)

struct BurnDriver BurnDrvmd_collncp06 = {
	"md_collncp06", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940607)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp06RomInfo, md_collncp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940608)
static struct BurnRomInfo md_collncp05RomDesc[] = {
	{ "college football's national championship (prototype - jun 08, 1994).bin", 0x200000, 0xd008debc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp05)
STD_ROM_FN(md_collncp05)

struct BurnDriver BurnDrvmd_collncp05 = {
	"md_collncp05", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940608)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp05RomInfo, md_collncp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940614)
static struct BurnRomInfo md_collncp04RomDesc[] = {
	{ "college football's national championship (prototype - jun 14, 1994).bin", 0x200000, 0xecef7de7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp04)
STD_ROM_FN(md_collncp04)

struct BurnDriver BurnDrvmd_collncp04 = {
	"md_collncp04", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940614)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp04RomInfo, md_collncp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940615)
static struct BurnRomInfo md_collncp03RomDesc[] = {
	{ "college football's national championship (prototype - jun 15, 1994).bin", 0x200000, 0xc7e5a998, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collncp03)
STD_ROM_FN(md_collncp03)

struct BurnDriver BurnDrvmd_collncp03 = {
	"md_collncp03", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940615)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collncp03RomInfo, md_collncp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940618)
static struct BurnRomInfo md_collnp02RomDesc[] = {
	{ "college football's national championship (prototype - jun 18, 1994).bin", 0x200000, 0x74988a9d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp02)
STD_ROM_FN(md_collnp02)

struct BurnDriver BurnDrvmd_collnp02 = {
	"md_collnp02", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940618)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp02RomInfo, md_collnp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940620)
static struct BurnRomInfo md_collnp01RomDesc[] = {
	{ "college football's national championship (prototype - jun 20, 1994).bin", 0x200000, 0x898c17fa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp01)
STD_ROM_FN(md_collnp01)

struct BurnDriver BurnDrvmd_collnp01 = {
	"md_collnp01", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940620)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp01RomInfo, md_collnp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940503)
static struct BurnRomInfo md_collnp15RomDesc[] = {
	{ "college football's national championship (prototype - may 03, 1994).bin", 0x200000, 0xdb1a3f66, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp15)
STD_ROM_FN(md_collnp15)

struct BurnDriver BurnDrvmd_collnp15 = {
	"md_collnp15", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940503)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp15RomInfo, md_collnp15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940506)
static struct BurnRomInfo md_collnp14RomDesc[] = {
	{ "college football's national championship (prototype - may 06, 1994).bin", 0x200000, 0x0a538e75, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp14)
STD_ROM_FN(md_collnp14)

struct BurnDriver BurnDrvmd_collnp14 = {
	"md_collnp14", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940506)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp14RomInfo, md_collnp14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940511-A)
static struct BurnRomInfo md_collnp13RomDesc[] = {
	{ "college football's national championship (prototype - may 11, 1994 - a).bin", 0x200000, 0xce65b294, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp13)
STD_ROM_FN(md_collnp13)

struct BurnDriver BurnDrvmd_collnp13 = {
	"md_collnp13", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940511-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp13RomInfo, md_collnp13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940517-A)
static struct BurnRomInfo md_collnp12RomDesc[] = {
	{ "college football's national championship (prototype - may 17, 1994 - a).bin", 0x200000, 0x8cfd4c86, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp12)
STD_ROM_FN(md_collnp12)

struct BurnDriver BurnDrvmd_collnp12 = {
	"md_collnp12", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940517-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp12RomInfo, md_collnp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940520)
static struct BurnRomInfo md_collnp11RomDesc[] = {
	{ "college football's national championship (prototype - may 20, 1994).bin", 0x200000, 0xf285385e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp11)
STD_ROM_FN(md_collnp11)

struct BurnDriver BurnDrvmd_collnp11 = {
	"md_collnp11", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940520)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp11RomInfo, md_collnp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940525)
static struct BurnRomInfo md_collnp10RomDesc[] = {
	{ "college football's national championship (prototype - may 25, 1994).bin", 0x200000, 0x482e334a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp10)
STD_ROM_FN(md_collnp10)

struct BurnDriver BurnDrvmd_collnp10 = {
	"md_collnp10", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940525)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp10RomInfo, md_collnp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype, 19940531)
static struct BurnRomInfo md_collnp09RomDesc[] = {
	{ "college football's national championship (prototype - may 31, 1994).bin", 0x200000, 0xc6766745, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnp09)
STD_ROM_FN(md_collnp09)

struct BurnDriver BurnDrvmd_collnp09 = {
	"md_collnp09", "md_collnc", NULL, NULL, "1994",
	"College Football's National Championship (Prototype, 19940531)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnp09RomInfo, md_collnp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship II (USA)
static struct BurnRomInfo md_collnc2RomDesc[] = {
	{ "college football's national championship ii (usa).bin", 0x200000, 0x65b64413, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collnc2)
STD_ROM_FN(md_collnc2)

struct BurnDriver BurnDrvmd_collnc2 = {
	"md_collnc2", NULL, NULL, NULL, "1995",
	"College Football's National Championship II (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collnc2RomInfo, md_collnc2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Slam (USA)
static struct BurnRomInfo md_collslamRomDesc[] = {
	{ "college slam (usa).bin", 0x400000, 0x96a42431, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_collslam)
STD_ROM_FN(md_collslam)

struct BurnDriver BurnDrvmd_collslam = {
	"md_collslam", NULL, NULL, NULL, "1996",
	"College Slam (USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_C_SLAM, GBF_MISC, 0,
	MegadriveGetZipName, md_collslamRomInfo, md_collslamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns (World, v1.1)
static struct BurnRomInfo md_columnsRomDesc[] = {
	{ "columns (world) (v1.1).bin", 0x020000, 0xd783c244, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_columns)
STD_ROM_FN(md_columns)

struct BurnDriver BurnDrvmd_columns = {
	"md_columns", NULL, NULL, NULL, "1990",
	"Columns (World, v1.1)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_columnsRomInfo, md_columnsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns (World)
static struct BurnRomInfo md_columns1RomDesc[] = {
	{ "mpr-13193.bin", 0x020000, 0x03163d7a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_columns1)
STD_ROM_FN(md_columns1)

struct BurnDriver BurnDrvmd_columns1 = {
	"md_columns1", "md_columns", NULL, NULL, "1990",
	"Columns (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_columns1RomInfo, md_columns1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns III - Revenge of Columns (USA)
static struct BurnRomInfo md_columns3RomDesc[] = {
	{ "columns iii - revenge of columns (usa).bin", 0x080000, 0xdc678f6d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_columns3)
STD_ROM_FN(md_columns3)

struct BurnDriver BurnDrvmd_columns3 = {
	"md_columns3", NULL, NULL, NULL, "1993",
	"Columns III - Revenge of Columns (USA)\0", NULL, "Vic Tokai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_columns3RomInfo, md_columns3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns III - Taiketsu! Columns World (Jpn, Kor)
static struct BurnRomInfo md_columns3jRomDesc[] = {
	{ "columns iii - taiketsu! columns world (jpn, kor).bin", 0x080000, 0xcd07462f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_columns3j)
STD_ROM_FN(md_columns3j)

struct BurnDriver BurnDrvmd_columns3j = {
	"md_columns3j", "md_columns3", NULL, NULL, "1993",
	"Columns III - Taiketsu! Columns World (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_columns3jRomInfo, md_columns3jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Combat Aces (Prototype)
static struct BurnRomInfo md_combatRomDesc[] = {
	{ "combat aces (beta).bin", 0x080000, 0x84560d5a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_combat)
STD_ROM_FN(md_combat)

struct BurnDriver BurnDrvmd_combat = {
	"md_combat", NULL, NULL, NULL, "199?",
	"Combat Aces (Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_combatRomInfo, md_combatRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Combat Cars (Euro, USA)
static struct BurnRomInfo md_combatcaRomDesc[] = {
	{ "combat cars (euro, usa).bin", 0x100000, 0xe439b101, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_combatca)
STD_ROM_FN(md_combatca)

struct BurnDriver BurnDrvmd_combatca = {
	"md_combatca", NULL, NULL, NULL, "1994",
	"Combat Cars (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_combatcaRomInfo, md_combatcaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Euro)
static struct BurnRomInfo md_comixRomDesc[] = {
	{ "mpr-18301.bin", 0x200000, 0x1318e923, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comix)
STD_ROM_FN(md_comix)

struct BurnDriver BurnDrvmd_comix = {
	"md_comix", NULL, NULL, NULL, "1995",
	"Comix Zone (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixRomInfo, md_comixRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Euro, Prototype, 19950628)
static struct BurnRomInfo md_comixpRomDesc[] = {
	{ "comix zone (euro) (prototype - jun 28, 1995).bin", 0x200000, 0x939efd4c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixp)
STD_ROM_FN(md_comixp)

struct BurnDriver BurnDrvmd_comixp = {
	"md_comixp", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Euro, Prototype, 19950628)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixpRomInfo, md_comixpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Jpn)
static struct BurnRomInfo md_comixjRomDesc[] = {
	{ "comix zone (jpn).bin", 0x200000, 0x7a6027b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixj)
STD_ROM_FN(md_comixj)

struct BurnDriver BurnDrvmd_comixj = {
	"md_comixj", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixjRomInfo, md_comixjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950712)
static struct BurnRomInfo md_comixup01RomDesc[] = {
	{ "comix zone (prototype - jul 12, 1995).bin", 0x200000, 0xe28c89c1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup01)
STD_ROM_FN(md_comixup01)

struct BurnDriver BurnDrvmd_comixup01 = {
	"md_comixup01", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950712)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup01RomInfo, md_comixup01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950601-B)
static struct BurnRomInfo md_comixup08RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - b).bin", 0x200000, 0xbbe03cb6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup08)
STD_ROM_FN(md_comixup08)

struct BurnDriver BurnDrvmd_comixup08 = {
	"md_comixup08", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950601-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup08RomInfo, md_comixup08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950601-C)
static struct BurnRomInfo md_comixup07RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - c).bin", 0x200000, 0x413b9a94, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup07)
STD_ROM_FN(md_comixup07)

struct BurnDriver BurnDrvmd_comixup07 = {
	"md_comixup07", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950601-C)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup07RomInfo, md_comixup07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950601-D)
static struct BurnRomInfo md_comixup06RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - d).bin", 0x200000, 0x9ae93c9d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup06)
STD_ROM_FN(md_comixup06)

struct BurnDriver BurnDrvmd_comixup06 = {
	"md_comixup06", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950601-D)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup06RomInfo, md_comixup06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950601)
static struct BurnRomInfo md_comixup05RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995).bin", 0x200000, 0xba506835, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup05)
STD_ROM_FN(md_comixup05)

struct BurnDriver BurnDrvmd_comixup05 = {
	"md_comixup05", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950601)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup05RomInfo, md_comixup05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950602-B)
static struct BurnRomInfo md_comixup04RomDesc[] = {
	{ "comix zone (prototype - jun 02, 1995 - b).bin", 0x200000, 0xb5f0dae5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup04)
STD_ROM_FN(md_comixup04)

struct BurnDriver BurnDrvmd_comixup04 = {
	"md_comixup04", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950602-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup04RomInfo, md_comixup04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950602)
static struct BurnRomInfo md_comixup03RomDesc[] = {
	{ "comix zone (prototype - jun 02, 1995).bin", 0x200000, 0x1a4abcf3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup03)
STD_ROM_FN(md_comixup03)

struct BurnDriver BurnDrvmd_comixup03 = {
	"md_comixup03", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950602)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup03RomInfo, md_comixup03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950603)
static struct BurnRomInfo md_comixup02RomDesc[] = {
	{ "comix zone (prototype - jun 03, 1995).bin", 0x200000, 0xaff32614, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup02)
STD_ROM_FN(md_comixup02)

struct BurnDriver BurnDrvmd_comixup02 = {
	"md_comixup02", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950603)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup02RomInfo, md_comixup02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950526)
static struct BurnRomInfo md_comixup10RomDesc[] = {
	{ "comix zone (prototype - may 26, 1995).bin", 0x200000, 0x36029a1f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup10)
STD_ROM_FN(md_comixup10)

struct BurnDriver BurnDrvmd_comixup10 = {
	"md_comixup10", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950526)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup10RomInfo, md_comixup10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype, 19950530)
static struct BurnRomInfo md_comixup09RomDesc[] = {
	{ "comix zone (prototype - may 30, 1995).bin", 0x200000, 0xa72eca2c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup09)
STD_ROM_FN(md_comixup09)

struct BurnDriver BurnDrvmd_comixup09 = {
	"md_comixup09", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Prototype, 19950530)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixup09RomInfo, md_comixup09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Kor, Prototype, 19950609)
static struct BurnRomInfo md_comixkpRomDesc[] = {
	{ "comix zone (kor) (prototype - jun 09, 1995).bin", 0x200000, 0xe45a15f4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixkp)
STD_ROM_FN(md_comixkp)

struct BurnDriver BurnDrvmd_comixkp = {
	"md_comixkp", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Kor, Prototype, 19950609)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixkpRomInfo, md_comixkpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Sega Channel, Prototype, 19950612)
static struct BurnRomInfo md_comixscRomDesc[] = {
	{ "comix zone (sega channel) (prototype - jun 12, 1995).bin", 0x200000, 0xc77db9e1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixsc)
STD_ROM_FN(md_comixsc)

struct BurnDriver BurnDrvmd_comixsc = {
	"md_comixsc", "md_comix", NULL, NULL, "1995",
	"Comix Zone (Sega Channel, Prototype, 19950612)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixscRomInfo, md_comixscRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (USA)
static struct BurnRomInfo md_comixuRomDesc[] = {
	{ "comix zone (usa).bin", 0x200000, 0x17da0354, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixu)
STD_ROM_FN(md_comixu)

struct BurnDriver BurnDrvmd_comixu = {
	"md_comixu", "md_comix", NULL, NULL, "1995",
	"Comix Zone (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixuRomInfo, md_comixuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (USA, Prototype)
static struct BurnRomInfo md_comixupRomDesc[] = {
	{ "comix zone (usa) (beta).bin", 0x200000, 0x2efcb6ee, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_comixup)
STD_ROM_FN(md_comixup)

struct BurnDriver BurnDrvmd_comixup = {
	"md_comixup", "md_comix", NULL, NULL, "1995",
	"Comix Zone (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_comixupRomInfo, md_comixupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Congo (Prototype)
static struct BurnRomInfo md_congoRomDesc[] = {
	{ "congo (unknown) (prototype).bin", 0x0f7d36, 0x13746716, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_congo)
STD_ROM_FN(md_congo)

struct BurnDriver BurnDrvmd_congo = {
	"md_congo", NULL, NULL, NULL, "199?",
	"Congo (Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_congoRomInfo, md_congoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (Euro)
static struct BurnRomInfo md_coolspRomDesc[] = {
	{ "mpr-15477.bin", 0x100000, 0x5f09fa41, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_coolsp)
STD_ROM_FN(md_coolsp)

struct BurnDriver BurnDrvmd_coolsp = {
	"md_coolsp", NULL, NULL, NULL, "1994",
	"Cool Spot (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_coolspRomInfo, md_coolspRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (Jpn, Kor)
static struct BurnRomInfo md_coolspjRomDesc[] = {
	{ "cool spot (jpn, kor).bin", 0x100000, 0xe869efb1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_coolspj)
STD_ROM_FN(md_coolspj)

struct BurnDriver BurnDrvmd_coolspj = {
	"md_coolspj", "md_coolsp", NULL, NULL, "1994",
	"Cool Spot (Jpn, Kor)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_coolspjRomInfo, md_coolspjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (USA)
static struct BurnRomInfo md_coolspuRomDesc[] = {
	{ "cool spot (usa).bin", 0x100000, 0xf024c1a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_coolspu)
STD_ROM_FN(md_coolspu)

struct BurnDriver BurnDrvmd_coolspu = {
	"md_coolspu", "md_coolsp", NULL, NULL, "1994",
	"Cool Spot (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_coolspuRomInfo, md_coolspuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (USA, Prototype)
static struct BurnRomInfo md_coolspupRomDesc[] = {
	{ "cool spot (usa) (beta).bin", 0x100000, 0x0ebaa4a8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_coolspup)
STD_ROM_FN(md_coolspup)

struct BurnDriver BurnDrvmd_coolspup = {
	"md_coolspup", "md_coolsp", NULL, NULL, "1994",
	"Cool Spot (USA, Prototype)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_coolspupRomInfo, md_coolspupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Corporation (Euro)
static struct BurnRomInfo md_corporatRomDesc[] = {
	{ "mpr-15065.bin", 0x100000, 0xa80d18aa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_corporat)
STD_ROM_FN(md_corporat)

struct BurnDriver BurnDrvmd_corporat = {
	"md_corporat", NULL, NULL, NULL, "1992",
	"Corporation (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_corporatRomInfo, md_corporatRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyber-Cop (USA)
static struct BurnRomInfo md_cybercopRomDesc[] = {
	{ "cyber-cop (usa).bin", 0x100000, 0x01e719c8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cybercop)
STD_ROM_FN(md_cybercop)

struct BurnDriver BurnDrvmd_cybercop = {
	"md_cybercop", "md_corporat", NULL, NULL, "1992",
	"Cyber-Cop (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cybercopRomInfo, md_cybercopRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cosmic Spacehead (Euro, USA)
static struct BurnRomInfo md_cosmicRomDesc[] = {
	{ "cosmic spacehead (euro, usa).bin", 0x100000, 0xc593d31c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cosmic)
STD_ROM_FN(md_cosmic)

struct BurnDriver BurnDrvmd_cosmic = {
	"md_cosmic", NULL, NULL, NULL, "1993",
	"Cosmic Spacehead (Euro, USA)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cosmicRomInfo, md_cosmicRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (Euro, Jpn, Rev. A)
static struct BurnRomInfo md_crkdownRomDesc[] = {
	{ "mpr-13578a.bin", 0x080000, 0xd012a47a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crkdown)
STD_ROM_FN(md_crkdown)

struct BurnDriver BurnDrvmd_crkdown = {
	"md_crkdown", NULL, NULL, NULL, "1990",
	"Crack Down (Euro, Jpn, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crkdownRomInfo, md_crkdownRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (Euro, Jpn)
static struct BurnRomInfo md_crkdown1RomDesc[] = {
	{ "crack down (euro, jpn).bin", 0x080000, 0x538aaa5d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crkdown1)
STD_ROM_FN(md_crkdown1)

struct BurnDriver BurnDrvmd_crkdown1 = {
	"md_crkdown1", "md_crkdown", NULL, NULL, "1990",
	"Crack Down (Euro, Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crkdown1RomInfo, md_crkdown1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (USA)
static struct BurnRomInfo md_crkdownuRomDesc[] = {
	{ "crack down (usa).bin", 0x080000, 0xb9ce9051, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crkdownu)
STD_ROM_FN(md_crkdownu)

struct BurnDriver BurnDrvmd_crkdownu = {
	"md_crkdownu", "md_crkdown", NULL, NULL, "1991",
	"Crack Down (USA)\0", NULL, "Sage's Creation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crkdownuRomInfo, md_crkdownuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crayon Shin-chan - Arashi o Yobu Enji (Jpn)
static struct BurnRomInfo md_crayonRomDesc[] = {
	{ "crayon shin-chan - arashi o yobu enji (jpn).bin", 0x200000, 0x97fc42d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crayon)
STD_ROM_FN(md_crayon)

struct BurnDriver BurnDrvmd_crayon = {
	"md_crayon", NULL, NULL, NULL, "1994",
	"Crayon Shin-chan - Arashi o Yobu Enji (Jpn)\0", NULL, "Ma-Ba", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crayonRomInfo, md_crayonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cross Fire (USA)
static struct BurnRomInfo md_crossfRomDesc[] = {
	{ "cross fire (usa).bin", 0x080000, 0xcc73f3a9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crossf)
STD_ROM_FN(md_crossf)

struct BurnDriver BurnDrvmd_crossf = {
	"md_crossf", NULL, NULL, NULL, "1991",
	"Cross Fire (USA)\0", NULL, "Kyugo Boueki", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crossfRomInfo, md_crossfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Super Airwolf (Jpn)
static struct BurnRomInfo md_superairRomDesc[] = {
	{ "mpr-13814.bin", 0x080000, 0xfa451982, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_superair)
STD_ROM_FN(md_superair)

struct BurnDriver BurnDrvmd_superair = {
	"md_superair", "md_crossf", NULL, NULL, "1991",
	"Super Airwolf (Jpn)\0", NULL, "Kyugo Boueki", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_superairRomInfo, md_superairRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crue Ball (Euro, USA)
static struct BurnRomInfo md_crueballRomDesc[] = {
	{ "crue06.bin", 0x080000, 0x4b195fc0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crueball)
STD_ROM_FN(md_crueball)

struct BurnDriver BurnDrvmd_crueball = {
	"md_crueball", NULL, NULL, NULL, "1992",
	"Crue Ball (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crueballRomInfo, md_crueballRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crue Ball (Jpn)
static struct BurnRomInfo md_crueballjRomDesc[] = {
	{ "crue ball (jpn).bin", 0x080000, 0x514c53e2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crueballj)
STD_ROM_FN(md_crueballj)

struct BurnDriver BurnDrvmd_crueballj = {
	"md_crueballj", "md_crueball", NULL, NULL, "1993",
	"Crue Ball (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crueballjRomInfo, md_crueballjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Twisted Flipper (USA, Prototype)
static struct BurnRomInfo md_twistedfRomDesc[] = {
	{ "twisted flipper (usa) (beta).bin", 0x080000, 0x6dd47554, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_twistedf)
STD_ROM_FN(md_twistedf)

struct BurnDriver BurnDrvmd_twistedf = {
	"md_twistedf", "md_crueball", NULL, NULL, "199?",
	"Twisted Flipper (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_twistedfRomInfo, md_twistedfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (USA)
static struct BurnRomInfo md_crystlptRomDesc[] = {
	{ "crystal's pony tale (usa).bin", 0x100000, 0x6cf7a4df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlpt)
STD_ROM_FN(md_crystlpt)

struct BurnDriver BurnDrvmd_crystlpt = {
	"md_crystlpt", NULL, NULL, NULL, "1994",
	"Crystal's Pony Tale (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptRomInfo, md_crystlptRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940701)
static struct BurnRomInfo md_crystlptp06RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 01, 1994).bin", 0x100000, 0x16ac2e4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp06)
STD_ROM_FN(md_crystlptp06)

struct BurnDriver BurnDrvmd_crystlptp06 = {
	"md_crystlptp06", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940701)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp06RomInfo, md_crystlptp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940702)
static struct BurnRomInfo md_crystlptp05RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 02, 1994).bin", 0x100000, 0x24bc4354, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp05)
STD_ROM_FN(md_crystlptp05)

struct BurnDriver BurnDrvmd_crystlptp05 = {
	"md_crystlptp05", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940702)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp05RomInfo, md_crystlptp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940703)
static struct BurnRomInfo md_crystlptp04RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 03, 1994).bin", 0x100000, 0x6d67a87c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp04)
STD_ROM_FN(md_crystlptp04)

struct BurnDriver BurnDrvmd_crystlptp04 = {
	"md_crystlptp04", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940703)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp04RomInfo, md_crystlptp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940712-B)
static struct BurnRomInfo md_crystlptp03RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 12, 1994 - b).bin", 0x100000, 0x3577dc72, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp03)
STD_ROM_FN(md_crystlptp03)

struct BurnDriver BurnDrvmd_crystlptp03 = {
	"md_crystlptp03", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940712-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp03RomInfo, md_crystlptp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940712)
static struct BurnRomInfo md_crystlptp02RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 12, 1994).bin", 0x0ff554, 0x2bfc0a53, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp02)
STD_ROM_FN(md_crystlptp02)

struct BurnDriver BurnDrvmd_crystlptp02 = {
	"md_crystlptp02", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940712)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp02RomInfo, md_crystlptp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940713)
static struct BurnRomInfo md_crystlptp01RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 13, 1994).bin", 0x100000, 0xc67b6dba, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp01)
STD_ROM_FN(md_crystlptp01)

struct BurnDriver BurnDrvmd_crystlptp01 = {
	"md_crystlptp01", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940713)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp01RomInfo, md_crystlptp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940601)
static struct BurnRomInfo md_crystlptp12RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 01, 1994).bin", 0x100000, 0x14c6347c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp12)
STD_ROM_FN(md_crystlptp12)

struct BurnDriver BurnDrvmd_crystlptp12 = {
	"md_crystlptp12", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940601)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp12RomInfo, md_crystlptp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940606)
static struct BurnRomInfo md_crystlptp11RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 06, 1994).bin", 0x100000, 0x83e8cac9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp11)
STD_ROM_FN(md_crystlptp11)

struct BurnDriver BurnDrvmd_crystlptp11 = {
	"md_crystlptp11", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940606)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp11RomInfo, md_crystlptp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940610)
static struct BurnRomInfo md_crystlptp10RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 10, 1994).bin", 0x100000, 0x9e1dd267, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp10)
STD_ROM_FN(md_crystlptp10)

struct BurnDriver BurnDrvmd_crystlptp10 = {
	"md_crystlptp10", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940610)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp10RomInfo, md_crystlptp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940623)
static struct BurnRomInfo md_crystlptp09RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 23, 1994).bin", 0x100000, 0x4ccc19af, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp09)
STD_ROM_FN(md_crystlptp09)

struct BurnDriver BurnDrvmd_crystlptp09 = {
	"md_crystlptp09", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940623)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp09RomInfo, md_crystlptp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940628)
static struct BurnRomInfo md_crystlptp08RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 28, 1994).bin", 0x100000, 0x03be7f66, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp08)
STD_ROM_FN(md_crystlptp08)

struct BurnDriver BurnDrvmd_crystlptp08 = {
	"md_crystlptp08", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940628)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp08RomInfo, md_crystlptp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940630)
static struct BurnRomInfo md_crystlptp07RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 30, 1994).bin", 0x100000, 0xdd8c73fb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp07)
STD_ROM_FN(md_crystlptp07)

struct BurnDriver BurnDrvmd_crystlptp07 = {
	"md_crystlptp07", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940630)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp07RomInfo, md_crystlptp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940511)
static struct BurnRomInfo md_crystlptp15RomDesc[] = {
	{ "crystal's pony tale (prototype - may 11, 1994).bin", 0x100000, 0xeac9d74b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp15)
STD_ROM_FN(md_crystlptp15)

struct BurnDriver BurnDrvmd_crystlptp15 = {
	"md_crystlptp15", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940511)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp15RomInfo, md_crystlptp15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940519)
static struct BurnRomInfo md_crystlptp14RomDesc[] = {
	{ "crystal's pony tale (prototype - may 19, 1994).bin", 0x100000, 0xdc50b741, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp14)
STD_ROM_FN(md_crystlptp14)

struct BurnDriver BurnDrvmd_crystlptp14 = {
	"md_crystlptp14", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940519)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp14RomInfo, md_crystlptp14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype, 19940526)
static struct BurnRomInfo md_crystlptp13RomDesc[] = {
	{ "crystal's pony tale (prototype - may 26, 1994).bin", 0x100000, 0xa2eaba55, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crystlptp13)
STD_ROM_FN(md_crystlptp13)

struct BurnDriver BurnDrvmd_crystlptp13 = {
	"md_crystlptp13", "md_crystlpt", NULL, NULL, "1994",
	"Crystal's Pony Tale (Prototype, 19940526)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crystlptp13RomInfo, md_crystlptp13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Curse (Jpn)
static struct BurnRomInfo md_curseRomDesc[] = {
	{ "curse (jpn).bin", 0x080000, 0xa4fbf9a9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_curse)
STD_ROM_FN(md_curse)

struct BurnDriver BurnDrvmd_curse = {
	"md_curse", NULL, NULL, NULL, "1989",
	"Curse (Jpn)\0", NULL, "Micronet", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_curseRomInfo, md_curseRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cutie Suzuki no Ringside Angel (Jpn)
static struct BurnRomInfo md_cutiesuzRomDesc[] = {
	{ "cutie suzuki no ringside angel (jpn).bin", 0x080000, 0x13795dca, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cutiesuz)
STD_ROM_FN(md_cutiesuz)

struct BurnDriver BurnDrvmd_cutiesuz = {
	"md_cutiesuz", NULL, NULL, NULL, "1990",
	"Cutie Suzuki no Ringside Angel (Jpn)\0", NULL, "Asmik Ace", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cutiesuzRomInfo, md_cutiesuzRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// CutThroat Island (Euro, USA)
static struct BurnRomInfo md_cutthrRomDesc[] = {
	{ "cutthroat island (euro, usa).bin", 0x200000, 0xebabbc70, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cutthr)
STD_ROM_FN(md_cutthr)

struct BurnDriver BurnDrvmd_cutthr = {
	"md_cutthr", NULL, NULL, NULL, "1995",
	"CutThroat Island (Euro, USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cutthrRomInfo, md_cutthrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// CyberBall (World)
static struct BurnRomInfo md_cyberbalRomDesc[] = {
	{ "mpr-13201.bin", 0x080000, 0x76120e96, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cyberbal)
STD_ROM_FN(md_cyberbal)

struct BurnDriver BurnDrvmd_cyberbal = {
	"md_cyberbal", NULL, NULL, NULL, "1990",
	"CyberBall (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cyberbalRomInfo, md_cyberbalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyborg Justice (Euro, USA)
static struct BurnRomInfo md_cyborgjRomDesc[] = {
	{ "mpr-15468.bin", 0x080000, 0xab0d1269, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cyborgj)
STD_ROM_FN(md_cyborgj)

struct BurnDriver BurnDrvmd_cyborgj = {
	"md_cyborgj", NULL, NULL, NULL, "1993",
	"Cyborg Justice (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cyborgjRomInfo, md_cyborgjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyborg Justice (Prototype)
static struct BurnRomInfo md_cyborgjpRomDesc[] = {
	{ "cyborg justice (beta).bin", 0x080000, 0x91daf11e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_cyborgjp)
STD_ROM_FN(md_cyborgjp)

struct BurnDriver BurnDrvmd_cyborgjp = {
	"md_cyborgjp", "md_cyborgj", NULL, NULL, "1993",
	"Cyborg Justice (Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_cyborgjpRomInfo, md_cyborgjpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daffy Duck in Hollywood (Euro)
static struct BurnRomInfo md_daffyRomDesc[] = {
	{ "daffy duck in hollywood (euro).bin", 0x200000, 0x1fdc66b0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daffy)
STD_ROM_FN(md_daffy)

struct BurnDriver BurnDrvmd_daffy = {
	"md_daffy", NULL, NULL, NULL, "1994",
	"Daffy Duck in Hollywood (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daffyRomInfo, md_daffyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daffy Duck in Hollywood (Euro, Prototype)
static struct BurnRomInfo md_daffypRomDesc[] = {
	{ "daffy duck in hollywood (euro) (beta).bin", 0x200000, 0x0eaa4740, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daffyp)
STD_ROM_FN(md_daffyp)

struct BurnDriver BurnDrvmd_daffyp = {
	"md_daffyp", "md_daffy", NULL, NULL, "1994",
	"Daffy Duck in Hollywood (Euro, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daffypRomInfo, md_daffypRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dahna Megami Tanjou (Jpn)
static struct BurnRomInfo md_dahnamRomDesc[] = {
	{ "dahna megami tanjou (jpn).bin", 0x100000, 0x4602584f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dahnam)
STD_ROM_FN(md_dahnam)

struct BurnDriver BurnDrvmd_dahnam = {
	"md_dahnam", NULL, NULL, NULL, "1991",
	"Dahna Megami Tanjou (Jpn)\0", NULL, "IGS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dahnamRomInfo, md_dahnamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dahna (Kor)
static struct BurnRomInfo md_dahnamkRomDesc[] = {
	{ "mpr-14636.bin", 0x100000, 0x10829ea1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dahnamk)
STD_ROM_FN(md_dahnamk)

struct BurnDriver BurnDrvmd_dahnamk = {
	"md_dahnamk", "md_dahnam", NULL, NULL, "199?",
	"Dahna (Kor)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dahnamkRomInfo, md_dahnamkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hercules
static struct BurnRomInfo md_herculRomDesc[] = {
	{ "hercules (unl).bin", 0x100000, 0xff75d9d0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hercul)
STD_ROM_FN(md_hercul)

struct BurnDriver BurnDrvmd_hercul = {
	"md_hercul", "md_dahnam", NULL, NULL, "199?",
	"Hercules\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_herculRomInfo, md_herculRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dangerous Seed (Jpn)
static struct BurnRomInfo md_dangseedRomDesc[] = {
	{ "dangerous seed (jpn).bin", 0x080000, 0xa2990031, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dangseed)
STD_ROM_FN(md_dangseed)

struct BurnDriver BurnDrvmd_dangseed = {
	"md_dangseed", NULL, NULL, NULL, "1990",
	"Dangerous Seed (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dangseedRomInfo, md_dangseedRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dark Castle (Euro, USA)
static struct BurnRomInfo md_darkcastRomDesc[] = {
	{ "dark castle (euro, usa).bin", 0x080000, 0x0464aca4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_darkcast)
STD_ROM_FN(md_darkcast)

struct BurnDriver BurnDrvmd_darkcast = {
	"md_darkcast", NULL, NULL, NULL, "1991",
	"Dark Castle (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_darkcastRomInfo, md_darkcastRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Darwin 4081 (Jpn, Kor)
static struct BurnRomInfo md_darwinRomDesc[] = {
	{ "darwin 4081 (jpn, kor).bin", 0x080000, 0x7a33b0cb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_darwin)
STD_ROM_FN(md_darwin)

struct BurnDriver BurnDrvmd_darwin = {
	"md_darwin", NULL, NULL, NULL, "1990",
	"Darwin 4081 (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_darwinRomInfo, md_darwinRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (USA)
static struct BurnRomInfo md_dashRomDesc[] = {
	{ "dashin' desperadoes (usa).bin", 0x100000, 0xdcb76fb7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dash)
STD_ROM_FN(md_dash)

struct BurnDriver BurnDrvmd_dash = {
	"md_dash", NULL, NULL, NULL, "1993",
	"Dashin' Desperadoes (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dashRomInfo, md_dashRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (USA, Prototype)
static struct BurnRomInfo md_dashp1RomDesc[] = {
	{ "dashin' desperadoes (usa) (beta).bin", 0x100000, 0x98d224a5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dashp1)
STD_ROM_FN(md_dashp1)

struct BurnDriver BurnDrvmd_dashp1 = {
	"md_dashp1", "md_dash", NULL, NULL, "1993",
	"Dashin' Desperadoes (USA, Prototype)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dashp1RomInfo, md_dashp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (USA, Prototype, Alt)
static struct BurnRomInfo md_dashp2RomDesc[] = {
	{ "dashin' desperadoes (beta).bin", 0x100000, 0xadaffc3f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dashp2)
STD_ROM_FN(md_dashp2)

struct BurnDriver BurnDrvmd_dashp2 = {
	"md_dashp2", "md_dash", NULL, NULL, "1993",
	"Dashin' Desperadoes (USA, Prototype, Alt)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dashp2RomInfo, md_dashp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Crane's Amazing Tennis (USA)
static struct BurnRomInfo md_davidcRomDesc[] = {
	{ "david crane's amazing tennis (usa).bin", 0x100000, 0x9177088c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_davidc)
STD_ROM_FN(md_davidc)

struct BurnDriver BurnDrvmd_davidc = {
	"md_davidc", NULL, NULL, NULL, "1992",
	"David Crane's Amazing Tennis (USA)\0", NULL, "Absolute Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_davidcRomInfo, md_davidcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Robinson's Supreme Court (Euro, USA)
static struct BurnRomInfo md_drscRomDesc[] = {
	{ "mpr-14835.bin", 0x080000, 0x512b7599, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_drsc)
STD_ROM_FN(md_drsc)

struct BurnDriver BurnDrvmd_drsc = {
	"md_drsc", NULL, NULL, NULL, "1992",
	"David Robinson's Supreme Court (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_drscRomInfo, md_drscRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Robinson Basketball (Jpn)
static struct BurnRomInfo md_drscjRomDesc[] = {
	{ "david robinson basketball (jpn).bin", 0x080000, 0x56164b00, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_drscj)
STD_ROM_FN(md_drscj)

struct BurnDriver BurnDrvmd_drscj = {
	"md_drscj", "md_drsc", NULL, NULL, "1992",
	"David Robinson Basketball (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_drscjRomInfo, md_drscjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour (Euro, USA, 199307)
static struct BurnRomInfo md_daviscupRomDesc[] = {
	{ "davis cup world tour (euro, usa) (july 1993).bin", 0x100000, 0x894686f0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daviscup)
STD_ROM_FN(md_daviscup)

struct BurnDriver BurnDrvmd_daviscup = {
	"md_daviscup", NULL, NULL, NULL, "1993",
	"Davis Cup World Tour (Euro, USA, 199307)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daviscupRomInfo, md_daviscupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour (Euro, USA, 199306)
static struct BurnRomInfo md_daviscupaRomDesc[] = {
	{ "davis cup world tour (euro, usa) (june 1993).bin", 0x100000, 0x7c6b0646, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daviscupa)
STD_ROM_FN(md_daviscupa)

struct BurnDriver BurnDrvmd_daviscupa = {
	"md_daviscupa", "md_daviscup", NULL, NULL, "1993",
	"Davis Cup World Tour (Euro, USA, 199306)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daviscupaRomInfo, md_daviscupaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour Tennis 2 (Prototype 1)
static struct BurnRomInfo md_daviscp2RomDesc[] = {
	{ "davis cup world tour tennis 2 (beta 1).bin", 0x200000, 0x6f4183c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daviscp2)
STD_ROM_FN(md_daviscp2)

struct BurnDriver BurnDrvmd_daviscp2 = {
	"md_daviscp2", NULL, NULL, NULL, "199?",
	"Davis Cup World Tour Tennis 2 (Prototype 1)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daviscp2RomInfo, md_daviscp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup II (USA, Prototype)
static struct BurnRomInfo md_daviscp2aRomDesc[] = {
	{ "davis cup ii (usa) (prototype).bin", 0x200000, 0x76f2bed8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daviscp2a)
STD_ROM_FN(md_daviscp2a)

struct BurnDriver BurnDrvmd_daviscp2a = {
	"md_daviscp2a", "md_daviscp2", NULL, NULL, "199?",
	"Davis Cup II (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daviscp2aRomInfo, md_daviscp2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daze Before Christmas (Oceania)
static struct BurnRomInfo md_dazeRomDesc[] = {
	{ "daze before christmas (aus).bin", 0x200000, 0xb95e25c9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daze)
STD_ROM_FN(md_daze)

struct BurnDriver BurnDrvmd_daze = {
	"md_daze", NULL, NULL, NULL, "1994",
	"Daze Before Christmas (Oceania)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dazeRomInfo, md_dazeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daze Before Christmas (Oceania, Prototype)
static struct BurnRomInfo md_dazepRomDesc[] = {
	{ "daze before christmas (aus) (beta).bin", 0x200000, 0x317c9491, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dazep)
STD_ROM_FN(md_dazep)

struct BurnDriver BurnDrvmd_dazep = {
	"md_dazep", "md_daze", NULL, NULL, "1994",
	"Daze Before Christmas (Oceania, Prototype)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dazepRomInfo, md_dazepRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Deadly Moves (USA)
static struct BurnRomInfo md_deadlymvRomDesc[] = {
	{ "deadly moves (usa).bin", 0x100000, 0x35cbd237, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_deadlymv)
STD_ROM_FN(md_deadlymv)

struct BurnDriver BurnDrvmd_deadlymv = {
	"md_deadlymv", NULL, NULL, NULL, "1992",
	"Deadly Moves (USA)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_deadlymvRomInfo, md_deadlymvRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Power Athlete (Jpn, Kor)
static struct BurnRomInfo md_powerathRomDesc[] = {
	{ "power athlete (jpn, kor).bin", 0x100000, 0xb41b77cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_powerath)
STD_ROM_FN(md_powerath)

struct BurnDriver BurnDrvmd_powerath = {
	"md_powerath", "md_deadlymv", NULL, NULL, "1992",
	"Power Athlete (Jpn, Kor)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_powerathRomInfo, md_powerathRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Death and Return of Superman (USA)
static struct BurnRomInfo md_deathretRomDesc[] = {
	{ "death and return of superman, the (usa).bin", 0x200000, 0x982242d3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_deathret)
STD_ROM_FN(md_deathret)

struct BurnDriver BurnDrvmd_deathret = {
	"md_deathret", NULL, NULL, NULL, "1995",
	"The Death and Return of Superman (USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_deathretRomInfo, md_deathretRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Death Duel (USA)
static struct BurnRomInfo md_deathdlRomDesc[] = {
	{ "death duel (usa).bin", 0x100000, 0xa9804dcc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_deathdl)
STD_ROM_FN(md_deathdl)

struct BurnDriver BurnDrvmd_deathdl = {
	"md_deathdl", NULL, NULL, NULL, "1992",
	"Death Duel (USA)\0", NULL, "Razorsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_deathdlRomInfo, md_deathdlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DecapAttack (Euro, USA, Kor)
static struct BurnRomInfo md_decapattRomDesc[] = {
	{ "mpr-14249.bin", 0x080000, 0x73dc0dd8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_decapatt)
STD_ROM_FN(md_decapatt)

struct BurnDriver BurnDrvmd_decapatt = {
	"md_decapatt", NULL, NULL, NULL, "1991",
	"DecapAttack (Euro, USA, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_decapattRomInfo, md_decapattRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Demolition Man (Euro, USA)
static struct BurnRomInfo md_demomanRomDesc[] = {
	{ "demolition man (euro, usa).bin", 0x200000, 0x5ff71877, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_demoman)
STD_ROM_FN(md_demoman)

struct BurnDriver BurnDrvmd_demoman = {
	"md_demoman", NULL, NULL, NULL, "1995",
	"Demolition Man (Euro, USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_demomanRomInfo, md_demomanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Demolition Man (USA, Prototype)
static struct BurnRomInfo md_demomanpRomDesc[] = {
	{ "demolition man (usa) (beta).bin", 0x200000, 0x57ffad7a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_demomanp)
STD_ROM_FN(md_demomanp)

struct BurnDriver BurnDrvmd_demomanp = {
	"md_demomanp", "md_demoman", NULL, NULL, "1995",
	"Demolition Man (USA, Prototype)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_demomanpRomInfo, md_demomanpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Euro, USA)
static struct BurnRomInfo md_desrtdemRomDesc[] = {
	{ "desert demolition starring road runner and wile e. coyote (euro, usa).bin", 0x100000, 0xc287343d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdem)
STD_ROM_FN(md_desrtdem)

struct BurnDriver BurnDrvmd_desrtdem = {
	"md_desrtdem", NULL, NULL, NULL, "1994",
	"Desert Demolition (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemRomInfo, md_desrtdemRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941206)
static struct BurnRomInfo md_desrtdemp9RomDesc[] = {
	{ "desert demolition (prototype - dec 06, 1994).bin", 0x0ed0ad, 0xd27fe9e5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp9)
STD_ROM_FN(md_desrtdemp9)

struct BurnDriver BurnDrvmd_desrtdemp9 = {
	"md_desrtdemp9", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941206)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp9RomInfo, md_desrtdemp9RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941208)
static struct BurnRomInfo md_desrtdemp8RomDesc[] = {
	{ "desert demolition (prototype - dec 08, 1994).bin", 0x0fdfb8, 0x69aaeab6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp8)
STD_ROM_FN(md_desrtdemp8)

struct BurnDriver BurnDrvmd_desrtdemp8 = {
	"md_desrtdemp8", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941208)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp8RomInfo, md_desrtdemp8RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941212-B)
static struct BurnRomInfo md_desrtdemp7RomDesc[] = {
	{ "desert demolition (prototype - dec 12, 1994 - b).bin", 0x100000, 0x16f19283, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp7)
STD_ROM_FN(md_desrtdemp7)

struct BurnDriver BurnDrvmd_desrtdemp7 = {
	"md_desrtdemp7", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941212-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp7RomInfo, md_desrtdemp7RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941212)
static struct BurnRomInfo md_desrtdemp6RomDesc[] = {
	{ "desert demolition (prototype - dec 12, 1994).bin", 0x0ec988, 0x5dad49d7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp6)
STD_ROM_FN(md_desrtdemp6)

struct BurnDriver BurnDrvmd_desrtdemp6 = {
	"md_desrtdemp6", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941212)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp6RomInfo, md_desrtdemp6RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941213)
static struct BurnRomInfo md_desrtdemp5RomDesc[] = {
	{ "desert demolition (prototype - dec 13, 1994).bin", 0x0fde9c, 0x375dee15, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp5)
STD_ROM_FN(md_desrtdemp5)

struct BurnDriver BurnDrvmd_desrtdemp5 = {
	"md_desrtdemp5", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941213)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp5RomInfo, md_desrtdemp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941214)
static struct BurnRomInfo md_desrtdemp4RomDesc[] = {
	{ "desert demolition (prototype - dec 14, 1994).bin", 0x0fde9c, 0x39f9f304, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp4)
STD_ROM_FN(md_desrtdemp4)

struct BurnDriver BurnDrvmd_desrtdemp4 = {
	"md_desrtdemp4", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941214)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp4RomInfo, md_desrtdemp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941215)
static struct BurnRomInfo md_desrtdemp3RomDesc[] = {
	{ "desert demolition (prototype - dec 15, 1994).bin", 0x0fde9c, 0x5109736a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp3)
STD_ROM_FN(md_desrtdemp3)

struct BurnDriver BurnDrvmd_desrtdemp3 = {
	"md_desrtdemp3", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941215)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp3RomInfo, md_desrtdemp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941216)
static struct BurnRomInfo md_desrtdemp2RomDesc[] = {
	{ "desert demolition (prototype - dec 16, 1994).bin", 0x100000, 0x573fabfb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp2)
STD_ROM_FN(md_desrtdemp2)

struct BurnDriver BurnDrvmd_desrtdemp2 = {
	"md_desrtdemp2", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941216)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp2RomInfo, md_desrtdemp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype, 19941219)
static struct BurnRomInfo md_desrtdemp1RomDesc[] = {
	{ "desert demolition (prototype - dec 19, 1994).bin", 0x0fde9c, 0xb0ece758, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_desrtdemp1)
STD_ROM_FN(md_desrtdemp1)

struct BurnDriver BurnDrvmd_desrtdemp1 = {
	"md_desrtdemp1", "md_desrtdem", NULL, NULL, "1994",
	"Desert Demolition (Prototype, 19941219)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_desrtdemp1RomInfo, md_desrtdemp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Strike (Euro, USA)
static struct BurnRomInfo md_dstrikeRomDesc[] = {
	{ "desert strike (euro, usa).bin", 0x100000, 0x67a9860b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dstrike)
STD_ROM_FN(md_dstrike)

struct BurnDriver BurnDrvmd_dstrike = {
	"md_dstrike", NULL, NULL, NULL, "1992",
	"Desert Strike (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dstrikeRomInfo, md_dstrikeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Strike (Jpn, Kor)
static struct BurnRomInfo md_dstrikejRomDesc[] = {
	{ "desert strike (jpn, kor).bin", 0x100000, 0x1e740145, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dstrikej)
STD_ROM_FN(md_dstrikej)

struct BurnDriver BurnDrvmd_dstrikej = {
	"md_dstrikej", "md_dstrike", NULL, NULL, "1993",
	"Desert Strike (Jpn, Kor)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dstrikejRomInfo, md_dstrikejRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Devilish - The Next Possession (USA)
static struct BurnRomInfo md_devilishRomDesc[] = {
	{ "devilish - the next possession (usa).bin", 0x080000, 0xd3f300ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_devilish)
STD_ROM_FN(md_devilish)

struct BurnDriver BurnDrvmd_devilish = {
	"md_devilish", NULL, NULL, NULL, "1992",
	"Devilish - The Next Possession (USA)\0", NULL, "Sage's Creation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_devilishRomInfo, md_devilishRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bad Omen (Jpn, Kor)
static struct BurnRomInfo md_badomenRomDesc[] = {
	{ "bad omen (jpn, kor).bin", 0x080000, 0x975693ce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_badomen)
STD_ROM_FN(md_badomen)

struct BurnDriver BurnDrvmd_badomen = {
	"md_badomen", "md_devilish", NULL, NULL, "1992",
	"Bad Omen (Jpn, Kor)\0", NULL, "Hot-B", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_badomenRomInfo, md_badomenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dial Q o Mawase! (Jpn)
static struct BurnRomInfo md_dialqoRomDesc[] = {
	{ "dial q o mawase! (jpn) (unl).bin", 0x100000, 0xc632e5af, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dialqo)
STD_ROM_FN(md_dialqo)

struct BurnDriver BurnDrvmd_dialqo = {
	"md_dialqo", NULL, NULL, NULL, "199?",
	"Dial Q o Mawase! (Jpn)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dialqoRomInfo, md_dialqoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dick Tracy (World)
static struct BurnRomInfo md_dicktrRomDesc[] = {
	{ "mpr-13661.bin", 0x080000, 0xef887533, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dicktr)
STD_ROM_FN(md_dicktr)

struct BurnDriver BurnDrvmd_dicktr = {
	"md_dicktr", NULL, NULL, NULL, "1991",
	"Dick Tracy (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dicktrRomInfo, md_dicktrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dick Vitale's 'Awesome, Baby!' College Hoops (USA)
static struct BurnRomInfo md_dickvitlRomDesc[] = {
	{ "dick vitale's 'awesome, baby!' college hoops (usa).bin", 0x200000, 0x1312cf22, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dickvitl)
STD_ROM_FN(md_dickvitl)

struct BurnDriver BurnDrvmd_dickvitl = {
	"md_dickvitl", NULL, NULL, NULL, "1994",
	"Dick Vitale's 'Awesome, Baby!' College Hoops (USA)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dickvitlRomInfo, md_dickvitlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dino Dini's Soccer (Euro)
static struct BurnRomInfo md_dinodiniRomDesc[] = {
	{ "dino dini's soccer (euro).bin", 0x100000, 0x4608f53a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinodini)
STD_ROM_FN(md_dinodini)

struct BurnDriver BurnDrvmd_dinodini = {
	"md_dinodini", NULL, NULL, NULL, "1994",
	"Dino Dini's Soccer (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dinodiniRomInfo, md_dinodiniRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dino Land (USA)
static struct BurnRomInfo md_dinolandRomDesc[] = {
	{ "dino land (usa).bin", 0x080000, 0x5fe351b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinoland)
STD_ROM_FN(md_dinoland)

struct BurnDriver BurnDrvmd_dinoland = {
	"md_dinoland", NULL, NULL, NULL, "1991",
	"Dino Land (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinolandRomInfo, md_dinolandRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chou Touryuu Retsuden - Dino Land (Jpn)
static struct BurnRomInfo md_dinolandjRomDesc[] = {
	{ "chou touryuu retsuden - dino land (jpn).bin", 0x080000, 0x81f939de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinolandj)
STD_ROM_FN(md_dinolandj)

struct BurnDriver BurnDrvmd_dinolandj = {
	"md_dinolandj", "md_dinoland", NULL, NULL, "1991",
	"Chou Touryuu Retsuden - Dino Land (Jpn)\0", NULL, "Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinolandjRomInfo, md_dinolandjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// A Dinosaur's Tale (USA)
static struct BurnRomInfo md_dinotaleRomDesc[] = {
	{ "dinosaur's tale, a (usa).bin", 0x100000, 0x70155b5b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinotale)
STD_ROM_FN(md_dinotale)

struct BurnDriver BurnDrvmd_dinotale = {
	"md_dinotale", NULL, NULL, NULL, "1993",
	"A Dinosaur's Tale (USA)\0", NULL, "Hi-Tech Expression", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinotaleRomInfo, md_dinotaleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (USA)
static struct BurnRomInfo md_dinohireRomDesc[] = {
	{ "dinosaurs for hire (usa).bin", 0x100000, 0x39351146, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinohire)
STD_ROM_FN(md_dinohire)

struct BurnDriver BurnDrvmd_dinohire = {
	"md_dinohire", NULL, NULL, NULL, "1993",
	"Dinosaurs for Hire (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinohireRomInfo, md_dinohireRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype, 19930426)
static struct BurnRomInfo md_dinohirep3RomDesc[] = {
	{ "dinosaurs for hire (prototype - apr 26, 1993).bin", 0x100000, 0x54c77d3e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinohirep3)
STD_ROM_FN(md_dinohirep3)

struct BurnDriver BurnDrvmd_dinohirep3 = {
	"md_dinohirep3", "md_dinohire", NULL, NULL, "1993",
	"Dinosaurs for Hire (Prototype, 19930426)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinohirep3RomInfo, md_dinohirep3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype, 19930427)
static struct BurnRomInfo md_dinohirep2RomDesc[] = {
	{ "dinosaurs for hire (prototype - apr 27, 1993).bin", 0x100000, 0x16000453, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinohirep2)
STD_ROM_FN(md_dinohirep2)

struct BurnDriver BurnDrvmd_dinohirep2 = {
	"md_dinohirep2", "md_dinohire", NULL, NULL, "1993",
	"Dinosaurs for Hire (Prototype, 19930427)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinohirep2RomInfo, md_dinohirep2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype, 19930502)
static struct BurnRomInfo md_dinohirep1RomDesc[] = {
	{ "dinosaurs for hire (prototype - may 02, 1993).bin", 0x100000, 0x8954dee9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dinohirep1)
STD_ROM_FN(md_dinohirep1)

struct BurnDriver BurnDrvmd_dinohirep1 = {
	"md_dinohirep1", "md_dinohire", NULL, NULL, "1993",
	"Dinosaurs for Hire (Prototype, 19930502)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dinohirep1RomInfo, md_dinohirep1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Disney Collection - Mickey and Donald (Euro)
static struct BurnRomInfo md_disneyclRomDesc[] = {
	{ "disney collection, the (euro).bin", 0x100000, 0xadfde883, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_disneycl)
STD_ROM_FN(md_disneycl)

struct BurnDriver BurnDrvmd_disneycl = {
	"md_disneycl", NULL, NULL, NULL, "1996",
	"The Disney Collection - Mickey and Donald (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_disneyclRomInfo, md_disneyclRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Divine Sealing (Jpn)
static struct BurnRomInfo md_divineRomDesc[] = {
	{ "divine sealing (jpn) (unl).bin", 0x100000, 0xca72973c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_divine)
STD_ROM_FN(md_divine)

struct BurnDriver BurnDrvmd_divine = {
	"md_divine", NULL, NULL, NULL, "1991",
	"Divine Sealing (Jpn)\0", NULL, "CYX", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_divineRomInfo, md_divineRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (Euro)
static struct BurnRomInfo md_djboyRomDesc[] = {
	{ "mpr-14560.bin", 0x080000, 0x860e749a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_djboy)
STD_ROM_FN(md_djboy)

struct BurnDriver BurnDrvmd_djboy = {
	"md_djboy", NULL, NULL, NULL, "1991",
	"DJ Boy (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_djboyRomInfo, md_djboyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (Jpn)
static struct BurnRomInfo md_djboyjRomDesc[] = {
	{ "dj boy (jpn).bin", 0x080000, 0x202abaa8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_djboyj)
STD_ROM_FN(md_djboyj)

struct BurnDriver BurnDrvmd_djboyj = {
	"md_djboyj", "md_djboy", NULL, NULL, "1990",
	"DJ Boy (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_djboyjRomInfo, md_djboyjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (USA)
static struct BurnRomInfo md_djboyuRomDesc[] = {
	{ "dj boy (usa).bin", 0x080000, 0xdc9f02db, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_djboyu)
STD_ROM_FN(md_djboyu)

struct BurnDriver BurnDrvmd_djboyu = {
	"md_djboyu", "md_djboy", NULL, NULL, "1990",
	"DJ Boy (USA)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_djboyuRomInfo, md_djboyuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ikazuse! Koi no Doki Doki Penguin Land MD (Jpn, SegaNet)
static struct BurnRomInfo md_dokidokiRomDesc[] = {
	{ "ikazuse! koi no doki doki penguin land md (jpn) (sn).bin", 0x040000, 0x0053bfd6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dokidoki)
STD_ROM_FN(md_dokidoki)

struct BurnDriver BurnDrvmd_dokidoki = {
	"md_dokidoki", NULL, NULL, NULL, "1991",
	"Ikazuse! Koi no Doki Doki Penguin Land MD (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dokidokiRomInfo, md_dokidokiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ikazuse! Koi no Doki Doki Penguin Land MD (Jpn, Game no Kandume MegaCD Rip)
static struct BurnRomInfo md_dokidokignkRomDesc[] = {
	{ "ikazuse! koi no doki doki penguin land md (jpn) (gnk).bin", 0x040000, 0x22736650, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dokidokignk)
STD_ROM_FN(md_dokidokignk)

struct BurnDriver BurnDrvmd_dokidokignk = {
	"md_dokidokignk", "md_dokidoki", NULL, NULL, "1991",
	"Ikazuse! Koi no Doki Doki Penguin Land MD (Jpn, Game no Kandume MegaCD Rip)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dokidokignkRomInfo, md_dokidokignkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dominus (USA, Prototype)
static struct BurnRomInfo md_dominusRomDesc[] = {
	{ "dominus (usa) (prototype).bin", 0x0c0000, 0x30006ebd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dominus)
STD_ROM_FN(md_dominus)

struct BurnDriver BurnDrvmd_dominus = {
	"md_dominus", NULL, NULL, NULL, "199?",
	"Dominus (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dominusRomInfo, md_dominusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Donald in Maui Mallard (Euro)
static struct BurnRomInfo md_mauimallRomDesc[] = {
	{ "donald in maui mallard (euro).bin", 0x300000, 0xb2dd857f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mauimall)
STD_ROM_FN(md_mauimall)

struct BurnDriver BurnDrvmd_mauimall = {
	"md_mauimall", NULL, NULL, NULL, "1995",
	"Donald in Maui Mallard (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mauimallRomInfo, md_mauimallRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Doom Troopers - The Mutant Chronicles (USA)
static struct BurnRomInfo md_doomtrRomDesc[] = {
	{ "doom troopers - the mutant chronicles (usa).bin", 0x200000, 0x11194414, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_doomtr)
STD_ROM_FN(md_doomtr)

struct BurnDriver BurnDrvmd_doomtr = {
	"md_doomtr", NULL, NULL, NULL, "1995",
	"Doom Troopers - The Mutant Chronicles (USA)\0", NULL, "Playmates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_doomtrRomInfo, md_doomtrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Doraemon - Yume Dorobou to 7-nin no Gozans (Jpn)
static struct BurnRomInfo md_doraemonRomDesc[] = {
	{ "doraemon - yume dorobou to 7-nin no gozans (jpn).bin", 0x080000, 0xeeed1130, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_doraemon)
STD_ROM_FN(md_doraemon)

struct BurnDriver BurnDrvmd_doraemon = {
	"md_doraemon", NULL, NULL, NULL, "1993",
	"Doraemon - Yume Dorobou to 7-nin no Gozans (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_doraemonRomInfo, md_doraemonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Clutch (Euro)
static struct BurnRomInfo md_doubleclRomDesc[] = {
	{ "double clutch (euro).bin", 0x040000, 0xd98c623c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_doublecl)
STD_ROM_FN(md_doublecl)

struct BurnDriver BurnDrvmd_doublecl = {
	"md_doublecl", NULL, NULL, NULL, "1992",
	"Double Clutch (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_doubleclRomInfo, md_doubleclRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon (Euro, USA)
static struct BurnRomInfo md_ddragonRomDesc[] = {
	{ "double dragon (euro, usa).bin", 0x080000, 0x054f5d53, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddragon)
STD_ROM_FN(md_ddragon)

struct BurnDriver BurnDrvmd_ddragon = {
	"md_ddragon", NULL, NULL, NULL, "1993",
	"Double Dragon (Euro, USA)\0", NULL, "Ballistic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ddragonRomInfo, md_ddragonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon II - The Revenge (Jpn)
static struct BurnRomInfo md_ddragon2RomDesc[] = {
	{ "double dragon ii - the revenge (jpn).bin", 0x080000, 0xa8bfdbd6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddragon2)
STD_ROM_FN(md_ddragon2)

struct BurnDriver BurnDrvmd_ddragon2 = {
	"md_ddragon2", NULL, NULL, NULL, "1991",
	"Double Dragon II - The Revenge (Jpn)\0", NULL, "Palsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ddragon2RomInfo, md_ddragon2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon 3 - The Arcade Game (Euro, USA)
static struct BurnRomInfo md_ddragon3RomDesc[] = {
	{ "double dragon 3 - the arcade game (euro, usa).bin", 0x100000, 0xb36ab75c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddragon3)
STD_ROM_FN(md_ddragon3)

struct BurnDriver BurnDrvmd_ddragon3 = {
	"md_ddragon3", NULL, NULL, NULL, "1992",
	"Double Dragon 3 - The Arcade Game (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ddragon3RomInfo, md_ddragon3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon V - The Shadow Falls (USA)
static struct BurnRomInfo md_ddragon5RomDesc[] = {
	{ "double dragon v - the shadow falls (usa).bin", 0x300000, 0x27e59e35, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddragon5)
STD_ROM_FN(md_ddragon5)

struct BurnDriver BurnDrvmd_ddragon5 = {
	"md_ddragon5", NULL, NULL, NULL, "1994",
	"Double Dragon V - The Shadow Falls (USA)\0", NULL, "Tradewest", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ddragon5RomInfo, md_ddragon5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (Euro)
static struct BurnRomInfo md_drrobotnRomDesc[] = {
	{ "dr. robotnik's mean bean machine (euro).bin", 0x100000, 0x70680706, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_drrobotn)
STD_ROM_FN(md_drrobotn)

struct BurnDriver BurnDrvmd_drrobotn = {
	"md_drrobotn", NULL, NULL, NULL, "1993",
	"Dr. Robotnik's Mean Bean Machine (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_drrobotnRomInfo, md_drrobotnRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (USA, Prototype)
static struct BurnRomInfo md_drrobotn1RomDesc[] = {
	{ "dr. robotnik's mean bean machine (usa) (beta).bin", 0x100000, 0x4d0e5273, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_drrobotn1)
STD_ROM_FN(md_drrobotn1)

struct BurnDriver BurnDrvmd_drrobotn1 = {
	"md_drrobotn1", "md_drrobotn", NULL, NULL, "1993",
	"Dr. Robotnik's Mean Bean Machine (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_drrobotn1RomInfo, md_drrobotn1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (USA)
static struct BurnRomInfo md_drrobotnuRomDesc[] = {
	{ "dr. robotnik's mean bean machine (usa).bin", 0x100000, 0xc7ca517f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_drrobotnu)
STD_ROM_FN(md_drrobotnu)

struct BurnDriver BurnDrvmd_drrobotnu = {
	"md_drrobotnu", "md_drrobotn", NULL, NULL, "1993",
	"Dr. Robotnik's Mean Bean Machine (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_drrobotnuRomInfo, md_drrobotnuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dong Gu Ri Te Chi Jak Jeon (Kor)
static struct BurnRomInfo md_dongguriRomDesc[] = {
	{ "dong gu ri te chi jak jeon (kor).bin", 0x100000, 0xe32f0b1c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dongguri)
STD_ROM_FN(md_dongguri)

struct BurnDriver BurnDrvmd_dongguri = {
	"md_dongguri", "md_drrobotn", NULL, NULL, "199?",
	"Dong Gu Ri Te Chi Jak Jeon (Kor)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dongguriRomInfo, md_dongguriRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon - The Bruce Lee Story (Euro)
static struct BurnRomInfo md_dragonRomDesc[] = {
	{ "dragon - the bruce lee story (euro).bin", 0x200000, 0xfdeed51d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dragon)
STD_ROM_FN(md_dragon)

struct BurnDriver BurnDrvmd_dragon = {
	"md_dragon", NULL, NULL, NULL, "1993",
	"Dragon - The Bruce Lee Story (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dragonRomInfo, md_dragonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon - The Bruce Lee Story (USA)
static struct BurnRomInfo md_dragonuRomDesc[] = {
	{ "dragon - the bruce lee story (usa).bin", 0x200000, 0xefe850e5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dragonu)
STD_ROM_FN(md_dragonu)

struct BurnDriver BurnDrvmd_dragonu = {
	"md_dragonu", "md_dragon", NULL, NULL, "1994",
	"Dragon - The Bruce Lee Story (USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dragonuRomInfo, md_dragonuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Ball Z - Buyuu Retsuden (Jpn)
static struct BurnRomInfo md_dbzRomDesc[] = {
	{ "dragon ball z - buyuu retsuden (jpn).bin", 0x200000, 0xaf8f3371, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dbz)
STD_ROM_FN(md_dbz)

struct BurnDriver BurnDrvmd_dbz = {
	"md_dbz", NULL, NULL, NULL, "1994",
	"Dragon Ball Z - Buyuu Retsuden (Jpn)\0", NULL, "Bandai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dbzRomInfo, md_dbzRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Ball Z - L'Appel du Destin (Fra)
static struct BurnRomInfo md_dbzfRomDesc[] = {
	{ "dragon ball z - l'appel du destin (france).bin", 0x200000, 0xf035c737, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dbzf)
STD_ROM_FN(md_dbzf)

struct BurnDriver BurnDrvmd_dbzf = {
	"md_dbzf", "md_dbz", NULL, NULL, "1994",
	"Dragon Ball Z - L'Appel du Destin (Fra)\0", NULL, "Bandai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dbzfRomInfo, md_dbzfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Slayer - Eiyuu Densetsu (Jpn)
static struct BurnRomInfo md_dslayerRomDesc[] = {
	{ "dragon slayer - eiyuu densetsu (jpn).bin", 0x200000, 0x01bc1604, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dslayer)
STD_ROM_FN(md_dslayer)

struct BurnDriver BurnDrvmd_dslayer = {
	"md_dslayer", NULL, NULL, NULL, "1994",
	"Dragon Slayer - Eiyuu Densetsu (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dslayerRomInfo, md_dslayerRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Slayer - Eiyuu Densetsu II (Jpn)
static struct BurnRomInfo md_dslayer2RomDesc[] = {
	{ "dragon slayer - eiyuu densetsu ii (jpn).bin", 0x200000, 0x46924dc3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dslayer2)
STD_ROM_FN(md_dslayer2)

struct BurnDriver BurnDrvmd_dslayer2 = {
	"md_dslayer2", NULL, NULL, NULL, "1995",
	"Dragon Slayer - Eiyuu Densetsu II (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dslayer2RomInfo, md_dslayer2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Eye Plus - Shanghai III (Jpn)
static struct BurnRomInfo md_shangai3RomDesc[] = {
	{ "dragon's eye plus - shanghai iii (jpn).bin", 0x040000, 0x81f0c3cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_shangai3)
STD_ROM_FN(md_shangai3)

struct BurnDriver BurnDrvmd_shangai3 = {
	"md_shangai3", NULL, NULL, NULL, "1991",
	"Dragon's Eye Plus - Shanghai III (Jpn)\0", NULL, "Home Data", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_shangai3RomInfo, md_shangai3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Fury (Euro, USA)
static struct BurnRomInfo md_dfuryRomDesc[] = {
	{ "dragon's fury (euro, usa).bin", 0x080000, 0x58037bc6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dfury)
STD_ROM_FN(md_dfury)

struct BurnDriver BurnDrvmd_dfury = {
	"md_dfury", NULL, NULL, NULL, "1992",
	"Dragon's Fury (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dfuryRomInfo, md_dfuryRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Lair (USA, Prototype)
static struct BurnRomInfo md_dlairRomDesc[] = {
	{ "dragon's lair (usa, prototype).bin", 0x080000, 0xa33eb522, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dlair)
STD_ROM_FN(md_dlair)

struct BurnDriver BurnDrvmd_dlair = {
	"md_dlair", NULL, NULL, NULL, "199?",
	"Dragon's Lair (USA, Prototype)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dlairRomInfo, md_dlairRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Devil Crash MD (Jpn)
static struct BurnRomInfo md_devlcrshRomDesc[] = {
	{ "devil crash md (jpn).bin", 0x080000, 0x4c4caad8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_devlcrsh)
STD_ROM_FN(md_devlcrsh)

struct BurnDriver BurnDrvmd_devlcrsh = {
	"md_devlcrsh", "md_dfury", NULL, NULL, "1993",
	"Devil Crash MD (Jpn)\0", NULL, "Technosoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_devlcrshRomInfo, md_devlcrshRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Revenge (Euro, USA)
static struct BurnRomInfo md_dragnrevRomDesc[] = {
	{ "dragon's revenge (euro, usa).bin", 0x100000, 0x841edbc0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dragnrev)
STD_ROM_FN(md_dragnrev)

struct BurnDriver BurnDrvmd_dragnrev = {
	"md_dragnrev", NULL, NULL, NULL, "1993",
	"Dragon's Revenge (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dragnrevRomInfo, md_dragnrevRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Revenge (Jpn)
static struct BurnRomInfo md_dragnrevjRomDesc[] = {
	{ "dragon's revenge (japan).bin", 0x100000, 0xd8d2efd7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dragnrevj)
STD_ROM_FN(md_dragnrevj)

struct BurnDriver BurnDrvmd_dragnrevj = {
	"md_dragnrevj", "md_dragnrev", NULL, NULL, "1993",
	"Dragon's Revenge (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dragnrevjRomInfo, md_dragnrevjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Duke Nukem 3D (Bra)
static struct BurnRomInfo md_dukenk3dRomDesc[] = {
	{ "duke nukem 3d (bra).bin", 0x400000, 0x6bd2accb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dukenk3d)
STD_ROM_FN(md_dukenk3d)

struct BurnDriver BurnDrvmd_dukenk3d = {
	"md_dukenk3d", NULL, NULL, NULL, "1998",
	"Duke Nukem 3D (Bra)\0", NULL, "Tec Toy", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dukenk3dRomInfo, md_dukenk3dRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune II - Battle for Arrakis (Euro)
static struct BurnRomInfo md_dune2RomDesc[] = {
	{ "dune ii - battle for arrakis (euro).bin", 0x100000, 0xb58ae71d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dune2)
STD_ROM_FN(md_dune2)

struct BurnDriver BurnDrvmd_dune2 = {
	"md_dune2", NULL, NULL, NULL, "1993",
	"Dune II - Battle for Arrakis (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dune2RomInfo, md_dune2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune II - Kampf um den Wustenplaneten (Ger)
static struct BurnRomInfo md_dune2gRomDesc[] = {
	{ "dune ii - kampf um den wustenplaneten (germany).bin", 0x100000, 0x39790728, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dune2g)
STD_ROM_FN(md_dune2g)

struct BurnDriver BurnDrvmd_dune2g = {
	"md_dune2g", "md_dune2", NULL, NULL, "1993",
	"Dune II - Kampf um den Wustenplaneten (Ger)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dune2gRomInfo, md_dune2gRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune - The Battle for Arrakis (USA)
static struct BurnRomInfo md_duneuRomDesc[] = {
	{ "dune - the battle for arrakis (usa).bin", 0x100000, 0x4dea40ba, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_duneu)
STD_ROM_FN(md_duneu)

struct BurnDriver BurnDrvmd_duneu = {
	"md_duneu", "md_dune2", NULL, NULL, "1993",
	"Dune - The Battle for Arrakis (USA)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_duneuRomInfo, md_duneuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dungeons & Dragons - Warriors of the Eternal Sun (Euro, USA)
static struct BurnRomInfo md_ddwaresRomDesc[] = {
	{ "dungeons & dragons - warriors of the eternal sun (euro, usa).bin", 0x100000, 0xaf4a9cd7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddwares)
STD_ROM_FN(md_ddwares)

struct BurnDriver BurnDrvmd_ddwares = {
	"md_ddwares", NULL, NULL, NULL, "1992",
	"Dungeons & Dragons - Warriors of the Eternal Sun (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_ddwaresRomInfo, md_ddwaresRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dyna Brothers (Jpn)
static struct BurnRomInfo md_dynabrRomDesc[] = {
	{ "dyna brothers (jpn).bin", 0x100000, 0x360c1b20, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dynabr)
STD_ROM_FN(md_dynabr)

struct BurnDriver BurnDrvmd_dynabr = {
	"md_dynabr", NULL, NULL, NULL, "1992",
	"Dyna Brothers (Jpn)\0", NULL, "CRI", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dynabrRomInfo, md_dynabrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dyna Brothers 2 (Jpn)
static struct BurnRomInfo md_dynabr2RomDesc[] = {
	{ "dyna brothers 2 (jpn).bin", 0x200000, 0x47e0a64e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dynabr2)
STD_ROM_FN(md_dynabr2)

struct BurnDriver BurnDrvmd_dynabr2 = {
	"md_dynabr2", NULL, NULL, NULL, "1993",
	"Dyna Brothers 2 (Jpn)\0", NULL, "CRI", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dynabr2RomInfo, md_dynabr2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dyna Brothers 2 - Sega Channel Special (Jpn, Sega Channel)
static struct BurnRomInfo md_dynabr2spRomDesc[] = {
	{ "dyna brothers 2 - sega channel special (jpn).bin", 0x280000, 0xba3554bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dynabr2sp)
STD_ROM_FN(md_dynabr2sp)

struct BurnDriver BurnDrvmd_dynabr2sp = {
	"md_dynabr2sp", "md_dynabr2", NULL, NULL, "1991",
	"Dyna Brothers 2 - Sega Channel Special (Jpn, Sega Channel)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_dynabr2spRomInfo, md_dynabr2spRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Duke (World, Rev. A)
static struct BurnRomInfo md_dyndukeRomDesc[] = {
	{ "mpr-13438a.bin", 0x080000, 0x246f0bda, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dynduke)
STD_ROM_FN(md_dynduke)

struct BurnDriver BurnDrvmd_dynduke = {
	"md_dynduke", NULL, NULL, NULL, "1990",
	"Dynamite Duke (World, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dyndukeRomInfo, md_dyndukeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Duke (World)
static struct BurnRomInfo md_dynduke1RomDesc[] = {
	{ "mpr-13438.bin", 0x080000, 0x39d01c8c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dynduke1)
STD_ROM_FN(md_dynduke1)

struct BurnDriver BurnDrvmd_dynduke1 = {
	"md_dynduke1", "md_dynduke", NULL, NULL, "1990",
	"Dynamite Duke (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dynduke1RomInfo, md_dynduke1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Euro, USA)
static struct BurnRomInfo md_dheadRomDesc[] = {
	{ "mpr-16990.bin", 0x200000, 0x3dfeeb77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dhead)
STD_ROM_FN(md_dhead)

struct BurnDriver BurnDrvmd_dhead = {
	"md_dhead", NULL, NULL, NULL, "1994",
	"Dynamite Headdy (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadRomInfo, md_dheadRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Jpn)
static struct BurnRomInfo md_dheadjRomDesc[] = {
	{ "dynamite headdy (jpn).bin", 0x200000, 0xd03cdb53, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dheadj)
STD_ROM_FN(md_dheadj)

struct BurnDriver BurnDrvmd_dheadj = {
	"md_dheadj", "md_dhead", NULL, NULL, "1994",
	"Dynamite Headdy (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadjRomInfo, md_dheadjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Jpn, Prototype)
static struct BurnRomInfo md_dheadjpRomDesc[] = {
	{ "dynamite headdy (jpn) (beta).bin", 0x200000, 0x5c25e934, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dheadjp)
STD_ROM_FN(md_dheadjp)

struct BurnDriver BurnDrvmd_dheadjp = {
	"md_dheadjp", "md_dhead", NULL, NULL, "1994",
	"Dynamite Headdy (Jpn, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadjpRomInfo, md_dheadjpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype, 19940614-CABEZA)
static struct BurnRomInfo md_dheadp3RomDesc[] = {
	{ "dynamite headdy (prototype - jun 14, 1994 - cabeza).bin", 0x200000, 0x971ef24c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dheadp3)
STD_ROM_FN(md_dheadp3)

struct BurnDriver BurnDrvmd_dheadp3 = {
	"md_dheadp3", "md_dhead", NULL, NULL, "1994",
	"Dynamite Headdy (Prototype, 19940614-CABEZA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadp3RomInfo, md_dheadp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype, 19940616)
static struct BurnRomInfo md_dheadp2RomDesc[] = {
	{ "dynamite headdy (prototype - jun 16, 1994).bin", 0x200000, 0xf8a96719, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dheadp2)
STD_ROM_FN(md_dheadp2)

struct BurnDriver BurnDrvmd_dheadp2 = {
	"md_dheadp2", "md_dhead", NULL, NULL, "1994",
	"Dynamite Headdy (Prototype, 19940616)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadp2RomInfo, md_dheadp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype, 19940622)
static struct BurnRomInfo md_dheadp1RomDesc[] = {
	{ "dynamite headdy (prototype - jun 22, 1994).bin", 0x200000, 0x61001ec8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dheadp1)
STD_ROM_FN(md_dheadp1)

struct BurnDriver BurnDrvmd_dheadp1 = {
	"md_dheadp1", "md_dhead", NULL, NULL, "1994",
	"Dynamite Headdy (Prototype, 19940622)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dheadp1RomInfo, md_dheadp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Hockey (Euro)
static struct BurnRomInfo md_eahockeyRomDesc[] = {
	{ "ea hockey (euro).bin", 0x080000, 0x9bfc279c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eahockey)
STD_ROM_FN(md_eahockey)

struct BurnDriver BurnDrvmd_eahockey = {
	"md_eahockey", NULL, NULL, NULL, "1991",
	"EA Hockey (Euro)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eahockeyRomInfo, md_eahockeyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Hockey (Jpn)
static struct BurnRomInfo md_eahockeyjRomDesc[] = {
	{ "ea hockey (jpn).bin", 0x080000, 0x9dcdc894, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eahockeyj)
STD_ROM_FN(md_eahockeyj)

struct BurnDriver BurnDrvmd_eahockeyj = {
	"md_eahockeyj", "md_eahockey", NULL, NULL, "1992",
	"EA Hockey (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eahockeyjRomInfo, md_eahockeyjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL Hockey (USA)
static struct BurnRomInfo md_nhlhocRomDesc[] = {
	{ "nhl hockey (usa).bin", 0x080000, 0x2641653f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlhoc)
STD_ROM_FN(md_nhlhoc)

struct BurnDriver BurnDrvmd_nhlhoc = {
	"md_nhlhoc", NULL, NULL, NULL, "1991",
	"NHL Hockey (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlhocRomInfo, md_nhlhocRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Sports Double Header (Euro)
static struct BurnRomInfo md_easportsRomDesc[] = {
	{ "ea304.bin", 0x100000, 0xa0b54cbc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_easports)
STD_ROM_FN(md_easports)

struct BurnDriver BurnDrvmd_easports = {
	"md_easports", NULL, NULL, NULL, "1993",
	"EA Sports Double Header (Euro)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_easportsRomInfo, md_easportsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earnest Evans (USA)
static struct BurnRomInfo md_earnestRomDesc[] = {
	{ "earnest evans (usa).bin", 0x100000, 0xa243816d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_earnest)
STD_ROM_FN(md_earnest)

struct BurnDriver BurnDrvmd_earnest = {
	"md_earnest", NULL, NULL, NULL, "1992",
	"Earnest Evans (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_earnestRomInfo, md_earnestRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim (Euro)
static struct BurnRomInfo md_ejimRomDesc[] = {
	{ "earthworm jim (euro).bin", 0x300000, 0x1c07b337, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ejim)
STD_ROM_FN(md_ejim)

struct BurnDriver BurnDrvmd_ejim = {
	"md_ejim", NULL, NULL, NULL, "1994",
	"Earthworm Jim (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ejimRomInfo, md_ejimRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim (USA)
static struct BurnRomInfo md_ejimuRomDesc[] = {
	{ "earthworm jim (usa).bin", 0x300000, 0xdf3acf59, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ejimu)
STD_ROM_FN(md_ejimu)

struct BurnDriver BurnDrvmd_ejimu = {
	"md_ejimu", "md_ejim", NULL, NULL, "1994",
	"Earthworm Jim (USA)\0", NULL, "Playmates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ejimuRomInfo, md_ejimuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim 2 (Euro)
static struct BurnRomInfo md_ejim2RomDesc[] = {
	{ "earthworm jim 2 (euro).bin", 0x300000, 0xaf235fdf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ejim2)
STD_ROM_FN(md_ejim2)

struct BurnDriver BurnDrvmd_ejim2 = {
	"md_ejim2", NULL, NULL, NULL, "1995",
	"Earthworm Jim 2 (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ejim2RomInfo, md_ejim2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim 2 (USA)
static struct BurnRomInfo md_ejim2uRomDesc[] = {
	{ "earthworm jim 2 (usa).bin", 0x300000, 0xd57f8ba7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ejim2u)
STD_ROM_FN(md_ejim2u)

struct BurnDriver BurnDrvmd_ejim2u = {
	"md_ejim2u", "md_ejim2", NULL, NULL, "1996",
	"Earthworm Jim 2 (USA)\0", NULL, "Playmates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ejim2uRomInfo, md_ejim2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin (Euro, USA, Kor)
static struct BurnRomInfo md_eccoRomDesc[] = {
	{ "mpr-15265.bin", 0x100000, 0x45547390, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco)
STD_ROM_FN(md_ecco)

struct BurnDriver BurnDrvmd_ecco = {
	"md_ecco", NULL, NULL, NULL, "1993",
	"Ecco the Dolphin (Euro, USA, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eccoRomInfo, md_eccoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin (Jpn)
static struct BurnRomInfo md_eccojRomDesc[] = {
	{ "mpr-15702.bin", 0x100000, 0x6520304d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eccoj)
STD_ROM_FN(md_eccoj)

struct BurnDriver BurnDrvmd_eccoj = {
	"md_eccoj", "md_ecco", NULL, NULL, "1993",
	"Ecco the Dolphin (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eccojRomInfo, md_eccojRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Euro)
static struct BurnRomInfo md_ecco2RomDesc[] = {
	{ "ecco - the tides of time (euro).bin", 0x200000, 0x7b1bf89c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2)
STD_ROM_FN(md_ecco2)

struct BurnDriver BurnDrvmd_ecco2 = {
	"md_ecco2", NULL, NULL, NULL, "1994",
	"Ecco - The Tides of Time (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2RomInfo, md_ecco2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Prototype)
static struct BurnRomInfo md_ecco2pRomDesc[] = {
	{ "ecco - the tides of time (beta).bin", 0x200000, 0x8db60749, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2p)
STD_ROM_FN(md_ecco2p)

struct BurnDriver BurnDrvmd_ecco2p = {
	"md_ecco2p", "md_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2pRomInfo, md_ecco2pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Prototype, Alt)
static struct BurnRomInfo md_ecco2p1RomDesc[] = {
	{ "ecco - the tides of time (beta, alt).bin", 0x200000, 0x1d1470ea, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2p1)
STD_ROM_FN(md_ecco2p1)

struct BurnDriver BurnDrvmd_ecco2p1 = {
	"md_ecco2p1", "md_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (Prototype, Alt)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2p1RomInfo, md_ecco2p1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Prototype, 19940429)
static struct BurnRomInfo md_ecco2p2RomDesc[] = {
	{ "ecco ii - the tides of time (prototype - apr 29, 1994).bin", 0x200000, 0x5af83ecb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2p2)
STD_ROM_FN(md_ecco2p2)

struct BurnDriver BurnDrvmd_ecco2p2 = {
	"md_ecco2p2", "md_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (Prototype, 19940429)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2p2RomInfo, md_ecco2p2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin II (Jpn)
static struct BurnRomInfo md_ecco2jRomDesc[] = {
	{ "mpr-16996.bin", 0x200000, 0x062d439c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2j)
STD_ROM_FN(md_ecco2j)

struct BurnDriver BurnDrvmd_ecco2j = {
	"md_ecco2j", "md_ecco2", NULL, NULL, "1994",
	"Ecco the Dolphin II (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2jRomInfo, md_ecco2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Prototype X11, 19940413)
static struct BurnRomInfo md_ecco2px11RomDesc[] = {
	{ "ecco - the tides of time (prototype x11 - apr 13, 1994).bin", 0x200000, 0xb5d64817, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2px11)
STD_ROM_FN(md_ecco2px11)

struct BurnDriver BurnDrvmd_ecco2px11 = {
	"md_ecco2px11", "md_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (Prototype X11, 19940413)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2px11RomInfo, md_ecco2px11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (USA)
static struct BurnRomInfo md_ecco2uRomDesc[] = {
	{ "ecco - the tides of time (usa).bin", 0x200000, 0xccb21f98, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ecco2u)
STD_ROM_FN(md_ecco2u)

struct BurnDriver BurnDrvmd_ecco2u = {
	"md_ecco2u", "md_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ecco2uRomInfo, md_ecco2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco Jr. (USA, Oceania, 199502)
static struct BurnRomInfo md_eccojrRomDesc[] = {
	{ "ecco jr. (usa, aus) (february 1995).bin", 0x100000, 0x6c6f4b89, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eccojr)
STD_ROM_FN(md_eccojr)

struct BurnDriver BurnDrvmd_eccojr = {
	"md_eccojr", NULL, NULL, NULL, "1995",
	"Ecco Jr. (USA, Oceania, 199502)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eccojrRomInfo, md_eccojrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco Jr. (USA, Oceania, 199503)
static struct BurnRomInfo md_eccojr1RomDesc[] = {
	{ "ecco jr. (usa, aus) (march 1995).bin", 0x100000, 0x3c517975, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eccojr1)
STD_ROM_FN(md_eccojr1)

struct BurnDriver BurnDrvmd_eccojr1 = {
	"md_eccojr1", "md_eccojr", NULL, NULL, "1995",
	"Ecco Jr. (USA, Oceania, 199503)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eccojr1RomInfo, md_eccojr1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// El Viento (USA)
static struct BurnRomInfo md_elvientRomDesc[] = {
	{ "mpr-14336.bin", 0x100000, 0x070a1ceb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elvient)
STD_ROM_FN(md_elvient)

struct BurnDriver BurnDrvmd_elvient = {
	"md_elvient", NULL, NULL, NULL, "1991",
	"El Viento (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_elvientRomInfo, md_elvientRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// El Viento (Jpn)
static struct BurnRomInfo md_elvientjRomDesc[] = {
	{ "el viento (jpn).bin", 0x100000, 0x6091c36e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elvientj)
STD_ROM_FN(md_elvientj)

struct BurnDriver BurnDrvmd_elvientj = {
	"md_elvientj", "md_elvient", NULL, NULL, "1991",
	"El Viento (Jpn)\0", NULL, "Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_elvientjRomInfo, md_elvientjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elemental Master (USA)
static struct BurnRomInfo md_elemastRomDesc[] = {
	{ "elemental master (usa).bin", 0x080000, 0x390918c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elemast)
STD_ROM_FN(md_elemast)

struct BurnDriver BurnDrvmd_elemast = {
	"md_elemast", NULL, NULL, NULL, "1993",
	"Elemental Master (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_elemastRomInfo, md_elemastRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elemental Master (Jpn)
static struct BurnRomInfo md_elemastjRomDesc[] = {
	{ "elemental master (jpn).bin", 0x080000, 0x5f553e29, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elemastj)
STD_ROM_FN(md_elemastj)

struct BurnDriver BurnDrvmd_elemastj = {
	"md_elemastj", "md_elemast", NULL, NULL, "1990",
	"Elemental Master (Jpn)\0", NULL, "Technosoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_elemastjRomInfo, md_elemastjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eliminate Down (Jpn)
static struct BurnRomInfo md_elimdownRomDesc[] = {
	{ "eliminate down (jpn).bin", 0x100000, 0x48467542, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elimdown)
STD_ROM_FN(md_elimdown)

struct BurnDriver BurnDrvmd_elimdown = {
	"md_elimdown", NULL, NULL, NULL, "1993",
	"Eliminate Down (Jpn)\0", NULL, "Soft Vision", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_elimdownRomInfo, md_elimdownRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elitserien 95 (Swe)
static struct BurnRomInfo md_elit95RomDesc[] = {
	{ "swed9584.bin", 0x200000, 0xe10a25c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elit95)
STD_ROM_FN(md_elit95)

struct BurnDriver BurnDrvmd_elit95 = {
	"md_elit95", NULL, NULL, NULL, "1994",
	"Elitserien 95 (Swe)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_elit95RomInfo, md_elit95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elitserien 96 (Swe)
static struct BurnRomInfo md_elit96RomDesc[] = {
	{ "elitserien 96 (sweden).bin", 0x200000, 0x9821d0a3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_elit96)
STD_ROM_FN(md_elit96)

struct BurnDriver BurnDrvmd_elit96 = {
	"md_elit96", NULL, NULL, NULL, "1995",
	"Elitserien 96 (Swe)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_elit96RomInfo, md_elit96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Empire of Steel (Euro)
static struct BurnRomInfo md_empirestRomDesc[] = {
	{ "empire of steel (euro).bin", 0x100000, 0xe5517b77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_empirest)
STD_ROM_FN(md_empirest)

struct BurnDriver BurnDrvmd_empirest = {
	"md_empirest", NULL, NULL, NULL, "1992",
	"Empire of Steel (Euro)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_empirestRomInfo, md_empirestRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Steel Empire (USA)
static struct BurnRomInfo md_steelempRomDesc[] = {
	{ "steel empire (usa).bin", 0x100000, 0xd0e7a0b6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_steelemp)
STD_ROM_FN(md_steelemp)

struct BurnDriver BurnDrvmd_steelemp = {
	"md_steelemp", "md_empirest", NULL, NULL, "1992",
	"Steel Empire (USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_steelempRomInfo, md_steelempRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Koutetsu Teikoku (Jpn)
static struct BurnRomInfo md_koutetsuRomDesc[] = {
	{ "koutetsu teikoku (jpn).bin", 0x100000, 0x755d0b8a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_koutetsu)
STD_ROM_FN(md_koutetsu)

struct BurnDriver BurnDrvmd_koutetsu = {
	"md_koutetsu", "md_empirest", NULL, NULL, "1992",
	"Koutetsu Teikoku (Jpn)\0", NULL, "Hot-B", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_koutetsuRomInfo, md_koutetsuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Euro)
static struct BurnRomInfo md_tazemRomDesc[] = {
	{ "taz in escape from mars (euro).bin", 0x200000, 0x62100099, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazem)
STD_ROM_FN(md_tazem)

struct BurnDriver BurnDrvmd_tazem = {
	"md_tazem", NULL, NULL, NULL, "1994",
	"Taz in Escape from Mars (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemRomInfo, md_tazemRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940418)
static struct BurnRomInfo md_tazemp10RomDesc[] = {
	{ "taz in escape from mars (prototype - apr 18, 1994).bin", 0x200000, 0xbfa776ec, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp10)
STD_ROM_FN(md_tazemp10)

struct BurnDriver BurnDrvmd_tazemp10 = {
	"md_tazemp10", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940418)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp10RomInfo, md_tazemp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940602)
static struct BurnRomInfo md_tazemp06RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 02, 1994).bin", 0x200000, 0x39f345c2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp06)
STD_ROM_FN(md_tazemp06)

struct BurnDriver BurnDrvmd_tazemp06 = {
	"md_tazemp06", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940602)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp06RomInfo, md_tazemp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940607)
static struct BurnRomInfo md_tazemp05RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 07, 1994).bin", 0x200000, 0x3481e709, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp05)
STD_ROM_FN(md_tazemp05)

struct BurnDriver BurnDrvmd_tazemp05 = {
	"md_tazemp05", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940607)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp05RomInfo, md_tazemp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940610)
static struct BurnRomInfo md_tazemp04RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 10, 1994).bin", 0x200000, 0x832f4cb4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp04)
STD_ROM_FN(md_tazemp04)

struct BurnDriver BurnDrvmd_tazemp04 = {
	"md_tazemp04", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940610)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp04RomInfo, md_tazemp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940614)
static struct BurnRomInfo md_tazemp03RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 14, 1994).bin", 0x200000, 0x2badb65b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp03)
STD_ROM_FN(md_tazemp03)

struct BurnDriver BurnDrvmd_tazemp03 = {
	"md_tazemp03", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940614)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp03RomInfo, md_tazemp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940618-A)
static struct BurnRomInfo md_tazemp02RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 18, 1994 - a).bin", 0x200000, 0x3c4b1e9c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp02)
STD_ROM_FN(md_tazemp02)

struct BurnDriver BurnDrvmd_tazemp02 = {
	"md_tazemp02", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940618-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp02RomInfo, md_tazemp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940620)
static struct BurnRomInfo md_tazemp01RomDesc[] = {
	{ "taz in escape from mars (prototype - jun 20, 1994).bin", 0x200000, 0xf00f4203, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp01)
STD_ROM_FN(md_tazemp01)

struct BurnDriver BurnDrvmd_tazemp01 = {
	"md_tazemp01", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940620)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp01RomInfo, md_tazemp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940309)
static struct BurnRomInfo md_tazemp11RomDesc[] = {
	{ "taz in escape from mars (prototype - mar 09, 1994).bin", 0x1d9936, 0xe3c2271e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp11)
STD_ROM_FN(md_tazemp11)

struct BurnDriver BurnDrvmd_tazemp11 = {
	"md_tazemp11", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940309)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp11RomInfo, md_tazemp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940509)
static struct BurnRomInfo md_tazemp09RomDesc[] = {
	{ "taz in escape from mars (prototype - may 09, 1994).bin", 0x200000, 0x11727086, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp09)
STD_ROM_FN(md_tazemp09)

struct BurnDriver BurnDrvmd_tazemp09 = {
	"md_tazemp09", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940509)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp09RomInfo, md_tazemp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940518)
static struct BurnRomInfo md_tazemp08RomDesc[] = {
	{ "taz in escape from mars (prototype - may 18, 1994).bin", 0x0b9584, 0x6e2666de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp08)
STD_ROM_FN(md_tazemp08)

struct BurnDriver BurnDrvmd_tazemp08 = {
	"md_tazemp08", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940518)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp08RomInfo, md_tazemp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype, 19940523)
static struct BurnRomInfo md_tazemp07RomDesc[] = {
	{ "taz in escape from mars (prototype - may 23, 1994).bin", 0x200000, 0xea344fd2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemp07)
STD_ROM_FN(md_tazemp07)

struct BurnDriver BurnDrvmd_tazemp07 = {
	"md_tazemp07", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (Prototype, 19940523)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemp07RomInfo, md_tazemp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (USA)
static struct BurnRomInfo md_tazemuRomDesc[] = {
	{ "taz in escape from mars (usa).bin", 0x200000, 0x62009f8c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tazemu)
STD_ROM_FN(md_tazemu)

struct BurnDriver BurnDrvmd_tazemu = {
	"md_tazemu", "md_tazem", NULL, NULL, "1994",
	"Taz in Escape from Mars (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tazemuRomInfo, md_tazemuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Baseball Tonight (USA)
static struct BurnRomInfo md_espnbbRomDesc[] = {
	{ "espn baseball tonight (usa).bin", 0x200000, 0x96d8440c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_espnbb)
STD_ROM_FN(md_espnbb)

struct BurnDriver BurnDrvmd_espnbb = {
	"md_espnbb", NULL, NULL, NULL, "1995",
	"ESPN Baseball Tonight (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_espnbbRomInfo, md_espnbbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN National Hockey Night (USA)
static struct BurnRomInfo md_espnhnRomDesc[] = {
	{ "espn national hockey night (usa).bin", 0x200000, 0x1d08828c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_espnhn)
STD_ROM_FN(md_espnhn)

struct BurnDriver BurnDrvmd_espnhn = {
	"md_espnhn", NULL, NULL, NULL, "1994",
	"ESPN National Hockey Night (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_espnhnRomInfo, md_espnhnRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN National Hockey Night (USA, Prototype)
static struct BurnRomInfo md_espnhnpRomDesc[] = {
	{ "espn national hockey night (usa) (beta).bin", 0x200000, 0xa427814a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_espnhnp)
STD_ROM_FN(md_espnhnp)

struct BurnDriver BurnDrvmd_espnhnp = {
	"md_espnhnp", "md_espnhn", NULL, NULL, "1994",
	"ESPN National Hockey Night (USA, Prototype)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_espnhnpRomInfo, md_espnhnpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Speed World (USA)
static struct BurnRomInfo md_espnspRomDesc[] = {
	{ "espn speed world (usa).bin", 0x200000, 0xf50be478, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_espnsp)
STD_ROM_FN(md_espnsp)

struct BurnDriver BurnDrvmd_espnsp = {
	"md_espnsp", NULL, NULL, NULL, "1994",
	"ESPN Speed World (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_espnspRomInfo, md_espnspRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Sunday Night NFL (USA)
static struct BurnRomInfo md_espnnflRomDesc[] = {
	{ "espn sunday night nfl (usa).bin", 0x200000, 0x61e9c309, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_espnnfl)
STD_ROM_FN(md_espnnfl)

struct BurnDriver BurnDrvmd_espnnfl = {
	"md_espnnfl", NULL, NULL, NULL, "1994",
	"ESPN Sunday Night NFL (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_espnnflRomInfo, md_espnnflRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyber Police ESWAT (Jpn, Rev. 0)
static struct BurnRomInfo md_eswatjRomDesc[] = {
	{ "mpr-13192.bin", 0x080000, 0x87b636a2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eswatj)
STD_ROM_FN(md_eswatj)

struct BurnDriver BurnDrvmd_eswatj = {
	"md_eswatj", "md_eswat", NULL, NULL, "1990",
	"Cyber Police ESWAT (Jpn, Rev. 0)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eswatjRomInfo, md_eswatjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Euro)
static struct BurnRomInfo md_eternalcRomDesc[] = {
	{ "mpr-16212+mpr-16213.bin", 0x300000, 0xb9512f5e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eternalc)
STD_ROM_FN(md_eternalc)

struct BurnDriver BurnDrvmd_eternalc = {
	"md_eternalc", NULL, NULL, NULL, "1994",
	"Eternal Champions (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eternalcRomInfo, md_eternalcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Euro, Prototype)
static struct BurnRomInfo md_eternalcbRomDesc[] = {
	{ "eternal champions (euro) (beta).bin", 0x300000, 0xe0665f06, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eternalcb)
STD_ROM_FN(md_eternalcb)

struct BurnDriver BurnDrvmd_eternalcb = {
	"md_eternalcb", "md_eternalc", NULL, NULL, "1994",
	"Eternal Champions (Euro, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eternalcbRomInfo, md_eternalcbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Jpn, Kor)
static struct BurnRomInfo md_eternalcjRomDesc[] = {
	{ "eternal champions (jpn, kor).bin", 0x300000, 0x66aa3c64, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eternalcj)
STD_ROM_FN(md_eternalcj)

struct BurnDriver BurnDrvmd_eternalcj = {
	"md_eternalcj", "md_eternalc", NULL, NULL, "1994",
	"Eternal Champions (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eternalcjRomInfo, md_eternalcjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Jpn, Prototype, 19931117)
static struct BurnRomInfo md_eternalcjpRomDesc[] = {
	{ "eternal champions (jpn) (prototype - nov 17, 1993).bin", 0x2ff4b0, 0xc486b439, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eternalcjp)
STD_ROM_FN(md_eternalcjp)

struct BurnDriver BurnDrvmd_eternalcjp = {
	"md_eternalcjp", "md_eternalc", NULL, NULL, "1994",
	"Eternal Champions (Jpn, Prototype, 19931117)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eternalcjpRomInfo, md_eternalcjpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (USA)
static struct BurnRomInfo md_eternalcuRomDesc[] = {
	{ "eternal champions (usa).bin", 0x300000, 0x48f1a42e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_eternalcu)
STD_ROM_FN(md_eternalcu)

struct BurnDriver BurnDrvmd_eternalcu = {
	"md_eternalcu", "md_eternalc", NULL, NULL, "1994",
	"Eternal Champions (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_eternalcuRomInfo, md_eternalcuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// European Club Soccer (Euro)
static struct BurnRomInfo md_euroclubRomDesc[] = {
	{ "mpr-14776.bin", 0x080000, 0x6a5cf104, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_euroclub)
STD_ROM_FN(md_euroclub)

struct BurnDriver BurnDrvmd_euroclub = {
	"md_euroclub", NULL, NULL, NULL, "1992",
	"European Club Soccer (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_euroclubRomInfo, md_euroclubRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// World Trophy Soccer (USA)
static struct BurnRomInfo md_worldtsRomDesc[] = {
	{ "world trophy soccer (usa).bin", 0x080000, 0x6e3edc7c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_worldts)
STD_ROM_FN(md_worldts)

struct BurnDriver BurnDrvmd_worldts = {
	"md_worldts", "md_euroclub", NULL, NULL, "1992",
	"World Trophy Soccer (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_worldtsRomInfo, md_worldtsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Champion Soccer (Jpn)
static struct BurnRomInfo md_jlcsRomDesc[] = {
	{ "j. league champion soccer (jpn).bin", 0x080000, 0x453c405e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jlcs)
STD_ROM_FN(md_jlcs)

struct BurnDriver BurnDrvmd_jlcs = {
	"md_jlcs", "md_euroclub", NULL, NULL, "1993",
	"J. League Champion Soccer (Jpn)\0", NULL, "Game Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jlcsRomInfo, md_jlcsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exile (USA)
static struct BurnRomInfo md_exileRomDesc[] = {
	{ "exile (usa).bin", 0x100000, 0x1b569dc2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exile)
STD_ROM_FN(md_exile)

struct BurnDriver BurnDrvmd_exile = {
	"md_exile", NULL, NULL, NULL, "1991",
	"Exile (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_exileRomInfo, md_exileRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exile - Toki no Hazama e (Jpn)
static struct BurnRomInfo md_exilejRomDesc[] = {
	{ "exile - toki no hazama e (jpn).bin", 0x100000, 0x880bf311, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exilej)
STD_ROM_FN(md_exilej)

struct BurnDriver BurnDrvmd_exilej = {
	"md_exilej", "md_exile", NULL, NULL, "1991",
	"Exile - Toki no Hazama e (Jpn)\0", NULL, "Riot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_exilejRomInfo, md_exilejRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (Euro)
static struct BurnRomInfo md_exosqRomDesc[] = {
	{ "exo squad (euro).bin", 0x100000, 0xb599b9f9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exosq)
STD_ROM_FN(md_exosq)

struct BurnDriver BurnDrvmd_exosq = {
	"md_exosq", NULL, NULL, NULL, "1995",
	"Exo Squad (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_exosqRomInfo, md_exosqRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (USA)
static struct BurnRomInfo md_exosquRomDesc[] = {
	{ "exo squad (usa).bin", 0x100000, 0x10ec03f3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exosqu)
STD_ROM_FN(md_exosqu)

struct BurnDriver BurnDrvmd_exosqu = {
	"md_exosqu", "md_exosq", NULL, NULL, "1995",
	"Exo Squad (USA)\0", NULL, "Playmates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_exosquRomInfo, md_exosquRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (USA, Prototype)
static struct BurnRomInfo md_exosqupRomDesc[] = {
	{ "exo squad (usa) (beta).bin", 0x100000, 0x70edf964, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exosqup)
STD_ROM_FN(md_exosqup)

struct BurnDriver BurnDrvmd_exosqup = {
	"md_exosqup", "md_exosq", NULL, NULL, "1995",
	"Exo Squad (USA, Prototype)\0", NULL, "Playmates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_exosqupRomInfo, md_exosqupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exodus - Journey to the Promised Land (USA)
static struct BurnRomInfo md_exodusRomDesc[] = {
	{ "exodus - journey to the promised land (usa) (unl).bin", 0x080000, 0x22e6fc04, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_exodus)
STD_ROM_FN(md_exodus)

struct BurnDriver BurnDrvmd_exodus = {
	"md_exodus", NULL, NULL, NULL, "1993",
	"Exodus - Journey to the Promised Land (USA)\0", NULL, "Wisdom Tree", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_exodusRomInfo, md_exodusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-117 Night Storm (Euro, USA)
static struct BurnRomInfo md_f117RomDesc[] = {
	{ "f-117 night storm (euro, usa).bin", 0x200000, 0x1bf67a07, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f117)
STD_ROM_FN(md_f117)

struct BurnDriver BurnDrvmd_f117 = {
	"md_f117", NULL, NULL, NULL, "1993",
	"F-117 Night Storm (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f117RomInfo, md_f117RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-117 Stealth - Operation Night Storm (Jpn)
static struct BurnRomInfo md_f117jRomDesc[] = {
	{ "f-117 stealth - operation night storm (jpn).bin", 0x200000, 0xea6e421a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f117j)
STD_ROM_FN(md_f117j)

struct BurnDriver BurnDrvmd_f117j = {
	"md_f117j", "md_f117", NULL, NULL, "1994",
	"F-117 Stealth - Operation Night Storm (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f117jRomInfo, md_f117jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (Euro)
static struct BurnRomInfo md_f15strRomDesc[] = {
	{ "f-15 strike eagle ii (euro).bin", 0x100000, 0xe98ee370, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f15str)
STD_ROM_FN(md_f15str)

struct BurnDriver BurnDrvmd_f15str = {
	"md_f15str", NULL, NULL, NULL, "1993",
	"F-15 Strike Eagle II (Euro)\0", NULL, "Microprose", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f15strRomInfo, md_f15strRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (USA)
static struct BurnRomInfo md_f15struRomDesc[] = {
	{ "f-15 strike eagle ii (usa).bin", 0x100000, 0x412c4d60, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f15stru)
STD_ROM_FN(md_f15stru)

struct BurnDriver BurnDrvmd_f15stru = {
	"md_f15stru", "md_f15str", NULL, NULL, "1993",
	"F-15 Strike Eagle II (USA)\0", NULL, "Microprose", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f15struRomInfo, md_f15struRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (USA, Prototype)
static struct BurnRomInfo md_f15strupRomDesc[] = {
	{ "f-15 strike eagle ii (usa) (beta).bin", 0x100000, 0xfd4f5a01, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f15strup)
STD_ROM_FN(md_f15strup)

struct BurnDriver BurnDrvmd_f15strup = {
	"md_f15strup", "md_f15str", NULL, NULL, "1993",
	"F-15 Strike Eagle II (USA, Prototype)\0", NULL, "Microprose", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f15strupRomInfo, md_f15strupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (Euro, USA, 199206)
static struct BurnRomInfo md_f22RomDesc[] = {
	{ "f-22 interceptor (euro, usa) (june 1992).bin", 0x0c0000, 0xdd19b2b3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f22)
STD_ROM_FN(md_f22)

struct BurnDriver BurnDrvmd_f22 = {
	"md_f22", NULL, NULL, NULL, "1991",
	"F-22 Interceptor (Euro, USA, 199206)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f22RomInfo, md_f22RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (Euro, USA, Prototype)
static struct BurnRomInfo md_f22pRomDesc[] = {
	{ "f-22 interceptor (euro, usa) (beta).bin", 0x0c0000, 0xd6a880a4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f22p)
STD_ROM_FN(md_f22p)

struct BurnDriver BurnDrvmd_f22p = {
	"md_f22p", "md_f22", NULL, NULL, "1991",
	"F-22 Interceptor (Euro, USA, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f22pRomInfo, md_f22pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (Jpn)
static struct BurnRomInfo md_f22jRomDesc[] = {
	{ "f-22 interceptor (jpn).bin", 0x0c0000, 0xfb55c785, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f22j)
STD_ROM_FN(md_f22j)

struct BurnDriver BurnDrvmd_f22j = {
	"md_f22j", "md_f22", NULL, NULL, "1993",
	"F-22 Interceptor (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f22jRomInfo, md_f22jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 (Euro)
static struct BurnRomInfo md_f1RomDesc[] = {
	{ "mpr-15834.bin", 0x100000, 0xfbdd4520, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f1)
STD_ROM_FN(md_f1)

struct BurnDriver BurnDrvmd_f1 = {
	"md_f1", NULL, NULL, NULL, "1993",
	"F1 (Euro)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_f1RomInfo, md_f1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Formula One (USA)
static struct BurnRomInfo md_formula1RomDesc[] = {
	{ "formula one (usa).bin", 0x100000, 0xccd73738, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_formula1)
STD_ROM_FN(md_formula1)

struct BurnDriver BurnDrvmd_formula1 = {
	"md_formula1", "md_f1", NULL, NULL, "1993",
	"Formula One (USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_formula1RomInfo, md_formula1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 - World Championship Edition (Euro)
static struct BurnRomInfo md_f1wcRomDesc[] = {
	{ "f1 - world championship edition (euro).bin", 0x200000, 0x74cee0a7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f1wc)
STD_ROM_FN(md_f1wc)

struct BurnDriver BurnDrvmd_f1wc = {
	"md_f1wc", NULL, NULL, NULL, "1993",
	"F1 - World Championship Edition (Euro)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f1wcRomInfo, md_f1wcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 - World Championship Edition (Euro, Prototype)
static struct BurnRomInfo md_f1wcpRomDesc[] = {
	{ "f1 - world championship edition (euro) (beta).bin", 0x200000, 0x2269ed6b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f1wcp)
STD_ROM_FN(md_f1wcp)

struct BurnDriver BurnDrvmd_f1wcp = {
	"md_f1wcp", "md_f1wc", NULL, NULL, "1993",
	"F1 - World Championship Edition (Euro, Prototype)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_f1wcpRomInfo, md_f1wcpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 Circus MD (Jpn)
static struct BurnRomInfo md_f1circusRomDesc[] = {
	{ "f1 circus md (jpn).bin", 0x080000, 0x5d30befb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_f1circus)
STD_ROM_FN(md_f1circus)

struct BurnDriver BurnDrvmd_f1circus = {
	"md_f1circus", NULL, NULL, NULL, "1991",
	"F1 Circus MD (Jpn)\0", NULL, "Nichibutsu", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_f1circusRomInfo, md_f1circusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Faery Tale Adventure (Euro, USA)
static struct BurnRomInfo md_faerytalRomDesc[] = {
	{ "faery tale adventure, the (euro, usa).bin", 0x080000, 0x963f4969, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_faerytal)
STD_ROM_FN(md_faerytal)

struct BurnDriver BurnDrvmd_faerytal = {
	"md_faerytal", NULL, NULL, NULL, "1991",
	"The Faery Tale Adventure (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_faerytalRomInfo, md_faerytalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Family Feud (USA)
static struct BurnRomInfo md_famfeudRomDesc[] = {
	{ "family feud (usa).bin", 0x080000, 0x1aa628b0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_famfeud)
STD_ROM_FN(md_famfeud)

struct BurnDriver BurnDrvmd_famfeud = {
	"md_famfeud", NULL, NULL, NULL, "1993",
	"Family Feud (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_famfeudRomInfo, md_famfeudRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantasia (World, Rev. A)
static struct BurnRomInfo md_fantasiaRomDesc[] = {
	{ "mpr-14028a.bin", 0x080000, 0xfc43df2d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fantasia)
STD_ROM_FN(md_fantasia)

struct BurnDriver BurnDrvmd_fantasia = {
	"md_fantasia", NULL, NULL, NULL, "1991",
	"Fantasia (World, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fantasiaRomInfo, md_fantasiaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantasia (World)
static struct BurnRomInfo md_fantasia1RomDesc[] = {
	{ "mpr-14028.bin", 0x080000, 0xd351b242, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fantasia1)
STD_ROM_FN(md_fantasia1)

struct BurnDriver BurnDrvmd_fantasia1 = {
	"md_fantasia1", "md_fantasia", NULL, NULL, "1991",
	"Fantasia (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fantasia1RomInfo, md_fantasia1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantastic Dizzy (Euro, USA)
static struct BurnRomInfo md_fantdizRomDesc[] = {
	{ "fantastic dizzy (euro, usa).bin", 0x080000, 0x46447e7a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fantdiz)
STD_ROM_FN(md_fantdiz)

struct BurnDriver BurnDrvmd_fantdiz = {
	"md_fantdiz", NULL, NULL, NULL, "1991",
	"Fantastic Dizzy (Euro, USA)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fantdizRomInfo, md_fantdizRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantastic Dizzy (Euro, USA, Alt)
static struct BurnRomInfo md_fantdiz1RomDesc[] = {
	{ "fantastic dizzy (euro, usa) (alt).bin", 0x080000, 0x86b2a235, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fantdiz1)
STD_ROM_FN(md_fantdiz1)

struct BurnDriver BurnDrvmd_fantdiz1 = {
	"md_fantdiz1", "md_fantdiz", NULL, NULL, "1991",
	"Fantastic Dizzy (Euro, USA, Alt)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fantdiz1RomInfo, md_fantdiz1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fastest 1 (Jpn)
static struct BurnRomInfo md_fastest1RomDesc[] = {
	{ "fastest 1 (jpn).bin", 0x080000, 0xbb43f0de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fastest1)
STD_ROM_FN(md_fastest1)

struct BurnDriver BurnDrvmd_fastest1 = {
	"md_fastest1", NULL, NULL, NULL, "1991",
	"Fastest 1 (Jpn)\0", NULL, "Human Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fastest1RomInfo, md_fastest1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury (Euro, Kor)
static struct BurnRomInfo md_fatfuryRomDesc[] = {
	{ "fatal fury (euro, kor).bin", 0x180000, 0x2e730a91, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fatfury)
STD_ROM_FN(md_fatfury)

struct BurnDriver BurnDrvmd_fatfury = {
	"md_fatfury", NULL, NULL, NULL, "1993",
	"Fatal Fury (Euro, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fatfuryRomInfo, md_fatfuryRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury (USA)
static struct BurnRomInfo md_fatfuryuRomDesc[] = {
	{ "fatal fury (usa).bin", 0x180000, 0x98d49170, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fatfuryu)
STD_ROM_FN(md_fatfuryu)

struct BurnDriver BurnDrvmd_fatfuryu = {
	"md_fatfuryu", "md_fatfury", NULL, NULL, "1993",
	"Fatal Fury (USA)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fatfuryuRomInfo, md_fatfuryuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garou Densetsu - Shukumei no Tatakai (Jpn)
static struct BurnRomInfo md_garouRomDesc[] = {
	{ "garou densetsu - shukumei no tatakai (jpn).bin", 0x180000, 0xbf3e3fa4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_garou)
STD_ROM_FN(md_garou)

struct BurnDriver BurnDrvmd_garou = {
	"md_garou", "md_fatfury", NULL, NULL, "1993",
	"Garou Densetsu - Shukumei no Tatakai (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_garouRomInfo, md_garouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury 2 (USA, Kor)
static struct BurnRomInfo md_fatfury2RomDesc[] = {
	{ "fatal fury 2 (usa, kor).bin", 0x300000, 0x1b1754cb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fatfury2)
STD_ROM_FN(md_fatfury2)

struct BurnDriver BurnDrvmd_fatfury2 = {
	"md_fatfury2", NULL, NULL, NULL, "1994",
	"Fatal Fury 2 (USA, Kor)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fatfury2RomInfo, md_fatfury2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garou Densetsu 2 - Aratanaru Tatakai (Jpn)
static struct BurnRomInfo md_garou2RomDesc[] = {
	{ "mpr-16704+mpr-16710.bin", 0x300000, 0x2af4427f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_garou2)
STD_ROM_FN(md_garou2)

struct BurnDriver BurnDrvmd_garou2 = {
	"md_garou2", "md_fatfury2", NULL, NULL, "1994",
	"Garou Densetsu 2 - Aratanaru Tatakai (Jpn)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_garou2RomInfo, md_garou2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Labyrinth (Euro, USA)
static struct BurnRomInfo md_fatallabRomDesc[] = {
	{ "fatal labyrinth (euro, usa).bin", 0x020000, 0x5f0bd984, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fatallab)
STD_ROM_FN(md_fatallab)

struct BurnDriver BurnDrvmd_fatallab = {
	"md_fatallab", NULL, NULL, NULL, "1991",
	"Fatal Labyrinth (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fatallabRomInfo, md_fatallabRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Shi no Meikyuu - Labyrinth of Death (Jpn, SegaNet)
static struct BurnRomInfo md_labdeathRomDesc[] = {
	{ "shi no meikyuu - labyrinth of death (jpn) (sn).bin", 0x040000, 0xa6d7e02d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_labdeath)
STD_ROM_FN(md_labdeath)

struct BurnDriver BurnDrvmd_labdeath = {
	"md_labdeath", "md_fatallab", NULL, NULL, "1991",
	"Shi no Meikyuu - Labyrinth of Death (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_labdeathRomInfo, md_labdeathRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Shi no Meikyuu - Labyrinth of Death (Jpn, Game no Kandume MegaCD Rip)
static struct BurnRomInfo md_labdeathgnkRomDesc[] = {
	{ "shi no meikyuu - labyrinth of death (jpn) (gnk).bin", 0x020000, 0x40c44cd3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_labdeathgnk)
STD_ROM_FN(md_labdeathgnk)

struct BurnDriver BurnDrvmd_labdeathgnk = {
	"md_labdeathgnk", "md_fatallab", NULL, NULL, "1991",
	"Shi no Meikyuu - Labyrinth of Death (Jpn, Game no Kandume MegaCD Rip)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_labdeathgnkRomInfo, md_labdeathgnkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Rewind (Euro, USA)
static struct BurnRomInfo md_fatalrewRomDesc[] = {
	{ "fatal rewind (euro, usa).bin", 0x080000, 0xe91aed05, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fatalrew)
STD_ROM_FN(md_fatalrew)

struct BurnDriver BurnDrvmd_fatalrew = {
	"md_fatalrew", NULL, NULL, NULL, "1991",
	"Fatal Rewind (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fatalrewRomInfo, md_fatalrewRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Killing Game Show (Jpn)
static struct BurnRomInfo md_killshowRomDesc[] = {
	{ "killing game show, the (jpn).bin", 0x100000, 0xb8e7668a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_killshow)
STD_ROM_FN(md_killshow)

struct BurnDriver BurnDrvmd_killshow = {
	"md_killshow", "md_fatalrew", NULL, NULL, "1993",
	"The Killing Game Show (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_killshowRomInfo, md_killshowRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Feng Kuang Tao Hua Yuan (Chi)
static struct BurnRomInfo md_fengkuRomDesc[] = {
	{ "feng kuang tao hua yuan (chi) (unl).bin", 0x100000, 0x8d40d64f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fengku)
STD_ROM_FN(md_fengku)

struct BurnDriver BurnDrvmd_fengku = {
	"md_fengku", NULL, NULL, NULL, "199?",
	"Feng Kuang Tao Hua Yuan (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fengkuRomInfo, md_fengkuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Feng Shen Ying Jie Chuan (Chi)
static struct BurnRomInfo md_fengshRomDesc[] = {
	{ "feng shen ying jie chuan (chi) (unl).bin", 0x200000, 0x6a382b60, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fengsh)
STD_ROM_FN(md_fengsh)

struct BurnDriver BurnDrvmd_fengsh = {
	"md_fengsh", NULL, NULL, NULL, "1996",
	"Feng Shen Ying Jie Chuan (Chi)\0", NULL, "Chuanpu Technologies", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fengshRomInfo, md_fengshRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Feng Shen Ying Jie Zhuan (Chi, Alt?)
static struct BurnRomInfo md_fengshaRomDesc[] = {
	{ "unknown chinese game 1 (chi).bin", 0x200000, 0xdfacb9ff, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fengsha)
STD_ROM_FN(md_fengsha)

struct BurnDriver BurnDrvmd_fengsha = {
	"md_fengsha", "md_fengsh", NULL, NULL, "1996",
	"Feng Shen Ying Jie Zhuan (Chi, Alt?)\0", NULL, "Chuanpu Technologies", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fengshaRomInfo, md_fengshaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Frias Frustradas do Pica-Pau (Bra)
static struct BurnRomInfo md_feriasRomDesc[] = {
	{ "ferias frustradas do pica-pau (bra).bin", 0x100000, 0x7b2e416d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ferias)
STD_ROM_FN(md_ferias)

struct BurnDriver BurnDrvmd_ferias = {
	"md_ferias", NULL, NULL, NULL, "1995",
	"Ferias Frustradas do Pica-Pau (Bra)\0", NULL, "Tec Toy", "Sega Megadrive",
	L"F\u00e9rias Frustradas do Pica-Pau (Bra)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_feriasRomInfo, md_feriasRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (Prototype)
static struct BurnRomInfo md_ferraripRomDesc[] = {
	{ "ferrari grand prix challenge (beta).bin", 0x100000, 0xd48d02d4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ferrarip)
STD_ROM_FN(md_ferrarip)

struct BurnDriver BurnDrvmd_ferrarip = {
	"md_ferrarip", "md_ferrari", NULL, NULL, "1992",
	"Ferrari Grand Prix Challenge (Prototype)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ferraripRomInfo, md_ferraripRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (USA)
static struct BurnRomInfo md_ferrariuRomDesc[] = {
	{ "ferrari grand prix challenge (usa).bin", 0x100000, 0xf73f6bec, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ferrariu)
STD_ROM_FN(md_ferrariu)

struct BurnDriver BurnDrvmd_ferrariu = {
	"md_ferrariu", "md_ferrari", NULL, NULL, "1992",
	"Ferrari Grand Prix Challenge (USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ferrariuRomInfo, md_ferrariuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fever Pitch Soccer (Euro)
static struct BurnRomInfo md_feverpRomDesc[] = {
	{ "fever pitch soccer (euro).bin", 0x200000, 0xfac29677, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_feverp)
STD_ROM_FN(md_feverp)

struct BurnDriver BurnDrvmd_feverp = {
	"md_feverp", NULL, NULL, NULL, "1995",
	"Fever Pitch Soccer (Euro)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_feverpRomInfo, md_feverpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Head-On Soccer (USA)
static struct BurnRomInfo md_headonRomDesc[] = {
	{ "head-on soccer (usa).bin", 0x200000, 0xdcffa327, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_headon)
STD_ROM_FN(md_headon)

struct BurnDriver BurnDrvmd_headon = {
	"md_headon", "md_feverp", NULL, NULL, "1995",
	"Head-On Soccer (USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_headonRomInfo, md_headonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fido Dido (USA, Prototype)
static struct BurnRomInfo md_fidodidoRomDesc[] = {
	{ "fido dido (usa) (prototype).bin", 0x100000, 0xc6d4a240, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fidodido)
STD_ROM_FN(md_fidodido)

struct BurnDriver BurnDrvmd_fidodido = {
	"md_fidodido", NULL, NULL, NULL, "1994",
	"Fido Dido (USA, Prototype)\0", NULL, "Kaneko", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fidodidoRomInfo, md_fidodidoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA International Soccer (Euro, USA)
static struct BurnRomInfo md_fifaRomDesc[] = {
	{ "soccer10.bin", 0x200000, 0xbddbb763, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa)
STD_ROM_FN(md_fifa)

struct BurnDriver BurnDrvmd_fifa = {
	"md_fifa", NULL, NULL, NULL, "1994",
	"FIFA International Soccer (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fifaRomInfo, md_fifaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 95 (Euro, USA)
static struct BurnRomInfo md_fifa95RomDesc[] = {
	{ "fifa95b1.bin", 0x200000, 0xb389d036, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa95)
STD_ROM_FN(md_fifa95)

struct BurnDriver BurnDrvmd_fifa95 = {
	"md_fifa95", NULL, NULL, NULL, "1994",
	"FIFA Soccer 95 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa95RomInfo, md_fifa95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Futbol Argentino 98 - Pasion de Multitudes (Pirate)
static struct BurnRomInfo md_futbolRomDesc[] = {
	{ "futbol argentino 98 - pasion de multitudes (unl).bin", 0x200000, 0x5c015888, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_futbol)
STD_ROM_FN(md_futbol)

struct BurnDriver BurnDrvmd_futbol = {
	"md_futbol", "md_fifa95", NULL, NULL, "199?",
	"Futbol Argentino 98 - Pasion de Multitudes (Pirate)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_futbolRomInfo, md_futbolRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 96 (Euro, USA)
static struct BurnRomInfo md_fifa96RomDesc[] = {
	{ "fifa01.bin", 0x200000, 0xbad30ffa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa96)
STD_ROM_FN(md_fifa96)

struct BurnDriver BurnDrvmd_fifa96 = {
	"md_fifa96", NULL, NULL, NULL, "1995",
	"FIFA Soccer 96 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa96RomInfo, md_fifa96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 99 (Pirate)
static struct BurnRomInfo md_fifa99RomDesc[] = {
	{ "fifa soccer 99 (pirate) (unl).bin", 0x200000, 0xc5c5a4b0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa99)
STD_ROM_FN(md_fifa99)

struct BurnDriver BurnDrvmd_fifa99 = {
	"md_fifa99", "md_fifa96", NULL, NULL, "199?",
	"FIFA Soccer 99 (Pirate)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa99RomInfo, md_fifa99RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 2000 Gold Edition (Pirate)
static struct BurnRomInfo md_fifa2kRomDesc[] = {
	{ "fifa soccer 2000 gold edition (pirate) (unl).bin", 0x200000, 0x647df504, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa2k)
STD_ROM_FN(md_fifa2k)

struct BurnDriver BurnDrvmd_fifa2k = {
	"md_fifa2k", "md_fifa97", NULL, NULL, "199?",
	"FIFA Soccer 2000 Gold Edition (Pirate)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa2kRomInfo, md_fifa2kRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA 98 - Road to World Cup (Euro)
static struct BurnRomInfo md_fifa98RomDesc[] = {
	{ "fifa 98 - road to world cup (euro).bin", 0x200000, 0x96947f57, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fifa98)
STD_ROM_FN(md_fifa98)

struct BurnDriver BurnDrvmd_fifa98 = {
	"md_fifa98", NULL, NULL, NULL, "1997",
	"FIFA 98 - Road to World Cup (Euro)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_fifa98RomInfo, md_fifa98RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fighting Masters (USA)
static struct BurnRomInfo md_fightmRomDesc[] = {
	{ "fighting masters (usa).bin", 0x080000, 0x5f51983b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fightm)
STD_ROM_FN(md_fightm)

struct BurnDriver BurnDrvmd_fightm = {
	"md_fightm", NULL, NULL, NULL, "1992",
	"Fighting Masters (USA)\0", NULL, "Treco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fightmRomInfo, md_fightmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fighting Masters (Jpn, Kor)
static struct BurnRomInfo md_fightmjRomDesc[] = {
	{ "fighting masters (jpn, kor).bin", 0x080000, 0x39be80ec, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fightmj)
STD_ROM_FN(md_fightmj)

struct BurnDriver BurnDrvmd_fightmj = {
	"md_fightmj", "md_fightm", NULL, NULL, "1991",
	"Fighting Masters (Jpn, Kor)\0", NULL, "Treco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fightmjRomInfo, md_fightmjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Final Zone (USA) ~ FZ Senki Axis (Jpn)
static struct BurnRomInfo md_finalzonRomDesc[] = {
	{ "final zone -- fz senki axis (usa, jpn).bin", 0x080000, 0x731fa4a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_finalzon)
STD_ROM_FN(md_finalzon)

struct BurnDriver BurnDrvmd_finalzon = {
	"md_finalzon", NULL, NULL, NULL, "1990",
	"Final Zone (USA) ~ FZ Senki Axis (Jpn)\0", NULL, "Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_finalzonRomInfo, md_finalzonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Mustang (Jpn)
static struct BurnRomInfo md_firemustRomDesc[] = {
	{ "fire mustang (jpn).bin", 0x080000, 0xeb7e36c3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_firemust)
STD_ROM_FN(md_firemust)

struct BurnDriver BurnDrvmd_firemust = {
	"md_firemust", NULL, NULL, NULL, "1991",
	"Fire Mustang (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_firemustRomInfo, md_firemustRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (Euro)
static struct BurnRomInfo md_fireshrkRomDesc[] = {
	{ "mpr-14341.bin", 0x080000, 0x2351ce61, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fireshrk)
STD_ROM_FN(md_fireshrk)

struct BurnDriver BurnDrvmd_fireshrk = {
	"md_fireshrk", NULL, NULL, NULL, "1991",
	"Fire Shark (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fireshrkRomInfo, md_fireshrkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (USA)
static struct BurnRomInfo md_fireshrkuRomDesc[] = {
	{ "fire shark (usa).bin", 0x080000, 0x570b5024, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fireshrku)
STD_ROM_FN(md_fireshrku)

struct BurnDriver BurnDrvmd_fireshrku = {
	"md_fireshrku", "md_fireshrk", NULL, NULL, "1990",
	"Fire Shark (USA)\0", NULL, "Dreamworks Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fireshrkuRomInfo, md_fireshrkuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (USA, Alt)
static struct BurnRomInfo md_fireshrku1RomDesc[] = {
	{ "fire shark (usa) (alt).bin", 0x080000, 0x9c175146, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_fireshrku1)
STD_ROM_FN(md_fireshrku1)

struct BurnDriver BurnDrvmd_fireshrku1 = {
	"md_fireshrku1", "md_fireshrk", NULL, NULL, "1990",
	"Fire Shark (USA, Alt)\0", NULL, "Dreamworks Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_fireshrku1RomInfo, md_fireshrku1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Same! Same! Same! (Jpn)
static struct BurnRomInfo md_samesameRomDesc[] = {
	{ "mpr-13301.bin", 0x080000, 0x77bbd841, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_samesame)
STD_ROM_FN(md_samesame)

struct BurnDriver BurnDrvmd_samesame = {
	"md_samesame", "md_fireshrk", NULL, NULL, "1990",
	"Same! Same! Same! (Jpn)\0", NULL, "Toaplan", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_samesameRomInfo, md_samesameRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback (Euro, Rev. A)
static struct BurnRomInfo md_flashbRomDesc[] = {
	{ "mpr-15410a.bin", 0x180000, 0x6f311c83, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flashb)
STD_ROM_FN(md_flashb)

struct BurnDriver BurnDrvmd_flashb = {
	"md_flashb", NULL, NULL, NULL, "1993",
	"Flashback (Euro, Rev. A)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flashbRomInfo, md_flashbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback (Jpn)
static struct BurnRomInfo md_flashbjRomDesc[] = {
	{ "flashback (jpn).bin", 0x180000, 0xb790e3b4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flashbj)
STD_ROM_FN(md_flashbj)

struct BurnDriver BurnDrvmd_flashbj = {
	"md_flashbj", "md_flashb", NULL, NULL, "1993",
	"Flashback (Jpn)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flashbjRomInfo, md_flashbjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback - The Quest for Identity (USA)
static struct BurnRomInfo md_flashbuRomDesc[] = {
	{ "flashback - the quest for identity (usa).bin", 0x180000, 0x23a9616d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flashbu)
STD_ROM_FN(md_flashbu)

struct BurnDriver BurnDrvmd_flashbu = {
	"md_flashbu", "md_flashb", NULL, NULL, "1993",
	"Flashback - The Quest for Identity (USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flashbuRomInfo, md_flashbuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback - The Quest for Identity (USA, Alt)
static struct BurnRomInfo md_flashbu1RomDesc[] = {
	{ "flashback - the quest for identity (usa) (alt).bin", 0x180000, 0x33cd2b65, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flashbu1)
STD_ROM_FN(md_flashbu1)

struct BurnDriver BurnDrvmd_flashbu1 = {
	"md_flashbu1", "md_flashb", NULL, NULL, "1993",
	"Flashback - The Quest for Identity (USA, Alt)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flashbu1RomInfo, md_flashbu1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flash Point (Jpn, Prototype)
static struct BurnRomInfo md_flashpRomDesc[] = {
	{ "flash point (japan) (proto).bin", 0x020000, 0x0655074d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flashp)
STD_ROM_FN(md_flashp)

struct BurnDriver BurnDrvmd_flashp = {
	"md_flashp", NULL, NULL, NULL, "199?",
	"Flash Point (Jpn, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flashpRomInfo, md_flashpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flicky (Euro, USA)
static struct BurnRomInfo md_flickyRomDesc[] = {
	{ "flicky (euro, usa).bin", 0x020000, 0x4291c8ab, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flicky)
STD_ROM_FN(md_flicky)

struct BurnDriver BurnDrvmd_flicky = {
	"md_flicky", NULL, NULL, NULL, "1991",
	"Flicky (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flickyRomInfo, md_flickyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flink (Euro)
static struct BurnRomInfo md_flinkRomDesc[] = {
	{ "flink (euro).bin", 0x100000, 0xbef9a4f4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flink)
STD_ROM_FN(md_flink)

struct BurnDriver BurnDrvmd_flink = {
	"md_flink", NULL, NULL, NULL, "1994",
	"Flink (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flinkRomInfo, md_flinkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Flintstones (Euro)
static struct BurnRomInfo md_flintRomDesc[] = {
	{ "flintstones, the (euro).bin", 0x080000, 0x21845d61, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flint)
STD_ROM_FN(md_flint)

struct BurnDriver BurnDrvmd_flint = {
	"md_flint", NULL, NULL, NULL, "1993",
	"The Flintstones (Euro)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flintRomInfo, md_flintRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flintstone (Jpn)
static struct BurnRomInfo md_flintjRomDesc[] = {
	{ "flintstone (jpn).bin", 0x080000, 0x920a3031, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flintj)
STD_ROM_FN(md_flintj)

struct BurnDriver BurnDrvmd_flintj = {
	"md_flintj", "md_flint", NULL, NULL, "1993",
	"Flintstone (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flintjRomInfo, md_flintjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Flintstones (USA)
static struct BurnRomInfo md_flintuRomDesc[] = {
	{ "flintstones, the (usa).bin", 0x080000, 0x7c982c59, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_flintu)
STD_ROM_FN(md_flintu)

struct BurnDriver BurnDrvmd_flintu = {
	"md_flintu", "md_flint", NULL, NULL, "1993",
	"The Flintstones (USA)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_flintuRomInfo, md_flintuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Foreman for Real (World)
static struct BurnRomInfo md_foremanRomDesc[] = {
	{ "foreman for real (world).bin", 0x300000, 0x36248f90, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_foreman)
STD_ROM_FN(md_foreman)

struct BurnDriver BurnDrvmd_foreman = {
	"md_foreman", NULL, NULL, NULL, "1995",
	"Foreman for Real (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_foremanRomInfo, md_foremanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Forgotten Worlds (World, v1.1)
static struct BurnRomInfo md_forgottnRomDesc[] = {
	{ "forgotten worlds (world) (v1.1).bin", 0x080000, 0x95513985, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_forgottn)
STD_ROM_FN(md_forgottn)

struct BurnDriver BurnDrvmd_forgottn = {
	"md_forgottn", NULL, NULL, NULL, "1989",
	"Forgotten Worlds (World, v1.1)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_forgottnRomInfo, md_forgottnRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Forgotten Worlds (World)
static struct BurnRomInfo md_forgottn1RomDesc[] = {
	{ "mpr-12672.bin", 0x080000, 0xd0ee6434, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_forgottn1)
STD_ROM_FN(md_forgottn1)

struct BurnDriver BurnDrvmd_forgottn1 = {
	"md_forgottn1", "md_forgottn", NULL, NULL, "1989",
	"Forgotten Worlds (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_forgottn1RomInfo, md_forgottn1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mary Shelley's Frankenstein (USA)
static struct BurnRomInfo md_frankenRomDesc[] = {
	{ "mary shelley's frankenstein (usa).bin", 0x200000, 0x48993dc3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_franken)
STD_ROM_FN(md_franken)

struct BurnDriver BurnDrvmd_franken = {
	"md_franken", NULL, NULL, NULL, "1994",
	"Mary Shelley's Frankenstein (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_frankenRomInfo, md_frankenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Frank Thomas Big Hurt Baseball (Euro, USA)
static struct BurnRomInfo md_franktRomDesc[] = {
	{ "frank thomas big hurt baseball (euro, usa).bin", 0x400000, 0x863e0950, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_frankt)
STD_ROM_FN(md_frankt)

struct BurnDriver BurnDrvmd_frankt = {
	"md_frankt", NULL, NULL, NULL, "1995",
	"Frank Thomas Big Hurt Baseball (Euro, USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_C_SLAM, GBF_MISC, 0,
	MegadriveGetZipName, md_franktRomInfo, md_franktRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Frogger (USA)
static struct BurnRomInfo md_froggerRomDesc[] = {
	{ "frogger (usa).bin", 0x080000, 0xea2e48c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_frogger)
STD_ROM_FN(md_frogger)

struct BurnDriver BurnDrvmd_frogger = {
	"md_frogger", NULL, NULL, NULL, "1998",
	"Frogger (USA)\0", NULL, "Majesco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_froggerRomInfo, md_froggerRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun 'N Games (Euro)
static struct BurnRomInfo md_funngameRomDesc[] = {
	{ "fun 'n' games (euro).bin", 0x100000, 0xda4ab3cd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_funngame)
STD_ROM_FN(md_funngame)

struct BurnDriver BurnDrvmd_funngame = {
	"md_funngame", NULL, NULL, NULL, "1993",
	"Fun 'N Games (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_funngameRomInfo, md_funngameRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun 'N' Games (USA)
static struct BurnRomInfo md_funngameuRomDesc[] = {
	{ "fun 'n' games (usa).bin", 0x100000, 0xb5ae351d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_funngameu)
STD_ROM_FN(md_funngameu)

struct BurnDriver BurnDrvmd_funngameu = {
	"md_funngameu", "md_funngame", NULL, NULL, "1993",
	"Fun 'N' Games (USA)\0", NULL, "Tradewest", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_funngameuRomInfo, md_funngameuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun Car Rally (USA, Prototype)
static struct BurnRomInfo md_funcarRomDesc[] = {
	{ "fun car rally (usa) (prototype).bin", 0x100000, 0x42e27845, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_funcar)
STD_ROM_FN(md_funcar)

struct BurnDriver BurnDrvmd_funcar = {
	"md_funcar", NULL, NULL, NULL, "199?",
	"Fun Car Rally (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_funcarRomInfo, md_funcarRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// G-LOC Air Battle (World)
static struct BurnRomInfo md_glocRomDesc[] = {
	{ "mpr-15326.bin", 0x100000, 0xf2af886e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gloc)
STD_ROM_FN(md_gloc)

struct BurnDriver BurnDrvmd_gloc = {
	"md_gloc", NULL, NULL, NULL, "1993",
	"G-LOC Air Battle (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_glocRomInfo, md_glocRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// G-LOC Air Battle (World, Prototype)
static struct BurnRomInfo md_glocpRomDesc[] = {
	{ "g-loc air battle (world) (beta).bin", 0x100000, 0x175c7e63, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_glocp)
STD_ROM_FN(md_glocp)

struct BurnDriver BurnDrvmd_glocp = {
	"md_glocp", "md_gloc", NULL, NULL, "1993",
	"G-LOC Air Battle (World, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_glocpRomInfo, md_glocpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gadget Twins (USA)
static struct BurnRomInfo md_gadgetRomDesc[] = {
	{ "gadget twins (usa).bin", 0x100000, 0x7ae5e248, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gadget)
STD_ROM_FN(md_gadget)

struct BurnDriver BurnDrvmd_gadget = {
	"md_gadget", NULL, NULL, NULL, "1992",
	"Gadget Twins (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gadgetRomInfo, md_gadgetRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gaiares (Jpn, USA)
static struct BurnRomInfo md_gaiaresRomDesc[] = {
	{ "gaiares (usa, jpn).bin", 0x100000, 0x5d8bf68b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gaiares)
STD_ROM_FN(md_gaiares)

struct BurnDriver BurnDrvmd_gaiares = {
	"md_gaiares", NULL, NULL, NULL, "1990",
	"Gaiares (Jpn, USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gaiaresRomInfo, md_gaiaresRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gain Ground (World)
static struct BurnRomInfo md_gaingrndRomDesc[] = {
	{ "gain ground (world).bin", 0x080000, 0x8641a2ab, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gaingrnd)
STD_ROM_FN(md_gaingrnd)

struct BurnDriver BurnDrvmd_gaingrnd = {
	"md_gaingrnd", NULL, NULL, NULL, "1991",
	"Gain Ground (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gaingrndRomInfo, md_gaingrndRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gain Ground (World, Alt)
static struct BurnRomInfo md_gaingrnd1RomDesc[] = {
	{ "gain ground (world) (alt).bin", 0x080000, 0x83e7b8ae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gaingrnd1)
STD_ROM_FN(md_gaingrnd1)

struct BurnDriver BurnDrvmd_gaingrnd1 = {
	"md_gaingrnd1", "md_gaingrnd", NULL, NULL, "1991",
	"Gain Ground (World, Alt)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gaingrnd1RomInfo, md_gaingrnd1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Galaxy Force II (World)
static struct BurnRomInfo md_gforce2aRomDesc[] = {
	{ "galaxy force ii (world).bin", 0x100000, 0xcae883c5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gforce2a)
STD_ROM_FN(md_gforce2a)

struct BurnDriver BurnDrvmd_gforce2a = {
	"md_gforce2a", "md_gforce2", NULL, NULL, "1991",
	"Galaxy Force II (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gforce2aRomInfo, md_gforce2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gambler Jiko Chuushinha - Katayama Masayuki no Mahjong Doujou (Jpn)
static struct BurnRomInfo md_gamblerjRomDesc[] = {
	{ "gambler jiko chuushinha - katayama masayuki no mahjong doujou (jpn).bin", 0x080000, 0x05650b7a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gamblerj)
STD_ROM_FN(md_gamblerj)

struct BurnDriver BurnDrvmd_gamblerj = {
	"md_gamblerj", NULL, NULL, NULL, "1990",
	"Gambler Jiko Chuushinha - Katayama Masayuki no Mahjong Doujou (Jpn)\0", NULL, "Game Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gamblerjRomInfo, md_gamblerjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game no Kandume Otokuyou (Jpn)
static struct BurnRomInfo md_gamenkoRomDesc[] = {
	{ "game no kandume otokuyou (jpn).bin", 0x300000, 0xcdad7e6b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gamenko)
STD_ROM_FN(md_gamenko)

struct BurnDriver BurnDrvmd_gamenko = {
	"md_gamenko", NULL, NULL, NULL, "199?",
	"Game no Kandume Otokuyou (Jpn)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_GAME_KANDUME, GBF_MISC, 0,
	MegadriveGetZipName, md_gamenkoRomInfo, md_gamenkoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garfield - Caught in the Act (Euro, USA)
static struct BurnRomInfo md_garfieldRomDesc[] = {
	{ "garfield - caught in the act (euro, usa).bin", 0x200000, 0xf0ff078e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_garfield)
STD_ROM_FN(md_garfield)

struct BurnDriver BurnDrvmd_garfield = {
	"md_garfield", NULL, NULL, NULL, "1995",
	"Garfield - Caught in the Act (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_garfieldRomInfo, md_garfieldRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gargoyles (USA)
static struct BurnRomInfo md_gargoyleRomDesc[] = {
	{ "gargoyles (usa).bin", 0x300000, 0x2d965364, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gargoyle)
STD_ROM_FN(md_gargoyle)

struct BurnDriver BurnDrvmd_gargoyle = {
	"md_gargoyle", NULL, NULL, NULL, "1995",
	"Gargoyles (USA)\0", NULL, "Disney Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gargoyleRomInfo, md_gargoyleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet IV (Euro, USA, 199309)
static struct BurnRomInfo md_gauntl4RomDesc[] = {
	{ "gauntlet iv (euro, usa) (september 1993).bin", 0x100000, 0xf9d60510, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gauntl4)
STD_ROM_FN(md_gauntl4)

struct BurnDriver BurnDrvmd_gauntl4 = {
	"md_gauntl4", NULL, NULL, NULL, "1993",
	"Gauntlet IV (Euro, USA, 199309)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gauntl4RomInfo, md_gauntl4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet IV (Euro, USA, 199308)
static struct BurnRomInfo md_gauntl4aRomDesc[] = {
	{ "gauntlet iv (euro, usa) (august 1993).bin", 0x100000, 0x3bf46dce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gauntl4a)
STD_ROM_FN(md_gauntl4a)

struct BurnDriver BurnDrvmd_gauntl4a = {
	"md_gauntl4a", "md_gauntl4", NULL, NULL, "1993",
	"Gauntlet IV (Euro, USA, 199308)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gauntl4aRomInfo, md_gauntl4aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet (Jpn)
static struct BurnRomInfo md_gauntljRomDesc[] = {
	{ "gauntlet (jpn).bin", 0x100000, 0xf9872055, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gauntlj)
STD_ROM_FN(md_gauntlj)

struct BurnDriver BurnDrvmd_gauntlj = {
	"md_gauntlj", "md_gauntl4", NULL, NULL, "1993",
	"Gauntlet (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gauntljRomInfo, md_gauntljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gemfire (USA)
static struct BurnRomInfo md_gemfireRomDesc[] = {
	{ "gemfire (usa).bin", 0x100000, 0x3d36135b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gemfire)
STD_ROM_FN(md_gemfire)

struct BurnDriver BurnDrvmd_gemfire = {
	"md_gemfire", NULL, NULL, NULL, "1992",
	"Gemfire (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_gemfireRomInfo, md_gemfireRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Royal Blood (Jpn)
static struct BurnRomInfo md_royalbldRomDesc[] = {
	{ "royal blood (jpn).bin", 0x100000, 0x0e0107f1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_royalbld)
STD_ROM_FN(md_royalbld)

struct BurnDriver BurnDrvmd_royalbld = {
	"md_royalbld", "md_gemfire", NULL, NULL, "1992",
	"Royal Blood (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_royalbldRomInfo, md_royalbldRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// General Chaos (Euro, USA)
static struct BurnRomInfo md_genchaosRomDesc[] = {
	{ "general chaos (euro, usa).bin", 0x100000, 0xf1ecc4df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_genchaos)
STD_ROM_FN(md_genchaos)

struct BurnDriver BurnDrvmd_genchaos = {
	"md_genchaos", NULL, NULL, NULL, "1994",
	"General Chaos (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_genchaosRomInfo, md_genchaosRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// General Chaos Daikonsen (Jpn)
static struct BurnRomInfo md_genchaosjRomDesc[] = {
	{ "general chaos daikonsen (jpn).bin", 0x100000, 0x05cc7369, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_genchaosj)
STD_ROM_FN(md_genchaosj)

struct BurnDriver BurnDrvmd_genchaosj = {
	"md_genchaosj", "md_genchaos", NULL, NULL, "1994",
	"General Chaos Daikonsen (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_genchaosjRomInfo, md_genchaosjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Generations Lost (Euro, USA)
static struct BurnRomInfo md_genelostRomDesc[] = {
	{ "generations lost (euro, usa).bin", 0x100000, 0x131f36a6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_genelost)
STD_ROM_FN(md_genelost)

struct BurnDriver BurnDrvmd_genelost = {
	"md_genelost", NULL, NULL, NULL, "1994",
	"Generations Lost (Euro, USA)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_genelostRomInfo, md_genelostRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Genghis Khan II - Clan of the Gray Wolf (USA)
static struct BurnRomInfo md_genghisRomDesc[] = {
	{ "genghis khan ii - clan of the gray wolf (usa).bin", 0x100000, 0x87a281ae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_genghis)
STD_ROM_FN(md_genghis)

struct BurnDriver BurnDrvmd_genghis = {
	"md_genghis", NULL, NULL, NULL, "1993",
	"Genghis Khan II - Clan of the Gray Wolf (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_genghisRomInfo, md_genghisRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aoki Ookami to Shiroki Meshika - Genchou Hishi (Jpn)
static struct BurnRomInfo md_aokiooRomDesc[] = {
	{ "aoki ookami to shiroki meshika - genchou hishi (jpn).bin", 0x140000, 0x10be1d93, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_aokioo)
STD_ROM_FN(md_aokioo)

struct BurnDriver BurnDrvmd_aokioo = {
	"md_aokioo", "md_genghis", NULL, NULL, "1993",
	"Aoki Ookami to Shiroki Meshika - Genchou Hishi (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_aokiooRomInfo, md_aokiooRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// George Foreman's KO Boxing (Euro)
static struct BurnRomInfo md_georgekoRomDesc[] = {
	{ "george foreman's ko boxing (euro).bin", 0x100000, 0xbd556381, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_georgeko)
STD_ROM_FN(md_georgeko)

struct BurnDriver BurnDrvmd_georgeko = {
	"md_georgeko", NULL, NULL, NULL, "1992",
	"George Foreman's KO Boxing (Euro)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_georgekoRomInfo, md_georgekoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// George Foreman's KO Boxing (USA)
static struct BurnRomInfo md_georgekouRomDesc[] = {
	{ "george foreman's ko boxing (usa).bin", 0x100000, 0xe1fdc787, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_georgekou)
STD_ROM_FN(md_georgekou)

struct BurnDriver BurnDrvmd_georgekou = {
	"md_georgekou", "md_georgeko", NULL, NULL, "1992",
	"George Foreman's KO Boxing (USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_georgekouRomInfo, md_georgekouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghostbusters (World, v1.1)
static struct BurnRomInfo md_ghostbstRomDesc[] = {
	{ "ghostbusters (world) (v1.1).bin", 0x080000, 0x792df93b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ghostbst)
STD_ROM_FN(md_ghostbst)

struct BurnDriver BurnDrvmd_ghostbst = {
	"md_ghostbst", NULL, NULL, NULL, "1990",
	"Ghostbusters (World, v1.1)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ghostbstRomInfo, md_ghostbstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghostbusters (World)
static struct BurnRomInfo md_ghostbst1RomDesc[] = {
	{ "ghostbusters (world).bin", 0x080000, 0x00419da3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ghostbst1)
STD_ROM_FN(md_ghostbst1)

struct BurnDriver BurnDrvmd_ghostbst1 = {
	"md_ghostbst1", "md_ghostbst", NULL, NULL, "1990",
	"Ghostbusters (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ghostbst1RomInfo, md_ghostbst1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dai Makaimura (Jpn)
static struct BurnRomInfo md_daimakaiRomDesc[] = {
	{ "dai makaimura (jpn).bin", 0x0a0000, 0x5659f379, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_daimakai)
STD_ROM_FN(md_daimakai)

struct BurnDriver BurnDrvmd_daimakai = {
	"md_daimakai", "md_ghouls", NULL, NULL, "1989",
	"Dai Makaimura (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_daimakaiRomInfo, md_daimakaiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// GleyLancer (Jpn)
static struct BurnRomInfo md_gleylancRomDesc[] = {
	{ "advanced busterhawk gleylancer (jpn).bin", 0x100000, 0x42cf9b5b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gleylanc)
STD_ROM_FN(md_gleylanc)

struct BurnDriver BurnDrvmd_gleylanc = {
	"md_gleylanc", NULL, NULL, NULL, "1992",
	"GleyLancer (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gleylancRomInfo, md_gleylancRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Global Gladiators (Euro)
static struct BurnRomInfo md_globgladRomDesc[] = {
	{ "mpr-15237.bin", 0x100000, 0x5c218c6a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_globglad)
STD_ROM_FN(md_globglad)

struct BurnDriver BurnDrvmd_globglad = {
	"md_globglad", NULL, NULL, NULL, "1993",
	"Global Gladiators (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_globgladRomInfo, md_globgladRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mick & Mack as the Global Gladiators (USA)
static struct BurnRomInfo md_mickmackRomDesc[] = {
	{ "mick & mack as the global gladiators (usa).bin", 0x100000, 0x40f17bb3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mickmack)
STD_ROM_FN(md_mickmack)

struct BurnDriver BurnDrvmd_mickmack = {
	"md_mickmack", "md_globglad", NULL, NULL, "1992",
	"Mick & Mack as the Global Gladiators (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mickmackRomInfo, md_mickmackRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mick & Mack as the Global Gladiators (USA, Prototype)
static struct BurnRomInfo md_mickmackpRomDesc[] = {
	{ "mick & mack as the global gladiators (usa) (beta).bin", 0x100000, 0x08c2af21, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mickmackp)
STD_ROM_FN(md_mickmackp)

struct BurnDriver BurnDrvmd_mickmackp = {
	"md_mickmackp", "md_globglad", NULL, NULL, "1992",
	"Mick & Mack as the Global Gladiators (USA, Prototype)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mickmackpRomInfo, md_mickmackpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (Euro)
static struct BurnRomInfo md_godsRomDesc[] = {
	{ "gods (euro).bin", 0x100000, 0x6c415016, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gods)
STD_ROM_FN(md_gods)

struct BurnDriver BurnDrvmd_gods = {
	"md_gods", NULL, NULL, NULL, "1993",
	"Gods (Euro)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_godsRomInfo, md_godsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (Jpn)
static struct BurnRomInfo md_godsjRomDesc[] = {
	{ "gods (jpn).bin", 0x100000, 0xe4f50206, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_godsj)
STD_ROM_FN(md_godsj)

struct BurnDriver BurnDrvmd_godsj = {
	"md_godsj", "md_gods", NULL, NULL, "1993",
	"Gods (Jpn)\0", NULL, "PCM Complete", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_godsjRomInfo, md_godsjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (USA)
static struct BurnRomInfo md_godsuRomDesc[] = {
	{ "gods (usa).bin", 0x100000, 0xfd234ccd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_godsu)
STD_ROM_FN(md_godsu)

struct BurnDriver BurnDrvmd_godsu = {
	"md_godsu", "md_gods", NULL, NULL, "1992",
	"Gods (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_godsuRomInfo, md_godsuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (USA, Prototype)
static struct BurnRomInfo md_godsupRomDesc[] = {
	{ "gods (usa) (beta).bin", 0x100000, 0x2c06bb64, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_godsup)
STD_ROM_FN(md_godsup)

struct BurnDriver BurnDrvmd_godsup = {
	"md_godsup", "md_gods", NULL, NULL, "1992",
	"Gods (USA, Prototype)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_godsupRomInfo, md_godsupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe (World, v1.1)
static struct BurnRomInfo md_goldnaxeRomDesc[] = {
	{ "golden axe (world) (v1.1).bin", 0x080000, 0x665d7df9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goldnaxe)
STD_ROM_FN(md_goldnaxe)

struct BurnDriver BurnDrvmd_goldnaxe = {
	"md_goldnaxe", NULL, NULL, NULL, "1989",
	"Golden Axe (World, v1.1)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goldnaxeRomInfo, md_goldnaxeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe (World)
static struct BurnRomInfo md_goldnaxe1RomDesc[] = {
	{ "mpr-12806.bin", 0x080000, 0xe8182b90, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goldnaxe1)
STD_ROM_FN(md_goldnaxe1)

struct BurnDriver BurnDrvmd_goldnaxe1 = {
	"md_goldnaxe1", "md_goldnaxe", NULL, NULL, "1989",
	"Golden Axe (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goldnaxe1RomInfo, md_goldnaxe1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe II (World)
static struct BurnRomInfo md_goldnax2RomDesc[] = {
	{ "mpr-14272.bin", 0x080000, 0x725e0a18, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goldnax2)
STD_ROM_FN(md_goldnax2)

struct BurnDriver BurnDrvmd_goldnax2 = {
	"md_goldnax2", NULL, NULL, NULL, "1991",
	"Golden Axe II (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goldnax2RomInfo, md_goldnax2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe II (World, Prototype)
static struct BurnRomInfo md_goldnax2pRomDesc[] = {
	{ "golden axe ii (world) (beta).bin", 0x080000, 0xe62ea1bb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goldnax2p)
STD_ROM_FN(md_goldnax2p)

struct BurnDriver BurnDrvmd_goldnax2p = {
	"md_goldnax2p", "md_goldnax2", NULL, NULL, "1991",
	"Golden Axe II (World, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goldnax2pRomInfo, md_goldnax2pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe III (Jpn)
static struct BurnRomInfo md_goldnax3RomDesc[] = {
	{ "golden axe iii (jpn).bin", 0x100000, 0xc7862ea3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goldnax3)
STD_ROM_FN(md_goldnax3)

struct BurnDriver BurnDrvmd_goldnax3 = {
	"md_goldnax3", NULL, NULL, NULL, "1993",
	"Golden Axe III (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goldnax3RomInfo, md_goldnax3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Uchuu Senkan Gomora (Jpn)
static struct BurnRomInfo md_gomoraRomDesc[] = {
	{ "uchuu senkan gomora (jpn).bin", 0x100000, 0xc511e8d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gomora)
STD_ROM_FN(md_gomora)

struct BurnDriver BurnDrvmd_gomora = {
	"md_gomora", NULL, NULL, NULL, "1991",
	"Uchuu Senkan Gomora (Jpn)\0", NULL, "UPL", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gomoraRomInfo, md_gomoraRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Goofy's Hysterical History Tour (USA)
static struct BurnRomInfo md_goofyRomDesc[] = {
	{ "goofy's hysterical history tour (usa).bin", 0x100000, 0x4e1cc833, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_goofy)
STD_ROM_FN(md_goofy)

struct BurnDriver BurnDrvmd_goofy = {
	"md_goofy", NULL, NULL, NULL, "1993",
	"Goofy's Hysterical History Tour (USA)\0", NULL, "	Absolute Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_goofyRomInfo, md_goofyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gouketsuji Ichizoku (Jpn)
static struct BurnRomInfo md_gouketsuRomDesc[] = {
	{ "gouketsuji ichizoku (jpn).bin", 0x300000, 0xabe9c415, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gouketsu)
STD_ROM_FN(md_gouketsu)

struct BurnDriver BurnDrvmd_gouketsu = {
	"md_gouketsu", NULL, NULL, NULL, "1994",
	"Gouketsuji Ichizoku (Jpn)\0", NULL, "Atlus", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gouketsuRomInfo, md_gouketsuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Granada (Jpn, USA, v1.1)
static struct BurnRomInfo md_granadaRomDesc[] = {
	{ "granada (usa, jpn) (v1.1).bin", 0x080000, 0xe89d1e66, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_granada)
STD_ROM_FN(md_granada)

struct BurnDriver BurnDrvmd_granada = {
	"md_granada", NULL, NULL, NULL, "1990",
	"Granada (Jpn, USA, v1.1)\0", NULL, "Renovation ~ Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_granadaRomInfo, md_granadaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Granada (Jpn, USA)
static struct BurnRomInfo md_granada1RomDesc[] = {
	{ "granada (usa, jpn).bin", 0x080000, 0x7f45719b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_granada1)
STD_ROM_FN(md_granada1)

struct BurnDriver BurnDrvmd_granada1 = {
	"md_granada1", "md_granada", NULL, NULL, "1990",
	"Granada (Jpn, USA)\0", NULL, "Renovation ~ Wolf Team", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_granada1RomInfo, md_granada1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// GrandSlam - The Tennis Tournament (Euro)
static struct BurnRomInfo md_grandslRomDesc[] = {
	{ "mpr-15208.bin", 0x080000, 0x8c2670de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_grandsl)
STD_ROM_FN(md_grandsl)

struct BurnDriver BurnDrvmd_grandsl = {
	"md_grandsl", NULL, NULL, NULL, "1992",
	"GrandSlam - The Tennis Tournament (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_grandslRomInfo, md_grandslRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// GrandSlam - The Tennis Tournament '92 (Jpn)
static struct BurnRomInfo md_grandsljRomDesc[] = {
	{ "grandslam - the tennis tournament '92 (jpn).bin", 0x080000, 0x30cf37d0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_grandslj)
STD_ROM_FN(md_grandslj)

struct BurnDriver BurnDrvmd_grandslj = {
	"md_grandslj", "md_grandsl", NULL, NULL, "1992",
	"GrandSlam - The Tennis Tournament '92 (Jpn)\0", NULL, "Nippon Telenet", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_grandsljRomInfo, md_grandsljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jennifer Capriati Tennis (USA)
static struct BurnRomInfo md_jennifctRomDesc[] = {
	{ "jennifer capriati tennis (usa).bin", 0x080000, 0xab2abc8e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jennifct)
STD_ROM_FN(md_jennifct)

struct BurnDriver BurnDrvmd_jennifct = {
	"md_jennifct", "md_grandsl", NULL, NULL, "1992",
	"Jennifer Capriati Tennis (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jennifctRomInfo, md_jennifctRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Great Circus Mystery - Mickey to Minnie Magical Adventure 2 (Jpn)
static struct BurnRomInfo md_greatcirjRomDesc[] = {
	{ "great circus mystery - mickey to minnie magical adventure 2 (jpn).bin", 0x200000, 0x5aa0f3a0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_greatcirj)
STD_ROM_FN(md_greatcirj)

struct BurnDriver BurnDrvmd_greatcirj = {
	"md_greatcirj", "md_greatcir", NULL, NULL, "1994",
	"Great Circus Mystery - Mickey to Minnie Magical Adventure 2 (Jpn)\0", NULL, "Capcom", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_greatcirjRomInfo, md_greatcirjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Great Circus Mystery Starring Mickey & Minnie (USA)
static struct BurnRomInfo md_greatcirRomDesc[] = {
	{ "great circus mystery starring mickey & minnie, the (usa).bin", 0x200000, 0x14744883, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_greatcir)
STD_ROM_FN(md_greatcir)

struct BurnDriver BurnDrvmd_greatcir = {
	"md_greatcir", NULL, NULL, NULL, "1994",
	"The Great Circus Mystery Starring Mickey & Minnie (USA)\0", NULL, "Capcom", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_greatcirRomInfo, md_greatcirRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Great Waldo Search (USA)
static struct BurnRomInfo md_greatwsRomDesc[] = {
	{ "great waldo search, the (usa).bin", 0x100000, 0x8c5c93b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_greatws)
STD_ROM_FN(md_greatws)

struct BurnDriver BurnDrvmd_greatws = {
	"md_greatws", NULL, NULL, NULL, "1992",
	"The Great Waldo Search (USA)\0", NULL, "THQ", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_greatwsRomInfo, md_greatwsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (Jpn)
static struct BurnRomInfo md_ghwjRomDesc[] = {
	{ "greatest heavyweights (jpn).bin", 0x200000, 0x7ef8b162, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ghwj)
STD_ROM_FN(md_ghwj)

struct BurnDriver BurnDrvmd_ghwj = {
	"md_ghwj", "md_ghw", NULL, NULL, "1994",
	"Greatest Heavyweights (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_ghwjRomInfo, md_ghwjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (USA)
static struct BurnRomInfo md_ghwuRomDesc[] = {
	{ "greatest heavyweights (usa).bin", 0x200000, 0x6e3621d5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ghwu)
STD_ROM_FN(md_ghwu)

struct BurnDriver BurnDrvmd_ghwu = {
	"md_ghwu", "md_ghw", NULL, NULL, "1994",
	"Greatest Heavyweights (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_ghwuRomInfo, md_ghwuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greendog - The Beached Surfer Dude! (Euro, USA)
static struct BurnRomInfo md_greendogRomDesc[] = {
	{ "mpr-14993.bin", 0x080000, 0xc4820a03, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_greendog)
STD_ROM_FN(md_greendog)

struct BurnDriver BurnDrvmd_greendog = {
	"md_greendog", NULL, NULL, NULL, "1992",
	"Greendog - The Beached Surfer Dude! (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_greendogRomInfo, md_greendogRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Grind Stormer (USA)
static struct BurnRomInfo md_grindstRomDesc[] = {
	{ "grind stormer (usa).bin", 0x100000, 0x7e6bef15, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_grindst)
STD_ROM_FN(md_grindst)

struct BurnDriver BurnDrvmd_grindst = {
	"md_grindst", NULL, NULL, NULL, "1994",
	"Grind Stormer (USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_grindstRomInfo, md_grindstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// V-Five (Jpn)
static struct BurnRomInfo md_vfiveRomDesc[] = {
	{ "v-v (jpn).bin", 0x100000, 0xad9d0ec0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_vfive)
STD_ROM_FN(md_vfive)

struct BurnDriver BurnDrvmd_vfive = {
	"md_vfive", "md_grindst", NULL, NULL, "1994",
	"V-Five (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_vfiveRomInfo, md_vfiveRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Growl (USA)
static struct BurnRomInfo md_growlRomDesc[] = {
	{ "growl (usa).bin", 0x080000, 0xf60ef143, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_growl)
STD_ROM_FN(md_growl)

struct BurnDriver BurnDrvmd_growl = {
	"md_growl", NULL, NULL, NULL, "1991",
	"Growl (USA)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_growlRomInfo, md_growlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Runark (Jpn, Kor)
static struct BurnRomInfo md_runarkRomDesc[] = {
	{ "runark (jpn, kor).bin", 0x080000, 0x0894d8fb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_runark)
STD_ROM_FN(md_runark)

struct BurnDriver BurnDrvmd_runark = {
	"md_runark", "md_growl", NULL, NULL, "1991",
	"Runark (Jpn, Kor)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_runarkRomInfo, md_runarkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunship (Euro)
static struct BurnRomInfo md_gunshipRomDesc[] = {
	{ "gunship (euro).bin", 0x100000, 0xda1440c9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gunship)
STD_ROM_FN(md_gunship)

struct BurnDriver BurnDrvmd_gunship = {
	"md_gunship", NULL, NULL, NULL, "1993",
	"Gunship (Euro)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gunshipRomInfo, md_gunshipRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Euro)
static struct BurnRomInfo md_gunstarRomDesc[] = {
	{ "gunstar heroes (euro).bin", 0x100000, 0x866ed9d0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gunstar)
STD_ROM_FN(md_gunstar)

struct BurnDriver BurnDrvmd_gunstar = {
	"md_gunstar", NULL, NULL, NULL, "1993",
	"Gunstar Heroes (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gunstarRomInfo, md_gunstarRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Jpn)
static struct BurnRomInfo md_gunstarjRomDesc[] = {
	{ "gunstar heroes (jpn).bin", 0x100000, 0x1cfd0383, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gunstarj)
STD_ROM_FN(md_gunstarj)

struct BurnDriver BurnDrvmd_gunstarj = {
	"md_gunstarj", "md_gunstar", NULL, NULL, "1993",
	"Gunstar Heroes (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gunstarjRomInfo, md_gunstarjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Jpn, Sample)
static struct BurnRomInfo md_gunstarjsRomDesc[] = {
	{ "gunstar heroes (jpn) (sample).bin", 0x100000, 0x6f90b502, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gunstarjs)
STD_ROM_FN(md_gunstarjs)

struct BurnDriver BurnDrvmd_gunstarjs = {
	"md_gunstarjs", "md_gunstar", NULL, NULL, "1993",
	"Gunstar Heroes (Jpn, Sample)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gunstarjsRomInfo, md_gunstarjsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (USA)
static struct BurnRomInfo md_gunstaruRomDesc[] = {
	{ "gunstar heroes (usa).bin", 0x100000, 0xb813cf0d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gunstaru)
STD_ROM_FN(md_gunstaru)

struct BurnDriver BurnDrvmd_gunstaru = {
	"md_gunstaru", "md_gunstar", NULL, NULL, "1993",
	"Gunstar Heroes (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gunstaruRomInfo, md_gunstaruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gynoug (Euro)
static struct BurnRomInfo md_gynougRomDesc[] = {
	{ "mpr-14439.bin", 0x080000, 0x03405102, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gynoug)
STD_ROM_FN(md_gynoug)

struct BurnDriver BurnDrvmd_gynoug = {
	"md_gynoug", NULL, NULL, NULL, "1991",
	"Gynoug (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gynougRomInfo, md_gynougRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gynoug (Jpn)
static struct BurnRomInfo md_gynougjRomDesc[] = {
	{ "gynoug (jpn).bin", 0x080000, 0x1b69241f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_gynougj)
STD_ROM_FN(md_gynougj)

struct BurnDriver BurnDrvmd_gynougj = {
	"md_gynougj", "md_gynoug", NULL, NULL, "1991",
	"Gynoug (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_gynougjRomInfo, md_gynougjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Wings of Wor (USA)
static struct BurnRomInfo md_wingsworRomDesc[] = {
	{ "wings of wor (usa).bin", 0x080000, 0x210a2fcd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_wingswor)
STD_ROM_FN(md_wingswor)

struct BurnDriver BurnDrvmd_wingswor = {
	"md_wingswor", "md_gynoug", NULL, NULL, "1991",
	"Wings of Wor (USA)\0", NULL, "Dreamworks Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_wingsworRomInfo, md_wingsworRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hard Drivin' (World)
static struct BurnRomInfo md_harddrivRomDesc[] = {
	{ "mpr-13489.bin", 0x040000, 0x3225baaf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_harddriv)
STD_ROM_FN(md_harddriv)

struct BurnDriver BurnDrvmd_harddriv = {
	"md_harddriv", NULL, NULL, NULL, "1991",
	"Hard Drivin' (World)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_harddrivRomInfo, md_harddrivRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall '94 (Euro, USA)
static struct BurnRomInfo md_hardbl94RomDesc[] = {
	{ "hardball '94 (euro, usa).bin", 0x200000, 0xea9c4878, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hardbl94)
STD_ROM_FN(md_hardbl94)

struct BurnDriver BurnDrvmd_hardbl94 = {
	"md_hardbl94", NULL, NULL, NULL, "1994",
	"HardBall '94 (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_hardbl94RomInfo, md_hardbl94RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall '95 (USA)
static struct BurnRomInfo md_hardbl95RomDesc[] = {
	{ "hardball '95 (usa).bin", 0x300000, 0xed10bc9e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hardbl95)
STD_ROM_FN(md_hardbl95)

struct BurnDriver BurnDrvmd_hardbl95 = {
	"md_hardbl95", NULL, NULL, NULL, "1995",
	"HardBall '95 (USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hardbl95RomInfo, md_hardbl95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall III (USA)
static struct BurnRomInfo md_hardbal3RomDesc[] = {
	{ "hardball iii (usa).bin", 0x200000, 0xa4f2f011, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hardbal3)
STD_ROM_FN(md_hardbal3)

struct BurnDriver BurnDrvmd_hardbal3 = {
	"md_hardbal3", NULL, NULL, NULL, "1993",
	"HardBall III (USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hardbal3RomInfo, md_hardbal3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall! (USA)
static struct BurnRomInfo md_hardballRomDesc[] = {
	{ "hardball! (usa).bin", 0x100000, 0xbd1b9a04, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hardball)
STD_ROM_FN(md_hardball)

struct BurnDriver BurnDrvmd_hardball = {
	"md_hardball", NULL, NULL, NULL, "1991",
	"HardBall! (USA)\0", NULL, "Ballistic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hardballRomInfo, md_hardballRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Haunting Starring Polterguy (Euro, USA)
static struct BurnRomInfo md_hauntingRomDesc[] = {
	{ "haunting starring polterguy (euro, usa).bin", 0x200000, 0xc9fc876d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_haunting)
STD_ROM_FN(md_haunting)

struct BurnDriver BurnDrvmd_haunting = {
	"md_haunting", NULL, NULL, NULL, "1993",
	"Haunting Starring Polterguy (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hauntingRomInfo, md_hauntingRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Capt'n Havoc (Euro)
static struct BurnRomInfo md_havocRomDesc[] = {
	{ "capt'n havoc (euro).bin", 0x100000, 0x76e6d20d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_havoc)
STD_ROM_FN(md_havoc)

struct BurnDriver BurnDrvmd_havoc = {
	"md_havoc", NULL, NULL, NULL, "1994",
	"Capt'n Havoc (Euro)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_havocRomInfo, md_havocRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// High Seas Havoc (USA)
static struct BurnRomInfo md_havocuRomDesc[] = {
	{ "high seas havoc (usa).bin", 0x100000, 0x17be551c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_havocu)
STD_ROM_FN(md_havocu)

struct BurnDriver BurnDrvmd_havocu = {
	"md_havocu", "md_havoc", NULL, NULL, "1993",
	"High Seas Havoc (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_havocuRomInfo, md_havocuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Heavy Nova (USA)
static struct BurnRomInfo md_heavynovRomDesc[] = {
	{ "heavy nova (usa).bin", 0x100000, 0xf6b6a9d8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_heavynov)
STD_ROM_FN(md_heavynov)

struct BurnDriver BurnDrvmd_heavynov = {
	"md_heavynov", NULL, NULL, NULL, "1992",
	"Heavy Nova (USA)\0", NULL, "Micronet", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_heavynovRomInfo, md_heavynovRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Heavy Unit - Mega Drive Special (Jpn)
static struct BurnRomInfo md_hvyunitRomDesc[] = {
	{ "heavy unit - mega drive special (jpn).bin", 0x080000, 0x1acbe608, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hvyunit)
STD_ROM_FN(md_hvyunit)

struct BurnDriver BurnDrvmd_hvyunit = {
	"md_hvyunit", NULL, NULL, NULL, "1990",
	"Heavy Unit - Mega Drive Special (Jpn)\0", NULL, "Toho", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hvyunitRomInfo, md_hvyunitRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hei Tao 2 - Super Big 2 (Chi)
static struct BurnRomInfo md_heitaoRomDesc[] = {
	{ "hei tao 2 - super big 2 (chi) (unl).bin", 0x100000, 0x31449113, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_heitao)
STD_ROM_FN(md_heitao)

struct BurnDriver BurnDrvmd_heitao = {
	"md_heitao", NULL, NULL, NULL, "199?",
	"Hei Tao 2 - Super Big 2 (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_heitaoRomInfo, md_heitaoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (Euro)
static struct BurnRomInfo md_hellfireRomDesc[] = {
	{ "mpr-14430.bin", 0x080000, 0xcf30acec, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hellfire)
STD_ROM_FN(md_hellfire)

struct BurnDriver BurnDrvmd_hellfire = {
	"md_hellfire", NULL, NULL, NULL, "1991",
	"Hellfire (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hellfireRomInfo, md_hellfireRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (Jpn)
static struct BurnRomInfo md_hellfirejRomDesc[] = {
	{ "hellfire (jpn).bin", 0x080000, 0x8e5e13ba, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hellfirej)
STD_ROM_FN(md_hellfirej)

struct BurnDriver BurnDrvmd_hellfirej = {
	"md_hellfirej", "md_hellfire", NULL, NULL, "1990",
	"Hellfire (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hellfirejRomInfo, md_hellfirejRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (USA)
static struct BurnRomInfo md_hellfireuRomDesc[] = {
	{ "hellfire (usa).bin", 0x080000, 0x184018f9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hellfireu)
STD_ROM_FN(md_hellfireu)

struct BurnDriver BurnDrvmd_hellfireu = {
	"md_hellfireu", "md_hellfire", NULL, NULL, "1991",
	"Hellfire (USA)\0", NULL, "Seismic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hellfireuRomInfo, md_hellfireuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Herzog Zwei (Euro, USA)
static struct BurnRomInfo md_herzogRomDesc[] = {
	{ "herzog zwei (euro, usa).bin", 0x080000, 0xa605b65b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_herzog)
STD_ROM_FN(md_herzog)

struct BurnDriver BurnDrvmd_herzog = {
	"md_herzog", NULL, NULL, NULL, "1990",
	"Herzog Zwei (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_herzogRomInfo, md_herzogRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Herzog Zwei (Jpn)
static struct BurnRomInfo md_herzogjRomDesc[] = {
	{ "herzog zwei (jpn).bin", 0x080000, 0x4cf676b3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_herzogj)
STD_ROM_FN(md_herzogj)

struct BurnDriver BurnDrvmd_herzogj = {
	"md_herzogj", "md_herzog", NULL, NULL, "1989",
	"Herzog Zwei (Jpn)\0", NULL, "Technosoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_herzogjRomInfo, md_herzogjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hit the Ice (USA)
static struct BurnRomInfo md_hiticeRomDesc[] = {
	{ "hit the ice (usa).bin", 0x080000, 0x85b23606, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hitice)
STD_ROM_FN(md_hitice)

struct BurnDriver BurnDrvmd_hitice = {
	"md_hitice", NULL, NULL, NULL, "1992",
	"Hit the Ice (USA)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hiticeRomInfo, md_hiticeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone (USA, Prototype)
static struct BurnRomInfo md_homeapRomDesc[] = {
	{ "home alone (usa) (beta).bin", 0x100000, 0x3a235fb9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_homeap)
STD_ROM_FN(md_homeap)

struct BurnDriver BurnDrvmd_homeap = {
	"md_homeap", "md_homea", NULL, NULL, "1992",
	"Home Alone (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_homeapRomInfo, md_homeapRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone 2 - Lost in New York (USA)
static struct BurnRomInfo md_homea2RomDesc[] = {
	{ "home alone 2 - lost in new york (usa).bin", 0x080000, 0xcbf87c14, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_homea2)
STD_ROM_FN(md_homea2)

struct BurnDriver BurnDrvmd_homea2 = {
	"md_homea2", NULL, NULL, NULL, "1993",
	"Home Alone 2 - Lost in New York (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_homea2RomInfo, md_homea2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Honoo no Toukyuuji Dodge Danpei (Jpn)
static struct BurnRomInfo md_dodgedanRomDesc[] = {
	{ "mpr-14856.bin", 0x080000, 0x630f07c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_dodgedan)
STD_ROM_FN(md_dodgedan)

struct BurnDriver BurnDrvmd_dodgedan = {
	"md_dodgedan", NULL, NULL, NULL, "1992",
	"Honoo no Toukyuuji Dodge Danpei (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_dodgedanRomInfo, md_dodgedanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hook (USA)
static struct BurnRomInfo md_hookRomDesc[] = {
	{ "hook (usa).bin", 0x100000, 0x2c48e712, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hook)
STD_ROM_FN(md_hook)

struct BurnDriver BurnDrvmd_hook = {
	"md_hook", NULL, NULL, NULL, "1992",
	"Hook (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hookRomInfo, md_hookRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Humans (USA)
static struct BurnRomInfo md_humansRomDesc[] = {
	{ "humans, the (usa).bin", 0x100000, 0xa0cf4366, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_humans)
STD_ROM_FN(md_humans)

struct BurnDriver BurnDrvmd_humans = {
	"md_humans", NULL, NULL, NULL, "1992",
	"The Humans (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_humansRomInfo, md_humansRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hurricanes (Euro)
static struct BurnRomInfo md_hurricanRomDesc[] = {
	{ "hurricanes (euro).bin", 0x200000, 0xdeccc874, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hurrican)
STD_ROM_FN(md_hurrican)

struct BurnDriver BurnDrvmd_hurrican = {
	"md_hurrican", NULL, NULL, NULL, "1994",
	"Hurricanes (Euro)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hurricanRomInfo, md_hurricanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Hybrid Front (Jpn)
static struct BurnRomInfo md_hybridfRomDesc[] = {
	{ "hybrid front, the (jpn).bin", 0x200000, 0xa1f1cfe7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hybridf)
STD_ROM_FN(md_hybridf)

struct BurnDriver BurnDrvmd_hybridf = {
	"md_hybridf", NULL, NULL, NULL, "1994",
	"The Hybrid Front (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_hybridfRomInfo, md_hybridfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Hybrid Front (Jpn, Prototype)
static struct BurnRomInfo md_hybridfpRomDesc[] = {
	{ "hybrid front, the (jpn) (beta).bin", 0x300000, 0x04f02687, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hybridfp)
STD_ROM_FN(md_hybridfp)

struct BurnDriver BurnDrvmd_hybridfp = {
	"md_hybridfp", "md_hybridf", NULL, NULL, "1994",
	"The Hybrid Front (Jpn, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_hybridfpRomInfo, md_hybridfpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyokkori Hyoutanjima - Daitouryou o Mezase! (Jpn)
static struct BurnRomInfo md_hyokkoRomDesc[] = {
	{ "hyokkori hyoutanjima - daitouryou o mezase! (jpn).bin", 0x080000, 0x72253bdb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hyokko)
STD_ROM_FN(md_hyokko)

struct BurnDriver BurnDrvmd_hyokko = {
	"md_hyokko", NULL, NULL, NULL, "1992",
	"Hyokkori Hyoutanjima - Daitouryou o Mezase! (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hyokkoRomInfo, md_hyokkoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk (Euro)
static struct BurnRomInfo md_hyperdRomDesc[] = {
	{ "hyper dunk (euro).bin", 0x200000, 0xf27c576a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hyperd)
STD_ROM_FN(md_hyperd)

struct BurnDriver BurnDrvmd_hyperd = {
	"md_hyperd", NULL, NULL, NULL, "1994",
	"Hyper Dunk (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hyperdRomInfo, md_hyperdRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk - The Playoff Edition (Jpn)
static struct BurnRomInfo md_hyperdjRomDesc[] = {
	{ "fz009a1.bin", 0x200000, 0x5baf53d7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hyperdj)
STD_ROM_FN(md_hyperdj)

struct BurnDriver BurnDrvmd_hyperdj = {
	"md_hyperdj", "md_hyperd", NULL, NULL, "1994",
	"Hyper Dunk - The Playoff Edition (Jpn)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hyperdjRomInfo, md_hyperdjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk - The Playoff Edition (Jpn, Prototype)
static struct BurnRomInfo md_hyperdjpRomDesc[] = {
	{ "hyper dunk - the playoff edition (jpn) (beta).in", 0x200000, 0xdb124bbb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hyperdjp)
STD_ROM_FN(md_hyperdjp)

struct BurnDriver BurnDrvmd_hyperdjp = {
	"md_hyperdjp", "md_hyperd", NULL, NULL, "1994",
	"Hyper Dunk - The Playoff Edition (Jpn, Prototype)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hyperdjpRomInfo, md_hyperdjpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dribble - The Playoff Edition (USA)
static struct BurnRomInfo md_ddribbleRomDesc[] = {
	{ "double dribble - the playoff edition (usa).bin", 0x200000, 0x8352b1d0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ddribble)
STD_ROM_FN(md_ddribble)

struct BurnDriver BurnDrvmd_ddribble = {
	"md_ddribble", "md_hyperd", NULL, NULL, "1994",
	"Double Dribble - The Playoff Edition (USA)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ddribbleRomInfo, md_ddribbleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Marbles (Jpn, SegaNet)
static struct BurnRomInfo md_hypermRomDesc[] = {
	{ "hyper marbles (jpn) (sn).bin", 0x040000, 0x83bb2799, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hyperm)
STD_ROM_FN(md_hyperm)

struct BurnDriver BurnDrvmd_hyperm = {
	"md_hyperm", NULL, NULL, NULL, "1991",
	"Hyper Marbles (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hypermRomInfo, md_hypermRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Marbles (Jpn, Game no Kandume MegaCD Rip)
static struct BurnRomInfo md_hypermgnkRomDesc[] = {
	{ "hyper marbles (jpn) (gnk).bin", 0x040000, 0x9ed72146, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hypermgnk)
STD_ROM_FN(md_hypermgnk)

struct BurnDriver BurnDrvmd_hypermgnk = {
	"md_hypermgnk", "md_hyperm", NULL, NULL, "1991",
	"Hyper Marbles (Jpn, Game no Kandume MegaCD Rip)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hypermgnkRomInfo, md_hypermgnkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// IMG International Tour Tennis (Euro, USA)
static struct BurnRomInfo md_imgittRomDesc[] = {
	{ "img international tour tennis (euro, usa).bin", 0x200000, 0xe04ffc2b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_imgitt)
STD_ROM_FN(md_imgitt)

struct BurnDriver BurnDrvmd_imgitt = {
	"md_imgitt", NULL, NULL, NULL, "1994",
	"IMG International Tour Tennis (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_imgittRomInfo, md_imgittRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Immortal (Euro, USA)
static struct BurnRomInfo md_immortalRomDesc[] = {
	{ "immortal, the (euro, usa).bin", 0x100000, 0xf653c508, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_immortal)
STD_ROM_FN(md_immortal)

struct BurnDriver BurnDrvmd_immortal = {
	"md_immortal", NULL, NULL, NULL, "1993",
	"The Immortal (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_immortalRomInfo, md_immortalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Wizard of the Immortal (Jpn)
static struct BurnRomInfo md_immortaljRomDesc[] = {
	{ "wizard of the immortal (jpn).bin", 0x200000, 0xc99fad92, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_immortalj)
STD_ROM_FN(md_immortalj)

struct BurnDriver BurnDrvmd_immortalj = {
	"md_immortalj", "md_immortal", NULL, NULL, "1993",
	"Wizard of the Immortal (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_immortaljRomInfo, md_immortaljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Incredible Crash Dummies (USA, Prototype)
static struct BurnRomInfo md_crashdumpRomDesc[] = {
	{ "incredible crash dummies, the (usa) (beta).bin", 0x100000, 0x623a920f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_crashdump)
STD_ROM_FN(md_crashdump)

struct BurnDriver BurnDrvmd_crashdump = {
	"md_crashdump", "md_crashdum", NULL, NULL, "1993",
	"The Incredible Crash Dummies (USA, Prototype)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_crashdumpRomInfo, md_crashdumpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Incredible Hulk (Euro, USA)
static struct BurnRomInfo md_incrhulkRomDesc[] = {
	{ "incredible hulk, the (euro, usa).bin", 0x200000, 0x84a5a2dc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_incrhulk)
STD_ROM_FN(md_incrhulk)

struct BurnDriver BurnDrvmd_incrhulk = {
	"md_incrhulk", NULL, NULL, NULL, "1994",
	"The Incredible Hulk (Euro, USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_incrhulkRomInfo, md_incrhulkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Indiana Jones and the Last Crusade (Euro)
static struct BurnRomInfo md_indycrusRomDesc[] = {
	{ "mpr-15207.bin", 0x100000, 0xeb8f4374, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_indycrus)
STD_ROM_FN(md_indycrus)

struct BurnDriver BurnDrvmd_indycrus = {
	"md_indycrus", NULL, NULL, NULL, "1992",
	"Indiana Jones and the Last Crusade (Euro)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_indycrusRomInfo, md_indycrusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Indiana Jones and the Last Crusade (USA)
static struct BurnRomInfo md_indycrusuRomDesc[] = {
	{ "indiana jones and the last crusade (usa).bin", 0x100000, 0x3599a3fd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_indycrusu)
STD_ROM_FN(md_indycrusu)

struct BurnDriver BurnDrvmd_indycrusu = {
	"md_indycrusu", "md_indycrus", NULL, NULL, "1992",
	"Indiana Jones and the Last Crusade (USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_indycrusuRomInfo, md_indycrusuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Insector X (USA)
static struct BurnRomInfo md_insectxRomDesc[] = {
	{ "insector x (usa).bin", 0x080000, 0x70626304, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_insectx)
STD_ROM_FN(md_insectx)

struct BurnDriver BurnDrvmd_insectx = {
	"md_insectx", NULL, NULL, NULL, "1990",
	"Insector X (USA)\0", NULL, "Sage's Creation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_insectxRomInfo, md_insectxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Insector X (Jpn, Kor)
static struct BurnRomInfo md_insectxjRomDesc[] = {
	{ "insector x (jpn, kor).bin", 0x080000, 0x9625c434, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_insectxj)
STD_ROM_FN(md_insectxj)

struct BurnDriver BurnDrvmd_insectxj = {
	"md_insectxj", "md_insectx", NULL, NULL, "1990",
	"Insector X (Jpn, Kor)\0", NULL, "Hot-B", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_insectxjRomInfo, md_insectxjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (USA)
static struct BurnRomInfo md_instchRomDesc[] = {
	{ "instruments of chaos starring young indiana jones (usa).bin", 0x100000, 0x4e384ef0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instch)
STD_ROM_FN(md_instch)

struct BurnDriver BurnDrvmd_instch = {
	"md_instch", NULL, NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchRomInfo, md_instchRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (USA, Prototype)
static struct BurnRomInfo md_instchp1RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (usa) (beta).bin", 0x180000, 0xad6c2050, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp1)
STD_ROM_FN(md_instchp1)

struct BurnDriver BurnDrvmd_instchp1 = {
	"md_instchp1", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp1RomInfo, md_instchp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19941229)
static struct BurnRomInfo md_instchp2RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - dec 29, 1994).bin", 0x100000, 0x94b02351, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp2)
STD_ROM_FN(md_instchp2)

struct BurnDriver BurnDrvmd_instchp2 = {
	"md_instchp2", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19941229)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp2RomInfo, md_instchp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19941228-A)
static struct BurnRomInfo md_instchp3RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - dec 28, 1994 - a).bin", 0x0ff73c, 0xf285ad46, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp3)
STD_ROM_FN(md_instchp3)

struct BurnDriver BurnDrvmd_instchp3 = {
	"md_instchp3", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19941228-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp3RomInfo, md_instchp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940101)
static struct BurnRomInfo md_instchp8RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - jan 01, 1994).bin", 0x100000, 0x263f1a4c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp8)
STD_ROM_FN(md_instchp8)

struct BurnDriver BurnDrvmd_instchp8 = {
	"md_instchp8", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940101)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp8RomInfo, md_instchp8RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940103)
static struct BurnRomInfo md_instchp7RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - jan 03, 1994).bin", 0x100000, 0x3c46d83d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp7)
STD_ROM_FN(md_instchp7)

struct BurnDriver BurnDrvmd_instchp7 = {
	"md_instchp7", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940103)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp7RomInfo, md_instchp7RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940126)
static struct BurnRomInfo md_instchp6RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - jan 26, 1994).bin", 0x100000, 0xf3498542, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp6)
STD_ROM_FN(md_instchp6)

struct BurnDriver BurnDrvmd_instchp6 = {
	"md_instchp6", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940126)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp6RomInfo, md_instchp6RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940127)
static struct BurnRomInfo md_instchp5RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - jan 27, 1994).bin", 0x100000, 0xf43112c3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp5)
STD_ROM_FN(md_instchp5)

struct BurnDriver BurnDrvmd_instchp5 = {
	"md_instchp5", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940127)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp5RomInfo, md_instchp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940923-A)
static struct BurnRomInfo md_instchp4RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - sep 23, 1994 - a).bin", 0x0fe3c4, 0x14443a29, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp4)
STD_ROM_FN(md_instchp4)

struct BurnDriver BurnDrvmd_instchp4 = {
	"md_instchp4", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19940923-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp4RomInfo, md_instchp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (Prototype, 19931228)
static struct BurnRomInfo md_instchp9RomDesc[] = {
	{ "instruments of chaos starring young indiana jones (prototype - dec 28, 1993).bin", 0x100000, 0x51ca641c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_instchp9)
STD_ROM_FN(md_instchp9)

struct BurnDriver BurnDrvmd_instchp9 = {
	"md_instchp9", "md_instch", NULL, NULL, "1994",
	"Instruments of Chaos Starring Young Indiana Jones (Prototype, 19931228)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_instchp9RomInfo, md_instchp9RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// International Rugby (Euro)
static struct BurnRomInfo md_intrugbyRomDesc[] = {
	{ "international rugby (euro).bin", 0x080000, 0xd97d1699, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_intrugby)
STD_ROM_FN(md_intrugby)

struct BurnDriver BurnDrvmd_intrugby = {
	"md_intrugby", NULL, NULL, NULL, "1993",
	"International Rugby (Euro)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_intrugbyRomInfo, md_intrugbyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// International Superstar Soccer Deluxe (Euro)
static struct BurnRomInfo md_issdxRomDesc[] = {
	{ "international superstar soccer deluxe (euro).bin", 0x200000, 0x9bb3b180, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_issdx)
STD_ROM_FN(md_issdx)

struct BurnDriver BurnDrvmd_issdx = {
	"md_issdx", NULL, NULL, NULL, "1996",
	"International Superstar Soccer Deluxe (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_issdxRomInfo, md_issdxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ronaldinho 98 (Pirate)
static struct BurnRomInfo md_ronaldRomDesc[] = {
	{ "ronaldinho 98 (pirate).bin", 0x200000, 0xdd27c84e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ronald)
STD_ROM_FN(md_ronald)

struct BurnDriver BurnDrvmd_ronald = {
	"md_ronald", "md_issdx", NULL, NULL, "199?",
	"Ronaldinho 98 (Pirate)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ronaldRomInfo, md_ronaldRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ishido - The Way of Stones (USA)
static struct BurnRomInfo md_ishidoRomDesc[] = {
	{ "mb834200a.bin", 0x020000, 0xb1de7d5e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ishido)
STD_ROM_FN(md_ishido)

struct BurnDriver BurnDrvmd_ishido = {
	"md_ishido", NULL, NULL, NULL, "1990",
	"Ishido - The Way of Stones (USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ishidoRomInfo, md_ishidoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// It Came from the Desert (USA)
static struct BurnRomInfo md_itcameRomDesc[] = {
	{ "it came from the desert (usa).bin", 0x080000, 0x25afb4f7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_itcame)
STD_ROM_FN(md_itcame)

struct BurnDriver BurnDrvmd_itcame = {
	"md_itcame", NULL, NULL, NULL, "1990",
	"It Came from the Desert (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_itcameRomInfo, md_itcameRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Itchy and Scratchy Game (USA, Prototype)
static struct BurnRomInfo md_itchyRomDesc[] = {
	{ "itchy and scratchy game, the (usa) (prototype).bin", 0x100000, 0x81b7725d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_itchy)
STD_ROM_FN(md_itchy)

struct BurnDriver BurnDrvmd_itchy = {
	"md_itchy", NULL, NULL, NULL, "1994",
	"The Itchy and Scratchy Game (USA, Prototype)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_itchyRomInfo, md_itchyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Izzy's Quest for the Olympic Rings (Euro, USA)
static struct BurnRomInfo md_izzyqstRomDesc[] = {
	{ "izzy's quest for the olympic rings (euro, usa).bin", 0x200000, 0x77b416e4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_izzyqst)
STD_ROM_FN(md_izzyqst)

struct BurnDriver BurnDrvmd_izzyqst = {
	"md_izzyqst", NULL, NULL, NULL, "1995",
	"Izzy's Quest for the Olympic Rings (Euro, USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_izzyqstRomInfo, md_izzyqstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker (Jpn, v1.3)
static struct BurnRomInfo md_jlpsRomDesc[] = {
	{ "j. league pro striker (jpn) (v1.3).bin", 0x100000, 0x2d5b7a11, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jlps)
STD_ROM_FN(md_jlps)

struct BurnDriver BurnDrvmd_jlps = {
	"md_jlps", NULL, NULL, NULL, "1993",
	"J. League Pro Striker (Jpn, v1.3)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_jlpsRomInfo, md_jlpsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker (Jpn, v1.0)
static struct BurnRomInfo md_jlpsaRomDesc[] = {
	{ "j. league pro striker (jpn) (v1.0).bin", 0x100000, 0xec229156, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jlpsa)
STD_ROM_FN(md_jlpsa)

struct BurnDriver BurnDrvmd_jlpsa = {
	"md_jlpsa", "md_jlps", NULL, NULL, "1993",
	"J. League Pro Striker (Jpn, v1.0)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_jlpsaRomInfo, md_jlpsaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker 2 (Jpn)
static struct BurnRomInfo md_jlps2RomDesc[] = {
	{ "mpr-16857.bin", 0x200000, 0x9fe71002, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jlps2)
STD_ROM_FN(md_jlps2)

struct BurnDriver BurnDrvmd_jlps2 = {
	"md_jlps2", NULL, NULL, NULL, "1994",
	"J. League Pro Striker 2 (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_jlps2RomInfo, md_jlps2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Striker Final Stage (Jpn)
static struct BurnRomInfo md_prostrfsRomDesc[] = {
	{ "j. league pro striker final stage (jpn).bin", 0x200000, 0xe35e25fb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_prostrfs)
STD_ROM_FN(md_prostrfs)

struct BurnDriver BurnDrvmd_prostrfs = {
	"md_prostrfs", NULL, NULL, NULL, "1995",
	"Pro Striker Final Stage (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_prostrfsRomInfo, md_prostrfsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker Perfect (Jpn)
static struct BurnRomInfo md_jlpspRomDesc[] = {
	{ "mpr-16267.bin", 0x100000, 0x0abed379, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jlpsp)
STD_ROM_FN(md_jlpsp)

struct BurnDriver BurnDrvmd_jlpsp = {
	"md_jlpsp", NULL, NULL, NULL, "1993",
	"J. League Pro Striker Perfect (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_jlpspRomInfo, md_jlpspRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jack Nicklaus' Power Challenge Golf (Euro, USA)
static struct BurnRomInfo md_jacknickRomDesc[] = {
	{ "jack nicklaus' power challenge golf (euro, usa).bin", 0x100000, 0x5545e909, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jacknick)
STD_ROM_FN(md_jacknick)

struct BurnDriver BurnDrvmd_jacknick = {
	"md_jacknick", NULL, NULL, NULL, "1993",
	"Jack Nicklaus' Power Challenge Golf (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_jacknickRomInfo, md_jacknickRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James 'Buster' Douglas Knockout Boxing (Euro, USA)
static struct BurnRomInfo md_jbdougkoRomDesc[] = {
	{ "mpr-13262.bin", 0x080000, 0x87bbcf2a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jbdougko)
STD_ROM_FN(md_jbdougko)

struct BurnDriver BurnDrvmd_jbdougko = {
	"md_jbdougko", NULL, NULL, NULL, "1990",
	"James 'Buster' Douglas Knockout Boxing (Euro, USA)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jbdougkoRomInfo, md_jbdougkoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Final Blow (Jpn)
static struct BurnRomInfo md_finalbRomDesc[] = {
	{ "final blow (jpn).bin", 0x080000, 0x48ad505d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_finalb)
STD_ROM_FN(md_finalb)

struct BurnDriver BurnDrvmd_finalb = {
	"md_finalb", "md_jbdougko", NULL, NULL, "1990",
	"Final Blow (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_finalbRomInfo, md_finalbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Bond 007 - The Duel (USA)
static struct BurnRomInfo md_jb007uRomDesc[] = {
	{ "james bond 007 - the duel (usa).bin", 0x080000, 0x4e614548, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jb007u)
STD_ROM_FN(md_jb007u)

struct BurnDriver BurnDrvmd_jb007u = {
	"md_jb007u", "md_jb007", NULL, NULL, "1992",
	"James Bond 007 - The Duel (USA)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jb007uRomInfo, md_jb007uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 007 Shitou - The Duel (Jpn)
static struct BurnRomInfo md_007shitouRomDesc[] = {
	{ "007 shitou - the duel (jpn).bin", 0x080000, 0xaeb4b262, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_007shitou)
STD_ROM_FN(md_007shitou)

struct BurnDriver BurnDrvmd_007shitou = {
	"md_007shitou", "md_jb007", NULL, NULL, "1993",
	"007 Shitou - The Duel (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_007shitouRomInfo, md_007shitouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond II - Codename Robocod (Jpn, Kor)
static struct BurnRomInfo md_jpond2jRomDesc[] = {
	{ "james pond ii - codename robocod (jpn, kor).bin", 0x080000, 0x98794702, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpond2j)
STD_ROM_FN(md_jpond2j)

struct BurnDriver BurnDrvmd_jpond2j = {
	"md_jpond2j", "md_jpond2", NULL, NULL, "1993",
	"James Pond II - Codename Robocod (Jpn, Kor)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpond2jRomInfo, md_jpond2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond 3 - Operation Starfish (Euro, USA)
static struct BurnRomInfo md_jpond3RomDesc[] = {
	{ "james pond 3 - operation starfish (euro, usa).bin", 0x200000, 0x26f64b2a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpond3)
STD_ROM_FN(md_jpond3)

struct BurnDriver BurnDrvmd_jpond3 = {
	"md_jpond3", NULL, NULL, NULL, "1993",
	"James Pond 3 - Operation Starfish (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpond3RomInfo, md_jpond3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jammit (USA)
static struct BurnRomInfo md_jammitRomDesc[] = {
	{ "jammit (usa).bin", 0x200000, 0xd91b52b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jammit)
STD_ROM_FN(md_jammit)

struct BurnDriver BurnDrvmd_jammit = {
	"md_jammit", NULL, NULL, NULL, "1994",
	"Jammit (USA)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jammitRomInfo, md_jammitRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Janou Touryuumon (Jpn)
static struct BurnRomInfo md_janoutRomDesc[] = {
	{ "janou touryuumon (jpn).bin", 0x100000, 0xb5ef97c6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_janout)
STD_ROM_FN(md_janout)

struct BurnDriver BurnDrvmd_janout = {
	"md_janout", NULL, NULL, NULL, "1993",
	"Janou Touryuumon (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_janoutRomInfo, md_janoutRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jantei Monogatari (Jpn)
static struct BurnRomInfo md_janteiRomDesc[] = {
	{ "jantei monogatari (jpn).bin", 0x100000, 0x8a1b19ad, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jantei)
STD_ROM_FN(md_jantei)

struct BurnDriver BurnDrvmd_jantei = {
	"md_jantei", NULL, NULL, NULL, "1991",
	"Jantei Monogatari (Jpn)\0", NULL, "Reno", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_janteiRomInfo, md_janteiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jelly Boy (Euro, Prototype)
static struct BurnRomInfo md_jellyboyRomDesc[] = {
	{ "jelly boy (euro) (prototype).bin", 0x100000, 0x7cfadc16, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jellyboy)
STD_ROM_FN(md_jellyboy)

struct BurnDriver BurnDrvmd_jellyboy = {
	"md_jellyboy", NULL, NULL, NULL, "199?",
	"Jelly Boy (Euro, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jellyboyRomInfo, md_jellyboyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! (USA)
static struct BurnRomInfo md_jeopardyRomDesc[] = {
	{ "jeopardy! (usa).bin", 0x080000, 0x56cff3f1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jeopardy)
STD_ROM_FN(md_jeopardy)

struct BurnDriver BurnDrvmd_jeopardy = {
	"md_jeopardy", NULL, NULL, NULL, "1992",
	"Jeopardy! (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jeopardyRomInfo, md_jeopardyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! Deluxe (USA)
static struct BurnRomInfo md_jeoparddRomDesc[] = {
	{ "jeopardy! deluxe (usa).bin", 0x080000, 0x25e2f9d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jeopardd)
STD_ROM_FN(md_jeopardd)

struct BurnDriver BurnDrvmd_jeopardd = {
	"md_jeopardd", NULL, NULL, NULL, "1993",
	"Jeopardy! Deluxe (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jeoparddRomInfo, md_jeoparddRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! Sports Edition (USA)
static struct BurnRomInfo md_jeopardsRomDesc[] = {
	{ "jeopardy! sports edition (usa).bin", 0x080000, 0x13f924d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jeopards)
STD_ROM_FN(md_jeopards)

struct BurnDriver BurnDrvmd_jeopards = {
	"md_jeopards", NULL, NULL, NULL, "1993",
	"Jeopardy! Sports Edition (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jeopardsRomInfo, md_jeopardsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jerry Glanville's Pigskin Footbrawl (USA)
static struct BurnRomInfo md_pigskinfRomDesc[] = {
	{ "jerry glanville's pigskin footbrawl (usa).bin", 0x100000, 0xe7f48d30, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pigskinf)
STD_ROM_FN(md_pigskinf)

struct BurnDriver BurnDrvmd_pigskinf = {
	"md_pigskinf", NULL, NULL, NULL, "1992",
	"Jerry Glanville's Pigskin Footbrawl (USA)\0", NULL, "Razorsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pigskinfRomInfo, md_pigskinfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jewel Master (Euro, USA, Rev. A)
static struct BurnRomInfo md_jewelmsRomDesc[] = {
	{ "mpr-14118a.bin", 0x080000, 0xcee98813, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jewelms)
STD_ROM_FN(md_jewelms)

struct BurnDriver BurnDrvmd_jewelms = {
	"md_jewelms", NULL, NULL, NULL, "1991",
	"Jewel Master (Euro, USA, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jewelmsRomInfo, md_jewelmsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jewel Master (Jpn)
static struct BurnRomInfo md_jewelmsjRomDesc[] = {
	{ "jewel master (jpn).bin", 0x080000, 0x2cf6926c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jewelmsj)
STD_ROM_FN(md_jewelmsj)

struct BurnDriver BurnDrvmd_jewelmsj = {
	"md_jewelmsj", "md_jewelms", NULL, NULL, "1991",
	"Jewel Master (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jewelmsjRomInfo, md_jewelmsjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jim Power - The Arcade Game (USA, Prototype)
static struct BurnRomInfo md_jimpowRomDesc[] = {
	{ "jim power - the arcade game (usa) (prototype) (bad dump).bin", 0x100000, 0x1cf3238b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jimpow)
STD_ROM_FN(md_jimpow)

struct BurnDriver BurnDrvmd_jimpow = {
	"md_jimpow", NULL, NULL, NULL, "199?",
	"Jim Power - The Arcade Game (USA, Prototype)\0", NULL, "Loriciel", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jimpowRomInfo, md_jimpowRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jimmy White's Whirlwind Snooker (Euro)
static struct BurnRomInfo md_jimmywwsRomDesc[] = {
	{ "jimmy white's whirlwind snooker (euro).bin", 0x080000, 0x0aef5b1f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jimmywws)
STD_ROM_FN(md_jimmywws)

struct BurnDriver BurnDrvmd_jimmywws = {
	"md_jimmywws", NULL, NULL, NULL, "1991",
	"Jimmy White's Whirlwind Snooker (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jimmywwsRomInfo, md_jimmywwsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jiu Ji Ma Jiang II - Ye Yan Bian (Chi)
static struct BurnRomInfo md_jiujimRomDesc[] = {
	{ "jiu ji ma jiang ii - ye yan bian (chi) (unl).bin", 0x100000, 0xe9829b22, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jiujim)
STD_ROM_FN(md_jiujim)

struct BurnDriver BurnDrvmd_jiujim = {
	"md_jiujim", NULL, NULL, NULL, "199?",
	"Jiu Ji Ma Jiang II - Ye Yan Bian (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jiujimRomInfo, md_jiujimRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe & Mac (USA)
static struct BurnRomInfo md_joemacRomDesc[] = {
	{ "joe & mac (usa).bin", 0x100000, 0x85bcc1c7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_joemac)
STD_ROM_FN(md_joemac)

struct BurnDriver BurnDrvmd_joemac = {
	"md_joemac", NULL, NULL, NULL, "1991",
	"Joe & Mac (USA)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_joemacRomInfo, md_joemacRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana Football (World)
static struct BurnRomInfo md_joemontRomDesc[] = {
	{ "mpr-13654.bin", 0x080000, 0x8aa6a1dd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_joemont)
STD_ROM_FN(md_joemont)

struct BurnDriver BurnDrvmd_joemont = {
	"md_joemont", NULL, NULL, NULL, "1990",
	"Joe Montana Football (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_joemontRomInfo, md_joemontRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana II Sports Talk Football (World, Rev. A)
static struct BurnRomInfo md_joemont2RomDesc[] = {
	{ "mpr-14356a.bin", 0x100000, 0xa45da893, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_joemont2)
STD_ROM_FN(md_joemont2)

struct BurnDriver BurnDrvmd_joemont2 = {
	"md_joemont2", NULL, NULL, NULL, "1991",
	"Joe Montana II Sports Talk Football (World, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_joemont2RomInfo, md_joemont2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '92 (Euro, USA)
static struct BurnRomInfo md_madden92RomDesc[] = {
	{ "john madden football '92 (euro, usa).bin", 0x080000, 0x046e3945, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden92)
STD_ROM_FN(md_madden92)

struct BurnDriver BurnDrvmd_madden92 = {
	"md_madden92", NULL, NULL, NULL, "1991",
	"John Madden Football '92 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_madden92RomInfo, md_madden92RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '93 (Euro, USA)
static struct BurnRomInfo md_madden93RomDesc[] = {
	{ "jmf302.bin", 0x100000, 0xca323b3e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden93)
STD_ROM_FN(md_madden93)

struct BurnDriver BurnDrvmd_madden93 = {
	"md_madden93", NULL, NULL, NULL, "1992",
	"John Madden Football '93 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_madden93RomInfo, md_madden93RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '93 - Championship Edition (USA)
static struct BurnRomInfo md_madd93ceRomDesc[] = {
	{ "john madden football '93 - championship edition (usa).bin", 0x100000, 0xca534b1a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madd93ce)
STD_ROM_FN(md_madd93ce)

struct BurnDriver BurnDrvmd_madd93ce = {
	"md_madd93ce", NULL, NULL, NULL, "1992",
	"John Madden Football '93 - Championship Edition (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_madd93ceRomInfo, md_madd93ceRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football (Euro, USA)
static struct BurnRomInfo md_maddenRomDesc[] = {
	{ "john madden football (euro, usa).bin", 0x080000, 0x90fb8818, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden)
STD_ROM_FN(md_madden)

struct BurnDriver BurnDrvmd_madden = {
	"md_madden", NULL, NULL, NULL, "1990",
	"John Madden Football (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_maddenRomInfo, md_maddenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football - Pro Football (Jpn)
static struct BurnRomInfo md_maddenjRomDesc[] = {
	{ "john madden football - pro football (jpn).bin", 0x080000, 0x0460611c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_maddenj)
STD_ROM_FN(md_maddenj)

struct BurnDriver BurnDrvmd_maddenj = {
	"md_maddenj", "md_madden", NULL, NULL, "1992",
	"John Madden Football - Pro Football (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_maddenjRomInfo, md_maddenjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird (Euro, USA, v1.1)
static struct BurnRomInfo md_jordanbRomDesc[] = {
	{ "jordan vs bird (euro, usa) (v1.1).bin", 0x080000, 0x4d3ddd7c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jordanb)
STD_ROM_FN(md_jordanb)

struct BurnDriver BurnDrvmd_jordanb = {
	"md_jordanb", NULL, NULL, NULL, "1992",
	"Jordan Vs Bird (Euro, USA, v1.1)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jordanbRomInfo, md_jordanbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird (Euro, USA)
static struct BurnRomInfo md_jordanb1RomDesc[] = {
	{ "jordan vs bird (euro, usa).bin", 0x080000, 0x22d77e6d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jordanb1)
STD_ROM_FN(md_jordanb1)

struct BurnDriver BurnDrvmd_jordanb1 = {
	"md_jordanb1", "md_jordanb", NULL, NULL, "1992",
	"Jordan Vs Bird (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jordanb1RomInfo, md_jordanb1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird - One on One (Jpn)
static struct BurnRomInfo md_jordanbjRomDesc[] = {
	{ "jordan vs bird - one on one (jpn).bin", 0x080000, 0x8837e896, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jordanbj)
STD_ROM_FN(md_jordanbj)

struct BurnDriver BurnDrvmd_jordanbj = {
	"md_jordanbj", "md_jordanb", NULL, NULL, "1993",
	"Jordan Vs Bird - One on One (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jordanbjRomInfo, md_jordanbjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joshua & The Battle of Jericho (USA)
static struct BurnRomInfo md_joshuaRomDesc[] = {
	{ "joshua & the battle of jericho (usa) (unl).bin", 0x040000, 0xda9e25aa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_joshua)
STD_ROM_FN(md_joshua)

struct BurnDriver BurnDrvmd_joshua = {
	"md_joshua", NULL, NULL, NULL, "1992",
	"Joshua & The Battle of Jericho (USA)\0", NULL, "Wisdom Tree", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_joshuaRomInfo, md_joshuaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (World)
static struct BurnRomInfo md_jdreddRomDesc[] = {
	{ "judge dredd (world).bin", 0x200000, 0xea342ed8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jdredd)
STD_ROM_FN(md_jdredd)

struct BurnDriver BurnDrvmd_jdredd = {
	"md_jdredd", NULL, NULL, NULL, "1995",
	"Judge Dredd (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jdreddRomInfo, md_jdreddRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (USA, Prototype, Alt)
static struct BurnRomInfo md_jdreddp2RomDesc[] = {
	{ "judge dredd (usa) (beta) (alt).bin", 0x200000, 0xe649f784, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jdreddp2)
STD_ROM_FN(md_jdreddp2)

struct BurnDriver BurnDrvmd_jdreddp2 = {
	"md_jdreddp2", "md_jdredd", NULL, NULL, "1995",
	"Judge Dredd (USA, Prototype, Alt)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jdreddp2RomInfo, md_jdreddp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (USA, Prototype)
static struct BurnRomInfo md_jdreddp1RomDesc[] = {
	{ "judge dredd (usa) (beta).bin", 0x200000, 0x8d46f4da, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jdreddp1)
STD_ROM_FN(md_jdreddp1)

struct BurnDriver BurnDrvmd_jdreddp1 = {
	"md_jdreddp1", "md_jdredd", NULL, NULL, "1995",
	"Judge Dredd (USA, Prototype)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jdreddp1RomInfo, md_jdreddp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Junction (Jpn, USA)
static struct BurnRomInfo md_junctionRomDesc[] = {
	{ "junction (usa, jpn).bin", 0x080000, 0x94cdce8d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_junction)
STD_ROM_FN(md_junction)

struct BurnDriver BurnDrvmd_junction = {
	"md_junction", NULL, NULL, NULL, "1990",
	"Junction (Jpn, USA)\0", NULL, "Micronet", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_junctionRomInfo, md_junctionRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's The Jungle Book (Euro)
static struct BurnRomInfo md_jungleRomDesc[] = {
	{ "jungle book, the (euro).bin", 0x200000, 0xb9709a99, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jungle)
STD_ROM_FN(md_jungle)

struct BurnDriver BurnDrvmd_jungle = {
	"md_jungle", NULL, NULL, NULL, "1994",
	"Disney's The Jungle Book (Euro)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jungleRomInfo, md_jungleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney's The Jungle Book (USA)
static struct BurnRomInfo md_jungleuRomDesc[] = {
	{ "jungle book, the (usa).bin", 0x200000, 0x3fb6d92e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jungleu)
STD_ROM_FN(md_jungleu)

struct BurnDriver BurnDrvmd_jungleu = {
	"md_jungleu", "md_jungle", NULL, NULL, "1994",
	"Disney's The Jungle Book (USA)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jungleuRomInfo, md_jungleuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike (Euro, USA)
static struct BurnRomInfo md_jstrikeRomDesc[] = {
	{ "jungle strike (euro, usa).bin", 0x200000, 0xa5d29735, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jstrike)
STD_ROM_FN(md_jstrike)

struct BurnDriver BurnDrvmd_jstrike = {
	"md_jstrike", NULL, NULL, NULL, "1993",
	"Jungle Strike (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jstrikeRomInfo, md_jstrikeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike (USA, Prototype)
static struct BurnRomInfo md_jstrikepRomDesc[] = {
	{ "jungle strike (usa) (beta).bin", 0x200000, 0x0cd540d4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jstrikep)
STD_ROM_FN(md_jstrikep)

struct BurnDriver BurnDrvmd_jstrikep = {
	"md_jstrikep", "md_jstrike", NULL, NULL, "1993",
	"Jungle Strike (USA, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jstrikepRomInfo, md_jstrikepRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike - Uketsugareta Kyouki (Jpn)
static struct BurnRomInfo md_jstrikejRomDesc[] = {
	{ "jungle strike - uketsugareta kyouki (jpn).bin", 0x200000, 0xba7a870b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jstrikej)
STD_ROM_FN(md_jstrikej)

struct BurnDriver BurnDrvmd_jstrikej = {
	"md_jstrikej", "md_jstrike", NULL, NULL, "1993",
	"Jungle Strike - Uketsugareta Kyouki (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jstrikejRomInfo, md_jstrikejRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (Euro)
static struct BurnRomInfo md_jparkRomDesc[] = {
	{ "mpr-15679.bin", 0x200000, 0x448341f6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpark)
STD_ROM_FN(md_jpark)

struct BurnDriver BurnDrvmd_jpark = {
	"md_jpark", NULL, NULL, NULL, "1993",
	"Jurassic Park (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jparkRomInfo, md_jparkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (Jpn)
static struct BurnRomInfo md_jparkjRomDesc[] = {
	{ "jurassic park (jpn).bin", 0x200000, 0xec8e5783, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jparkj)
STD_ROM_FN(md_jparkj)

struct BurnDriver BurnDrvmd_jparkj = {
	"md_jparkj", "md_jpark", NULL, NULL, "1993",
	"Jurassic Park (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jparkjRomInfo, md_jparkjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (USA)
static struct BurnRomInfo md_jparkuRomDesc[] = {
	{ "jurassic park (usa).bin", 0x200000, 0x7b31deef, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jparku)
STD_ROM_FN(md_jparku)

struct BurnDriver BurnDrvmd_jparku = {
	"md_jparku", "md_jpark", NULL, NULL, "1993",
	"Jurassic Park (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jparkuRomInfo, md_jparkuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (USA, Prototype)
static struct BurnRomInfo md_jparkupRomDesc[] = {
	{ "jurassic park (usa) (beta).bin", 0x200000, 0xcf890eed, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jparkup)
STD_ROM_FN(md_jparkup)

struct BurnDriver BurnDrvmd_jparkup = {
	"md_jparkup", "md_jpark", NULL, NULL, "1993",
	"Jurassic Park (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jparkupRomInfo, md_jparkupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Euro, USA)
static struct BurnRomInfo md_jpramRomDesc[] = {
	{ "jurassic park - rampage edition (euro, usa).bin", 0x200000, 0x98b4aa1b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpram)
STD_ROM_FN(md_jpram)

struct BurnDriver BurnDrvmd_jpram = {
	"md_jpram", NULL, NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramRomInfo, md_jpramRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940708)
static struct BurnRomInfo md_jpramp6RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 08, 1994).bin", 0x200000, 0xf4c78bd0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp6)
STD_ROM_FN(md_jpramp6)

struct BurnDriver BurnDrvmd_jpramp6 = {
	"md_jpramp6", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940708)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp6RomInfo, md_jpramp6RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940713)
static struct BurnRomInfo md_jpramp5RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 13, 1994).bin", 0x200000, 0x8475a105, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp5)
STD_ROM_FN(md_jpramp5)

struct BurnDriver BurnDrvmd_jpramp5 = {
	"md_jpramp5", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940713)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp5RomInfo, md_jpramp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940714)
static struct BurnRomInfo md_jpramp4RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 14, 1994).bin", 0x200000, 0x9bf0e28d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp4)
STD_ROM_FN(md_jpramp4)

struct BurnDriver BurnDrvmd_jpramp4 = {
	"md_jpramp4", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940714)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp4RomInfo, md_jpramp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940715)
static struct BurnRomInfo md_jpramp3RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 15, 1994).bin", 0x200000, 0xd2202be5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp3)
STD_ROM_FN(md_jpramp3)

struct BurnDriver BurnDrvmd_jpramp3 = {
	"md_jpramp3", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940715)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp3RomInfo, md_jpramp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940717)
static struct BurnRomInfo md_jpramp2RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 17, 1994).bin", 0x200000, 0x2eae6140, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp2)
STD_ROM_FN(md_jpramp2)

struct BurnDriver BurnDrvmd_jpramp2 = {
	"md_jpramp2", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940717)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp2RomInfo, md_jpramp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940718)
static struct BurnRomInfo md_jpramp1RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 18, 1994).bin", 0x200000, 0x1a62b826, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp1)
STD_ROM_FN(md_jpramp1)

struct BurnDriver BurnDrvmd_jpramp1 = {
	"md_jpramp1", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940718)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp1RomInfo, md_jpramp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940620)
static struct BurnRomInfo md_jpramp9RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 20, 1994).bin", 0x1f6e60, 0x1280fa5c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp9)
STD_ROM_FN(md_jpramp9)

struct BurnDriver BurnDrvmd_jpramp9 = {
	"md_jpramp9", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940620)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp9RomInfo, md_jpramp9RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940622)
static struct BurnRomInfo md_jpramp8RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 22, 1994).bin", 0x200000, 0x53582f2b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp8)
STD_ROM_FN(md_jpramp8)

struct BurnDriver BurnDrvmd_jpramp8 = {
	"md_jpramp8", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940622)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp8RomInfo, md_jpramp8RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype, 19940630)
static struct BurnRomInfo md_jpramp7RomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 30, 1994).bin", 0x200000, 0xbff4b396, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jpramp7)
STD_ROM_FN(md_jpramp7)

struct BurnDriver BurnDrvmd_jpramp7 = {
	"md_jpramp7", "md_jpram", NULL, NULL, "1994",
	"Jurassic Park - Rampage Edition (Prototype, 19940630)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jpramp7RomInfo, md_jpramp7RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Justice League Task Force (World)
static struct BurnRomInfo md_jleagtfRomDesc[] = {
	{ "justice league task force (world).bin", 0x300000, 0x2a60ebe9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_jleagtf)
STD_ROM_FN(md_jleagtf)

struct BurnDriver BurnDrvmd_jleagtf = {
	"md_jleagtf", NULL, NULL, NULL, "1995",
	"Justice League Task Force (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_jleagtfRomInfo, md_jleagtfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ka-Ge-Ki - Fists of Steel (USA)
static struct BurnRomInfo md_kagekiRomDesc[] = {
	{ "ka-ge-ki - fists of steel (usa).bin", 0x100000, 0xeffc0fa6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kageki)
STD_ROM_FN(md_kageki)

struct BurnDriver BurnDrvmd_kageki = {
	"md_kageki", NULL, NULL, NULL, "1991",
	"Ka-Ge-Ki - Fists of Steel (USA)\0", NULL, "Sage's Creation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kagekiRomInfo, md_kagekiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ka-Ge-Ki (Jpn)
static struct BurnRomInfo md_kagekijRomDesc[] = {
	{ "ka-ge-ki (jpn).bin", 0x100000, 0x391866a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kagekij)
STD_ROM_FN(md_kagekij)

struct BurnDriver BurnDrvmd_kagekij = {
	"md_kagekij", "md_kageki", NULL, NULL, "1991",
	"Ka-Ge-Ki (Jpn)\0", NULL, "Hot-B", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kagekijRomInfo, md_kagekijRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kawasaki Superbike Challenge (Euro, USA)
static struct BurnRomInfo md_kawasakiRomDesc[] = {
	{ "kawasaki superbike challenge (euro, usa).bin", 0x100000, 0x631cc8e9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kawasaki)
STD_ROM_FN(md_kawasaki)

struct BurnDriver BurnDrvmd_kawasaki = {
	"md_kawasaki", NULL, NULL, NULL, "1994",
	"Kawasaki Superbike Challenge (Euro, USA)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kawasakiRomInfo, md_kawasakiRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kawasaki Superbike Challenge (USA, Prototype)
static struct BurnRomInfo md_kawasakipRomDesc[] = {
	{ "kawasaki superbike challenge (usa) (beta).bin", 0x100000, 0x55934d1b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kawasakip)
STD_ROM_FN(md_kawasakip)

struct BurnDriver BurnDrvmd_kawasakip = {
	"md_kawasakip", "md_kawasaki", NULL, NULL, "1994",
	"Kawasaki Superbike Challenge (USA, Prototype)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kawasakipRomInfo, md_kawasakipRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kick Off 3 - European Challenge (Euro)
static struct BurnRomInfo md_kickoff3RomDesc[] = {
	{ "kick off 3 - european challenge (euro).bin", 0x100000, 0xbc37401a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kickoff3)
STD_ROM_FN(md_kickoff3)

struct BurnDriver BurnDrvmd_kickoff3 = {
	"md_kickoff3", NULL, NULL, NULL, "1994",
	"Kick Off 3 - European Challenge (Euro)\0", NULL, "Vic Tokai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kickoff3RomInfo, md_kickoff3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chameleon Kid (Jpn)
static struct BurnRomInfo md_kidchamjRomDesc[] = {
	{ "chameleon kid (jpn).bin", 0x100000, 0x50217c80, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kidchamj)
STD_ROM_FN(md_kidchamj)

struct BurnDriver BurnDrvmd_kidchamj = {
	"md_kidchamj", "md_kidcham", NULL, NULL, "1992",
	"Chameleon Kid (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kidchamjRomInfo, md_kidchamjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kidou Keisatsu Patlabor - 98-shiki Kidou Seyo! (Jpn)
static struct BurnRomInfo md_patlaborRomDesc[] = {
	{ "kidou keisatsu patlabor - 98-shiki kidou seyo! (jpn).bin", 0x080000, 0x21a0e749, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_patlabor)
STD_ROM_FN(md_patlabor)

struct BurnDriver BurnDrvmd_patlabor = {
	"md_patlabor", NULL, NULL, NULL, "1992",
	"Kidou Keisatsu Patlabor - 98-shiki Kidou Seyo! (Jpn)\0", NULL, "Ma-Ba", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_patlaborRomInfo, md_patlaborRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Tougiou King Colossus (Jpn)
static struct BurnRomInfo md_kingcolRomDesc[] = {
	{ "mpr-14929.bin", 0x100000, 0xffe7b3c7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kingcol)
STD_ROM_FN(md_kingcol)

struct BurnDriver BurnDrvmd_kingcol = {
	"md_kingcol", NULL, NULL, NULL, "1992",
	"Tougiou King Colossus (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_kingcolRomInfo, md_kingcolRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters (Euro)
static struct BurnRomInfo md_kotmRomDesc[] = {
	{ "king of the monsters (euro).bin", 0x100000, 0x7a94fd49, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kotm)
STD_ROM_FN(md_kotm)

struct BurnDriver BurnDrvmd_kotm = {
	"md_kotm", NULL, NULL, NULL, "1993",
	"King of the Monsters (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kotmRomInfo, md_kotmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters (USA)
static struct BurnRomInfo md_kotmuRomDesc[] = {
	{ "king of the monsters (usa).bin", 0x100000, 0xf390d406, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kotmu)
STD_ROM_FN(md_kotmu)

struct BurnDriver BurnDrvmd_kotmu = {
	"md_kotmu", "md_kotm", NULL, NULL, "1993",
	"King of the Monsters (USA)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kotmuRomInfo, md_kotmuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters (Jpn)
static struct BurnRomInfo md_kotmjRomDesc[] = {
	{ "king of the monsters (jpn).bin", 0x100000, 0x3af7e74e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kotmj)
STD_ROM_FN(md_kotmj)

struct BurnDriver BurnDrvmd_kotmj = {
	"md_kotmj", "md_kotm", NULL, NULL, "1993",
	"King of the Monsters (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kotmjRomInfo, md_kotmjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters 2 (USA)
static struct BurnRomInfo md_kotm2RomDesc[] = {
	{ "king of the monsters 2 (usa).bin", 0x200000, 0xee1638ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kotm2)
STD_ROM_FN(md_kotm2)

struct BurnDriver BurnDrvmd_kotm2 = {
	"md_kotm2", NULL, NULL, NULL, "1994",
	"King of the Monsters 2 (USA)\0", NULL, "Takara", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kotm2RomInfo, md_kotm2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King Salmon - The Big Catch (USA)
static struct BurnRomInfo md_kingsalRomDesc[] = {
	{ "king salmon - the big catch (usa).bin", 0x080000, 0xf516e7d9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kingsal)
STD_ROM_FN(md_kingsal)

struct BurnDriver BurnDrvmd_kingsal = {
	"md_kingsal", NULL, NULL, NULL, "1993",
	"King Salmon - The Big Catch (USA)\0", NULL, "Vic Tokai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kingsalRomInfo, md_kingsalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King Salmon (Jpn)
static struct BurnRomInfo md_kingsaljRomDesc[] = {
	{ "king salmon (jpn).bin", 0x080000, 0x2cfc9f61, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kingsalj)
STD_ROM_FN(md_kingsalj)

struct BurnDriver BurnDrvmd_kingsalj = {
	"md_kingsalj", "md_kingsal", NULL, NULL, "1992",
	"King Salmon (Jpn)\0", NULL, "Hot-B", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kingsaljRomInfo, md_kingsaljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King's Bounty - The Conqueror's Quest (Euro, USA)
static struct BurnRomInfo md_kingsbtyRomDesc[] = {
	{ "king's bounty - the conqueror's quest (euro, usa).bin", 0x080000, 0xaa68a92e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kingsbty)
STD_ROM_FN(md_kingsbty)

struct BurnDriver BurnDrvmd_kingsbty = {
	"md_kingsbty", NULL, NULL, NULL, "1991",
	"King's Bounty - The Conqueror's Quest (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kingsbtyRomInfo, md_kingsbtyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kishi Densetsu (Jpn)
static struct BurnRomInfo md_kishidenRomDesc[] = {
	{ "kishi densetsu (jpn).bin", 0x180000, 0x22e1f04a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kishiden)
STD_ROM_FN(md_kishiden)

struct BurnDriver BurnDrvmd_kishiden = {
	"md_kishiden", NULL, NULL, NULL, "1993",
	"Kishi Densetsu (Jpn)\0", NULL, "Kodansha", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_kishidenRomInfo, md_kishidenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kiss Shot (Jpn, SegaNet)
static struct BurnRomInfo md_kissshotRomDesc[] = {
	{ "kiss shot (jpn) (sn).bin", 0x040000, 0xe487088c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kissshot)
STD_ROM_FN(md_kissshot)

struct BurnDriver BurnDrvmd_kissshot = {
	"md_kissshot", NULL, NULL, NULL, "1991",
	"Kiss Shot (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kissshotRomInfo, md_kissshotRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Klax (Euro, USA)
static struct BurnRomInfo md_klaxRomDesc[] = {
	{ "klax (euro, usa).bin", 0x040000, 0x248cd09e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_klax)
STD_ROM_FN(md_klax)

struct BurnDriver BurnDrvmd_klax = {
	"md_klax", NULL, NULL, NULL, "1990",
	"Klax (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_klaxRomInfo, md_klaxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Klax (Jpn)
static struct BurnRomInfo md_klaxjRomDesc[] = {
	{ "klax (jpn).bin", 0x040000, 0x1afcc1da, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_klaxj)
STD_ROM_FN(md_klaxj)

struct BurnDriver BurnDrvmd_klaxj = {
	"md_klaxj", "md_klax", NULL, NULL, "1990",
	"Klax (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_klaxjRomInfo, md_klaxjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Krusty's Super Fun House (Euro, USA, v1.1)
static struct BurnRomInfo md_krustyRomDesc[] = {
	{ "krusty's super fun house (euro, usa) (v1.1).bin", 0x080000, 0x56976261, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_krusty)
STD_ROM_FN(md_krusty)

struct BurnDriver BurnDrvmd_krusty = {
	"md_krusty", NULL, NULL, NULL, "1992",
	"Krusty's Super Fun House (Euro, USA, v1.1)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_krustyRomInfo, md_krustyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Krusty's Super Fun House (Euro, USA)
static struct BurnRomInfo md_krusty1RomDesc[] = {
	{ "krusty's super fun house (euro, usa).bin", 0x080000, 0xf764005e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_krusty1)
STD_ROM_FN(md_krusty1)

struct BurnDriver BurnDrvmd_krusty1 = {
	"md_krusty1", "md_krusty", NULL, NULL, "1992",
	"Krusty's Super Fun House (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_krusty1RomInfo, md_krusty1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kyuukai Douchuuki (Jpn)
static struct BurnRomInfo md_kyukaidkRomDesc[] = {
	{ "kyuukai douchuuki (jpn).bin", 0x080000, 0xde48dce3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kyukaidk)
STD_ROM_FN(md_kyukaidk)

struct BurnDriver BurnDrvmd_kyukaidk = {
	"md_kyukaidk", NULL, NULL, NULL, "1991",
	"Kyuukai Douchuuki (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kyukaidkRomInfo, md_kyukaidkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// La Russa Baseball 95 (USA, Oceania)
static struct BurnRomInfo md_larussaRomDesc[] = {
	{ "la russa baseball 95 (usa, aus).bin", 0x200000, 0x3f848a92, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_larussa)
STD_ROM_FN(md_larussa)

struct BurnDriver BurnDrvmd_larussa = {
	"md_larussa", NULL, NULL, NULL, "1994",
	"La Russa Baseball 95 (USA, Oceania)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_larussaRomInfo, md_larussaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lakers versus Celtics and the NBA Playoffs (USA)
static struct BurnRomInfo md_lakersRomDesc[] = {
	{ "lakers versus celtics and the nba playoffs (usa).bin", 0x080000, 0x0e33fc75, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lakers)
STD_ROM_FN(md_lakers)

struct BurnDriver BurnDrvmd_lakers = {
	"md_lakers", NULL, NULL, NULL, "1991",
	"Lakers versus Celtics and the NBA Playoffs (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lakersRomInfo, md_lakersRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - The Treasures of King Nole (Euro)
static struct BurnRomInfo md_landstlkRomDesc[] = {
	{ "landstalker - the treasures of king nole (euro).bin", 0x200000, 0xe3c65277, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlk)
STD_ROM_FN(md_landstlk)

struct BurnDriver BurnDrvmd_landstlk = {
	"md_landstlk", NULL, NULL, NULL, "1993",
	"Landstalker - The Treasures of King Nole (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkRomInfo, md_landstlkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Le Tresor du Roi Nole (Fra)
static struct BurnRomInfo md_landstlkfRomDesc[] = {
	{ "landstalker - le tresor du roi nole (france).bin", 0x200000, 0x5de7d917, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlkf)
STD_ROM_FN(md_landstlkf)

struct BurnDriver BurnDrvmd_landstlkf = {
	"md_landstlkf", "md_landstlk", NULL, NULL, "1993",
	"Landstalker - Le Tresor du Roi Nole (Fra)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkfRomInfo, md_landstlkfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Die Schatze von Konig Nolo (Ger)
static struct BurnRomInfo md_landstlkgRomDesc[] = {
	{ "landstalker - die schatze von konig nolo (germany).bin", 0x200000, 0x10fedb8f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlkg)
STD_ROM_FN(md_landstlkg)

struct BurnDriver BurnDrvmd_landstlkg = {
	"md_landstlkg", "md_landstlk", NULL, NULL, "1993",
	"Landstalker - Die Schatze von Konig Nolo (Ger)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkgRomInfo, md_landstlkgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Koutei no Zaihou (Jpn)
static struct BurnRomInfo md_landstlkjRomDesc[] = {
	{ "landstalker - koutei no zaihou (jpn).bin", 0x200000, 0x60d4cedb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlkj)
STD_ROM_FN(md_landstlkj)

struct BurnDriver BurnDrvmd_landstlkj = {
	"md_landstlkj", "md_landstlk", NULL, NULL, "1992",
	"Landstalker - Koutei no Zaihou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkjRomInfo, md_landstlkjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker (USA)
static struct BurnRomInfo md_landstlkuRomDesc[] = {
	{ "landstalker (usa).bin", 0x200000, 0xfbbb5b97, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlku)
STD_ROM_FN(md_landstlku)

struct BurnDriver BurnDrvmd_landstlku = {
	"md_landstlku", "md_landstlk", NULL, NULL, "1992",
	"Landstalker (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkuRomInfo, md_landstlkuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker (USA, Prototype)
static struct BurnRomInfo md_landstlkupRomDesc[] = {
	{ "landstalker (usa) (beta).bin", 0x200000, 0x70483d03, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_landstlkup)
STD_ROM_FN(md_landstlkup)

struct BurnDriver BurnDrvmd_landstlkup = {
	"md_landstlkup", "md_landstlk", NULL, NULL, "1992",
	"Landstalker (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_landstlkupRomInfo, md_landstlkupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser (Jpn)
static struct BurnRomInfo md_langrissRomDesc[] = {
	{ "mpr-13845.bin", 0x080000, 0xb6ea5016, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_langriss)
STD_ROM_FN(md_langriss)

struct BurnDriver BurnDrvmd_langriss = {
	"md_langriss", "md_warsong", NULL, NULL, "1991",
	"Langrisser (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_langrissRomInfo, md_langrissRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Jpn, v1.2)
static struct BurnRomInfo md_langris2RomDesc[] = {
	{ "langrisser ii (jpn) (v1.2).bin", 0x200000, 0x4967c9f9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_langris2)
STD_ROM_FN(md_langris2)

struct BurnDriver BurnDrvmd_langris2 = {
	"md_langris2", NULL, NULL, NULL, "1994",
	"Langrisser II (Jpn, v1.2)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_langris2RomInfo, md_langris2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Jpn, v1.1)
static struct BurnRomInfo md_langris2aRomDesc[] = {
	{ "langrisser ii (jpn) (v1.1).bin", 0x200000, 0x0caa0593, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_langris2a)
STD_ROM_FN(md_langris2a)

struct BurnDriver BurnDrvmd_langris2a = {
	"md_langris2a", "md_langris2", NULL, NULL, "1994",
	"Langrisser II (Jpn, v1.1)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_langris2aRomInfo, md_langris2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Jpn)
static struct BurnRomInfo md_langris2bRomDesc[] = {
	{ "langrisser ii (jpn).bin", 0x200000, 0x7f891dfc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_langris2b)
STD_ROM_FN(md_langris2b)

struct BurnDriver BurnDrvmd_langris2b = {
	"md_langris2b", "md_langris2", NULL, NULL, "1994",
	"Langrisser II (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_langris2bRomInfo, md_langris2bRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Last Action Hero (Euro, USA)
static struct BurnRomInfo md_lastactRomDesc[] = {
	{ "last action hero (euro, usa).bin", 0x100000, 0x15357dde, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lastact)
STD_ROM_FN(md_lastact)

struct BurnDriver BurnDrvmd_lastact = {
	"md_lastact", NULL, NULL, NULL, "1993",
	"Last Action Hero (Euro, USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lastactRomInfo, md_lastactRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Last Battle (Euro, USA, Kor)
static struct BurnRomInfo md_lastbtleRomDesc[] = {
	{ "mpr-12578.bin", 0x080000, 0xbbfaad77, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lastbtle)
STD_ROM_FN(md_lastbtle)

struct BurnDriver BurnDrvmd_lastbtle = {
	"md_lastbtle", NULL, NULL, NULL, "1989",
	"Last Battle (Euro, USA, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lastbtleRomInfo, md_lastbtleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hokuto no Ken - Shin Seikimatsu Kyuuseishu Densetsu (Jpn)
static struct BurnRomInfo md_hokutoRomDesc[] = {
	{ "hokuto no ken - shin seikimatsu kyuuseishu densetsu (jpn).bin", 0x080000, 0x1b6585e7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_hokuto)
STD_ROM_FN(md_hokuto)

struct BurnDriver BurnDrvmd_hokuto = {
	"md_hokuto", "md_lastbtle", NULL, NULL, "1989",
	"Hokuto no Ken - Shin Seikimatsu Kyuuseishu Densetsu (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_hokutoRomInfo, md_hokutoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lawnmower Man (Euro, USA)
static struct BurnRomInfo md_lawnmowrRomDesc[] = {
	{ "lawnmower man, the (euro, usa).bin", 0x100000, 0xa7cacd59, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lawnmowr)
STD_ROM_FN(md_lawnmowr)

struct BurnDriver BurnDrvmd_lawnmowr = {
	"md_lawnmowr", NULL, NULL, NULL, "1994",
	"The Lawnmower Man (Euro, USA)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lawnmowrRomInfo, md_lawnmowrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Galahad (Euro, USA)
static struct BurnRomInfo md_galahadRomDesc[] = {
	{ "gal01.bin", 0x100000, 0x679557bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_galahad)
STD_ROM_FN(md_galahad)

struct BurnDriver BurnDrvmd_galahad = {
	"md_galahad", NULL, NULL, NULL, "1992",
	"Galahad (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_galahadRomInfo, md_galahadRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Euro)
static struct BurnRomInfo md_lemmingsRomDesc[] = {
	{ "mpr-15233.bin", 0x100000, 0x6a1a4579, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lemmings)
STD_ROM_FN(md_lemmings)

struct BurnDriver BurnDrvmd_lemmings = {
	"md_lemmings", NULL, NULL, NULL, "1992",
	"Lemmings (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lemmingsRomInfo, md_lemmingsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Jpn, USA, Kor, v1.1)
static struct BurnRomInfo md_lemmingsjuRomDesc[] = {
	{ "sunsoft_lem8_j.bin", 0x100000, 0x68c70362, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lemmingsju)
STD_ROM_FN(md_lemmingsju)

struct BurnDriver BurnDrvmd_lemmingsju = {
	"md_lemmingsju", "md_lemmings", NULL, NULL, "1992",
	"Lemmings (Jpn, USA, Kor, v1.1)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lemmingsjuRomInfo, md_lemmingsjuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Jpn, USA)
static struct BurnRomInfo md_lemmingsju1RomDesc[] = {
	{ "lemmings (usa, jpn).bin", 0x100000, 0xf015c2ad, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lemmingsju1)
STD_ROM_FN(md_lemmingsju1)

struct BurnDriver BurnDrvmd_lemmingsju1 = {
	"md_lemmingsju1", "md_lemmings", NULL, NULL, "1992",
	"Lemmings (Jpn, USA)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lemmingsju1RomInfo, md_lemmingsju1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings 2 - The Tribes (Euro)
static struct BurnRomInfo md_lemming2RomDesc[] = {
	{ "lemmings 2 - the tribes (euro).bin", 0x200000, 0x741eb624, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lemming2)
STD_ROM_FN(md_lemming2)

struct BurnDriver BurnDrvmd_lemming2 = {
	"md_lemming2", NULL, NULL, NULL, "1994",
	"Lemmings 2 - The Tribes (Euro)\0", NULL, "Psygnosis", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lemming2RomInfo, md_lemming2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings 2 - The Tribes (USA)
static struct BurnRomInfo md_lemming2uRomDesc[] = {
	{ "lemmings 2 - the tribes (usa).bin", 0x200000, 0xde59a3a3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lemming2u)
STD_ROM_FN(md_lemming2u)

struct BurnDriver BurnDrvmd_lemming2u = {
	"md_lemming2u", "md_lemming2", NULL, NULL, "1994",
	"Lemmings 2 - The Tribes (USA)\0", NULL, "Psygnosis", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lemming2uRomInfo, md_lemming2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (Euro)
static struct BurnRomInfo md_lethalenRomDesc[] = {
	{ "lethal enforcers (euro).bin", 0x200000, 0xca2bf99d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lethalen)
STD_ROM_FN(md_lethalen)

struct BurnDriver BurnDrvmd_lethalen = {
	"md_lethalen", NULL, NULL, NULL, "1993",
	"Lethal Enforcers (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lethalenRomInfo, md_lethalenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (Jpn)
static struct BurnRomInfo md_lethalenjRomDesc[] = {
	{ "fz008.bin", 0x200000, 0xf25f1e49, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lethalenj)
STD_ROM_FN(md_lethalenj)

struct BurnDriver BurnDrvmd_lethalenj = {
	"md_lethalenj", "md_lethalen", NULL, NULL, "1993",
	"Lethal Enforcers (Jpn)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lethalenjRomInfo, md_lethalenjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (USA)
static struct BurnRomInfo md_lethalenuRomDesc[] = {
	{ "lethal enforcers (usa).bin", 0x200000, 0x51d9a84a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lethalenu)
STD_ROM_FN(md_lethalenu)

struct BurnDriver BurnDrvmd_lethalenu = {
	"md_lethalenu", "md_lethalen", NULL, NULL, "1993",
	"Lethal Enforcers (USA)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lethalenuRomInfo, md_lethalenuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers II - Gun Fighters (Euro)
static struct BurnRomInfo md_le2RomDesc[] = {
	{ "lethal enforcers ii - gun fighters (euro).bin", 0x200000, 0x4bfe045c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_le2)
STD_ROM_FN(md_le2)

struct BurnDriver BurnDrvmd_le2 = {
	"md_le2", NULL, NULL, NULL, "1994",
	"Lethal Enforcers II - Gun Fighters (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_le2RomInfo, md_le2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers II - Gun Fighters (USA)
static struct BurnRomInfo md_le2uRomDesc[] = {
	{ "lethal enforcers ii - gun fighters (usa).bin", 0x200000, 0xe5fdd28b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_le2u)
STD_ROM_FN(md_le2u)

struct BurnDriver BurnDrvmd_le2u = {
	"md_le2u", "md_le2", NULL, NULL, "1994",
	"Lethal Enforcers II - Gun Fighters (USA)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_le2uRomInfo, md_le2uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// LHX Attack Chopper (Euro, USA)
static struct BurnRomInfo md_lhxRomDesc[] = {
	{ "lhx04.bin", 0x100000, 0x70c3428d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lhx)
STD_ROM_FN(md_lhx)

struct BurnDriver BurnDrvmd_lhx = {
	"md_lhx", NULL, NULL, NULL, "1992",
	"LHX Attack Chopper (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lhxRomInfo, md_lhxRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// LHX Attack Chopper (Jpn)
static struct BurnRomInfo md_lhxjRomDesc[] = {
	{ "lhx attack chopper (jpn).bin", 0x100000, 0x224ff103, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lhxj)
STD_ROM_FN(md_lhxj)

struct BurnDriver BurnDrvmd_lhxj = {
	"md_lhxj", "md_lhx", NULL, NULL, "1993",
	"LHX Attack Chopper (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lhxjRomInfo, md_lhxjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Liberty or Death (USA)
static struct BurnRomInfo md_libertyRomDesc[] = {
	{ "liberty or death (usa).bin", 0x200000, 0x2adb0364, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_liberty)
STD_ROM_FN(md_liberty)

struct BurnDriver BurnDrvmd_liberty = {
	"md_liberty", NULL, NULL, NULL, "1994",
	"Liberty or Death (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_libertyRomInfo, md_libertyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Jpn)
static struct BurnRomInfo md_lightcjRomDesc[] = {
	{ "light crusader (jpn).bin", 0x200000, 0x237076a4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lightcj)
STD_ROM_FN(md_lightcj)

struct BurnDriver BurnDrvmd_lightcj = {
	"md_lightcj", "md_lightc", NULL, NULL, "1995",
	"Light Crusader (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lightcjRomInfo, md_lightcjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Kor)
static struct BurnRomInfo md_lightckRomDesc[] = {
	{ "light crusader (kor).bin", 0x200000, 0x6d0cbcb2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lightck)
STD_ROM_FN(md_lightck)

struct BurnDriver BurnDrvmd_lightck = {
	"md_lightck", "md_lightc", NULL, NULL, "1995",
	"Light Crusader (Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lightckRomInfo, md_lightckRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Prototype, 19950608)
static struct BurnRomInfo md_lightcpRomDesc[] = {
	{ "light crusader (prototype - jun 08, 1995).bin", 0x200000, 0xe350ccfa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lightcp)
STD_ROM_FN(md_lightcp)

struct BurnDriver BurnDrvmd_lightcp = {
	"md_lightcp", "md_lightc", NULL, NULL, "1995",
	"Light Crusader (Prototype, 19950608)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lightcpRomInfo, md_lightcpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (USA)
static struct BurnRomInfo md_lightcuRomDesc[] = {
	{ "light crusader (usa).bin", 0x200000, 0xbeb715dc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lightcu)
STD_ROM_FN(md_lightcu)

struct BurnDriver BurnDrvmd_lightcu = {
	"md_lightcu", "md_lightc", NULL, NULL, "1995",
	"Light Crusader (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lightcuRomInfo, md_lightcuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lion King (World)
static struct BurnRomInfo md_lionkingRomDesc[] = {
	{ "mpr-17270.bin", 0x300000, 0x5696a5bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lionking)
STD_ROM_FN(md_lionking)

struct BurnDriver BurnDrvmd_lionking = {
	"md_lionking", NULL, NULL, NULL, "1994",
	"The Lion King (World)\0", NULL, "Virgin Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lionkingRomInfo, md_lionkingRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lobo (USA, Prototype)
static struct BurnRomInfo md_loboRomDesc[] = {
	{ "lobo (usa) (prototype).bin", 0x300000, 0xb5e09338, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lobo)
STD_ROM_FN(md_lobo)

struct BurnDriver BurnDrvmd_lobo = {
	"md_lobo", NULL, NULL, NULL, "1996",
	"Lobo (USA, Prototype)\0", NULL, "Ocean", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_loboRomInfo, md_loboRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Long (Chi)
static struct BurnRomInfo md_longRomDesc[] = {
	{ "long (chi) (unl).bin", 0x040000, 0x1b86e623, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_long)
STD_ROM_FN(md_long)

struct BurnDriver BurnDrvmd_long = {
	"md_long", NULL, NULL, NULL, "199?",
	"Long (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_longRomInfo, md_longRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lord Monarch - Tokoton Sentou Densetsu (Jpn)
static struct BurnRomInfo md_lordmonRomDesc[] = {
	{ "lord monarch - tokoton sentou densetsu (jpn).bin", 0x200000, 0x238bf5db, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lordmon)
STD_ROM_FN(md_lordmon)

struct BurnDriver BurnDrvmd_lordmon = {
	"md_lordmon", NULL, NULL, NULL, "1994",
	"Lord Monarch - Tokoton Sentou Densetsu (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_lordmonRomInfo, md_lordmonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lost Vikings (Euro)
static struct BurnRomInfo md_lostvikRomDesc[] = {
	{ "lost vikings, the (euro).bin", 0x100000, 0x1f14efc6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lostvik)
STD_ROM_FN(md_lostvik)

struct BurnDriver BurnDrvmd_lostvik = {
	"md_lostvik", NULL, NULL, NULL, "1993",
	"The Lost Vikings (Euro)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lostvikRomInfo, md_lostvikRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lost Vikings (Euro, Prototype)
static struct BurnRomInfo md_lostvikpRomDesc[] = {
	{ "lost vikings, the (euro) (beta).bin", 0x100000, 0x17bed25f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lostvikp)
STD_ROM_FN(md_lostvikp)

struct BurnDriver BurnDrvmd_lostvikp = {
	"md_lostvikp", "md_lostvik", NULL, NULL, "1993",
	"The Lost Vikings (Euro, Prototype)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lostvikpRomInfo, md_lostvikpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lost Vikings (USA)
static struct BurnRomInfo md_lostvikuRomDesc[] = {
	{ "lost vikings, the (usa).bin", 0x100000, 0x7ba49edb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lostviku)
STD_ROM_FN(md_lostviku)

struct BurnDriver BurnDrvmd_lostviku = {
	"md_lostviku", "md_lostvik", NULL, NULL, "1992",
	"The Lost Vikings (USA)\0", NULL, "Interplay", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lostvikuRomInfo, md_lostvikuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Lost World - Jurassic Park (Euro, USA)
static struct BurnRomInfo md_lostwrldRomDesc[] = {
	{ "lost world, the - jurassic park (euro, usa).bin", 0x400000, 0x140a284c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lostwrld)
STD_ROM_FN(md_lostwrld)

struct BurnDriver BurnDrvmd_lostwrld = {
	"md_lostwrld", NULL, NULL, NULL, "1997",
	"The Lost World - Jurassic Park (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lostwrldRomInfo, md_lostwrldRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus II (Euro, USA)
static struct BurnRomInfo md_lotus2RomDesc[] = {
	{ "lot205.bin", 0x100000, 0x1d8ee010, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lotus2)
STD_ROM_FN(md_lotus2)

struct BurnDriver BurnDrvmd_lotus2 = {
	"md_lotus2", NULL, NULL, NULL, "1993",
	"Lotus II (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lotus2RomInfo, md_lotus2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus II (USA, Prototype)
static struct BurnRomInfo md_lotus2pRomDesc[] = {
	{ "lotus ii (usa) (beta).bin", 0x100000, 0x2997b7d4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_lotus2p)
STD_ROM_FN(md_lotus2p)

struct BurnDriver BurnDrvmd_lotus2p = {
	"md_lotus2p", "md_lotus2", NULL, NULL, "1993",
	"Lotus II (USA, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_lotus2pRomInfo, md_lotus2pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// M-1 Abrams Battle Tank (Euro, USA)
static struct BurnRomInfo md_m1abramsRomDesc[] = {
	{ "m-1 abrams battle tank (euro, usa).bin", 0x080000, 0x1e2f74cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_m1abrams)
STD_ROM_FN(md_m1abrams)

struct BurnDriver BurnDrvmd_m1abrams = {
	"md_m1abrams", NULL, NULL, NULL, "1991",
	"M-1 Abrams Battle Tank (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_m1abramsRomInfo, md_m1abramsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ma Qiao E Mo Ta - Devilish Mahjong Tower (Chi)
static struct BurnRomInfo md_maqiaoRomDesc[] = {
	{ "ma qiao e mo ta - devilish mahjong tower (chi) (unl).bin", 0x100000, 0x12e35994, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_maqiao)
STD_ROM_FN(md_maqiao)

struct BurnDriver BurnDrvmd_maqiao = {
	"md_maqiao", NULL, NULL, NULL, "1994",
	"Ma Qiao E Mo Ta - Devilish Mahjong Tower (Chi)\0", NULL, "C&E", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_maqiaoRomInfo, md_maqiaoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL '94 (Euro, USA)
static struct BurnRomInfo md_madden94RomDesc[] = {
	{ "madden nfl '94 (euro, usa).bin", 0x200000, 0xd14b811b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden94)
STD_ROM_FN(md_madden94)

struct BurnDriver BurnDrvmd_madden94 = {
	"md_madden94", NULL, NULL, NULL, "1994",
	"Madden NFL '94 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_madden94RomInfo, md_madden94RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 95 (Euro, USA)
static struct BurnRomInfo md_madden95RomDesc[] = {
	{ "madden nfl 95 (euro, usa).bin", 0x200000, 0xdb0be0c2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden95)
STD_ROM_FN(md_madden95)

struct BurnDriver BurnDrvmd_madden95 = {
	"md_madden95", NULL, NULL, NULL, "1994",
	"Madden NFL 95 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_madden95RomInfo, md_madden95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 96 (Euro, USA)
static struct BurnRomInfo md_madden96RomDesc[] = {
	{ "madden nfl 96 (euro, usa).bin", 0x200000, 0xf126918b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden96)
STD_ROM_FN(md_madden96)

struct BurnDriver BurnDrvmd_madden96 = {
	"md_madden96", NULL, NULL, NULL, "1995",
	"Madden NFL 96 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_madden96RomInfo, md_madden96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 97 (Euro, USA)
static struct BurnRomInfo md_madden97RomDesc[] = {
	{ "madden nfl 97 (euro, usa).bin", 0x200000, 0xc4b4e112, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden97)
STD_ROM_FN(md_madden97)

struct BurnDriver BurnDrvmd_madden97 = {
	"md_madden97", NULL, NULL, NULL, "1997",
	"Madden NFL 97 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_madden97RomInfo, md_madden97RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 98 (USA)
static struct BurnRomInfo md_madden98RomDesc[] = {
	{ "madden nfl 98 (usa).bin", 0x200000, 0xe051ea62, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madden98)
STD_ROM_FN(md_madden98)

struct BurnDriver BurnDrvmd_madden98 = {
	"md_madden98", NULL, NULL, NULL, "1997",
	"Madden NFL 98 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_madden98RomInfo, md_madden98RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madou Monogatari I (Jpn)
static struct BurnRomInfo md_madoumRomDesc[] = {
	{ "madou monogatari i (jpn).bin", 0x200000, 0xdd82c401, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_madoum)
STD_ROM_FN(md_madoum)

struct BurnDriver BurnDrvmd_madoum = {
	"md_madoum", NULL, NULL, NULL, "1996",
	"Madou Monogatari I (Jpn)\0", NULL, "Compile", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_madoumRomInfo, md_madoumRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (USA)
static struct BurnRomInfo md_msbRomDesc[] = {
	{ "magic school bus, the (usa).bin", 0x100000, 0x1a5d4412, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msb)
STD_ROM_FN(md_msb)

struct BurnDriver BurnDrvmd_msb = {
	"md_msb", NULL, NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbRomInfo, md_msbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950411)
static struct BurnRomInfo md_msbp05RomDesc[] = {
	{ "magic school bus, the (prototype - apr 11, 1995).bin", 0x0fdfbc, 0x883023bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp05)
STD_ROM_FN(md_msbp05)

struct BurnDriver BurnDrvmd_msbp05 = {
	"md_msbp05", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950411)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp05RomInfo, md_msbp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950421)
static struct BurnRomInfo md_msbp04RomDesc[] = {
	{ "magic school bus, the (prototype - apr 21, 1995).bin", 0x0fcfdc, 0x7844b7ad, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp04)
STD_ROM_FN(md_msbp04)

struct BurnDriver BurnDrvmd_msbp04 = {
	"md_msbp04", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950421)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp04RomInfo, md_msbp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950425)
static struct BurnRomInfo md_msbp03RomDesc[] = {
	{ "magic school bus, the (prototype - apr 25, 1995).bin", 0x0fd5e0, 0xb6bd2d87, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp03)
STD_ROM_FN(md_msbp03)

struct BurnDriver BurnDrvmd_msbp03 = {
	"md_msbp03", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950425)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp03RomInfo, md_msbp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950428)
static struct BurnRomInfo md_msbp02RomDesc[] = {
	{ "magic school bus, the (prototype - apr 28, 1995).bin", 0x0fe89c, 0x9b6bae87, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp02)
STD_ROM_FN(md_msbp02)

struct BurnDriver BurnDrvmd_msbp02 = {
	"md_msbp02", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950428)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp02RomInfo, md_msbp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950202)
static struct BurnRomInfo md_msbp11RomDesc[] = {
	{ "magic school bus, the (prototype - feb 02, 1995).bin", 0x100000, 0x7805b5c9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp11)
STD_ROM_FN(md_msbp11)

struct BurnDriver BurnDrvmd_msbp11 = {
	"md_msbp11", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950202)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp11RomInfo, md_msbp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950217)
static struct BurnRomInfo md_msbp10RomDesc[] = {
	{ "magic school bus, the (prototype - feb 17, 1995).bin", 0x0df6bc, 0x2b7a88c0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp10)
STD_ROM_FN(md_msbp10)

struct BurnDriver BurnDrvmd_msbp10 = {
	"md_msbp10", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950217)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp10RomInfo, md_msbp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950112)
static struct BurnRomInfo md_msbp12RomDesc[] = {
	{ "magic school bus, the (prototype - jan 12, 1995).bin", 0x0eb2e4, 0x946346f9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp12)
STD_ROM_FN(md_msbp12)

struct BurnDriver BurnDrvmd_msbp12 = {
	"md_msbp12", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950112)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp12RomInfo, md_msbp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950307)
static struct BurnRomInfo md_msbp09RomDesc[] = {
	{ "magic school bus, the (prototype - mar 07, 1995).bin", 0x0e9aa8, 0x26c71eb8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp09)
STD_ROM_FN(md_msbp09)

struct BurnDriver BurnDrvmd_msbp09 = {
	"md_msbp09", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950307)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp09RomInfo, md_msbp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950314)
static struct BurnRomInfo md_msbp08RomDesc[] = {
	{ "magic school bus, the (prototype - mar 14, 1995).bin", 0x0f1c30, 0x37a6a1af, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp08)
STD_ROM_FN(md_msbp08)

struct BurnDriver BurnDrvmd_msbp08 = {
	"md_msbp08", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950314)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp08RomInfo, md_msbp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Magic School Bus (Prototype, 19950327)
static struct BurnRomInfo md_msbp07RomDesc[] = {
	{ "magic school bus, the (prototype - mar 27, 1995).bin", 0x0f52e8, 0xb065da40, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp07)
STD_ROM_FN(md_msbp07)

struct BurnDriver BurnDrvmd_msbp07 = {
	"md_msbp07", "md_msb", NULL, NULL, "1995",
	"The Magic School Bus (Prototype, 19950327)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp07RomInfo, md_msbp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950331)
static struct BurnRomInfo md_msbp06RomDesc[] = {
	{ "magic school bus, the (prototype - mar 31, 1995).bin", 0x0f93c0, 0xcd788def, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp06)
STD_ROM_FN(md_msbp06)

struct BurnDriver BurnDrvmd_msbp06 = {
	"md_msbp06", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950331)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp06RomInfo, md_msbp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Scholastic's The Magic School Bus (Prototype, 19950505)
static struct BurnRomInfo md_msbp01RomDesc[] = {
	{ "magic school bus, the (prototype - may 05, 1995).bin", 0x0fea00, 0xa2315f1c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_msbp01)
STD_ROM_FN(md_msbp01)

struct BurnDriver BurnDrvmd_msbp01 = {
	"md_msbp01", "md_msb", NULL, NULL, "1995",
	"Scholastic's The Magic School Bus (Prototype, 19950505)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_msbp01RomInfo, md_msbp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magical Hat no Buttobi Turbo! Daibouken (Jpn)
static struct BurnRomInfo md_magichatRomDesc[] = {
	{ "magical hat no buttobi turbo! daibouken (jpn).bin", 0x080000, 0xe43e853d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_magichat)
STD_ROM_FN(md_magichat)

struct BurnDriver BurnDrvmd_magichat = {
	"md_magichat", NULL, NULL, NULL, "1990",
	"Magical Hat no Buttobi Turbo! Daibouken (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_magichatRomInfo, md_magichatRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magical Taruruuto-kun (Jpn)
static struct BurnRomInfo md_magtaruRomDesc[] = {
	{ "magical taruruuto-kun (jpn).bin", 0x080000, 0xf11060a5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_magtaru)
STD_ROM_FN(md_magtaru)

struct BurnDriver BurnDrvmd_magtaru = {
	"md_magtaru", NULL, NULL, NULL, "1992",
	"Magical Taruruuto-kun (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_magtaruRomInfo, md_magtaruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mahjong Cop Ryuu - Shiro Ookami no Yabou (Jpn)
static struct BurnRomInfo md_mahjongcRomDesc[] = {
	{ "mahjong cop ryuu - shiro ookami no yabou (jpn).bin", 0x040000, 0x1ccbc782, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mahjongc)
STD_ROM_FN(md_mahjongc)

struct BurnDriver BurnDrvmd_mahjongc = {
	"md_mahjongc", NULL, NULL, NULL, "1989",
	"Mahjong Cop Ryuu - Shiro Ookami no Yabou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mahjongcRomInfo, md_mahjongcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mamono Hunter Youko - Dai 7 no Keishou (Jpn)
static struct BurnRomInfo md_mamonoRomDesc[] = {
	{ "mamono hunter youko - dai 7 no keishou (jpn).bin", 0x080000, 0x10bb359b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mamono)
STD_ROM_FN(md_mamono)

struct BurnDriver BurnDrvmd_mamono = {
	"md_mamono", NULL, NULL, NULL, "1991",
	"Mamono Hunter Youko - Dai 7 no Keishou (Jpn)\0", NULL, "NCS", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mamonoRomInfo, md_mamonoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// S.S. Lucifer - Man Overboard! (Euro)
static struct BurnRomInfo md_manoverRomDesc[] = {
	{ "mdss12c4.bin", 0x100000, 0xcae0e3a6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_manover)
STD_ROM_FN(md_manover)

struct BurnDriver BurnDrvmd_manover = {
	"md_manover", NULL, NULL, NULL, "1994",
	"S.S. Lucifer - Man Overboard! (Euro)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_manoverRomInfo, md_manoverRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Newman Haas Indy Car Featuring Nigel Mansell ~ Nigel Mansell Indy Car (World)
static struct BurnRomInfo md_mansellRomDesc[] = {
	{ "newman haas indy car featuring nigel mansell -- nigel mansell indy car (world).bin", 0x200000, 0x1233a229, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mansell)
STD_ROM_FN(md_mansell)

struct BurnDriver BurnDrvmd_mansell = {
	"md_mansell", NULL, NULL, NULL, "1994",
	"Newman Haas Indy Car Featuring Nigel Mansell ~ Nigel Mansell Indy Car (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mansellRomInfo, md_mansellRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marble Madness (Euro, USA)
static struct BurnRomInfo md_marbleRomDesc[] = {
	{ "mar01.bin", 0x080000, 0x79eba28a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_marble)
STD_ROM_FN(md_marble)

struct BurnDriver BurnDrvmd_marble = {
	"md_marble", NULL, NULL, NULL, "1993",
	"Marble Madness (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_marbleRomInfo, md_marbleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mario Andretti Racing (Euro, USA)
static struct BurnRomInfo md_marioandRomDesc[] = {
	{ "mario andretti racing (euro, usa).bin", 0x200000, 0x7f1dc0aa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_marioand)
STD_ROM_FN(md_marioand)

struct BurnDriver BurnDrvmd_marioand = {
	"md_marioand", NULL, NULL, NULL, "1994",
	"Mario Andretti Racing (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_marioandRomInfo, md_marioandRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mario Lemieux Hockey (Euro, USA)
static struct BurnRomInfo md_mariolhRomDesc[] = {
	{ "mpr-14376.bin", 0x080000, 0xf664eb6c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mariolh)
STD_ROM_FN(md_mariolh)

struct BurnDriver BurnDrvmd_mariolh = {
	"md_mariolh", NULL, NULL, NULL, "1991",
	"Mario Lemieux Hockey (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mariolhRomInfo, md_mariolhRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (Euro)
static struct BurnRomInfo md_markoRomDesc[] = {
	{ "mpr-16825.bin", 0x200000, 0x2307b905, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_marko)
STD_ROM_FN(md_marko)

struct BurnDriver BurnDrvmd_marko = {
	"md_marko", NULL, NULL, NULL, "1994",
	"Marko's Magic Football (Euro)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_markoRomInfo, md_markoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (Euro, Prototype)
static struct BurnRomInfo md_markopRomDesc[] = {
	{ "marko's magic football (euro) (beta).bin", 0x200000, 0x0273e564, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_markop)
STD_ROM_FN(md_markop)

struct BurnDriver BurnDrvmd_markop = {
	"md_markop", "md_marko", NULL, NULL, "1994",
	"Marko's Magic Football (Euro, Prototype)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_markopRomInfo, md_markopRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (USA)
static struct BurnRomInfo md_markouRomDesc[] = {
	{ "marko's magic football (usa).bin", 0x200000, 0x2b8c8cce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_markou)
STD_ROM_FN(md_markou)

struct BurnDriver BurnDrvmd_markou = {
	"md_markou", "md_marko", NULL, NULL, "1994",
	"Marko's Magic Football (USA)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_markouRomInfo, md_markouRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marsupilami (Euro)
static struct BurnRomInfo md_marsupRomDesc[] = {
	{ "marsupilami (euro).bin", 0x200000, 0xe09bbd70, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_marsup)
STD_ROM_FN(md_marsup)

struct BurnDriver BurnDrvmd_marsup = {
	"md_marsup", NULL, NULL, NULL, "1995",
	"Marsupilami (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_marsupRomInfo, md_marsupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marsupilami (USA)
static struct BurnRomInfo md_marsupuRomDesc[] = {
	{ "marsupilami (usa).bin", 0x200000, 0xc76558df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_marsupu)
STD_ROM_FN(md_marsupu)

struct BurnDriver BurnDrvmd_marsupu = {
	"md_marsupu", "md_marsup", NULL, NULL, "1995",
	"Marsupilami (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_marsupuRomInfo, md_marsupuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Monsters (USA)
static struct BurnRomInfo md_mastermRomDesc[] = {
	{ "master of monsters (usa).bin", 0x080000, 0x91354820, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_masterm)
STD_ROM_FN(md_masterm)

struct BurnDriver BurnDrvmd_masterm = {
	"md_masterm", NULL, NULL, NULL, "1991",
	"Master of Monsters (USA)\0", NULL, "Renovation", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_mastermRomInfo, md_mastermRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Monsters (Jpn)
static struct BurnRomInfo md_mastermjRomDesc[] = {
	{ "mpr-14120.bin", 0x080000, 0xd51ee8c2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mastermj)
STD_ROM_FN(md_mastermj)

struct BurnDriver BurnDrvmd_mastermj = {
	"md_mastermj", "md_masterm", NULL, NULL, "1991",
	"Master of Monsters (Jpn)\0", NULL, "Toshiba EMI", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_mastermjRomInfo, md_mastermjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Weapon (Jpn)
static struct BurnRomInfo md_mweaponRomDesc[] = {
	{ "master of weapon (jpn).bin", 0x080000, 0x12ad6178, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mweapon)
STD_ROM_FN(md_mweapon)

struct BurnDriver BurnDrvmd_mweapon = {
	"md_mweapon", NULL, NULL, NULL, "1991",
	"Master of Weapon (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mweaponRomInfo, md_mweaponRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Maten no Soumetsu (Jpn)
static struct BurnRomInfo md_matenRomDesc[] = {
	{ "maten no soumetsu (jpn).bin", 0x100000, 0xb804a105, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_maten)
STD_ROM_FN(md_maten)

struct BurnDriver BurnDrvmd_maten = {
	"md_maten", NULL, NULL, NULL, "1993",
	"Maten no Soumetsu (Jpn)\0", NULL, "Kodansha", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_matenRomInfo, md_matenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Math Blaster - Episode 1 (USA)
static struct BurnRomInfo md_mathblstRomDesc[] = {
	{ "math blaster - episode 1 (usa).bin", 0x100000, 0xd055a462, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mathblst)
STD_ROM_FN(md_mathblst)

struct BurnDriver BurnDrvmd_mathblst = {
	"md_mathblst", NULL, NULL, NULL, "1994",
	"Math Blaster - Episode 1 (USA)\0", NULL, "Davidson & Associates", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mathblstRomInfo, md_mathblstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Wars (Euro)
static struct BurnRomInfo md_mazinwarRomDesc[] = {
	{ "mazin wars (euro).bin", 0x100000, 0x4b07a105, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mazinwar)
STD_ROM_FN(md_mazinwar)

struct BurnDriver BurnDrvmd_mazinwar = {
	"md_mazinwar", NULL, NULL, NULL, "1993",
	"Mazin Wars (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mazinwarRomInfo, md_mazinwarRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga (Asia)
static struct BurnRomInfo md_mazinsagaRomDesc[] = {
	{ "mazin saga (asia).bin", 0x100000, 0x36459b59, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mazinsaga)
STD_ROM_FN(md_mazinsaga)

struct BurnDriver BurnDrvmd_mazinsaga = {
	"md_mazinsaga", "md_mazinwar", NULL, NULL, "1993",
	"Mazin Saga (Asia)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mazinsagaRomInfo, md_mazinsagaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga (Jpn, Kor)
static struct BurnRomInfo md_mazinsagjRomDesc[] = {
	{ "mazin saga (jpn, kor).bin", 0x100000, 0x45b3a34b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mazinsagj)
STD_ROM_FN(md_mazinsagj)

struct BurnDriver BurnDrvmd_mazinsagj = {
	"md_mazinsagj", "md_mazinwar", NULL, NULL, "1993",
	"Mazin Saga (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mazinsagjRomInfo, md_mazinsagjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga - Mutant Fighter (USA)
static struct BurnRomInfo md_mazinsaguRomDesc[] = {
	{ "mazin saga - mutant fighter (usa).bin", 0x100000, 0x1bd9fef1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mazinsagu)
STD_ROM_FN(md_mazinsagu)

struct BurnDriver BurnDrvmd_mazinsagu = {
	"md_mazinsagu", "md_mazinwar", NULL, NULL, "1993",
	"Mazin Saga - Mutant Fighter (USA)\0", NULL, "Vic Tokai", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mazinsaguRomInfo, md_mazinsaguRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Euro)
static struct BurnRomInfo md_mcdonaldRomDesc[] = {
	{ "mcdonald's treasure land adventure (euro).bin", 0x100000, 0x6ab6a8da, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mcdonald)
STD_ROM_FN(md_mcdonald)

struct BurnDriver BurnDrvmd_mcdonald = {
	"md_mcdonald", NULL, NULL, NULL, "1993",
	"McDonald's Treasure Land Adventure (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mcdonaldRomInfo, md_mcdonaldRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Jpn)
static struct BurnRomInfo md_mcdonaldjRomDesc[] = {
	{ "mcdonald's treasure land adventure (jpn).bin", 0x100000, 0xfebcfd06, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mcdonaldj)
STD_ROM_FN(md_mcdonaldj)

struct BurnDriver BurnDrvmd_mcdonaldj = {
	"md_mcdonaldj", "md_mcdonald", NULL, NULL, "1993",
	"McDonald's Treasure Land Adventure (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mcdonaldjRomInfo, md_mcdonaldjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Jpn, Prototype)
static struct BurnRomInfo md_mcdonaldjpRomDesc[] = {
	{ "mcdonald's treasure land adventure (jpn) (beta).bin", 0x100000, 0x7bf477e8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mcdonaldjp)
STD_ROM_FN(md_mcdonaldjp)

struct BurnDriver BurnDrvmd_mcdonaldjp = {
	"md_mcdonaldjp", "md_mcdonald", NULL, NULL, "1993",
	"McDonald's Treasure Land Adventure (Jpn, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mcdonaldjpRomInfo, md_mcdonaldjpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (USA)
static struct BurnRomInfo md_mcdonalduRomDesc[] = {
	{ "mcdonald's treasure land adventure (usa).bin", 0x100000, 0x04ef4899, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mcdonaldu)
STD_ROM_FN(md_mcdonaldu)

struct BurnDriver BurnDrvmd_mcdonaldu = {
	"md_mcdonaldu", "md_mcdonald", NULL, NULL, "1993",
	"McDonald's Treasure Land Adventure (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mcdonalduRomInfo, md_mcdonalduRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Medal City (Jpn, SegaNet)
static struct BurnRomInfo md_medalcRomDesc[] = {
	{ "medal city (jpn) (sn).bin", 0x040000, 0x3ef4135d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_medalc)
STD_ROM_FN(md_medalc)

struct BurnDriver BurnDrvmd_medalc = {
	"md_medalc", NULL, NULL, NULL, "1991",
	"Medal City (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_medalcRomInfo, md_medalcRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman (USA)
static struct BurnRomInfo md_megabombuRomDesc[] = {
	{ "mega bomberman (usa).bin", 0x100000, 0x4bd6667d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megabombu)
STD_ROM_FN(md_megabombu)

struct BurnDriver BurnDrvmd_megabombu = {
	"md_megabombu", "md_megabomb", NULL, NULL, "1994",
	"Mega Bomberman (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megabombuRomInfo, md_megabombuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman - 8 Player Demo
static struct BurnRomInfo md_megabm8RomDesc[] = {
	{ "mega bomberman - 8 player demo (unl).bin", 0x100000, 0xd41c0d81, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megabm8)
STD_ROM_FN(md_megabm8)

struct BurnDriver BurnDrvmd_megabm8 = {
	"md_megabm8", NULL, NULL, NULL, "199?",
	"Mega Bomberman - 8 Player Demo\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megabm8RomInfo, md_megabm8RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games I (Euro)
static struct BurnRomInfo md_megaga1RomDesc[] = {
	{ "mpr-15009.bin", 0x100000, 0xdb753224, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga1)
STD_ROM_FN(md_megaga1)

struct BurnDriver BurnDrvmd_megaga1 = {
	"md_megaga1", NULL, NULL, NULL, "1992",
	"Mega Games I (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga1RomInfo, md_megaga1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 2 (Euro)
static struct BurnRomInfo md_megaga2RomDesc[] = {
	{ "mega games 2 (euro).bin", 0x200000, 0x30d59f2f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga2)
STD_ROM_FN(md_megaga2)

struct BurnDriver BurnDrvmd_megaga2 = {
	"md_megaga2", NULL, NULL, NULL, "1993",
	"Mega Games 2 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga2RomInfo, md_megaga2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 3 (Euro, Asia)
static struct BurnRomInfo md_megaga3RomDesc[] = {
	{ "mega games 3 (euro, asia).bin", 0x200000, 0xb4247d98, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga3)
STD_ROM_FN(md_megaga3)

struct BurnDriver BurnDrvmd_megaga3 = {
	"md_megaga3", NULL, NULL, NULL, "1993",
	"Mega Games 3 (Euro, Asia)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga3RomInfo, md_megaga3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 1 (Euro)
static struct BurnRomInfo md_megaga61RomDesc[] = {
	{ "mpr-18002+mpr18003.bin", 0x300000, 0xb66fb80d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga61)
STD_ROM_FN(md_megaga61)

struct BurnDriver BurnDrvmd_megaga61 = {
	"md_megaga61", NULL, NULL, NULL, "1995",
	"Mega Games 6 Vol. 1 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga61RomInfo, md_megaga61RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 2 (Euro)
static struct BurnRomInfo md_megaga62RomDesc[] = {
	{ "mega games 6 vol. 2 (euro).bin", 0x300000, 0xe8d10db9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga62)
STD_ROM_FN(md_megaga62)

struct BurnDriver BurnDrvmd_megaga62 = {
	"md_megaga62", NULL, NULL, NULL, "1995",
	"Mega Games 6 Vol. 2 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga62RomInfo, md_megaga62RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 10 (Bra)
static struct BurnRomInfo md_megaga10RomDesc[] = {
	{ "mega games 10 (bra).bin", 0x400000, 0xc19ae368, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaga10)
STD_ROM_FN(md_megaga10)

struct BurnDriver BurnDrvmd_megaga10 = {
	"md_megaga10", NULL, NULL, NULL, "199?",
	"Mega Games 10 (Bra)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaga10RomInfo, md_megaga10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Man - The Wily Wars (Euro)
static struct BurnRomInfo md_megamanRomDesc[] = {
	{ "mega man - the wily wars (euro).bin", 0x200000, 0xdcf6e8b2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaman)
STD_ROM_FN(md_megaman)

struct BurnDriver BurnDrvmd_megaman = {
	"md_megaman", NULL, NULL, NULL, "1994",
	"Mega Man - The Wily Wars (Euro)\0", NULL, "Capcom", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_EEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_megamanRomInfo, md_megamanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rockman Mega World (Jpn)
static struct BurnRomInfo md_rockmanRomDesc[] = {
	{ "rockman mega world (jpn).bin", 0x200000, 0x4d87235e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_rockman)
STD_ROM_FN(md_rockman)

struct BurnDriver BurnDrvmd_rockman = {
	"md_rockman", "md_megaman", NULL, NULL, "1994",
	"Rockman Mega World (Jpn)\0", NULL, "Capcom", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_rockmanRomInfo, md_rockmanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rockman Mega World (Jpn, Alt)
static struct BurnRomInfo md_rockman1RomDesc[] = {
	{ "rockman mega world (jpn) (alt).bin", 0x200000, 0x85c956ef, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_rockman1)
STD_ROM_FN(md_rockman1)

struct BurnDriver BurnDrvmd_rockman1 = {
	"md_rockman1", "md_megaman", NULL, NULL, "1994",
	"Rockman Mega World (Jpn, Alt)\0", NULL, "Capcom", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_rockman1RomInfo, md_rockman1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega SWIV (Euro)
static struct BurnRomInfo md_megaswivRomDesc[] = {
	{ "mega swiv (euro).bin", 0x100000, 0x78c2f046, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaswiv)
STD_ROM_FN(md_megaswiv)

struct BurnDriver BurnDrvmd_megaswiv = {
	"md_megaswiv", NULL, NULL, NULL, "1994",
	"Mega SWIV (Euro)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaswivRomInfo, md_megaswivRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega SWIV (Euro, Pirate)
static struct BurnRomInfo md_megaswivbRomDesc[] = {
	{ "mega swiv (euro) (pirate).bin", 0x100000, 0x1ec66bf7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaswivb)
STD_ROM_FN(md_megaswivb)

struct BurnDriver BurnDrvmd_megaswivb = {
	"md_megaswivb", "md_megaswiv", NULL, NULL, "1994",
	"Mega SWIV (Euro, Pirate)\0", NULL, "Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaswivbRomInfo, md_megaswivbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Turrican (Euro)
static struct BurnRomInfo md_megaturrRomDesc[] = {
	{ "mega turrican (euro).bin", 0x100000, 0xb1d15d0f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaturr)
STD_ROM_FN(md_megaturr)

struct BurnDriver BurnDrvmd_megaturr = {
	"md_megaturr", NULL, NULL, NULL, "1994",
	"Mega Turrican (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaturrRomInfo, md_megaturrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Turrican (USA)
static struct BurnRomInfo md_megaturruRomDesc[] = {
	{ "mega turrican (usa).bin", 0x100000, 0xfe898cc9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaturru)
STD_ROM_FN(md_megaturru)

struct BurnDriver BurnDrvmd_megaturru = {
	"md_megaturru", "md_megaturr", NULL, NULL, "1994",
	"Mega Turrican (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaturruRomInfo, md_megaturruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Euro, v1.1)
static struct BurnRomInfo md_megaloRomDesc[] = {
	{ "mega-lo-mania (euro) (v1.1).bin", 0x100000, 0xab9fed30, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megalo)
STD_ROM_FN(md_megalo)

struct BurnDriver BurnDrvmd_megalo = {
	"md_megalo", NULL, NULL, NULL, "1992",
	"Mega-Lo-Mania (Euro, v1.1)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megaloRomInfo, md_megaloRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Euro)
static struct BurnRomInfo md_megalo1RomDesc[] = {
	{ "mpr-15230.bin", 0x100000, 0x2148d56d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megalo1)
STD_ROM_FN(md_megalo1)

struct BurnDriver BurnDrvmd_megalo1 = {
	"md_megalo1", "md_megalo", NULL, NULL, "1992",
	"Mega-Lo-Mania (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megalo1RomInfo, md_megalo1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Fra)
static struct BurnRomInfo md_megalofRomDesc[] = {
	{ "mega-lo-mania (france).bin", 0x100000, 0x3b3231ed, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megalof)
STD_ROM_FN(md_megalof)

struct BurnDriver BurnDrvmd_megalof = {
	"md_megalof", "md_megalo", NULL, NULL, "1992",
	"Mega-Lo-Mania (Fra)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megalofRomInfo, md_megalofRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Jpn)
static struct BurnRomInfo md_megalojRomDesc[] = {
	{ "mega-lo-mania (jpn).bin", 0x100000, 0xa60d8619, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megaloj)
STD_ROM_FN(md_megaloj)

struct BurnDriver BurnDrvmd_megaloj = {
	"md_megaloj", "md_megalo", NULL, NULL, "1993",
	"Mega-Lo-Mania (Jpn)\0", NULL, "CRI", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megalojRomInfo, md_megalojRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Tyrants - Fight through Time (USA)
static struct BurnRomInfo md_tyrantRomDesc[] = {
	{ "tyrants - fight through time (usa).bin", 0x100000, 0xa744921e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_tyrant)
STD_ROM_FN(md_tyrant)

struct BurnDriver BurnDrvmd_tyrant = {
	"md_tyrant", "md_megalo", NULL, NULL, "1992",
	"Tyrants - Fight through Time (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_tyrantRomInfo, md_tyrantRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaMind (Jpn, SegaNet)
static struct BurnRomInfo md_megamindRomDesc[] = {
	{ "megamind (jpn) (sn).bin", 0x040000, 0x76df2ae2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megamind)
STD_ROM_FN(md_megamind)

struct BurnDriver BurnDrvmd_megamind = {
	"md_megamind", NULL, NULL, NULL, "1991",
	"MegaMind (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megamindRomInfo, md_megamindRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaPanel (Jpn)
static struct BurnRomInfo md_megapanlRomDesc[] = {
	{ "megapanel (jpn).bin", 0x040000, 0x6240f579, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_megapanl)
STD_ROM_FN(md_megapanl)

struct BurnDriver BurnDrvmd_megapanl = {
	"md_megapanl", NULL, NULL, NULL, "1990",
	"MegaPanel (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_megapanlRomInfo, md_megapanlRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Menacer 6-Game Cartridge (Euro, USA)
static struct BurnRomInfo md_menacerRomDesc[] = {
	{ "mpr-15075.bin", 0x100000, 0x936b85f7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_menacer)
STD_ROM_FN(md_menacer)

struct BurnDriver BurnDrvmd_menacer = {
	"md_menacer", NULL, NULL, NULL, "1992",
	"Menacer 6-Game Cartridge (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_menacerRomInfo, md_menacerRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Meng Huan Shui Guo Pan - 777 Casino (Chi)
static struct BurnRomInfo md_menghuRomDesc[] = {
	{ "meng huan shui guo pan - 777 casino (chi) (unl).bin", 0x100000, 0x42dc03e4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_menghu)
STD_ROM_FN(md_menghu)

struct BurnDriver BurnDrvmd_menghu = {
	"md_menghu", NULL, NULL, NULL, "199?",
	"Meng Huan Shui Guo Pan - 777 Casino (Chi)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_menghuRomInfo, md_menghuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mercs (Euro, USA) ~ Senjou no Ookami II (Jpn)
static struct BurnRomInfo md_mercsRomDesc[] = {
	{ "mpr-14242.bin", 0x100000, 0x16113a72, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mercs)
STD_ROM_FN(md_mercs)

struct BurnDriver BurnDrvmd_mercs = {
	"md_mercs", NULL, NULL, NULL, "1991",
	"Mercs (Euro, USA) ~ Senjou no Ookami II (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mercsRomInfo, md_mercsRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Metal Fangs (Jpn)
static struct BurnRomInfo md_metalfRomDesc[] = {
	{ "metal fangs (jpn).bin", 0x080000, 0xa8df1c4c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_metalf)
STD_ROM_FN(md_metalf)

struct BurnDriver BurnDrvmd_metalf = {
	"md_metalf", NULL, NULL, NULL, "1993",
	"Metal Fangs (Jpn)\0", NULL, "Victor Interactive Software", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_metalfRomInfo, md_metalfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Michael Jackson's Moonwalker (World, Rev. A)
static struct BurnRomInfo md_mwalkRomDesc[] = {
	{ "mpr-13285a.bin", 0x080000, 0x11ce1f9e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mwalk)
STD_ROM_FN(md_mwalk)

struct BurnDriver BurnDrvmd_mwalk = {
	"md_mwalk", NULL, NULL, NULL, "1990",
	"Michael Jackson's Moonwalker (World, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mwalkRomInfo, md_mwalkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Michael Jackson's Moonwalker (World)
static struct BurnRomInfo md_mwalk1RomDesc[] = {
	{ "mpr-13285.bin", 0x080000, 0x6a70791b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mwalk1)
STD_ROM_FN(md_mwalk1)

struct BurnDriver BurnDrvmd_mwalk1 = {
	"md_mwalk1", "md_mwalk", NULL, NULL, "1990",
	"Michael Jackson's Moonwalker (World)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mwalk1RomInfo, md_mwalk1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (Euro)
static struct BurnRomInfo md_mmaniaRomDesc[] = {
	{ "mpr-17089.bin", 0x200000, 0xcb5a8b85, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmania)
STD_ROM_FN(md_mmania)

struct BurnDriver BurnDrvmd_mmania = {
	"md_mmania", NULL, NULL, NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (Euro)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmaniaRomInfo, md_mmaniaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (Jpn)
static struct BurnRomInfo md_mmaniajRomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (jpn).bin", 0x200000, 0x23180cf7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmaniaj)
STD_ROM_FN(md_mmaniaj)

struct BurnDriver BurnDrvmd_mmaniaj = {
	"md_mmaniaj", "md_mmania", NULL, NULL, "1995",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmaniajRomInfo, md_mmaniajRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (USA)
static struct BurnRomInfo md_mmaniauRomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (usa).bin", 0x200000, 0x629e5963, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmaniau)
STD_ROM_FN(md_mmaniau)

struct BurnDriver BurnDrvmd_mmaniau = {
	"md_mmaniau", "md_mmania", NULL, NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (USA)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmaniauRomInfo, md_mmaniauRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (USA, Prototype)
static struct BurnRomInfo md_mmaniaupRomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (usa) (beta).bin", 0x200000, 0x7fc1bdf0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmaniaup)
STD_ROM_FN(md_mmaniaup)

struct BurnDriver BurnDrvmd_mmaniaup = {
	"md_mmaniaup", "md_mmania", NULL, NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (USA, Prototype)\0", NULL, "Sony Imagesoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmaniaupRomInfo, md_mmaniaupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey's Ultimate Challenge (USA)
static struct BurnRomInfo md_mickeyucRomDesc[] = {
	{ "mickey's ultimate challenge (usa).bin", 0x100000, 0x30b512ee, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mickeyuc)
STD_ROM_FN(md_mickeyuc)

struct BurnDriver BurnDrvmd_mickeyuc = {
	"md_mickeyuc", NULL, NULL, NULL, "1994",
	"Mickey's Ultimate Challenge (USA)\0", NULL, "High Tech Expressions", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mickeyucRomInfo, md_mickeyucRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (Euro, USA)
static struct BurnRomInfo md_micromRomDesc[] = {
	{ "mdmm_acd3.bin", 0x080000, 0x50081a0b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_microm)
STD_ROM_FN(md_microm)

struct BurnDriver BurnDrvmd_microm = {
	"md_microm", NULL, NULL, NULL, "1993",
	"Micro Machines (Euro, USA)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_micromRomInfo, md_micromRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (Euro, USA, Alt)
static struct BurnRomInfo md_micromaRomDesc[] = {
	{ "micro machines (euro, usa) (alt).bin", 0x080000, 0xe5cf560d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_microma)
STD_ROM_FN(md_microma)

struct BurnDriver BurnDrvmd_microma = {
	"md_microma", "md_microm", NULL, NULL, "1993",
	"Micro Machines (Euro, USA, Alt)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_micromaRomInfo, md_micromaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (Euro, USA, Alt 2)
static struct BurnRomInfo md_micrombRomDesc[] = {
	{ "micro machines (euro, usa) (alt2).bin", 0x080000, 0x7ffbd1ad, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_micromb)
STD_ROM_FN(md_micromb)

struct BurnDriver BurnDrvmd_micromb = {
	"md_micromb", "md_microm", NULL, NULL, "1993",
	"Micro Machines (Euro, USA, Alt 2)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_micrombRomInfo, md_micrombRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (Can)
static struct BurnRomInfo md_micromcnRomDesc[] = {
	{ "micro machines (canada).bin", 0x080000, 0x54e4cff1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_micromcn)
STD_ROM_FN(md_micromcn)

struct BurnDriver BurnDrvmd_micromcn = {
	"md_micromcn", "md_microm", NULL, NULL, "1993",
	"Micro Machines (Can)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_micromcnRomInfo, md_micromcnRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Turbo Tournament 96 (Euro, J-Cart)
static struct BurnRomInfo md_micro96aRomDesc[] = {
	{ "mm96md7cc3.bin", 0x100000, 0x7492b1de, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_micro96a)
STD_ROM_FN(md_micro96a)

struct BurnDriver BurnDrvmd_micro96a = {
	"md_micro96a", "md_micro96", NULL, NULL, "1995",
	"Micro Machines Turbo Tournament 96 (Euro, J-Cart)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART_SEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_micro96aRomInfo, md_micro96aRomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines 2 - Turbo Tournament (Euro, J-Cart, Alt)
static struct BurnRomInfo md_microm2aRomDesc[] = {
	{ "micro machines 2 - turbo tournament (euro) (j-cart) (alt).bin", 0x100000, 0x01c22a5d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_microm2a)
STD_ROM_FN(md_microm2a)

struct BurnDriver BurnDrvmd_microm2a = {
	"md_microm2a", "md_microm2", NULL, NULL, "1994",
	"Micro Machines 2 - Turbo Tournament (Euro, J-Cart, Alt)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART_SEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_microm2aRomInfo, md_microm2aRomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Military (Euro, J-Cart)
static struct BurnRomInfo md_micrommRomDesc[] = {
	{ "micro machines military (euro) (j-cart).bin", 0x100000, 0xb3abb15e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_micromm)
STD_ROM_FN(md_micromm)

struct BurnDriver BurnDrvmd_micromm = {
	"md_micromm", NULL, NULL, NULL, "1996",
	"Micro Machines Military (Euro, J-Cart)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 4, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_CM_JCART_SEPROM, GBF_MISC, 0,
	MegadriveGetZipName, md_micrommRomInfo, md_micrommRomName, NULL, NULL, Megadrive4pInputInfo, Megadrive4pDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midnight Resistance (USA)
static struct BurnRomInfo md_midresRomDesc[] = {
	{ "midnight resistance (usa).bin", 0x100000, 0x187c6af6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_midres)
STD_ROM_FN(md_midres)

struct BurnDriver BurnDrvmd_midres = {
	"md_midres", NULL, NULL, NULL, "1991",
	"Midnight Resistance (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_midresRomInfo, md_midresRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midnight Resistance (Jpn)
static struct BurnRomInfo md_midresjRomDesc[] = {
	{ "midnight resistance (jpn).bin", 0x100000, 0x8f3f6e4d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_midresj)
STD_ROM_FN(md_midresj)

struct BurnDriver BurnDrvmd_midresj = {
	"md_midresj", "md_midres", NULL, NULL, "1991",
	"Midnight Resistance (Jpn)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_midresjRomInfo, md_midresjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midway Presents Arcade's Greatest Hits (Euro)
static struct BurnRomInfo md_midwayRomDesc[] = {
	{ "midway presents arcade's greatest hits (euro).bin", 0x080000, 0xc0dce0e5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_midway)
STD_ROM_FN(md_midway)

struct BurnDriver BurnDrvmd_midway = {
	"md_midway", NULL, NULL, NULL, "1996",
	"Midway Presents Arcade's Greatest Hits (Euro)\0", NULL, "Midway", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_midwayRomInfo, md_midwayRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (Euro)
static struct BurnRomInfo md_mig29RomDesc[] = {
	{ "mpr-15659.bin", 0x100000, 0x70b0a5d7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mig29)
STD_ROM_FN(md_mig29)

struct BurnDriver BurnDrvmd_mig29 = {
	"md_mig29", NULL, NULL, NULL, "1993",
	"Mig-29 Fighter Pilot (Euro)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mig29RomInfo, md_mig29RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (Jpn)
static struct BurnRomInfo md_mig29jRomDesc[] = {
	{ "mig-29 fighter pilot (jpn).bin", 0x100000, 0x3d239046, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mig29j)
STD_ROM_FN(md_mig29j)

struct BurnDriver BurnDrvmd_mig29j = {
	"md_mig29j", "md_mig29", NULL, NULL, "1993",
	"Mig-29 Fighter Pilot (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mig29jRomInfo, md_mig29jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (USA)
static struct BurnRomInfo md_mig29uRomDesc[] = {
	{ "mig-29 fighter pilot (usa).bin", 0x100000, 0x59ccabb2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mig29u)
STD_ROM_FN(md_mig29u)

struct BurnDriver BurnDrvmd_mig29u = {
	"md_mig29u", "md_mig29", NULL, NULL, "1993",
	"Mig-29 Fighter Pilot (USA)\0", NULL, "Domark", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mig29uRomInfo, md_mig29uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Might and Magic - Gates to Another World (Euro, USA)
static struct BurnRomInfo md_mightmagRomDesc[] = {
	{ "might and magic - gates to another world (euro, usa).bin", 0x0c0000, 0xf509145f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mightmag)
STD_ROM_FN(md_mightmag)

struct BurnDriver BurnDrvmd_mightmag = {
	"md_mightmag", NULL, NULL, NULL, "1991",
	"Might and Magic - Gates to Another World (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mightmagRomInfo, md_mightmagRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Might and Magic III - Isles of Terra (USA, Prototype)
static struct BurnRomInfo md_mmagic3pRomDesc[] = {
	{ "might and magic iii - isles of terra (usa) (prototype).bin", 0x200000, 0x6ef7104a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmagic3p)
STD_ROM_FN(md_mmagic3p)

struct BurnDriver BurnDrvmd_mmagic3p = {
	"md_mmagic3p", NULL, NULL, NULL, "199?",
	"Might and Magic III - Isles of Terra (USA, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmagic3pRomInfo, md_mmagic3pRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Euro)
static struct BurnRomInfo md_mmprRomDesc[] = {
	{ "mighty morphin power rangers (euro).bin", 0x200000, 0x7f96e663, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmpr)
STD_ROM_FN(md_mmpr)

struct BurnDriver BurnDrvmd_mmpr = {
	"md_mmpr", NULL, NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprRomInfo, md_mmprRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (USA)
static struct BurnRomInfo md_mmpruRomDesc[] = {
	{ "mighty morphin power rangers (usa).bin", 0x200000, 0x715158a9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmpru)
STD_ROM_FN(md_mmpru)

struct BurnDriver BurnDrvmd_mmpru = {
	"md_mmpru", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmpruRomInfo, md_mmpruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940804)
static struct BurnRomInfo md_mmprp4RomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 04, 1994).bin", 0x200000, 0xf3ae5aaf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp4)
STD_ROM_FN(md_mmprp4)

struct BurnDriver BurnDrvmd_mmprp4 = {
	"md_mmprp4", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940804)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp4RomInfo, md_mmprp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940808)
static struct BurnRomInfo md_mmprp3RomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 08, 1994).bin", 0x200000, 0x57644549, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp3)
STD_ROM_FN(md_mmprp3)

struct BurnDriver BurnDrvmd_mmprp3 = {
	"md_mmprp3", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940808)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp3RomInfo, md_mmprp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940809)
static struct BurnRomInfo md_mmprp2RomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 09, 1994).bin", 0x200000, 0x4356fe0a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp2)
STD_ROM_FN(md_mmprp2)

struct BurnDriver BurnDrvmd_mmprp2 = {
	"md_mmprp2", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940809)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp2RomInfo, md_mmprp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940810)
static struct BurnRomInfo md_mmprp1RomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 10, 1994).bin", 0x200000, 0xe79cd214, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp1)
STD_ROM_FN(md_mmprp1)

struct BurnDriver BurnDrvmd_mmprp1 = {
	"md_mmprp1", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940810)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp1RomInfo, md_mmprp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940708)
static struct BurnRomInfo md_mmprp6RomDesc[] = {
	{ "mighty morphin power rangers (prototype - jul 08, 1994).bin", 0x200000, 0xe6916c54, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp6)
STD_ROM_FN(md_mmprp6)

struct BurnDriver BurnDrvmd_mmprp6 = {
	"md_mmprp6", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940708)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp6RomInfo, md_mmprp6RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype, 19940718)
static struct BurnRomInfo md_mmprp5RomDesc[] = {
	{ "mighty morphin power rangers (prototype - jul 18, 1994).bin", 0x200000, 0x5accdb1a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprp5)
STD_ROM_FN(md_mmprp5)

struct BurnDriver BurnDrvmd_mmprp5 = {
	"md_mmprp5", "md_mmpr", NULL, NULL, "1994",
	"Mighty Morphin Power Rangers (Prototype, 19940718)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprp5RomInfo, md_mmprp5RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Euro)
static struct BurnRomInfo md_mmprtmRomDesc[] = {
	{ "mighty morphin power rangers - the movie (euro).bin", 0x200000, 0x254a4972, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtm)
STD_ROM_FN(md_mmprtm)

struct BurnDriver BurnDrvmd_mmprtm = {
	"md_mmprtm", NULL, NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmRomInfo, md_mmprtmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (USA)
static struct BurnRomInfo md_mmprtmuRomDesc[] = {
	{ "mighty morphin power rangers - the movie (usa).bin", 0x200000, 0xaa941cbc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtmu)
STD_ROM_FN(md_mmprtmu)

struct BurnDriver BurnDrvmd_mmprtmu = {
	"md_mmprtmu", "md_mmprtm", NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmuRomInfo, md_mmprtmuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype, 19950713)
static struct BurnRomInfo md_mmprtmp4RomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 13, 1995).bin", 0x200000, 0x227bf7fd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtmp4)
STD_ROM_FN(md_mmprtmp4)

struct BurnDriver BurnDrvmd_mmprtmp4 = {
	"md_mmprtmp4", "md_mmprtm", NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (Prototype, 19950713)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmp4RomInfo, md_mmprtmp4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype, 19950717)
static struct BurnRomInfo md_mmprtmp3RomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 17, 1995).bin", 0x200000, 0x579de657, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtmp3)
STD_ROM_FN(md_mmprtmp3)

struct BurnDriver BurnDrvmd_mmprtmp3 = {
	"md_mmprtmp3", "md_mmprtm", NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (Prototype, 19950717)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmp3RomInfo, md_mmprtmp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype, 19950722)
static struct BurnRomInfo md_mmprtmp2RomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 22, 1995).bin", 0x200000, 0xc2ca3a8b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtmp2)
STD_ROM_FN(md_mmprtmp2)

struct BurnDriver BurnDrvmd_mmprtmp2 = {
	"md_mmprtmp2", "md_mmprtm", NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (Prototype, 19950722)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmp2RomInfo, md_mmprtmp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype, 19950724)
static struct BurnRomInfo md_mmprtmp1RomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 24, 1995).bin", 0x200000, 0x3429fa3a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mmprtmp1)
STD_ROM_FN(md_mmprtmp1)

struct BurnDriver BurnDrvmd_mmprtmp1 = {
	"md_mmprtmp1", "md_mmprtm", NULL, NULL, "1995",
	"Mighty Morphin Power Rangers - The Movie (Prototype, 19950724)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mmprtmp1RomInfo, md_mmprtmp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mike Ditka Power Football (Euro, USA)
static struct BurnRomInfo md_mikediRomDesc[] = {
	{ "mike ditka power football (euro, usa).bin", 0x100000, 0x6078b310, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mikedi)
STD_ROM_FN(md_mikedi)

struct BurnDriver BurnDrvmd_mikedi = {
	"md_mikedi", NULL, NULL, NULL, "1991",
	"Mike Ditka Power Football (Euro, USA)\0", NULL, "Ballistic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mikediRomInfo, md_mikediRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mike Ditka Power Football (Euro, USA, Alt)
static struct BurnRomInfo md_mikedi1RomDesc[] = {
	{ "mike ditka power football (euro, usa) (alt).bin", 0x100000, 0xde50ca8e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mikedi1)
STD_ROM_FN(md_mikedi1)

struct BurnDriver BurnDrvmd_mikedi1 = {
	"md_mikedi1", "md_mikedi", NULL, NULL, "1991",
	"Mike Ditka Power Football (Euro, USA, Alt)\0", NULL, "Ballistic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mikedi1RomInfo, md_mikedi1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Minnesota Fats - Pool Legend (USA)
static struct BurnRomInfo md_minnesotRomDesc[] = {
	{ "minnesota fats - pool legend (usa).bin", 0x100000, 0x38174f40, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_minnesot)
STD_ROM_FN(md_minnesot)

struct BurnDriver BurnDrvmd_minnesot = {
	"md_minnesot", NULL, NULL, NULL, "1995",
	"Minnesota Fats - Pool Legend (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_minnesotRomInfo, md_minnesotRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chou Kyuukai Miracle Nine (Jpn)
static struct BurnRomInfo md_miracle9RomDesc[] = {
	{ "chou kyuukai miracle nine (jpn).bin", 0x200000, 0x6d8c2206, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_miracle9)
STD_ROM_FN(md_miracle9)

struct BurnDriver BurnDrvmd_miracle9 = {
	"md_miracle9", NULL, NULL, NULL, "1995",
	"Chou Kyuukai Miracle Nine (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_miracle9RomInfo, md_miracle9RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Miracle Piano Teaching System (USA)
static struct BurnRomInfo md_mpianoRomDesc[] = {
	{ "miracle piano teaching system, the (usa).bin", 0x080000, 0xa719542e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mpiano)
STD_ROM_FN(md_mpiano)

struct BurnDriver BurnDrvmd_mpiano = {
	"md_mpiano", NULL, NULL, NULL, "1992",
	"The Miracle Piano Teaching System (USA)\0", NULL, "Software Toolworks", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mpianoRomInfo, md_mpianoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MK 5 - Mortal Combat - SubZero
static struct BurnRomInfo md_mk5morRomDesc[] = {
	{ "mk 5 - mortal combat - subzero (unl).bin", 0x200000, 0x11e367a1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk5mor)
STD_ROM_FN(md_mk5mor)

struct BurnDriver BurnDrvmd_mk5mor = {
	"md_mk5mor", NULL, NULL, NULL, "199?",
	"MK 5 - Mortal Combat - SubZero\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mk5morRomInfo, md_mk5morRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MK 5 - Mortal Combat - SubZero (Pirate)
static struct BurnRomInfo md_mk5mor1RomDesc[] = {
	{ "mk 5 - mortal combat - subzero (unl) (pirate).bin", 0x200000, 0x41203006, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk5mor1)
STD_ROM_FN(md_mk5mor1)

struct BurnDriver BurnDrvmd_mk5mor1 = {
	"md_mk5mor1", "md_mk5mor", NULL, NULL, "199?",
	"MK 5 - Mortal Combat - SubZero (Pirate)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mk5mor1RomInfo, md_mk5mor1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MLBPA Baseball (USA)
static struct BurnRomInfo md_mlbpabRomDesc[] = {
	{ "mlbpa baseball (usa).bin", 0x200000, 0x14a8064d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mlbpab)
STD_ROM_FN(md_mlbpab)

struct BurnDriver BurnDrvmd_mlbpab = {
	"md_mlbpab", NULL, NULL, NULL, "1992",
	"MLBPA Baseball (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_mlbpabRomInfo, md_mlbpabRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monopoly (USA)
static struct BurnRomInfo md_monopolyRomDesc[] = {
	{ "monopoly (usa).bin", 0x080000, 0xc10268da, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_monopoly)
STD_ROM_FN(md_monopoly)

struct BurnDriver BurnDrvmd_monopoly = {
	"md_monopoly", NULL, NULL, NULL, "1992",
	"Monopoly (USA)\0", NULL, "Parker Brothers", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_monopolyRomInfo, md_monopolyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monopoly (USA, Prototype)
static struct BurnRomInfo md_monopolypRomDesc[] = {
	{ "monopoly (usa) (beta).bin", 0x080000, 0xdfbcc3fa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_monopolyp)
STD_ROM_FN(md_monopolyp)

struct BurnDriver BurnDrvmd_monopolyp = {
	"md_monopolyp", "md_monopoly", NULL, NULL, "1992",
	"Monopoly (USA, Prototype)\0", NULL, "Parker Brothers", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_monopolypRomInfo, md_monopolypRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monster World IV (Jpn)
static struct BurnRomInfo md_mworld4RomDesc[] = {
	{ "monster world iv (jpn).bin", 0x200000, 0x36a3aaa4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mworld4)
STD_ROM_FN(md_mworld4)

struct BurnDriver BurnDrvmd_mworld4 = {
	"md_mworld4", NULL, NULL, NULL, "1994",
	"Monster World IV (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_mworld4RomInfo, md_mworld4RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat (World, v1.1)
static struct BurnRomInfo md_mkRomDesc[] = {
	{ "mortal kombat (world) (v1.1).bin", 0x200000, 0x33f19ab6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk)
STD_ROM_FN(md_mk)

struct BurnDriver BurnDrvmd_mk = {
	"md_mk", NULL, NULL, NULL, "1993",
	"Mortal Kombat (World, v1.1)\0", NULL, "Arena", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mkRomInfo, md_mkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat (World)
static struct BurnRomInfo md_mkaRomDesc[] = {
	{ "s215_ver_1.00.bin", 0x200000, 0x1aa3a207, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mka)
STD_ROM_FN(md_mka)

struct BurnDriver BurnDrvmd_mka = {
	"md_mka", "md_mk", NULL, NULL, "1993",
	"Mortal Kombat (World)\0", NULL, "Arena", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mkaRomInfo, md_mkaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat II (World)
static struct BurnRomInfo md_mk2RomDesc[] = {
	{ "s376-u2.1+s382-u1.1.bin", 0x300000, 0xa9e013d8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk2)
STD_ROM_FN(md_mk2)

struct BurnDriver BurnDrvmd_mk2 = {
	"md_mk2", NULL, NULL, NULL, "1994",
	"Mortal Kombat II (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mk2RomInfo, md_mk2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat 3 (Euro)
static struct BurnRomInfo md_mk3RomDesc[] = {
	{ "mortal_kombat_3_pal.bin", 0x400000, 0xaf6de3e8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk3)
STD_ROM_FN(md_mk3)

struct BurnDriver BurnDrvmd_mk3 = {
	"md_mk3", NULL, NULL, NULL, "1995",
	"Mortal Kombat 3 (Euro)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mk3RomInfo, md_mk3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat 3 (USA)
static struct BurnRomInfo md_mk3uRomDesc[] = {
	{ "mortal kombat 3 (usa).bin", 0x400000, 0xdd638af6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mk3u)
STD_ROM_FN(md_mk3u)

struct BurnDriver BurnDrvmd_mk3u = {
	"md_mk3u", "md_mk3", NULL, NULL, "1995",
	"Mortal Kombat 3 (USA)\0", NULL, "Williams", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mk3uRomInfo, md_mk3uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mr. Nutz (Euro)
static struct BurnRomInfo md_mrnutzRomDesc[] = {
	{ "mr. nutz (euro).bin", 0x100000, 0x0786ea0b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mrnutz)
STD_ROM_FN(md_mrnutz)

struct BurnDriver BurnDrvmd_mrnutz = {
	"md_mrnutz", NULL, NULL, NULL, "1994",
	"Mr. Nutz (Euro)\0", NULL, "Ocean", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mrnutzRomInfo, md_mrnutzRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ms. Pac-Man (Euro, USA)
static struct BurnRomInfo md_mspacmanRomDesc[] = {
	{ "ms. pac-man (euro, usa).bin", 0x020000, 0xaf041be6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mspacman)
STD_ROM_FN(md_mspacman)

struct BurnDriver BurnDrvmd_mspacman = {
	"md_mspacman", NULL, NULL, NULL, "1991",
	"Ms. Pac-Man (Euro, USA)\0", NULL, "Tengen ~ Time Warner Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mspacmanRomInfo, md_mspacmanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ms. Pac-Man (Pirate, Ripped from Golden 10 in 1)
static struct BurnRomInfo md_mspacmanpirRomDesc[] = {
	{ "ms. pac-man (usa) (pirate).bin", 0x020000, 0x39b51b26, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mspacmanpir)
STD_ROM_FN(md_mspacmanpir)

struct BurnDriver BurnDrvmd_mspacmanpir = {
	"md_mspacmanpir", "md_mspacman", NULL, NULL, "199?",
	"Ms. Pac-Man (Pirate, Ripped from Golden 10 in 1)\0", NULL, "<unlicensed>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mspacmanpirRomInfo, md_mspacmanpirRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (Euro)
static struct BurnRomInfo md_muhammRomDesc[] = {
	{ "muhammad ali heavyweight boxing (euro).bin", 0x100000, 0x8ea4717b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_muhamm)
STD_ROM_FN(md_muhamm)

struct BurnDriver BurnDrvmd_muhamm = {
	"md_muhamm", NULL, NULL, NULL, "1992",
	"Muhammad Ali Heavyweight Boxing (Euro)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_muhammRomInfo, md_muhammRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (USA)
static struct BurnRomInfo md_muhammuRomDesc[] = {
	{ "muhammad ali heavyweight boxing (usa).bin", 0x100000, 0xb638b6a3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_muhammu)
STD_ROM_FN(md_muhammu)

struct BurnDriver BurnDrvmd_muhammu = {
	"md_muhammu", "md_muhamm", NULL, NULL, "1992",
	"Muhammad Ali Heavyweight Boxing (USA)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_muhammuRomInfo, md_muhammuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (USA, Prototype)
static struct BurnRomInfo md_muhammupRomDesc[] = {
	{ "muhammad ali heavyweight boxing (usa) (beta).bin", 0x100000, 0x7b852653, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_muhammup)
STD_ROM_FN(md_muhammup)

struct BurnDriver BurnDrvmd_muhammup = {
	"md_muhammup", "md_muhamm", NULL, NULL, "1992",
	"Muhammad Ali Heavyweight Boxing (USA, Prototype)\0", NULL, "Virgin Games", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_muhammupRomInfo, md_muhammupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MUSHA - Metallic Uniframe Super Hybrid Armor (USA)
static struct BurnRomInfo md_mushaRomDesc[] = {
	{ "musha - metallic uniframe super hybrid armor (usa).bin", 0x080000, 0x58a7f7b4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_musha)
STD_ROM_FN(md_musha)

struct BurnDriver BurnDrvmd_musha = {
	"md_musha", NULL, NULL, NULL, "1990",
	"MUSHA - Metallic Uniframe Super Hybrid Armor (USA)\0", NULL, "Seismic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mushaRomInfo, md_mushaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Musha Aleste - Full Metal Fighter Ellinor (Jpn)
static struct BurnRomInfo md_mushajRomDesc[] = {
	{ "musha aleste - full metal fighter ellinor (jpn).bin", 0x080000, 0x8fde18ab, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mushaj)
STD_ROM_FN(md_mushaj)

struct BurnDriver BurnDrvmd_mushaj = {
	"md_mushaj", "md_musha", NULL, NULL, "1990",
	"Musha Aleste - Full Metal Fighter Ellinor (Jpn)\0", NULL, "Toaplan", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mushajRomInfo, md_mushajRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Football (Jpn)
static struct BurnRomInfo md_mutantlfjRomDesc[] = {
	{ "mutant league football (jpn).bin", 0x100000, 0x2a97e6af, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mutantlfj)
STD_ROM_FN(md_mutantlfj)

struct BurnDriver BurnDrvmd_mutantlfj = {
	"md_mutantlfj", "md_mutantlf", NULL, NULL, "1993",
	"Mutant League Football (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mutantlfjRomInfo, md_mutantlfjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Hockey (Euro, USA)
static struct BurnRomInfo md_mlhockeyRomDesc[] = {
	{ "mutant league hockey (euro, usa).bin", 0x200000, 0x3529180f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mlhockey)
STD_ROM_FN(md_mlhockey)

struct BurnDriver BurnDrvmd_mlhockey = {
	"md_mlhockey", NULL, NULL, NULL, "1994",
	"Mutant League Hockey (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mlhockeyRomInfo, md_mlhockeyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystic Defender (Euro, USA, Rev. A)
static struct BurnRomInfo md_mystdefRomDesc[] = {
	{ "mpr-12707a.bin", 0x080000, 0x50fd5d93, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mystdef)
STD_ROM_FN(md_mystdef)

struct BurnDriver BurnDrvmd_mystdef = {
	"md_mystdef", NULL, NULL, NULL, "1989",
	"Mystic Defender (Euro, USA, Rev. A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mystdefRomInfo, md_mystdefRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystic Defender (Euro, USA)
static struct BurnRomInfo md_mystdefaRomDesc[] = {
	{ "mpr-12707.bin", 0x080000, 0xf9ce1ab8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mystdefa)
STD_ROM_FN(md_mystdefa)

struct BurnDriver BurnDrvmd_mystdefa = {
	"md_mystdefa", "md_mystdef", NULL, NULL, "1989",
	"Mystic Defender (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mystdefaRomInfo, md_mystdefaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kujaku Ou 2 - Geneijou (Jpn)
static struct BurnRomInfo md_kujakuRomDesc[] = {
	{ "kujaku ou 2 - geneijou (jpn).bin", 0x060000, 0xaffd56bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_kujaku)
STD_ROM_FN(md_kujaku)

struct BurnDriver BurnDrvmd_kujaku = {
	"md_kujaku", "md_mystdef", NULL, NULL, "1989",
	"Kujaku Ou 2 - Geneijou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_kujakuRomInfo, md_kujakuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// On Dal Jang Goon (Kor)
static struct BurnRomInfo md_ondalRomDesc[] = {
	{ "on dal jang goon (kor).bin", 0x080000, 0x67ccb1ca, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ondal)
STD_ROM_FN(md_ondal)

struct BurnDriver BurnDrvmd_ondal = {
	"md_ondal", "md_mystdef", NULL, NULL, "1990?",
	"On Dal Jang Goon (Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ondalRomInfo, md_ondalRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystical Fighter (USA)
static struct BurnRomInfo md_mysticfRomDesc[] = {
	{ "mystical fighter (usa).bin", 0x080000, 0xb2f2a69b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_mysticf)
STD_ROM_FN(md_mysticf)

struct BurnDriver BurnDrvmd_mysticf = {
	"md_mysticf", NULL, NULL, NULL, "1992",
	"Mystical Fighter (USA)\0", NULL, "Dreamworks", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_mysticfRomInfo, md_mysticfRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Maou Renjishi (Jpn)
static struct BurnRomInfo md_maourenRomDesc[] = {
	{ "maou renjishi (jpn).bin", 0x080000, 0x24a7f28c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_maouren)
STD_ROM_FN(md_maouren)

struct BurnDriver BurnDrvmd_maouren = {
	"md_maouren", "md_mysticf", NULL, NULL, "1991",
	"Maou Renjishi (Jpn)\0", NULL, "Taito", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_maourenRomInfo, md_maourenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fushigi no Umi no Nadia (Jpn)
static struct BurnRomInfo md_nadiaRomDesc[] = {
	{ "namcot_mfn_mb838200-20.bin", 0x100000, 0x4762062a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nadia)
STD_ROM_FN(md_nadia)

struct BurnDriver BurnDrvmd_nadia = {
	"md_nadia", NULL, NULL, NULL, "1991",
	"Fushigi no Umi no Nadia (Jpn)\0", NULL, "Namcot", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nadiaRomInfo, md_nadiaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Grand Prix (Jpn)
static struct BurnRomInfo md_nakaf1gpRomDesc[] = {
	{ "nakajima satoru kanshuu f1 grand prix (jpn).bin", 0x100000, 0x93be47cf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nakaf1gp)
STD_ROM_FN(md_nakaf1gp)

struct BurnDriver BurnDrvmd_nakaf1gp = {
	"md_nakaf1gp", NULL, NULL, NULL, "1991",
	"Nakajima Satoru Kanshuu F1 Grand Prix (Jpn)\0", NULL, "Varie", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nakaf1gpRomInfo, md_nakaf1gpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Hero MD (Jpn)
static struct BurnRomInfo md_nakaf1heRomDesc[] = {
	{ "nakajima satoru kanshuu f1 hero md (jpn).bin", 0x100000, 0x24f87987, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nakaf1he)
STD_ROM_FN(md_nakaf1he)

struct BurnDriver BurnDrvmd_nakaf1he = {
	"md_nakaf1he", NULL, NULL, NULL, "1992",
	"Nakajima Satoru Kanshuu F1 Hero MD (Jpn)\0", NULL, "Varie", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nakaf1heRomInfo, md_nakaf1heRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Super License (Jpn)
static struct BurnRomInfo md_nakaf1slRomDesc[] = {
	{ "nakajima satoru kanshuu f1 super license (jpn).bin", 0x100000, 0x8774bc79, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nakaf1sl)
STD_ROM_FN(md_nakaf1sl)

struct BurnDriver BurnDrvmd_nakaf1sl = {
	"md_nakaf1sl", NULL, NULL, NULL, "1992",
	"Nakajima Satoru Kanshuu F1 Super License (Jpn)\0", NULL, "Varie", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nakaf1slRomInfo, md_nakaf1slRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (USA)
static struct BurnRomInfo md_nbaactRomDesc[] = {
	{ "nba action (usa).bin", 0x200000, 0x99c348ba, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact)
STD_ROM_FN(md_nbaact)

struct BurnDriver BurnDrvmd_nbaact = {
	"md_nbaact", NULL, NULL, NULL, "1994",
	"NBA Action (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaactRomInfo, md_nbaactRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype, 19940104)
static struct BurnRomInfo md_nbaactp3RomDesc[] = {
	{ "nba action (prototype - jan 04, 1994).bin", 0x200000, 0x2491df2f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaactp3)
STD_ROM_FN(md_nbaactp3)

struct BurnDriver BurnDrvmd_nbaactp3 = {
	"md_nbaactp3", "md_nbaact", NULL, NULL, "1994",
	"NBA Action (Prototype, 19940104)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaactp3RomInfo, md_nbaactp3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype, 19940116)
static struct BurnRomInfo md_nbaactp2RomDesc[] = {
	{ "nba action (prototype - jan 16, 1994).bin", 0x200000, 0xfe43c79d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaactp2)
STD_ROM_FN(md_nbaactp2)

struct BurnDriver BurnDrvmd_nbaactp2 = {
	"md_nbaactp2", "md_nbaact", NULL, NULL, "1994",
	"NBA Action (Prototype, 19940116)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaactp2RomInfo, md_nbaactp2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype, 19940127, broken - C08 missing)
static struct BurnRomInfo md_nbaactp1RomDesc[] = {
	{ "nba action (prototype - jan 27, 1994) (broken - c08 missing).bin", 0x200000, 0x176a4bc5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaactp1)
STD_ROM_FN(md_nbaactp1)

struct BurnDriver BurnDrvmd_nbaactp1 = {
	"md_nbaactp1", "md_nbaact", NULL, NULL, "1994",
	"NBA Action (Prototype, 19940127, broken - C08 missing)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaactp1RomInfo, md_nbaactp1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Euro, USA)
static struct BurnRomInfo md_nbaact95RomDesc[] = {
	{ "nba action '95 starring david robinson (euro, usa).bin", 0x200000, 0xaa7006d6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95)
STD_ROM_FN(md_nbaact95)

struct BurnDriver BurnDrvmd_nbaact95 = {
	"md_nbaact95", NULL, NULL, NULL, "1995",
	"NBA Action '95 (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95RomInfo, md_nbaact95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941202-B)
static struct BurnRomInfo md_nbaact95p23RomDesc[] = {
	{ "nba action '95 (prototype - dec 02, 1994 - b).bin", 0x200000, 0x04bf6f6e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p23)
STD_ROM_FN(md_nbaact95p23)

struct BurnDriver BurnDrvmd_nbaact95p23 = {
	"md_nbaact95p23", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941202-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p23RomInfo, md_nbaact95p23RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941209)
static struct BurnRomInfo md_nbaact95p22RomDesc[] = {
	{ "nba action '95 (prototype - dec 09, 1994).bin", 0x200000, 0x2b198487, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p22)
STD_ROM_FN(md_nbaact95p22)

struct BurnDriver BurnDrvmd_nbaact95p22 = {
	"md_nbaact95p22", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941209)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p22RomInfo, md_nbaact95p22RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941215)
static struct BurnRomInfo md_nbaact95p21RomDesc[] = {
	{ "nba action '95 (prototype - dec 15, 1994).bin", 0x200000, 0x10a3b46d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p21)
STD_ROM_FN(md_nbaact95p21)

struct BurnDriver BurnDrvmd_nbaact95p21 = {
	"md_nbaact95p21", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941215)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p21RomInfo, md_nbaact95p21RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941222-A)
static struct BurnRomInfo md_nbaact95p20RomDesc[] = {
	{ "nba action '95 (prototype - dec 22, 1994 - a).bin", 0x200000, 0xf92ba323, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p20)
STD_ROM_FN(md_nbaact95p20)

struct BurnDriver BurnDrvmd_nbaact95p20 = {
	"md_nbaact95p20", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941222-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p20RomInfo, md_nbaact95p20RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941224-A)
static struct BurnRomInfo md_nbaact95p19RomDesc[] = {
	{ "nba action '95 (prototype - dec 24, 1994 - a).bin", 0x200000, 0xddb04550, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p19)
STD_ROM_FN(md_nbaact95p19)

struct BurnDriver BurnDrvmd_nbaact95p19 = {
	"md_nbaact95p19", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941224-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p19RomInfo, md_nbaact95p19RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941229)
static struct BurnRomInfo md_nbaact95p18RomDesc[] = {
	{ "nba action '95 (prototype - dec 29, 1994).bin", 0x200000, 0xdcebe32a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p18)
STD_ROM_FN(md_nbaact95p18)

struct BurnDriver BurnDrvmd_nbaact95p18 = {
	"md_nbaact95p18", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941229)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p18RomInfo, md_nbaact95p18RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941230)
static struct BurnRomInfo md_nbaact95p17RomDesc[] = {
	{ "nba action '95 (prototype - dec 30, 1994).bin", 0x200000, 0xd87956c9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p17)
STD_ROM_FN(md_nbaact95p17)

struct BurnDriver BurnDrvmd_nbaact95p17 = {
	"md_nbaact95p17", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941230)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p17RomInfo, md_nbaact95p17RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941231)
static struct BurnRomInfo md_nbaact95p16RomDesc[] = {
	{ "nba action '95 (prototype - dec 31, 1994).bin", 0x200000, 0x582a378f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p16)
STD_ROM_FN(md_nbaact95p16)

struct BurnDriver BurnDrvmd_nbaact95p16 = {
	"md_nbaact95p16", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941231)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p16RomInfo, md_nbaact95p16RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950201, Alt)
static struct BurnRomInfo md_nbaact95p03RomDesc[] = {
	{ "nba action '95 (prototype - feb 01, 1995).bin", 0x200000, 0x2c02a79d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p03)
STD_ROM_FN(md_nbaact95p03)

struct BurnDriver BurnDrvmd_nbaact95p03 = {
	"md_nbaact95p03", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950201, Alt)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p03RomInfo, md_nbaact95p03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950201)
static struct BurnRomInfo md_nbaact95p02RomDesc[] = {
	{ "nba action '95 (prototype - feb 1, 1995).bin", 0x1ff49e, 0xc4a0a624, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p02)
STD_ROM_FN(md_nbaact95p02)

struct BurnDriver BurnDrvmd_nbaact95p02 = {
	"md_nbaact95p02", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950201)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p02RomInfo, md_nbaact95p02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950202)
static struct BurnRomInfo md_nbaact95p01RomDesc[] = {
	{ "nba action '95 (prototype - feb 2, 1995).bin", 0x1fe1f0, 0xa9167903, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p01)
STD_ROM_FN(md_nbaact95p01)

struct BurnDriver BurnDrvmd_nbaact95p01 = {
	"md_nbaact95p01", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950202)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p01RomInfo, md_nbaact95p01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950103)
static struct BurnRomInfo md_nbaact95p15RomDesc[] = {
	{ "nba action '95 (prototype - jan 03, 1995).bin", 0x200000, 0x374af160, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p15)
STD_ROM_FN(md_nbaact95p15)

struct BurnDriver BurnDrvmd_nbaact95p15 = {
	"md_nbaact95p15", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950103)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p15RomInfo, md_nbaact95p15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950108)
static struct BurnRomInfo md_nbaact95p14RomDesc[] = {
	{ "nba action '95 (prototype - jan 08, 1995).bin", 0x200000, 0x0a6b7b9e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p14)
STD_ROM_FN(md_nbaact95p14)

struct BurnDriver BurnDrvmd_nbaact95p14 = {
	"md_nbaact95p14", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950108)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p14RomInfo, md_nbaact95p14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950112)
static struct BurnRomInfo md_nbaact95p13RomDesc[] = {
	{ "nba action '95 (prototype - jan 12, 1995).bin", 0x200000, 0xb47ff025, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p13)
STD_ROM_FN(md_nbaact95p13)

struct BurnDriver BurnDrvmd_nbaact95p13 = {
	"md_nbaact95p13", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950112)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p13RomInfo, md_nbaact95p13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950115-A)
static struct BurnRomInfo md_nbaact95p12RomDesc[] = {
	{ "nba action '95 (prototype - jan 15, 1995 - a).bin", 0x200000, 0x9c6a1f27, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p12)
STD_ROM_FN(md_nbaact95p12)

struct BurnDriver BurnDrvmd_nbaact95p12 = {
	"md_nbaact95p12", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950115-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p12RomInfo, md_nbaact95p12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950121)
static struct BurnRomInfo md_nbaact95p11RomDesc[] = {
	{ "nba action '95 (prototype - jan 21, 1995).bin", 0x200000, 0xe337bdfb, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p11)
STD_ROM_FN(md_nbaact95p11)

struct BurnDriver BurnDrvmd_nbaact95p11 = {
	"md_nbaact95p11", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950121)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p11RomInfo, md_nbaact95p11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950122-B)
static struct BurnRomInfo md_nbaact95p10RomDesc[] = {
	{ "nba action '95 (prototype - jan 22, 1995 - b).bin", 0x200000, 0x7bd7ca47, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p10)
STD_ROM_FN(md_nbaact95p10)

struct BurnDriver BurnDrvmd_nbaact95p10 = {
	"md_nbaact95p10", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950122-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p10RomInfo, md_nbaact95p10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950124-B)
static struct BurnRomInfo md_nbaact95p09RomDesc[] = {
	{ "nba action '95 (prototype - jan 24, 1995 - b).bin", 0x200000, 0x15abcf41, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p09)
STD_ROM_FN(md_nbaact95p09)

struct BurnDriver BurnDrvmd_nbaact95p09 = {
	"md_nbaact95p09", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950124-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p09RomInfo, md_nbaact95p09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950127-A)
static struct BurnRomInfo md_nbaact95p08RomDesc[] = {
	{ "nba action '95 (prototype - jan 27, 1995 - a).bin", 0x1fe190, 0x79c7fb00, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p08)
STD_ROM_FN(md_nbaact95p08)

struct BurnDriver BurnDrvmd_nbaact95p08 = {
	"md_nbaact95p08", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950127-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p08RomInfo, md_nbaact95p08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950127-B)
static struct BurnRomInfo md_nbaact95p07RomDesc[] = {
	{ "nba action '95 (prototype - jan 27, 1995 - b).bin", 0x1fe190, 0xef7f608b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p07)
STD_ROM_FN(md_nbaact95p07)

struct BurnDriver BurnDrvmd_nbaact95p07 = {
	"md_nbaact95p07", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950127-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p07RomInfo, md_nbaact95p07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950128-A)
static struct BurnRomInfo md_nbaact95p06RomDesc[] = {
	{ "nba action '95 (prototype - jan 28, 1995 - a).bin", 0x200000, 0x57c2c69c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p06)
STD_ROM_FN(md_nbaact95p06)

struct BurnDriver BurnDrvmd_nbaact95p06 = {
	"md_nbaact95p06", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950128-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p06RomInfo, md_nbaact95p06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950128)
static struct BurnRomInfo md_nbaact95p05RomDesc[] = {
	{ "nba action '95 (prototype - jan 28, 1995).bin", 0x1fe19e, 0x97d7075d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p05)
STD_ROM_FN(md_nbaact95p05)

struct BurnDriver BurnDrvmd_nbaact95p05 = {
	"md_nbaact95p05", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950128)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p05RomInfo, md_nbaact95p05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19950130)
static struct BurnRomInfo md_nbaact95p04RomDesc[] = {
	{ "nba action '95 (prototype - jan 30, 1995).bin", 0x200000, 0x2fac80b2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p04)
STD_ROM_FN(md_nbaact95p04)

struct BurnDriver BurnDrvmd_nbaact95p04 = {
	"md_nbaact95p04", "md_nbaact95", NULL, NULL, "1995",
	"NBA Action '95 (Prototype, 19950130)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p04RomInfo, md_nbaact95p04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941118)
static struct BurnRomInfo md_nbaact95p25RomDesc[] = {
	{ "nba action '95 (prototype - nov 18, 1994).bin", 0x200000, 0x2d411e4b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p25)
STD_ROM_FN(md_nbaact95p25)

struct BurnDriver BurnDrvmd_nbaact95p25 = {
	"md_nbaact95p25", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941118)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p25RomInfo, md_nbaact95p25RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype, 19941123-A)
static struct BurnRomInfo md_nbaact95p24RomDesc[] = {
	{ "nba action '95 (prototype - nov 23, 1994 - a).bin", 0x200000, 0x4650cfcc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaact95p24)
STD_ROM_FN(md_nbaact95p24)

struct BurnDriver BurnDrvmd_nbaact95p24 = {
	"md_nbaact95p24", "md_nbaact95", NULL, NULL, "1994",
	"NBA Action '95 (Prototype, 19941123-A)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaact95p24RomInfo, md_nbaact95p24RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA All-Star Challenge (Euro, USA)
static struct BurnRomInfo md_nbaallstRomDesc[] = {
	{ "nba all-star challenge (euro, usa).bin", 0x100000, 0xc4674adf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaallst)
STD_ROM_FN(md_nbaallst)

struct BurnDriver BurnDrvmd_nbaallst = {
	"md_nbaallst", NULL, NULL, NULL, "1992",
	"NBA All-Star Challenge (Euro, USA)\0", NULL, "Flying Edge", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaallstRomInfo, md_nbaallstRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Hang Time (Euro)
static struct BurnRomInfo md_nbahangRomDesc[] = {
	{ "nba hang time (euro).bin", 0x300000, 0xedb4d4aa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbahang)
STD_ROM_FN(md_nbahang)

struct BurnDriver BurnDrvmd_nbahang = {
	"md_nbahang", NULL, NULL, NULL, "1996",
	"NBA Hang Time (Euro)\0", NULL, "Midway", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbahangRomInfo, md_nbahangRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Hang Time (USA)
static struct BurnRomInfo md_nbahanguRomDesc[] = {
	{ "nba hang time (usa).bin", 0x300000, 0x176b0338, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbahangu)
STD_ROM_FN(md_nbahangu)

struct BurnDriver BurnDrvmd_nbahangu = {
	"md_nbahangu", "md_nbahang", NULL, NULL, "1996",
	"NBA Hang Time (USA)\0", NULL, "Midway", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbahanguRomInfo, md_nbahanguRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (Euro, USA, v1.1)
static struct BurnRomInfo md_nbajamRomDesc[] = {
	{ "nba jam (euro, usa) (v1.1).bin", 0x200000, 0xeb8360e6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbajam)
STD_ROM_FN(md_nbajam)

struct BurnDriver BurnDrvmd_nbajam = {
	"md_nbajam", NULL, NULL, NULL, "1993",
	"NBA Jam (Euro, USA, v1.1)\0", NULL, "Arena", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbajamRomInfo, md_nbajamRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (Euro, USA)
static struct BurnRomInfo md_nbajam1RomDesc[] = {
	{ "s285_ver_1.00.bin", 0x200000, 0x10fa248f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbajam1)
STD_ROM_FN(md_nbajam1)

struct BurnDriver BurnDrvmd_nbajam1 = {
	"md_nbajam1", "md_nbajam", NULL, NULL, "1993",
	"NBA Jam (Euro, USA)\0", NULL, "Arena", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbajam1RomInfo, md_nbajam1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (Jpn)
static struct BurnRomInfo md_nbajamjRomDesc[] = {
	{ "nba jam (jpn).bin", 0x200000, 0xa6c6305a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbajamj)
STD_ROM_FN(md_nbajamj)

struct BurnDriver BurnDrvmd_nbajamj = {
	"md_nbajamj", "md_nbajam", NULL, NULL, "1994",
	"NBA Jam (Jpn)\0", NULL, "Acclaim Japan", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbajamjRomInfo, md_nbajamjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam Tournament Edition (World)
static struct BurnRomInfo md_nbajamteRomDesc[] = {
	{ "nba jam tournament edition (world).bin", 0x300000, 0xe9ffcb37, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbajamte)
STD_ROM_FN(md_nbajamte)

struct BurnDriver BurnDrvmd_nbajamte = {
	"md_nbajamte", NULL, NULL, NULL, "1995",
	"NBA Jam Tournament Edition (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM_TE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbajamteRomInfo, md_nbajamteRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam Tournament Edition (World, 2002 Fix Release)
static struct BurnRomInfo md_nbajamtefRomDesc[] = {
	{ "nba jam tournament edition (world) (fixed).bin", 0x300000, 0x6e25ebf0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbajamtef)
STD_ROM_FN(md_nbajamtef)

struct BurnDriver BurnDrvmd_nbajamtef = {
	"md_nbajamtef", "md_nbajamte", NULL, NULL, "2002?",
	"NBA Jam Tournament Edition (World, 2002 Fix Release)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM_TE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbajamtefRomInfo, md_nbajamtefRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 95 (Euro, USA)
static struct BurnRomInfo md_nbaliv95RomDesc[] = {
	{ "nba live 95 (euro, usa).bin", 0x200000, 0x66018abc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaliv95)
STD_ROM_FN(md_nbaliv95)

struct BurnDriver BurnDrvmd_nbaliv95 = {
	"md_nbaliv95", NULL, NULL, NULL, "1994",
	"NBA Live 95 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaliv95RomInfo, md_nbaliv95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 95 (Kor)
static struct BurnRomInfo md_nbaliv95kRomDesc[] = {
	{ "lh5370hc.bin", 0x200000, 0x779c1244, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaliv95k)
STD_ROM_FN(md_nbaliv95k)

struct BurnDriver BurnDrvmd_nbaliv95k = {
	"md_nbaliv95k", "md_nbaliv95", NULL, NULL, "1994",
	"NBA Live 95 (Kor)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaliv95kRomInfo, md_nbaliv95kRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 96 (Euro, USA)
static struct BurnRomInfo md_nbaliv96RomDesc[] = {
	{ "nba live 96 (euro, usa).bin", 0x200000, 0x49de0062, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaliv96)
STD_ROM_FN(md_nbaliv96)

struct BurnDriver BurnDrvmd_nbaliv96 = {
	"md_nbaliv96", NULL, NULL, NULL, "1995",
	"NBA Live 96 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaliv96RomInfo, md_nbaliv96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 97 (Euro, USA)
static struct BurnRomInfo md_nbaliv97RomDesc[] = {
	{ "nba live 97 (euro, usa).bin", 0x200000, 0x7024843a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaliv97)
STD_ROM_FN(md_nbaliv97)

struct BurnDriver BurnDrvmd_nbaliv97 = {
	"md_nbaliv97", NULL, NULL, NULL, "1996",
	"NBA Live 97 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaliv97RomInfo, md_nbaliv97RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 98 (USA)
static struct BurnRomInfo md_nbaliv98RomDesc[] = {
	{ "nba live 98 (usa).bin", 0x200000, 0x23473a8a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbaliv98)
STD_ROM_FN(md_nbaliv98)

struct BurnDriver BurnDrvmd_nbaliv98 = {
	"md_nbaliv98", NULL, NULL, NULL, "1997",
	"NBA Live 98 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nbaliv98RomInfo, md_nbaliv98RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Playoffs - Bulls Vs Blazers (Jpn)
static struct BurnRomInfo md_bullvsbljRomDesc[] = {
	{ "nba playoffs - bulls vs blazers (jpn).bin", 0x100000, 0xeae8c000, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bullvsblj)
STD_ROM_FN(md_bullvsblj)

struct BurnDriver BurnDrvmd_bullvsblj = {
	"md_bullvsblj", "md_bullvsbl", NULL, NULL, "1993",
	"NBA Playoffs - Bulls Vs Blazers (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bullvsbljRomInfo, md_bullvsbljRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Playoffs - Bulls Vs Blazers (Jpn, Alt)
static struct BurnRomInfo md_bullvsblj1RomDesc[] = {
	{ "nba playoffs - bulls vs blazers (jpn) (alt).bin", 0x100000, 0x4565ce1f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bullvsblj1)
STD_ROM_FN(md_bullvsblj1)

struct BurnDriver BurnDrvmd_bullvsblj1 = {
	"md_bullvsblj1", "md_bullvsbl", NULL, NULL, "1993",
	"NBA Playoffs - Bulls Vs Blazers (Jpn, Alt)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bullvsblj1RomInfo, md_bullvsblj1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Pro Basketball - Bulls Vs Lakers (Jpn)
static struct BurnRomInfo md_bullvslajRomDesc[] = {
	{ "nba pro basketball - bulls vs lakers (jpn).bin", 0x100000, 0x4416ce39, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_bullvslaj)
STD_ROM_FN(md_bullvslaj)

struct BurnDriver BurnDrvmd_bullvslaj = {
	"md_bullvslaj", "md_bullvsla", NULL, NULL, "1993",
	"NBA Pro Basketball - Bulls Vs Lakers (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_bullvslajRomInfo, md_bullvslajRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Pro Basketball '94 (Jpn)
static struct BurnRomInfo md_nbapro94RomDesc[] = {
	{ "nba pro basketball '94 (jpn).bin", 0x200000, 0xeea19bce, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbapro94)
STD_ROM_FN(md_nbapro94)

struct BurnDriver BurnDrvmd_nbapro94 = {
	"md_nbapro94", NULL, NULL, NULL, "1994",
	"NBA Pro Basketball '94 (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbapro94RomInfo, md_nbapro94RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Showdown '94 (Euro, USA)
static struct BurnRomInfo md_nbashowRomDesc[] = {
	{ "nba showdown '94 (euro, usa).bin", 0x200000, 0x160b7090, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbashow)
STD_ROM_FN(md_nbashow)

struct BurnDriver BurnDrvmd_nbashow = {
	"md_nbashow", NULL, NULL, NULL, "1994",
	"NBA Showdown '94 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbashowRomInfo, md_nbashowRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Showdown '94 (USA, Prototype)
static struct BurnRomInfo md_nbashowpRomDesc[] = {
	{ "nba showdown '94 (usa) (beta).bin", 0x200000, 0x6643a308, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nbashowp)
STD_ROM_FN(md_nbashowp)

struct BurnDriver BurnDrvmd_nbashowp = {
	"md_nbashowp", "md_nbashow", NULL, NULL, "1994",
	"NBA Showdown '94 (USA, Prototype)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nbashowpRomInfo, md_nbashowpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NCAA Final Four Basketball (USA)
static struct BurnRomInfo md_ncaabaskRomDesc[] = {
	{ "ncaa final four basketball (usa).bin", 0x180000, 0xed0c1303, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ncaabask)
STD_ROM_FN(md_ncaabask)

struct BurnDriver BurnDrvmd_ncaabask = {
	"md_ncaabask", NULL, NULL, NULL, "1994",
	"NCAA Final Four Basketball (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_ncaabaskRomInfo, md_ncaabaskRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NCAA Football (USA)
static struct BurnRomInfo md_ncaafootRomDesc[] = {
	{ "ncaa football (usa).bin", 0x100000, 0x081012f0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ncaafoot)
STD_ROM_FN(md_ncaafoot)

struct BurnDriver BurnDrvmd_ncaafoot = {
	"md_ncaafoot", NULL, NULL, NULL, "1994",
	"NCAA Football (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_ncaafootRomInfo, md_ncaafootRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nekketsu Koukou Dodgeball Bu - Soccer Hen MD (Jpn)
static struct BurnRomInfo md_nekketsuRomDesc[] = {
	{ "nekketsu koukou dodgeball bu - soccer hen md (jpn).bin", 0x080000, 0xf49c3a86, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nekketsu)
STD_ROM_FN(md_nekketsu)

struct BurnDriver BurnDrvmd_nekketsu = {
	"md_nekketsu", NULL, NULL, NULL, "1992",
	"Nekketsu Koukou Dodgeball Bu - Soccer Hen MD (Jpn)\0", NULL, "Palsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nekketsuRomInfo, md_nekketsuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Devil's Course (Jpn)
static struct BurnRomInfo md_n3dgdeviRomDesc[] = {
	{ "new 3d golf simulation devil's course (jpn).bin", 0x180000, 0xbd090c67, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_n3dgdevi)
STD_ROM_FN(md_n3dgdevi)

struct BurnDriver BurnDrvmd_n3dgdevi = {
	"md_n3dgdevi", NULL, NULL, NULL, "1994",
	"New 3D Golf Simulation Devil's Course (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_n3dgdeviRomInfo, md_n3dgdeviRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Harukanaru Augusta (Jpn)
static struct BurnRomInfo md_n3dgauguRomDesc[] = {
	{ "mpr-16076.bin", 0x180000, 0xd2a9bf92, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_n3dgaugu)
STD_ROM_FN(md_n3dgaugu)

struct BurnDriver BurnDrvmd_n3dgaugu = {
	"md_n3dgaugu", NULL, NULL, NULL, "1993",
	"New 3D Golf Simulation Harukanaru Augusta (Jpn)\0", NULL, "T & E Soft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_n3dgauguRomInfo, md_n3dgauguRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Waialae no Kiseki (Jpn)
static struct BurnRomInfo md_n3dgwaiaRomDesc[] = {
	{ "new 3d golf simulation waialae no kiseki (jpn).bin", 0x180000, 0xcbe2c1f6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_n3dgwaia)
STD_ROM_FN(md_n3dgwaia)

struct BurnDriver BurnDrvmd_n3dgwaia = {
	"md_n3dgwaia", NULL, NULL, NULL, "1994",
	"New 3D Golf Simulation Waialae no Kiseki (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_n3dgwaiaRomInfo, md_n3dgwaiaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Euro, USA)
static struct BurnRomInfo md_nfl95RomDesc[] = {
	{ "nfl '95 (euro, usa).bin", 0x200000, 0xb58e4a81, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95)
STD_ROM_FN(md_nfl95)

struct BurnDriver BurnDrvmd_nfl95 = {
	"md_nfl95", NULL, NULL, NULL, "1994",
	"NFL '95 (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95RomInfo, md_nfl95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940801)
static struct BurnRomInfo md_nfl95p21RomDesc[] = {
	{ "nfl '95 (prototype - aug 01, 1994).bin", 0x200000, 0x5a57ea4e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p21)
STD_ROM_FN(md_nfl95p21)

struct BurnDriver BurnDrvmd_nfl95p21 = {
	"md_nfl95p21", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940801)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p21RomInfo, md_nfl95p21RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940805)
static struct BurnRomInfo md_nfl95p20RomDesc[] = {
	{ "nfl '95 (prototype - aug 05, 1994).bin", 0x200000, 0x88d51773, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p20)
STD_ROM_FN(md_nfl95p20)

struct BurnDriver BurnDrvmd_nfl95p20 = {
	"md_nfl95p20", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940805)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p20RomInfo, md_nfl95p20RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940810)
static struct BurnRomInfo md_nfl95p19RomDesc[] = {
	{ "nfl '95 (prototype - aug 10, 1994).bin", 0x200000, 0xa3c5710b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p19)
STD_ROM_FN(md_nfl95p19)

struct BurnDriver BurnDrvmd_nfl95p19 = {
	"md_nfl95p19", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940810)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p19RomInfo, md_nfl95p19RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940812)
static struct BurnRomInfo md_nfl95p18RomDesc[] = {
	{ "nfl '95 (prototype - aug 12, 1994).bin", 0x200000, 0x3d23633b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p18)
STD_ROM_FN(md_nfl95p18)

struct BurnDriver BurnDrvmd_nfl95p18 = {
	"md_nfl95p18", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940812)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p18RomInfo, md_nfl95p18RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940812, Alt)
static struct BurnRomInfo md_nfl95p17RomDesc[] = {
	{ "nfl '95 (prototype - aug 12, 1994 - b).bin", 0x200000, 0xcc86a259, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p17)
STD_ROM_FN(md_nfl95p17)

struct BurnDriver BurnDrvmd_nfl95p17 = {
	"md_nfl95p17", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940812, Alt)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p17RomInfo, md_nfl95p17RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940817-B)
static struct BurnRomInfo md_nfl95p16RomDesc[] = {
	{ "nfl '95 (prototype - aug 17, 1994 - b).bin", 0x200000, 0xa6015c29, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p16)
STD_ROM_FN(md_nfl95p16)

struct BurnDriver BurnDrvmd_nfl95p16 = {
	"md_nfl95p16", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940817-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p16RomInfo, md_nfl95p16RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940817)
static struct BurnRomInfo md_nfl95p15RomDesc[] = {
	{ "nfl '95 (prototype - aug 17, 1994).bin", 0x200000, 0x655966c8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p15)
STD_ROM_FN(md_nfl95p15)

struct BurnDriver BurnDrvmd_nfl95p15 = {
	"md_nfl95p15", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940817)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p15RomInfo, md_nfl95p15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940822)
static struct BurnRomInfo md_nfl95p14RomDesc[] = {
	{ "nfl '95 (prototype - aug 22, 1994).bin", 0x200000, 0xb01434e5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p14)
STD_ROM_FN(md_nfl95p14)

struct BurnDriver BurnDrvmd_nfl95p14 = {
	"md_nfl95p14", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940822)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p14RomInfo, md_nfl95p14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940830)
static struct BurnRomInfo md_nfl95p13RomDesc[] = {
	{ "nfl '95 (prototype - aug 30, 1994).bin", 0x200000, 0xd0e0a436, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p13)
STD_ROM_FN(md_nfl95p13)

struct BurnDriver BurnDrvmd_nfl95p13 = {
	"md_nfl95p13", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940830)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p13RomInfo, md_nfl95p13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940831)
static struct BurnRomInfo md_nfl95p12RomDesc[] = {
	{ "nfl '95 (prototype - aug 31, 1994).bin", 0x200000, 0xc360521e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p12)
STD_ROM_FN(md_nfl95p12)

struct BurnDriver BurnDrvmd_nfl95p12 = {
	"md_nfl95p12", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940831)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p12RomInfo, md_nfl95p12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940901)
static struct BurnRomInfo md_nfl95p11RomDesc[] = {
	{ "nfl '95 (prototype - sep 01, 1994).bin", 0x200000, 0x9240fcaa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p11)
STD_ROM_FN(md_nfl95p11)

struct BurnDriver BurnDrvmd_nfl95p11 = {
	"md_nfl95p11", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940901)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p11RomInfo, md_nfl95p11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940902)
static struct BurnRomInfo md_nfl95p10RomDesc[] = {
	{ "nfl '95 (prototype - sep 02, 1994).bin", 0x200000, 0xff049a49, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p10)
STD_ROM_FN(md_nfl95p10)

struct BurnDriver BurnDrvmd_nfl95p10 = {
	"md_nfl95p10", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940902)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p10RomInfo, md_nfl95p10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940904)
static struct BurnRomInfo md_nfl95p09RomDesc[] = {
	{ "nfl '95 (prototype - sep 04, 1994).bin", 0x200000, 0x60604d40, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p09)
STD_ROM_FN(md_nfl95p09)

struct BurnDriver BurnDrvmd_nfl95p09 = {
	"md_nfl95p09", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940904)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p09RomInfo, md_nfl95p09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940905-B)
static struct BurnRomInfo md_nfl95p08RomDesc[] = {
	{ "nfl '95 (prototype - sep 05, 1994 - b).bin", 0x200000, 0x123985a5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p08)
STD_ROM_FN(md_nfl95p08)

struct BurnDriver BurnDrvmd_nfl95p08 = {
	"md_nfl95p08", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940905-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p08RomInfo, md_nfl95p08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940905)
static struct BurnRomInfo md_nfl95p07RomDesc[] = {
	{ "nfl '95 (prototype - sep 05, 1994).bin", 0x200000, 0xdbdf61ac, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p07)
STD_ROM_FN(md_nfl95p07)

struct BurnDriver BurnDrvmd_nfl95p07 = {
	"md_nfl95p07", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940905)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p07RomInfo, md_nfl95p07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940906)
static struct BurnRomInfo md_nfl95p06RomDesc[] = {
	{ "nfl '95 (prototype - sep 06, 1994).bin", 0x200000, 0x624b8699, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p06)
STD_ROM_FN(md_nfl95p06)

struct BurnDriver BurnDrvmd_nfl95p06 = {
	"md_nfl95p06", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940906)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p06RomInfo, md_nfl95p06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940907)
static struct BurnRomInfo md_nfl95p05RomDesc[] = {
	{ "nfl '95 (prototype - sep 07, 1994).bin", 0x200000, 0xae8aa4be, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p05)
STD_ROM_FN(md_nfl95p05)

struct BurnDriver BurnDrvmd_nfl95p05 = {
	"md_nfl95p05", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940907)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p05RomInfo, md_nfl95p05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940908)
static struct BurnRomInfo md_nfl95p04RomDesc[] = {
	{ "nfl '95 (prototype - sep 08, 1994).bin", 0x200000, 0x22c5e289, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p04)
STD_ROM_FN(md_nfl95p04)

struct BurnDriver BurnDrvmd_nfl95p04 = {
	"md_nfl95p04", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940908)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p04RomInfo, md_nfl95p04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940909)
static struct BurnRomInfo md_nfl95p03RomDesc[] = {
	{ "nfl '95 (prototype - sep 09, 1994).bin", 0x200000, 0x55df1066, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p03)
STD_ROM_FN(md_nfl95p03)

struct BurnDriver BurnDrvmd_nfl95p03 = {
	"md_nfl95p03", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940909)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p03RomInfo, md_nfl95p03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940911-B)
static struct BurnRomInfo md_nfl95p02RomDesc[] = {
	{ "nfl '95 (prototype - sep 11, 1994 - b).bin", 0x200000, 0x111ac6a0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p02)
STD_ROM_FN(md_nfl95p02)

struct BurnDriver BurnDrvmd_nfl95p02 = {
	"md_nfl95p02", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940911-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p02RomInfo, md_nfl95p02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype, 19940911)
static struct BurnRomInfo md_nfl95p01RomDesc[] = {
	{ "nfl '95 (prototype - sep 11, 1994).bin", 0x200000, 0x21614c4f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl95p01)
STD_ROM_FN(md_nfl95p01)

struct BurnDriver BurnDrvmd_nfl95p01 = {
	"md_nfl95p01", "md_nfl95", NULL, NULL, "1994",
	"NFL '95 (Prototype, 19940911)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl95p01RomInfo, md_nfl95p01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL 98 (USA)
static struct BurnRomInfo md_nfl98RomDesc[] = {
	{ "nfl 98 (usa).bin", 0x200000, 0xf73ec54c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl98)
STD_ROM_FN(md_nfl98)

struct BurnDriver BurnDrvmd_nfl98 = {
	"md_nfl98", NULL, NULL, NULL, "1997",
	"NFL 98 (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl98RomInfo, md_nfl98RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Football '94 Starring Joe Montana (USA)
static struct BurnRomInfo md_nfl94RomDesc[] = {
	{ "nfl football '94 starring joe montana (usa).bin", 0x200000, 0x0d486ed5, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl94)
STD_ROM_FN(md_nfl94)

struct BurnDriver BurnDrvmd_nfl94 = {
	"md_nfl94", NULL, NULL, NULL, "1993",
	"NFL Football '94 Starring Joe Montana (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl94RomInfo, md_nfl94RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Football '94 (Jpn)
static struct BurnRomInfo md_nfl94jRomDesc[] = {
	{ "nfl football '94 (jpn).bin", 0x200000, 0xe490dc4a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nfl94j)
STD_ROM_FN(md_nfl94j)

struct BurnDriver BurnDrvmd_nfl94j = {
	"md_nfl94j", "md_nfl94", NULL, NULL, "1994",
	"NFL Football '94 (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nfl94jRomInfo, md_nfl94jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Quarterback Club (World)
static struct BurnRomInfo md_nflqbRomDesc[] = {
	{ "nfl quarterback club (world).bin", 0x300000, 0x94542eaf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nflqb)
STD_ROM_FN(md_nflqb)

struct BurnDriver BurnDrvmd_nflqb = {
	"md_nflqb", NULL, NULL, NULL, "1994",
	"NFL Quarterback Club (World)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NBA_JAM_TE, GBF_MISC, 0,
	MegadriveGetZipName, md_nflqbRomInfo, md_nflqbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Quarterback Club 96 (Euro, USA)
static struct BurnRomInfo md_nflqb96RomDesc[] = {
	{ "nfl quarterback club 96 (euro, usa).bin", 0x400000, 0xd5a37cab, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nflqb96)
STD_ROM_FN(md_nflqb96)

struct BurnDriver BurnDrvmd_nflqb96 = {
	"md_nflqb96", NULL, NULL, NULL, "1996",
	"NFL Quarterback Club 96 (Euro, USA)\0", NULL, "Acclaim Entertainment", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_NFL_QB_96, GBF_MISC, 0,
	MegadriveGetZipName, md_nflqb96RomInfo, md_nflqb96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Sports Talk Football '93 Starring Joe Montana (Euro, USA)
static struct BurnRomInfo md_nflsportRomDesc[] = {
	{ "mpr-15005+mpr-15006.bin", 0x180000, 0xce0b1fe1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nflsport)
STD_ROM_FN(md_nflsport)

struct BurnDriver BurnDrvmd_nflsport = {
	"md_nflsport", NULL, NULL, NULL, "1992",
	"NFL Sports Talk Football '93 Starring Joe Montana (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nflsportRomInfo, md_nflsportRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHK Taiga Drama - Taiheiki (Jpn)
static struct BurnRomInfo md_nhktaigaRomDesc[] = {
	{ "nhk taiga drama - taiheiki (jpn).bin", 0x100000, 0x09fbb30e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhktaiga)
STD_ROM_FN(md_nhktaiga)

struct BurnDriver BurnDrvmd_nhktaiga = {
	"md_nhktaiga", NULL, NULL, NULL, "1991",
	"NHK Taiga Drama - Taiheiki (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhktaigaRomInfo, md_nhktaigaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 95 (Euro, USA)
static struct BurnRomInfo md_nhl95RomDesc[] = {
	{ "nhl 95 (euro, usa).bin", 0x200000, 0xe8ee917e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhl95)
STD_ROM_FN(md_nhl95)

struct BurnDriver BurnDrvmd_nhl95 = {
	"md_nhl95", NULL, NULL, NULL, "1995",
	"NHL 95 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhl95RomInfo, md_nhl95RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 96 (Euro, USA)
static struct BurnRomInfo md_nhl96RomDesc[] = {
	{ "nhl 96 (euro, usa).bin", 0x200000, 0x8135702c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhl96)
STD_ROM_FN(md_nhl96)

struct BurnDriver BurnDrvmd_nhl96 = {
	"md_nhl96", NULL, NULL, NULL, "1995",
	"NHL 96 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhl96RomInfo, md_nhl96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 97 (Euro, USA)
static struct BurnRomInfo md_nhl97RomDesc[] = {
	{ "nhl 97 (euro, usa).bin", 0x200000, 0xf067c103, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhl97)
STD_ROM_FN(md_nhl97)

struct BurnDriver BurnDrvmd_nhl97 = {
	"md_nhl97", NULL, NULL, NULL, "1996",
	"NHL 97 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhl97RomInfo, md_nhl97RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 98 (USA)
static struct BurnRomInfo md_nhl98RomDesc[] = {
	{ "nhl 98 (usa).bin", 0x200000, 0x7b64cd98, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhl98)
STD_ROM_FN(md_nhl98)

struct BurnDriver BurnDrvmd_nhl98 = {
	"md_nhl98", NULL, NULL, NULL, "1997",
	"NHL 98 (USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhl98RomInfo, md_nhl98RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (USA)
static struct BurnRomInfo md_nhlasRomDesc[] = {
	{ "nhl all-star hockey '95 (usa).bin", 0x200000, 0xe6c0218b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlas)
STD_ROM_FN(md_nhlas)

struct BurnDriver BurnDrvmd_nhlas = {
	"md_nhlas", NULL, NULL, NULL, "1995",
	"NHL All-Star Hockey '95 (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasRomInfo, md_nhlasRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941201-B)
static struct BurnRomInfo md_nhlasp03RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 01, 1994 - b).bin", 0x1ffffa, 0xc209d720, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp03)
STD_ROM_FN(md_nhlasp03)

struct BurnDriver BurnDrvmd_nhlasp03 = {
	"md_nhlasp03", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941201-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp03RomInfo, md_nhlasp03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941201)
static struct BurnRomInfo md_nhlasp02RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 01, 1994).bin", 0x1ffffa, 0x112e4cb3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp02)
STD_ROM_FN(md_nhlasp02)

struct BurnDriver BurnDrvmd_nhlasp02 = {
	"md_nhlasp02", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941201)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp02RomInfo, md_nhlasp02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941202)
static struct BurnRomInfo md_nhlasp01RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 02, 1994).bin", 0x1ffffa, 0x01d6a6c7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp01)
STD_ROM_FN(md_nhlasp01)

struct BurnDriver BurnDrvmd_nhlasp01 = {
	"md_nhlasp01", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941202)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp01RomInfo, md_nhlasp01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941107)
static struct BurnRomInfo md_nhlasp12RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 07, 1994).bin", 0x200000, 0xe8f2c88f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp12)
STD_ROM_FN(md_nhlasp12)

struct BurnDriver BurnDrvmd_nhlasp12 = {
	"md_nhlasp12", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941107)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp12RomInfo, md_nhlasp12RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941109)
static struct BurnRomInfo md_nhlasp11RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 09, 1994).bin", 0x1ffff9, 0x82624073, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp11)
STD_ROM_FN(md_nhlasp11)

struct BurnDriver BurnDrvmd_nhlasp11 = {
	"md_nhlasp11", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941109)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp11RomInfo, md_nhlasp11RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941119)
static struct BurnRomInfo md_nhlasp10RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 19, 1994).bin", 0x200000, 0xcd0f588a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp10)
STD_ROM_FN(md_nhlasp10)

struct BurnDriver BurnDrvmd_nhlasp10 = {
	"md_nhlasp10", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941119)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp10RomInfo, md_nhlasp10RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941121)
static struct BurnRomInfo md_nhlasp09RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 21, 1994).bin", 0x200000, 0xcfe4059d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp09)
STD_ROM_FN(md_nhlasp09)

struct BurnDriver BurnDrvmd_nhlasp09 = {
	"md_nhlasp09", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941121)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp09RomInfo, md_nhlasp09RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941122)
static struct BurnRomInfo md_nhlasp08RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 22, 1994).bin", 0x1ffffa, 0x81d30fe6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp08)
STD_ROM_FN(md_nhlasp08)

struct BurnDriver BurnDrvmd_nhlasp08 = {
	"md_nhlasp08", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941122)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp08RomInfo, md_nhlasp08RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941123)
static struct BurnRomInfo md_nhlasp07RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 23, 1994).bin", 0x1ffffa, 0x88d4fc38, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp07)
STD_ROM_FN(md_nhlasp07)

struct BurnDriver BurnDrvmd_nhlasp07 = {
	"md_nhlasp07", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941123)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp07RomInfo, md_nhlasp07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941127)
static struct BurnRomInfo md_nhlasp06RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 27, 1994).bin", 0x1ffffa, 0x658ffe52, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp06)
STD_ROM_FN(md_nhlasp06)

struct BurnDriver BurnDrvmd_nhlasp06 = {
	"md_nhlasp06", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941127)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp06RomInfo, md_nhlasp06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941128)
static struct BurnRomInfo md_nhlasp05RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 28, 1994).bin", 0x1ffffa, 0x51ad0056, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp05)
STD_ROM_FN(md_nhlasp05)

struct BurnDriver BurnDrvmd_nhlasp05 = {
	"md_nhlasp05", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941128)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp05RomInfo, md_nhlasp05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941129)
static struct BurnRomInfo md_nhlasp04RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 29, 1994).bin", 0x1ffffa, 0xa060a60b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp04)
STD_ROM_FN(md_nhlasp04)

struct BurnDriver BurnDrvmd_nhlasp04 = {
	"md_nhlasp04", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941129)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp04RomInfo, md_nhlasp04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941001)
static struct BurnRomInfo md_nhlasp14RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - oct 01, 1994).bin", 0x1ffff9, 0xb1c0fbb2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp14)
STD_ROM_FN(md_nhlasp14)

struct BurnDriver BurnDrvmd_nhlasp14 = {
	"md_nhlasp14", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941001)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp14RomInfo, md_nhlasp14RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19941021)
static struct BurnRomInfo md_nhlasp13RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - oct 21, 1994).bin", 0x200000, 0x17eb2238, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp13)
STD_ROM_FN(md_nhlasp13)

struct BurnDriver BurnDrvmd_nhlasp13 = {
	"md_nhlasp13", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19941021)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp13RomInfo, md_nhlasp13RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19940914)
static struct BurnRomInfo md_nhlasp16RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - sep 14, 1994).bin", 0x200000, 0x5d4bc48d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp16)
STD_ROM_FN(md_nhlasp16)

struct BurnDriver BurnDrvmd_nhlasp16 = {
	"md_nhlasp16", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19940914)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp16RomInfo, md_nhlasp16RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype, 19940929)
static struct BurnRomInfo md_nhlasp15RomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - sep 29, 1994).bin", 0x1ffff9, 0x96bae44f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlasp15)
STD_ROM_FN(md_nhlasp15)

struct BurnDriver BurnDrvmd_nhlasp15 = {
	"md_nhlasp15", "md_nhlas", NULL, NULL, "1994",
	"NHL All-Star Hockey '95 (Prototype, 19940929)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlasp15RomInfo, md_nhlasp15RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHLPA Hockey 93 (Euro, USA, v1.1)
static struct BurnRomInfo md_nhlpahRomDesc[] = {
	{ "h9306.bin", 0x080000, 0xf361d0bf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlpah)
STD_ROM_FN(md_nhlpah)

struct BurnDriver BurnDrvmd_nhlpah = {
	"md_nhlpah", NULL, NULL, NULL, "1992",
	"NHLPA Hockey 93 (Euro, USA, v1.1)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_EA_NHLPA, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlpahRomInfo, md_nhlpahRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHLPA Hockey 93 (Euro, USA)
static struct BurnRomInfo md_nhlpah1RomDesc[] = {
	{ "nhlpa hockey 93 (euro, usa).bin", 0x080000, 0xcbbf4262, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nhlpah1)
STD_ROM_FN(md_nhlpah1)

struct BurnDriver BurnDrvmd_nhlpah1 = {
	"md_nhlpah1", "md_nhlpah", NULL, NULL, "1992",
	"NHLPA Hockey 93 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_EA_NHLPA, GBF_MISC, 0,
	MegadriveGetZipName, md_nhlpah1RomInfo, md_nhlpah1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nigel Mansell's World Championship Racing (Euro)
static struct BurnRomInfo md_nigelmRomDesc[] = {
	{ "nigel mansell's world championship racing (euro).bin", 0x100000, 0x3fe3d63b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nigelm)
STD_ROM_FN(md_nigelm)

struct BurnDriver BurnDrvmd_nigelm = {
	"md_nigelm", NULL, NULL, NULL, "1993",
	"Nigel Mansell's World Championship Racing (Euro)\0", NULL, "Konami", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nigelmRomInfo, md_nigelmRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nigel Mansell's World Championship Racing (USA)
static struct BurnRomInfo md_nigelmuRomDesc[] = {
	{ "nigel mansell's world championship racing (usa).bin", 0x100000, 0x6bc57b2c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nigelmu)
STD_ROM_FN(md_nigelmu)

struct BurnDriver BurnDrvmd_nigelmu = {
	"md_nigelmu", "md_nigelm", NULL, NULL, "1993",
	"Nigel Mansell's World Championship Racing (USA)\0", NULL, "GameTek", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_nigelmuRomInfo, md_nigelmuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Bra)
static struct BurnRomInfo md_ncircRomDesc[] = {
	{ "nightmare circus (bra).bin", 0x200000, 0x06da3217, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ncirc)
STD_ROM_FN(md_ncirc)

struct BurnDriver BurnDrvmd_ncirc = {
	"md_ncirc", NULL, NULL, NULL, "1995",
	"Nightmare Circus (Bra)\0", NULL, "Tec Toy", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_ncircRomInfo, md_ncircRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Bra, Alt)
static struct BurnRomInfo md_ncirc1RomDesc[] = {
	{ "nightmare circus (bra) (alt).bin", 0x200000, 0x31de5a94, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ncirc1)
STD_ROM_FN(md_ncirc1)

struct BurnDriver BurnDrvmd_ncirc1 = {
	"md_ncirc1", "md_ncirc", NULL, NULL, "1995",
	"Nightmare Circus (Bra, Alt)\0", NULL, "Tec Toy", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_ncirc1RomInfo, md_ncirc1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Prototype)
static struct BurnRomInfo md_ncircpRomDesc[] = {
	{ "nightmare circus (prototype).bin", 0x400000, 0xee96f1b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ncircp)
STD_ROM_FN(md_ncircp)

struct BurnDriver BurnDrvmd_ncircp = {
	"md_ncircp", "md_ncirc", NULL, NULL, "199?",
	"Nightmare Circus (Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ncircpRomInfo, md_ncircpRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nikkan Sports Pro Yakyuu Van (Jpn)
static struct BurnRomInfo md_nikkanRomDesc[] = {
	{ "nikkan sports pro yakyuu van (jpn).bin", 0x080000, 0xc3655a59, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nikkan)
STD_ROM_FN(md_nikkan)

struct BurnDriver BurnDrvmd_nikkan = {
	"md_nikkan", NULL, NULL, NULL, "1991",
	"Nikkan Sports Pro Yakyuu Van (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nikkanRomInfo, md_nikkanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ninja Burai Densetsu (Jpn)
static struct BurnRomInfo md_ninjabRomDesc[] = {
	{ "ninja burai densetsu (jpn).bin", 0x100000, 0xa8d828a0, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ninjab)
STD_ROM_FN(md_ninjab)

struct BurnDriver BurnDrvmd_ninjab = {
	"md_ninjab", NULL, NULL, NULL, "1991",
	"Ninja Burai Densetsu (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ninjabRomInfo, md_ninjabRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ninja Gaiden (Jpn, Prototype)
static struct BurnRomInfo md_ngaidenRomDesc[] = {
	{ "ninja gaiden (jpn) (prototype) (bad dump).bin", 0x100000, 0x0d7f74ba, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ngaiden)
STD_ROM_FN(md_ngaiden)

struct BurnDriver BurnDrvmd_ngaiden = {
	"md_ngaiden", NULL, NULL, NULL, "1992",
	"Ninja Gaiden (Jpn, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ngaidenRomInfo, md_ngaidenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// No Escape (USA)
static struct BurnRomInfo md_noescapeRomDesc[] = {
	{ "no escape (usa).bin", 0x200000, 0x44ee5f20, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_noescape)
STD_ROM_FN(md_noescape)

struct BurnDriver BurnDrvmd_noescape = {
	"md_noescape", NULL, NULL, NULL, "1994",
	"No Escape (USA)\0", NULL, "Psygnosis", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_noescapeRomInfo, md_noescapeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Bushou Fuuunroku (Jpn)
static struct BurnRomInfo md_nobubusRomDesc[] = {
	{ "mpr-14456.bin", 0x100000, 0x30bf8637, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nobubus)
STD_ROM_FN(md_nobubus)

struct BurnDriver BurnDrvmd_nobubus = {
	"md_nobubus", NULL, NULL, NULL, "1991",
	"Nobunaga no Yabou - Bushou Fuuunroku (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nobubusRomInfo, md_nobubusRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Haouden (Jpn)
static struct BurnRomInfo md_nobuhaoRomDesc[] = {
	{ "nobunaga no yabou - haouden (jpn).bin", 0x200000, 0x96c01fc6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nobuhao)
STD_ROM_FN(md_nobuhao)

struct BurnDriver BurnDrvmd_nobuhao = {
	"md_nobuhao", NULL, NULL, NULL, "1994",
	"Nobunaga no Yabou - Haouden (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nobuhaoRomInfo, md_nobuhaoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga's Ambition (USA)
static struct BurnRomInfo md_nobuambRomDesc[] = {
	{ "nobunaga's ambition (usa).bin", 0x080000, 0xb9bc07bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nobuamb)
STD_ROM_FN(md_nobuamb)

struct BurnDriver BurnDrvmd_nobuamb = {
	"md_nobuamb", NULL, NULL, NULL, "1993",
	"Nobunaga's Ambition (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nobuambRomInfo, md_nobuambRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Zenkoku Ban (Jpn)
static struct BurnRomInfo md_nobuzenRomDesc[] = {
	{ "nobunaga no yabou - zenkoku ban (jpn).bin", 0x080000, 0x1381b313, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_nobuzen)
STD_ROM_FN(md_nobuzen)

struct BurnDriver BurnDrvmd_nobuzen = {
	"md_nobuzen", "md_nobuamb", NULL, NULL, "1993",
	"Nobunaga no Yabou - Zenkoku Ban (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_nobuzenRomInfo, md_nobuzenRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Normy's Beach Babe-O-Rama (Euro, USA)
static struct BurnRomInfo md_normysRomDesc[] = {
	{ "normy's beach babe-o-rama (euro, usa).bin", 0x100000, 0xb56a8220, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_normys)
STD_ROM_FN(md_normys)

struct BurnDriver BurnDrvmd_normys = {
	"md_normys", NULL, NULL, NULL, "1994",
	"Normy's Beach Babe-O-Rama (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_normysRomInfo, md_normysRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (Euro)
static struct BurnRomInfo md_olympgRomDesc[] = {
	{ "mpr-14753.bin", 0x080000, 0x924e57d3, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_olympg)
STD_ROM_FN(md_olympg)

struct BurnDriver BurnDrvmd_olympg = {
	"md_olympg", NULL, NULL, NULL, "1992",
	"Olympic Gold (Euro)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_olympgRomInfo, md_olympgRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (Jpn, Kor)
static struct BurnRomInfo md_olympgjRomDesc[] = {
	{ "olympic gold (jpn, kor).bin", 0x080000, 0xe9c925b8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_olympgj)
STD_ROM_FN(md_olympgj)

struct BurnDriver BurnDrvmd_olympgj = {
	"md_olympgj", "md_olympg", NULL, NULL, "1992",
	"Olympic Gold (Jpn, Kor)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_olympgjRomInfo, md_olympgjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (USA)
static struct BurnRomInfo md_olympguRomDesc[] = {
	{ "olympic gold (usa).bin", 0x080000, 0x339594b4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_olympgu)
STD_ROM_FN(md_olympgu)

struct BurnDriver BurnDrvmd_olympgu = {
	"md_olympgu", "md_olympg", NULL, NULL, "1992",
	"Olympic Gold (USA)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_olympguRomInfo, md_olympguRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (USA, Alt)
static struct BurnRomInfo md_olympgu1RomDesc[] = {
	{ "olympic gold (usa) (alt).bin", 0x080000, 0xaf639376, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_olympgu1)
STD_ROM_FN(md_olympgu1)

struct BurnDriver BurnDrvmd_olympgu1 = {
	"md_olympgu1", "md_olympg", NULL, NULL, "1992",
	"Olympic Gold (USA, Alt)\0", NULL, "U.S. Gold", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_olympgu1RomInfo, md_olympgu1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Summer Games (Euro, USA)
static struct BurnRomInfo md_olympsumRomDesc[] = {
	{ "olympic summer games (euro, usa).bin", 0x200000, 0x9e470fb9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_olympsum)
STD_ROM_FN(md_olympsum)

struct BurnDriver BurnDrvmd_olympsum = {
	"md_olympsum", NULL, NULL, NULL, "1996",
	"Olympic Summer Games (Euro, USA)\0", NULL, "Black Pearl", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_olympsumRomInfo, md_olympsumRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Onslaught (Euro, USA)
static struct BurnRomInfo md_onslauRomDesc[] = {
	{ "onslaught (euro, usa).bin", 0x080000, 0x9f19d6df, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_onslau)
STD_ROM_FN(md_onslau)

struct BurnDriver BurnDrvmd_onslau = {
	"md_onslau", NULL, NULL, NULL, "1991",
	"Onslaught (Euro, USA)\0", NULL, "Ballistic", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_onslauRomInfo, md_onslauRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Euro)
static struct BurnRomInfo md_oozeRomDesc[] = {
	{ "ooze, the (euro).bin", 0x100000, 0xe16b102c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ooze)
STD_ROM_FN(md_ooze)

struct BurnDriver BurnDrvmd_ooze = {
	"md_ooze", NULL, NULL, NULL, "1995",
	"The Ooze (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozeRomInfo, md_oozeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Jpn, USA)
static struct BurnRomInfo md_oozejuRomDesc[] = {
	{ "ooze, the (usa, jpn).bin", 0x100000, 0x1c0dd42f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozeju)
STD_ROM_FN(md_oozeju)

struct BurnDriver BurnDrvmd_oozeju = {
	"md_oozeju", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Jpn, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozejuRomInfo, md_oozejuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Euro, Prototype, 19950728)
static struct BurnRomInfo md_oozep01RomDesc[] = {
	{ "ooze, the (euro) (prototype - jul 28, 1995).bin", 0x100000, 0x7cf868e7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep01)
STD_ROM_FN(md_oozep01)

struct BurnDriver BurnDrvmd_oozep01 = {
	"md_oozep01", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Euro, Prototype, 19950728)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep01RomInfo, md_oozep01RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype, 19950615)
static struct BurnRomInfo md_oozep07RomDesc[] = {
	{ "ooze, the (prototype - jun 15, 1995).bin", 0x0e35ce, 0x921106fd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep07)
STD_ROM_FN(md_oozep07)

struct BurnDriver BurnDrvmd_oozep07 = {
	"md_oozep07", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype, 19950615)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep07RomInfo, md_oozep07RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype, 19950619)
static struct BurnRomInfo md_oozep06RomDesc[] = {
	{ "ooze, the (prototype - jun 19, 1995).bin", 0x100000, 0xfa39281d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep06)
STD_ROM_FN(md_oozep06)

struct BurnDriver BurnDrvmd_oozep06 = {
	"md_oozep06", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype, 19950619)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep06RomInfo, md_oozep06RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype, 19950629-B)
static struct BurnRomInfo md_oozep03RomDesc[] = {
	{ "ooze, the (prototype - jun 29, 1995 - b).bin", 0x0ee456, 0xca93e93b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep03)
STD_ROM_FN(md_oozep03)

struct BurnDriver BurnDrvmd_oozep03 = {
	"md_oozep03", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype, 19950629-B)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep03RomInfo, md_oozep03RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype, 19950629)
static struct BurnRomInfo md_oozep02RomDesc[] = {
	{ "ooze, the (prototype - jun 29, 1995).bin", 0x100000, 0x1776763b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep02)
STD_ROM_FN(md_oozep02)

struct BurnDriver BurnDrvmd_oozep02 = {
	"md_oozep02", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype, 19950629)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep02RomInfo, md_oozep02RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype 104, 19950622)
static struct BurnRomInfo md_oozep05RomDesc[] = {
	{ "ooze, the (prototype 104 - jun 22, 1995).bin", 0x0ebea8, 0xce1f139f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep05)
STD_ROM_FN(md_oozep05)

struct BurnDriver BurnDrvmd_oozep05 = {
	"md_oozep05", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype 104, 19950622)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep05RomInfo, md_oozep05RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ooze (Prototype 112, 19950626)
static struct BurnRomInfo md_oozep04RomDesc[] = {
	{ "ooze, the (prototype 112 - jun 26, 1995).bin", 0x0ec570, 0x70419442, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_oozep04)
STD_ROM_FN(md_oozep04)

struct BurnDriver BurnDrvmd_oozep04 = {
	"md_oozep04", "md_ooze", NULL, NULL, "1995",
	"The Ooze (Prototype 112, 19950626)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_oozep04RomInfo, md_oozep04RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Operation Europe - Path to Victory 1939-45 (USA)
static struct BurnRomInfo md_opeuropeRomDesc[] = {
	{ "operation europe - path to victory 1939-45 (usa).bin", 0x100000, 0xe7cba1d8, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_opeurope)
STD_ROM_FN(md_opeurope)

struct BurnDriver BurnDrvmd_opeurope = {
	"md_opeurope", NULL, NULL, NULL, "1994",
	"Operation Europe - Path to Victory 1939-45 (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_opeuropeRomInfo, md_opeuropeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Europa Sensen (Jpn)
static struct BurnRomInfo md_europaRomDesc[] = {
	{ "europa sensen (jpn).bin", 0x100000, 0xb0416c60, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_europa)
STD_ROM_FN(md_europa)

struct BurnDriver BurnDrvmd_europa = {
	"md_europa", "md_opeurope", NULL, NULL, "1993",
	"Europa Sensen (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_europaRomInfo, md_europaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Osomatsu-kun Hachamecha Gekijou (Jpn)
static struct BurnRomInfo md_osomatsuRomDesc[] = {
	{ "osomatsu-kun hachamecha gekijou (jpn).bin", 0x040000, 0x2453350c, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_osomatsu)
STD_ROM_FN(md_osomatsu)

struct BurnDriver BurnDrvmd_osomatsu = {
	"md_osomatsu", NULL, NULL, NULL, "1988",
	"Osomatsu-kun Hachamecha Gekijou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_osomatsuRomInfo, md_osomatsuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ottifants (Euro)
static struct BurnRomInfo md_ottifaRomDesc[] = {
	{ "ottifants, the (euro).bin", 0x100000, 0x41ac8003, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ottifa)
STD_ROM_FN(md_ottifa)

struct BurnDriver BurnDrvmd_ottifa = {
	"md_ottifa", NULL, NULL, NULL, "1993",
	"The Ottifants (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ottifaRomInfo, md_ottifaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Ottifants (Ger, Prototype)
static struct BurnRomInfo md_ottifagRomDesc[] = {
	{ "ottifants, the (germany) (beta).bin", 0x100000, 0xc6e3dd23, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ottifag)
STD_ROM_FN(md_ottifag)

struct BurnDriver BurnDrvmd_ottifag = {
	"md_ottifag", "md_ottifa", NULL, NULL, "1993",
	"The Ottifants (Ger, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ottifagRomInfo, md_ottifagRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Outlander (Euro)
static struct BurnRomInfo md_outlandrRomDesc[] = {
	{ "outlander (euro).bin", 0x100000, 0xfe6f2350, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outlandr)
STD_ROM_FN(md_outlandr)

struct BurnDriver BurnDrvmd_outlandr = {
	"md_outlandr", NULL, NULL, NULL, "1992",
	"Outlander (Euro)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outlandrRomInfo, md_outlandrRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Outlander (USA)
static struct BurnRomInfo md_outlandruRomDesc[] = {
	{ "outlander (usa).bin", 0x100000, 0xc5ba7bbf, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outlandru)
STD_ROM_FN(md_outlandru)

struct BurnDriver BurnDrvmd_outlandru = {
	"md_outlandru", "md_outlandr", NULL, NULL, "1992",
	"Outlander (USA)\0", NULL, "Mindscape", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outlandruRomInfo, md_outlandruRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun (Euro, USA)
static struct BurnRomInfo md_outrunRomDesc[] = {
	{ "outrun (euro, usa).bin", 0x100000, 0xfdd9a8d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outrun)
STD_ROM_FN(md_outrun)

struct BurnDriver BurnDrvmd_outrun = {
	"md_outrun", NULL, NULL, NULL, "1991",
	"OutRun (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outrunRomInfo, md_outrunRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun (Jpn)
static struct BurnRomInfo md_outrunjRomDesc[] = {
	{ "outrun (jpn).bin", 0x100000, 0xee7d9f4a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outrunj)
STD_ROM_FN(md_outrunj)

struct BurnDriver BurnDrvmd_outrunj = {
	"md_outrunj", "md_outrun", NULL, NULL, "1991",
	"OutRun (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outrunjRomInfo, md_outrunjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (Euro)
static struct BurnRomInfo md_outr2019RomDesc[] = {
	{ "mpr-15482.bin", 0x100000, 0x5cb3536a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outr2019)
STD_ROM_FN(md_outr2019)

struct BurnDriver BurnDrvmd_outr2019 = {
	"md_outr2019", NULL, NULL, NULL, "1993",
	"OutRun 2019 (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outr2019RomInfo, md_outr2019RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (Jpn)
static struct BurnRomInfo md_outr2019jRomDesc[] = {
	{ "outrun 2019 (jpn).bin", 0x100000, 0x0eac7440, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outr2019j)
STD_ROM_FN(md_outr2019j)

struct BurnDriver BurnDrvmd_outr2019j = {
	"md_outr2019j", "md_outr2019", NULL, NULL, "1993",
	"OutRun 2019 (Jpn)\0", NULL, "Sims", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outr2019jRomInfo, md_outr2019jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (USA)
static struct BurnRomInfo md_outr2019uRomDesc[] = {
	{ "outrun 2019 (usa).bin", 0x100000, 0xe32e17e2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outr2019u)
STD_ROM_FN(md_outr2019u)

struct BurnDriver BurnDrvmd_outr2019u = {
	"md_outr2019u", "md_outr2019", NULL, NULL, "1993",
	"OutRun 2019 (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outr2019uRomInfo, md_outr2019uRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (USA, Prototype)
static struct BurnRomInfo md_outr2019upRomDesc[] = {
	{ "outrun 2019 (usa) (beta).bin", 0x100000, 0xd2ecddfa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_outr2019up)
STD_ROM_FN(md_outr2019up)

struct BurnDriver BurnDrvmd_outr2019up = {
	"md_outr2019up", "md_outr2019", NULL, NULL, "1993",
	"OutRun 2019 (USA, Prototype)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_outr2019upRomInfo, md_outr2019upRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Junker's High (Jpn, Prototype)
static struct BurnRomInfo md_junkerRomDesc[] = {
	{ "junker's high (jpn) (beta) (bad dump).bin", 0x100000, 0x23534949, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_junker)
STD_ROM_FN(md_junker)

struct BurnDriver BurnDrvmd_junker = {
	"md_junker", "md_outr2019", NULL, NULL, "199?",
	"Junker's High (Jpn, Prototype)\0", NULL, "<unknown>", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_junkerRomInfo, md_junkerRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRunners (USA)
static struct BurnRomInfo md_orunnersRomDesc[] = {
	{ "outrunners (usa).bin", 0x200000, 0xede636b9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_orunners)
STD_ROM_FN(md_orunners)

struct BurnDriver BurnDrvmd_orunners = {
	"md_orunners", NULL, NULL, NULL, "1994",
	"OutRunners (USA)\0", NULL, "Data East", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_orunnersRomInfo, md_orunnersRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRunners (Jpn)
static struct BurnRomInfo md_orunnersjRomDesc[] = {
	{ "outrunners (jpn).bin", 0x200000, 0xe164a09f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_orunnersj)
STD_ROM_FN(md_orunnersj)

struct BurnDriver BurnDrvmd_orunnersj = {
	"md_orunnersj", "md_orunners", NULL, NULL, "1994",
	"OutRunners (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_orunnersjRomInfo, md_orunnersjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Attack (USA)
static struct BurnRomInfo md_pacattckRomDesc[] = {
	{ "pac-attack (usa).bin", 0x040000, 0x5df382f7, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pacattck)
STD_ROM_FN(md_pacattck)

struct BurnDriver BurnDrvmd_pacattck = {
	"md_pacattck", NULL, NULL, NULL, "1993",
	"Pac-Attack (USA)\0", NULL, "Namco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pacattckRomInfo, md_pacattckRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Man 2 - The New Adventures (USA)
static struct BurnRomInfo md_pacmanRomDesc[] = {
	{ "pac-man 2 - the new adventures (usa).bin", 0x200000, 0xfe7a7ed1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pacman)
STD_ROM_FN(md_pacman)

struct BurnDriver BurnDrvmd_pacman = {
	"md_pacman", NULL, NULL, NULL, "1994",
	"Pac-Man 2 - The New Adventures (USA)\0", NULL, "Namco", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pacmanRomInfo, md_pacmanRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Mania (Euro, USA)
static struct BurnRomInfo md_pacmaniaRomDesc[] = {
	{ "mpr-14392.bin", 0x040000, 0x74bba09b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pacmania)
STD_ROM_FN(md_pacmania)

struct BurnDriver BurnDrvmd_pacmania = {
	"md_pacmania", NULL, NULL, NULL, "1991",
	"Pac-Mania (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pacmaniaRomInfo, md_pacmaniaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pachinko Kuunyan (Jpn)
static struct BurnRomInfo md_pachinkoRomDesc[] = {
	{ "pachinko kuunyan (jpn).bin", 0x100000, 0x9d137e7f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pachinko)
STD_ROM_FN(md_pachinko)

struct BurnDriver BurnDrvmd_pachinko = {
	"md_pachinko", NULL, NULL, NULL, "1992",
	"Pachinko Kuunyan (Jpn)\0", NULL, "Soft Vision International", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pachinkoRomInfo, md_pachinkoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pacific Theater of Operations (USA)
static struct BurnRomInfo md_pacificRomDesc[] = {
	{ "pacific theater of operations (usa).bin", 0x100000, 0xd9d4c6e2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pacific)
STD_ROM_FN(md_pacific)

struct BurnDriver BurnDrvmd_pacific = {
	"md_pacific", NULL, NULL, NULL, "1993",
	"Pacific Theater of Operations (USA)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pacificRomInfo, md_pacificRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Teitoku no Ketsudan (Jpn)
static struct BurnRomInfo md_teitokuRomDesc[] = {
	{ "teitoku no ketsudan (jpn).bin", 0x100000, 0x9b08e4e4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_teitoku)
STD_ROM_FN(md_teitoku)

struct BurnDriver BurnDrvmd_teitoku = {
	"md_teitoku", "md_pacific", NULL, NULL, "1992",
	"Teitoku no Ketsudan (Jpn)\0", NULL, "Koei", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_teitokuRomInfo, md_teitokuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paddle Fighter (Jpn, SegaNet)
static struct BurnRomInfo md_paddleRomDesc[] = {
	{ "paddle fighter (jpn) (sn).bin", 0x040000, 0x3d8147e6, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_paddle)
STD_ROM_FN(md_paddle)

struct BurnDriver BurnDrvmd_paddle = {
	"md_paddle", NULL, NULL, NULL, "1991",
	"Paddle Fighter (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_paddleRomInfo, md_paddleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paddle Fighter (Jpn, Game no Kandume MegaCD Rip)
static struct BurnRomInfo md_paddlegnkRomDesc[] = {
	{ "paddle fighter (jpn) (gnk).bin", 0x040000, 0xebef05a4, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_paddlegnk)
STD_ROM_FN(md_paddlegnk)

struct BurnDriver BurnDrvmd_paddlegnk = {
	"md_paddlegnk", "md_paddle", NULL, NULL, "1991",
	"Paddle Fighter (Jpn, Game no Kandume MegaCD Rip)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_paddlegnkRomInfo, md_paddlegnkRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Pagemaster (Euro)
static struct BurnRomInfo md_pagemastRomDesc[] = {
	{ "pagemaster, the (euro).bin", 0x200000, 0x79a180e2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pagemast)
STD_ROM_FN(md_pagemast)

struct BurnDriver BurnDrvmd_pagemast = {
	"md_pagemast", NULL, NULL, NULL, "1994",
	"The Pagemaster (Euro)\0", NULL, "Fox Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pagemastRomInfo, md_pagemastRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Pagemaster (USA)
static struct BurnRomInfo md_pagemastuRomDesc[] = {
	{ "pagemaster, the (usa).bin", 0x200000, 0x75a96d4e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pagemastu)
STD_ROM_FN(md_pagemastu)

struct BurnDriver BurnDrvmd_pagemastu = {
	"md_pagemastu", "md_pagemast", NULL, NULL, "1994",
	"The Pagemaster (USA)\0", NULL, "Fox Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pagemastuRomInfo, md_pagemastuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Pagemaster (USA, Prototype)
static struct BurnRomInfo md_pagemastupRomDesc[] = {
	{ "pagemaster, the (usa) (beta).bin", 0x200000, 0x29895e3d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pagemastup)
STD_ROM_FN(md_pagemastup)

struct BurnDriver BurnDrvmd_pagemastup = {
	"md_pagemastup", "md_pagemast", NULL, NULL, "1994",
	"The Pagemaster (USA, Prototype)\0", NULL, "Fox Interactive", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pagemastupRomInfo, md_pagemastupRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Panorama Cotton (Jpn)
static struct BurnRomInfo md_pcottonRomDesc[] = {
	{ "panorama cotton (jpn).bin", 0x280000, 0x9e57d92e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pcotton)
STD_ROM_FN(md_pcotton)

struct BurnDriver BurnDrvmd_pcotton = {
	"md_pcotton", NULL, NULL, NULL, "1994",
	"Panorama Cotton (Jpn)\0", NULL, "Sunsoft", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pcottonRomInfo, md_pcottonRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy (Euro, USA)
static struct BurnRomInfo md_paperboyRomDesc[] = {
	{ "paperboy (euro, usa).bin", 0x080000, 0x0a44819b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_paperboy)
STD_ROM_FN(md_paperboy)

struct BurnDriver BurnDrvmd_paperboy = {
	"md_paperboy", NULL, NULL, NULL, "1991",
	"Paperboy (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_paperboyRomInfo, md_paperboyRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy (Jpn)
static struct BurnRomInfo md_paperboyjRomDesc[] = {
	{ "mpr-14774.bin", 0x080000, 0xe14250ae, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_paperboyj)
STD_ROM_FN(md_paperboyj)

struct BurnDriver BurnDrvmd_paperboyj = {
	"md_paperboyj", "md_paperboy", NULL, NULL, "1992",
	"Paperboy (Jpn)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_paperboyjRomInfo, md_paperboyjRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy 2 (Euro, USA)
static struct BurnRomInfo md_paperby2RomDesc[] = {
	{ "paperboy 2 (euro, usa).bin", 0x100000, 0x1de28bb1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_paperby2)
STD_ROM_FN(md_paperby2)

struct BurnDriver BurnDrvmd_paperby2 = {
	"md_paperby2", NULL, NULL, NULL, "1992",
	"Paperboy 2 (Euro, USA)\0", NULL, "Tengen", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_paperby2RomInfo, md_paperby2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Party Quiz Mega Q (Jpn)
static struct BurnRomInfo md_partyqRomDesc[] = {
	{ "party quiz mega q (jpn).bin", 0x100000, 0x9d4b447a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_partyq)
STD_ROM_FN(md_partyq)

struct BurnDriver BurnDrvmd_partyq = {
	"md_partyq", NULL, NULL, NULL, "1993",
	"Party Quiz Mega Q (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_partyqRomInfo, md_partyqRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pebble Beach Golf Links (Euro)
static struct BurnRomInfo md_pebbleRomDesc[] = {
	{ "pebble beach golf links (euro).bin", 0x200000, 0x6cfc7297, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pebble)
STD_ROM_FN(md_pebble)

struct BurnDriver BurnDrvmd_pebble = {
	"md_pebble", NULL, NULL, NULL, "1993",
	"Pebble Beach Golf Links (Euro)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pebbleRomInfo, md_pebbleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pebble Beach Golf Links (USA)
static struct BurnRomInfo md_pebbleuRomDesc[] = {
	{ "pebble beach golf links (usa).bin", 0x200000, 0x95823c43, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pebbleu)
STD_ROM_FN(md_pebbleu)

struct BurnDriver BurnDrvmd_pebbleu = {
	"md_pebbleu", "md_pebble", NULL, NULL, "1993",
	"Pebble Beach Golf Links (USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pebbleuRomInfo, md_pebbleuRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Pebble Beach no Hatou (Jpn)
static struct BurnRomInfo md_n3dgpebbRomDesc[] = {
	{ "new 3d golf simulation pebble beach no hatou (jpn).bin", 0x180000, 0x96ed2e5d, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_n3dgpebb)
STD_ROM_FN(md_n3dgpebb)

struct BurnDriver BurnDrvmd_n3dgpebb = {
	"md_n3dgpebb", "md_pebble", NULL, NULL, "1993",
	"New 3D Golf Simulation Pebble Beach no Hatou (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_n3dgpebbRomInfo, md_n3dgpebbRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pel's World Tournament Soccer (Euro, USA)
static struct BurnRomInfo md_pele2RomDesc[] = {
	{ "pele ii - world tournament soccer (euro, usa).bin", 0x200000, 0x05a486e9, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pele2)
STD_ROM_FN(md_pele2)

struct BurnDriver BurnDrvmd_pele2 = {
	"md_pele2", NULL, NULL, NULL, "1994",
	"Pele's World Tournament Soccer (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	L"Pel\u00e9's World Tournament Soccer (Euro, USA)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pele2RomInfo, md_pele2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pel! (Euro, USA)
static struct BurnRomInfo md_peleRomDesc[] = {
	{ "pele! (euro, usa).bin", 0x100000, 0x5a8abe51, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pele)
STD_ROM_FN(md_pele)

struct BurnDriver BurnDrvmd_pele = {
	"md_pele", NULL, NULL, NULL, "1993",
	"Pele! (Euro, USA)\0", NULL, "Accolade", "Sega Megadrive",
	L"Pel\u00e9! (Euro, USA)\0", NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_peleRomInfo, md_peleRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pepenga Pengo (Jpn)
static struct BurnRomInfo md_ppengoRomDesc[] = {
	{ "pepenga pengo (jpn).bin", 0x100000, 0xd1e2324b, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ppengo)
STD_ROM_FN(md_ppengo)

struct BurnDriver BurnDrvmd_ppengo = {
	"md_ppengo", NULL, NULL, NULL, "1995",
	"Pepenga Pengo (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ppengoRomInfo, md_ppengoRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (Euro, USA, J-Cart, Alt)
static struct BurnRomInfo md_psampras1RomDesc[] = {
	{ "mdstee_13.bin", 0x100000, 0xaa8b19bc, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_psampras1)
STD_ROM_FN(md_psampras1)

struct BurnDriver BurnDrvmd_psampras1 = {
	"md_psampras1", "md_psampras", NULL, NULL, "1994",
	"Pete Sampras Tennis (Euro, USA, J-Cart, Alt)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_psampras1RomInfo, md_psampras1RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (Euro, USA, J-Cart, Alt 2)
static struct BurnRomInfo md_psampras2RomDesc[] = {
	{ "pete sampras tennis (euro, usa) (j-cart).bin", 0x100000, 0x9ef5bbd1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_psampras2)
STD_ROM_FN(md_psampras2)

struct BurnDriver BurnDrvmd_psampras2 = {
	"md_psampras2", "md_psampras", NULL, NULL, "1994",
	"Pete Sampras Tennis (Euro, USA, J-Cart, Alt 2)\0", NULL, "Codemasters", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_psampras2RomInfo, md_psampras2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA European Tour (Euro, USA)
static struct BurnRomInfo md_pgaeuroRomDesc[] = {
	{ "euro03.bin", 0x100000, 0x8ca45acd, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pgaeuro)
STD_ROM_FN(md_pgaeuro)

struct BurnDriver BurnDrvmd_pgaeuro = {
	"md_pgaeuro", NULL, NULL, NULL, "1994",
	"PGA European Tour (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pgaeuroRomInfo, md_pgaeuroRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour 96 (Euro, USA)
static struct BurnRomInfo md_pga96RomDesc[] = {
	{ "pga9601.bin", 0x200000, 0x9698bbde, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga96)
STD_ROM_FN(md_pga96)

struct BurnDriver BurnDrvmd_pga96 = {
	"md_pga96", NULL, NULL, NULL, "1995",
	"PGA Tour 96 (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pga96RomInfo, md_pga96RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf (Euro, USA, v1.2)
static struct BurnRomInfo md_pgaRomDesc[] = {
	{ "pga09.bin", 0x080000, 0xc1f0b4e1, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga)
STD_ROM_FN(md_pga)

struct BurnDriver BurnDrvmd_pga = {
	"md_pga", NULL, NULL, NULL, "1991",
	"PGA Tour Golf (Euro, USA, v1.2)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pgaRomInfo, md_pgaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf (Euro, USA, v1.1)
static struct BurnRomInfo md_pgaaRomDesc[] = {
	{ "pga tour golf (euro, usa) (v1.1).bin", 0x080000, 0x0489ff8e, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pgaa)
STD_ROM_FN(md_pgaa)

struct BurnDriver BurnDrvmd_pgaa = {
	"md_pgaa", "md_pga", NULL, NULL, "1991",
	"PGA Tour Golf (Euro, USA, v1.1)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_pgaaRomInfo, md_pgaaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (Euro, USA, v1.1)
static struct BurnRomInfo md_pga2RomDesc[] = {
	{ "pga tour golf ii (euro, usa) (v1.1).bin", 0x100000, 0xe82b8606, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga2)
STD_ROM_FN(md_pga2)

struct BurnDriver BurnDrvmd_pga2 = {
	"md_pga2", NULL, NULL, NULL, "1992",
	"PGA Tour Golf II (Euro, USA, v1.1)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pga2RomInfo, md_pga2RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (Jpn)
static struct BurnRomInfo md_pga2jRomDesc[] = {
	{ "pga tour golf ii (jpn).bin", 0x100000, 0xc05b7a4a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga2j)
STD_ROM_FN(md_pga2j)

struct BurnDriver BurnDrvmd_pga2j = {
	"md_pga2j", "md_pga2", NULL, NULL, "1993",
	"PGA Tour Golf II (Jpn)\0", NULL, "Electronic Arts Victor", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pga2jRomInfo, md_pga2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf III (Euro, USA)
static struct BurnRomInfo md_pga3RomDesc[] = {
	{ "pga tour golf iii (euro, usa).bin", 0x200000, 0xaeb3f65f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pga3)
STD_ROM_FN(md_pga3)

struct BurnDriver BurnDrvmd_pga3 = {
	"md_pga3", NULL, NULL, NULL, "1994",
	"PGA Tour Golf III (Euro, USA)\0", NULL, "Electronic Arts", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pga3RomInfo, md_pga3RomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (Euro, USA)
static struct BurnRomInfo md_pstar2aRomDesc[] = {
	{ "phantasy star ii (euro, usa).bin", 0x0c0000, 0x0d07d0ef, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pstar2a)
STD_ROM_FN(md_pstar2a)

struct BurnDriver BurnDrvmd_pstar2a = {
	"md_pstar2a", "md_pstar2", NULL, NULL, "1989",
	"Phantasy Star II (Euro, USA)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pstar2aRomInfo, md_pstar2aRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (Bra)
static struct BurnRomInfo md_pstar2brRomDesc[] = {
	{ "phantasy star ii (bra).bin", 0x0c0000, 0xe6688b66, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pstar2br)
STD_ROM_FN(md_pstar2br)

struct BurnDriver BurnDrvmd_pstar2br = {
	"md_pstar2br", "md_pstar2", NULL, NULL, "199?",
	"Phantasy Star II (Bra)\0", NULL, "Tec Toy", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pstar2brRomInfo, md_pstar2brRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Kaerazaru Toki no Owari ni (Jpn)
static struct BurnRomInfo md_pstar2jRomDesc[] = {
	{ "mpr-12140+mpr-12181+mpr-12182.bin", 0x0c0000, 0xbec8eb5a, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_pstar2j)
STD_ROM_FN(md_pstar2j)

struct BurnDriver BurnDrvmd_pstar2j = {
	"md_pstar2j", "md_pstar2", NULL, NULL, "1989",
	"Phantasy Star II - Kaerazaru Toki no Owari ni (Jpn)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE | HARDWARE_SEGA_MEGADRIVE_PCB_SEGA_SRAM, GBF_MISC, 0,
	MegadriveGetZipName, md_pstar2jRomInfo, md_pstar2jRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Amia's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2aaRomDesc[] = {
	{ "phantasy star ii - amia's adventure (jpn) (sn).bin", 0x040000, 0xa3a724aa, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2aa)
STD_ROM_FN(md_ps2aa)

struct BurnDriver BurnDrvmd_ps2aa = {
	"md_ps2aa", NULL, NULL, NULL, "1991",
	"Phantasy Star II - Amia's Adventure (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ps2aaRomInfo, md_ps2aaRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Anne's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2abRomDesc[] = {
	{ "phantasy star ii - anne's adventure (jpn) (sn).bin", 0x040000, 0xfafa5b6f, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2ab)
STD_ROM_FN(md_ps2ab)

struct BurnDriver BurnDrvmd_ps2ab = {
	"md_ps2ab", NULL, NULL, NULL, "1991",
	"Phantasy Star II - Anne's Adventure (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ps2abRomInfo, md_ps2abRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Huey's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2acRomDesc[] = {
	{ "phantasy star ii - huey's adventure (jpn) (sn).bin", 0x040000, 0x1a076f83, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2ac)
STD_ROM_FN(md_ps2ac)

struct BurnDriver BurnDrvmd_ps2ac = {
	"md_ps2ac", NULL, NULL, NULL, "1991",
	"Phantasy Star II - Huey's Adventure (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ps2acRomInfo, md_ps2acRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Kinds's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2adRomDesc[] = {
	{ "phantasy star ii - kinds's adventure (jpn) (sn).bin", 0x040000, 0xc334f308, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2ad)
STD_ROM_FN(md_ps2ad)

struct BurnDriver BurnDrvmd_ps2ad = {
	"md_ps2ad", NULL, NULL, NULL, "1991",
	"Phantasy Star II - Kinds's Adventure (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ps2adRomInfo, md_ps2adRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Nei's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2aeRomDesc[] = {
	{ "phantasy star ii - nei's adventure (jpn) (sn).bin", 0x040000, 0x3d9ad465, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2ae)
STD_ROM_FN(md_ps2ae)

struct BurnDriver BurnDrvmd_ps2ae = {
	"md_ps2ae", NULL, NULL, NULL, "1991",
	"Phantasy Star II - Nei's Adventure (Jpn, SegaNet)\0", NULL, "Sega", "Sega Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	MegadriveGetZipName, md_ps2aeRomInfo, md_ps2aeRomName, NULL, NULL, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	&bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Rudger's Adventure (Jpn, SegaNet)
static struct BurnRomInfo md_ps2afRomDesc[] = {
	{ "phantasy star ii - rudger's adventure (jpn) (sn).bin", 0x040000, 0x6b5916d2, BRF_PRG | SEGA_MD_ROM_LOAD16_WORD_SWAP | SEGA_MD_ROM_OFFS_000000 },
};

STD_ROM_PICK(md_ps2af)
STD_ROM_FN(md_ps2af)

struct BurnDriver BurnDrvmd_ps2af = {
	"md_ps