/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __MERGE_H__
#define __MERGE_H__

#include <glib.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS
 
#define TYPE_MATCH          match_get_type ()
#define TYPE_MATCH_LIST     match_list_get_type ()

typedef struct _MergeCandidate MergeCandidate;

typedef void (*MergeCb) (gint     merged_count,
                         gint     failed_count,
                         gint     total_count,
                         gpointer user_data);


MergeCandidate *merge_candidate_ref         (MergeCandidate     *candidate);
void            merge_candidate_unref       (MergeCandidate     *candidate);

void            merge_candidates_free       (GList              *candidates);
GList *         merge_candidates_get        (void);
void            merge_candidates_do_merge   (GList              *candidates,
                                             MergeCb             updated_cb,
                                             MergeCb             finished_cb,
                                             gpointer            user_data);

G_END_DECLS

#endif /* __MERGE_H__ */
