/*
 * Copyright (C) 2009-2010 Marco Barisione <marco@barisione.org>
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <libosso-abook/osso-abook.h>

#include "main.h"
#include "wizard.h"


static osso_context_t *osso_cxt = NULL;

osso_context_t *
get_osso_context (void)
{
    return osso_cxt;
}

int
main (int    argc,
      char **argv)
{
    gchar *app_name;
    GtkWidget *wizard;

    app_name = g_path_get_basename (argv[0]);
    osso_cxt = osso_initialize (app_name, "0.1", FALSE, NULL);
    g_free (app_name);

    osso_abook_init (&argc, &argv, osso_cxt);

    wizard = fb_wizard_new ();
    g_signal_connect (wizard, "destroy", G_CALLBACK (gtk_main_quit), NULL);
    gtk_widget_show_all (wizard);

    gtk_main ();

    return 0;
}
