/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "fastsmswidget.h"
#include "ui_fastsmswidget.h"
#include "busManagerServ.h"
#include "kb_qwerty.h"
#include "dialogabout.h"
#include "dialogsettings.h"
//#include "mce/dbus-names.h"

#include <QCloseEvent>
#include <QMenuBar>

#define OS_FORCEROTATION "forcerotation = 1"

FastSMSWidget::FastSMSWidget(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::FastSMSWidget)
{
    //Setup for QSettings
    QCoreApplication::setOrganizationName(Core::SETTING_ORG);
    QCoreApplication::setApplicationName(Core::SETTING_APPNAME);

    //    //Test purpose: reset all settings
    //    QSettings settings;
    //    settings.remove("");

    ui->setupUi(this);
    m_layoutManager = qobject_cast<LayoutManager *> (ui->centralwidget);
    m_textProcessor = m_layoutManager->getTextProcessor();
    m_bDictionaryUpdated = false;
    m_dictionary = NULL;

    qDebug() << "Load settings...";
    //Setup and Load Settings
    loadSettings(true);
    //
    qDebug() << "Settings loaded";

    //Menu
    QMenuBar *menu = new QMenuBar(this);
    QMenu *mainMenu = new QMenu("Menu",menu);

    QAction *aOption = new QAction("Options",mainMenu);
    connect(aOption,SIGNAL(triggered()),this, SLOT(openOptionDialog()));
    mainMenu->addAction(aOption);

    QAction *aNewWord = new QAction("New Word",mainMenu);
    connect(aNewWord,SIGNAL(triggered()),this, SLOT(insertNewWord()));
    mainMenu->addAction(aNewWord);

    QAction *aDonate = new QAction("Donate",mainMenu);
    connect(aDonate,SIGNAL(triggered()),this, SLOT(donate()));
    mainMenu->addAction(aDonate);

    QAction *aAbout = new QAction("About",mainMenu);
    mainMenu->addAction(aAbout);
    connect(aAbout,SIGNAL(triggered()),this, SLOT(openAboutDialog()));

    QAction *aQuit = new QAction("Quit",mainMenu);
    connect(aQuit,SIGNAL(triggered()),this, SLOT(close()));
    mainMenu->addAction(aQuit);

    menu->addMenu(mainMenu);
    //

    QDBusConnection systemBus = QDBusConnection::systemBus();
    systemBus.connect("com.nokia.mce",
                      "/com/nokia/mce/signal",
                      "com.nokia.mce.signal",
                      "sig_device_orientation_ind",
                      this, SLOT(orientationChanged(QString)));
}

FastSMSWidget::~FastSMSWidget()
{
    delete ui;
}


/** If is vkb prevent from real close, so dictionary haven't to be reloaded each time,
    then check if dictionary need save **/
void FastSMSWidget::closeEvent(QCloseEvent *event)
{
    if(!m_bStandalone)
    {
        event->ignore();
        qDebug() << "vkb hidden message is " << m_textProcessor->getText();

        qDebug() << "Curr orientation:" << m_sCurrOrientation;


#if defined(Q_WS_MAEMO_5)
        if(!m_bOSForceAutorotation)
        {
            //If not landscape, need to return to landscape view
            if(m_sCurrOrientation.compare(Core::ORIENTATION_LANDSCAPE) != 0)
            {
                setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);

                hide();
                showMaximized();
            }
        }
#endif


        hide();
        qDebug() << "hided";
        m_textProcessor->commit();
    }
    else
    {
        qDebug() << "Closed";
    }

    //TODO: spostare in un thread, ma non qui, nella classe della funzione
    if(m_bDictionaryUpdated)
    {
        m_dictionary->saveDictionaryToFile();
    }
}

void FastSMSWidget::setStandalone(bool bStandalone)
{
    m_bStandalone = bStandalone;

    if(m_bStandalone)
    {
        setWindowFlags(Qt::Window | Qt::WindowSystemMenuHint);
    }
    else
    {
        setWindowFlags(Qt::Dialog | Qt::FramelessWindowHint);

//        QDBusConnection systemBus = QDBusConnection::systemBus();
//        systemBus.connect("com.nokia.mce",
//                          "/com/nokia/mce/signal",
//                          "com.nokia.mce.signal",
//                          "sig_device_orientation_ind",
//                          this, SLOT(orientationChanged(QString)));


//        QSettings settings;
//        Core::vibrationFeedback vibration = (Core::vibrationFeedback)settings.value(Core::SETTING_VIBRATION).toInt();
//        if(vibration == Core::forceVibration)
//        {
//#ifdef Q_WS_MAEMO_5
//            QDBusInterface *mDbusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
//                                                MCE_REQUEST_IF, QDBusConnection::systemBus(),
//                                                this);

//            mDbusInterface->call(MCE_ENABLE_VIBRATOR);

//#endif


//        }
//        else if(vibration == Core::forceNoVibration)
//        {

//        }
    }

    m_textProcessor->setStandalone(bStandalone);
}

/** Workaround for enabling autorotation when used as keyboard **/
void FastSMSWidget::orientationChanged(QString sOrientation)
{
    //if hidden no action
    if(!isVisible())
        return;

    //Display prefered kb
    loadPreferedKb(sOrientation);

    if(m_bStandalone)
        return;

    if(!m_bOSForceAutorotation)
    {
        if(m_sCurrOrientation.compare(sOrientation) != 0)
        {
            qDebug() << "Orientation changed:" << sOrientation;

            if(sOrientation.compare(Core::ORIENTATION_PORTRAIT) == 0 ||
               sOrientation.compare(Core::ORIENTATION_LANDSCAPE) == 0)
            {
                m_sCurrOrientation = sOrientation;
                hide();
                showMaximized();
            }
            else
                qWarning() << "Unknown orientation:" << sOrientation;
        }
    }
}

/** Check QSetting to display the prefered kb **/
void FastSMSWidget::loadPreferedKb(QString sOrientation)
{
    QSettings settings;

    if(sOrientation.length() == 0)
        sOrientation = FastSMSWidget::getDeviceOrientation();

    if(sOrientation.compare("unknown") == 0)
        return;

    if(sOrientation.compare(Core::ORIENTATION_LANDSCAPE))
    {
        if(settings.value(Core::PREF_LANDSCAPE_KB,0).toInt() == Core::Qwerty)
            m_layoutManager->enableQwerty();
        else if(settings.value(Core::PREF_LANDSCAPE_KB,0).toInt() == Core::Alfanumeric)
            m_layoutManager->enableAlfanum();
    }
    else
    {
        if(settings.value(Core::PREF_PORTRAIT_KB,1).toInt() == Core::Qwerty)
            m_layoutManager->enableQwerty();
        else if(settings.value(Core::PREF_PORTRAIT_KB,1).toInt() == Core::Alfanumeric)
            m_layoutManager->enableAlfanum();
    }
}

/** Menu Management */
void FastSMSWidget::openAboutDialog()
{
    DialogAbout *about = new DialogAbout(this);
    about->setAttribute(Qt::WA_DeleteOnClose);
    about->showMaximized();
}

void FastSMSWidget::donate()
{
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=V353RBQ6TATN6&lc=GB"));
}

void FastSMSWidget::openOptionDialog()
{
    DialogSettings *dialSettings = new DialogSettings(this);
    dialSettings->setAttribute(Qt::WA_DeleteOnClose);
    connect(dialSettings,SIGNAL(settingsChanged(bool)),this,SLOT(loadSettings(bool)));
    dialSettings->show();
}

void FastSMSWidget::loadSettings(bool bLoadDictionary)
{
    //Check if CSSU autorotation is ON
    m_bOSForceAutorotation = false;
    QFile *fTransition = new QFile("/etc/hildon/theme/transitions.ini");

    //fallback
    if(!fTransition->exists())
    {
        delete fTransition;
        fTransition = new QFile("/usr/share/hildon-desktop/transitions.ini");
    }
    if(!fTransition->open(QIODevice::ReadOnly))
        qWarning() << "Can't open tranistions.ini";
    else
    {
        QTextStream in(fTransition);

        while (!in.atEnd())
        {
            QString line = in.readLine();
            if(line.compare(OS_FORCEROTATION) == 0)
            {
                m_bOSForceAutorotation = true;
                qDebug() << "Forced Autorotation is ON";
            }
        }
    }
    delete fTransition;

    QSettings settings;

    //Language
    if(bLoadDictionary)
    {
        QString sLang = settings.value(Core::SETTING_LANGUAGE,"").toString();

        //First start
        if(sLang.isEmpty())
        {
            openOptionDialog();
            return;
        }

        if(m_bDictionaryUpdated)
            m_dictionary->saveDictionaryToFile();

        if(m_dictionary != NULL)
            delete m_dictionary;

        m_dictionary = new dictionary(new QString(sLang),this);
        m_textProcessor->setDictionary(m_dictionary);
        settings.setValue(Core::SETTING_LANGUAGE,sLang);
    }

    //Orientation
#if defined(Q_WS_MAEMO_5)
    QString sCurrOrient = settings.value(Core::SETTING_ORIENTATION).toString();
    if(sCurrOrient.compare(Core::ORIENTATION_LANDSCAPE) == 0)
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    else if(sCurrOrient.compare(Core::ORIENTATION_PORTRAIT) == 0)
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    else
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    //Font
    int nFontSize = settings.value(Core::SETTING_FONTSIZE).toInt();
    m_textProcessor->setSmsFontSize(nFontSize * 9 + 18); //we will have 18,27 or 36

    //Qwerty Layout
    int nQwertyLayout = settings.value(Core::SETTING_QWERTY_LAYOUT).toInt();
    m_layoutManager->loadQwertyLayout((Core::QwertyLayout)nQwertyLayout);

    //Label Color
    Core::LabelColor nLabelColor = (Core::LabelColor)settings.value(Core::SETTING_LABEL_COLOR).toInt();
    m_layoutManager->setLabelColor(nLabelColor);
}

bool FastSMSWidget::addRecipient(const QString &phone, const QString &name)
{
    return m_textProcessor->m_recipient->addRecipient(phone,name);
}

void FastSMSWidget::insertNewWord(bool onlySymbol)
{
    m_bSymbolInserted = onlySymbol;

    m_dialNewWord = new DialogNewWord(this);
    m_dialNewWord->setAttribute(Qt::WA_DeleteOnClose);
    m_dialNewWord->m_kb->setScope(true,onlySymbol);
    if(onlySymbol)
        m_dialNewWord->setWindowTitle("Insert Symbol");
    else
        m_dialNewWord->setWindowTitle("Type New Word");
    m_inputNewWord = m_dialNewWord->m_lineEdit;
    connect(m_dialNewWord->m_btOk,SIGNAL(clicked()),this,SLOT(newWordInserted()));
    connect(m_dialNewWord->m_kb,SIGNAL(input(QString,Core::Keyboards)),this,SLOT(composite(QString,Core::Keyboards)));

    m_dialNewWord->show();
}

void FastSMSWidget::composite(QString sChar, Core::Keyboards)
{
    if(sChar.compare(Keyboard::DELETE) == 0)
        m_inputNewWord->backspace();
    else
        m_inputNewWord->insert(sChar);
}

void FastSMSWidget::newWordInserted()
{
    QString *newWord = new QString(m_inputNewWord->text());

    if(!newWord->isEmpty())
    {
        qDebug() << "New word is:" << newWord->toAscii();
        if(!m_bSymbolInserted)
        {
            m_bDictionaryUpdated = m_dictionary->addWord(&newWord->toLower());
            m_bSymbolInserted = false;
        }
        m_textProcessor->addNewWord(newWord);

        //TODO: spostare in un thread ma nella funzione di salvataggio
        if(m_bDictionaryUpdated)
        {
            m_dictionary->saveDictionaryToFile();
        }
    }

    delete newWord;

    m_dialNewWord->close();
}

void FastSMSWidget::enableQwerty()
{
    m_layoutManager->enableQwerty();
}

/** Method called by external app. Behaviour must be like virtual keyboard**/
void FastSMSWidget::surroundRequest(const QString &text)
{
#if defined(Q_WS_MAEMO_5)
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    if(m_bStandalone)
        setStandalone(false);

    if(!m_bOSForceAutorotation)
        m_sCurrOrientation = getDeviceOrientation();

    loadPreferedKb();
    m_textProcessor->setText(text);
    showMaximized();
    raise();
}

/** Method called by desktop icon **/
void FastSMSWidget::standalone()
{
    if(!m_bStandalone)
        setStandalone(true);

    loadPreferedKb();
    showMaximized();
    raise();
}

/** For MAEMO5 ask to DBus current orientation, empty string otherwise **/
QString FastSMSWidget::getDeviceOrientation()
{
    QString sOrientation;

#if defined(Q_WS_MAEMO_5)
    QDBusInterface iface("com.nokia.mce","/com/nokia/mce/request","com.nokia.mce.request",QDBusConnection::systemBus());
    QDBusPendingReply<QString, QString, QString, int, int, int> reply;
    reply = iface.call("get_device_orientation");
    reply.waitForFinished();
    sOrientation = reply.argumentAt(0).toString();
    if(reply.isError())
        qWarning() << "Can't retrive start orientation:" << reply.error();
    else
        qDebug() << "Orientation from DBus:" << sOrientation;

    if(sOrientation.compare("unknown") == 0)
        sOrientation = Core::ORIENTATION_LANDSCAPE;

#else
    sOrientation = "";
#endif

    return sOrientation;
}

QString FastSMSWidget::commitRequest()
{
//    QString msg = m_textProcessor->requestCommit();
//    qDebug() << "msg_3:" << msg;
//    //return msg;
//    qDebug() << "msg_4:" << m_textProcessor->getText();;
//    return m_textProcessor->getText();
    return "";
}

void FastSMSWidget::actionMenu(int nAction)
{
    if(SettingsMenu::Options == nAction)
    {
        openOptionDialog();
    }
    else if(SettingsMenu::NewWord == nAction)
    {
        insertNewWord(false);
    }
    else if(SettingsMenu::Symbols == nAction)
    {
        insertNewWord(true);
    }
}












