/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef SETTINGSMENU_H
#define SETTINGSMENU_H

#include <QObject>
#include <QAction>
#include <QMenu>
#include "core.h"

class SettingsMenu : public QMenu
{
    Q_OBJECT
public:
    static SettingsMenu* instance(QWidget *parent = 0);
    enum inputStyle {AutoCapitalize, UpperCase, LowerCase, DigitOnly, FastWriteOff, FastWriteOn, QwertyOn, AlfanumOn, Options, NewWord};
    ~SettingsMenu();
    void updateMenu(int);

public slots:
    void actionPerformed();

signals:
    void inputStyleChanged(int);

private:
    explicit SettingsMenu(QWidget *parent = 0);
    static SettingsMenu* m_instance;
    static void drop();
    void qwertyEnabled();
    void alfanumEnabled();

    QAction *m_aEnableQwerty;
    QAction *m_aEnableAlfanum;
    QAction *m_aFastWrite;
    QAction *m_aAutoCapitalization;
    QAction *m_aUpperCase;
    QAction *m_aLowerCase;
    QAction *m_aDigit;
    QAction *m_aOptions;
    QAction *m_aNewWord;

};

#endif // SETTINGSMENU_H
