/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef KEYBOARDMANAGER_H
#define KEYBOARDMANAGER_H

#include <QWidget>
#include <QSettings>
#include "core.h"

namespace Ui {
    class KeyboardManager;
}

class KeyboardManager : public QWidget
{
    Q_OBJECT

public:
    explicit KeyboardManager(QWidget *parent = 0);
    ~KeyboardManager();
    void enableQwerty();
    void enableAlfanum();

public slots:
    void settingsChanged(int);
//    void orientationChanged(QString);
    void processInput(QString, Core::Keyboards);

signals:
    void inputStyleChanged(int);
    void input(QString, Core::Keyboards);

private:
    Ui::KeyboardManager *ui;
    QString m_sCurrentOrientation;
    QSettings *m_settings;
};

#endif // KEYBOARDMANAGER_H
