/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "kb_alfanum.h"
#include "ui_kb_alfanum.h"

kb_AlfaNum::kb_AlfaNum(QWidget *parent) :
        Keyboard(parent),
        ui(new Ui::kb_AlfaNum)
{
    ui->setupUi(this);

    SettingsMenu *menu = SettingsMenu::instance(this);
    ui->btSettings->setMenu(menu);
    connect(menu,SIGNAL(inputStyleChanged(int)),this,SLOT(settingsChanged(int)));

    m_settingsMenu = qobject_cast<SettingsMenu *> (ui->btSettings->menu());

    connect(ui->btOne,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btTwo,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btThree,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btFour,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btFive,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btSix,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btSeven,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btEight,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btNine,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btZero,SIGNAL(released()),this, SLOT(inputClicked()));
    connect(ui->btNext,SIGNAL(released()),this, SLOT(nextWordClicked()));
    connect(ui->btPrev,SIGNAL(released()),this, SLOT(prevWordClicked()));
    connect(ui->btMoveCurNext,SIGNAL(released()),this, SLOT(moveRightClicked()));
    connect(ui->btMoveCurPrev,SIGNAL(released()),this, SLOT(moveLeftClicked()));
    connect(ui->btDelChar,SIGNAL(released()),this, SLOT(deleteClicked()));
}

kb_AlfaNum::~kb_AlfaNum()
{
    delete ui;
}

void kb_AlfaNum::inputClicked()
{
    QPushButton *clickedButton = qobject_cast<QPushButton *>(sender());
    QString lastPress = clickedButton->text().at(0);

    emit input(lastPress,Core::Alfanumeric);
}

void kb_AlfaNum::nextWordClicked()
{
    emit input(NEXTWORD,Core::Alfanumeric);
}

void kb_AlfaNum::prevWordClicked()
{
    emit input(PREVWORD,Core::Alfanumeric);
}
void kb_AlfaNum::moveRightClicked()
{
    emit input(MOVERIGHT,Core::Alfanumeric);
}

void kb_AlfaNum::moveLeftClicked()
{
    emit input(MOVELEFT,Core::Alfanumeric);
}

void kb_AlfaNum::deleteClicked()
{
    emit input(DELETE,Core::Alfanumeric);
}

