/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "settingsmenu.h"
#include "dialogsettings.h"
#include "fastsmswidget.h"
#include <QDebug>
#include <QSettings>


SettingsMenu* SettingsMenu::m_instance;

SettingsMenu::SettingsMenu(QWidget *parent) :
    QMenu(parent)
{
    //Add menu for functions button
    setTitle("Functions");

    QSettings settings;

    m_aEnableQwerty = new QAction(Core::LBL_QWERTY,this);
    m_aEnableQwerty->setData(QwertyOn);
    connect(m_aEnableQwerty,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aEnableQwerty);

    m_aEnableAlfanum = new QAction(Core::LBL_ALFANUM,this);
    m_aEnableAlfanum->setData(AlfanumOn);
    connect(m_aEnableAlfanum,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aEnableAlfanum);

    addSeparator();

    m_aFastWrite = new QAction(Core::LBL_FASTWRITE_OFF,this);
    m_aFastWrite->setData(FastWriteOff);
    connect(m_aFastWrite,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aFastWrite);

    addSeparator();

    m_aAutoCapitalization = new QAction(Core::LBL_AUTOCAPITALIZATION,this);
    m_aAutoCapitalization->setData(AutoCapitalize);
    connect(m_aAutoCapitalization,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aAutoCapitalization);

    m_aUpperCase = new QAction(Core::LBL_UPPERCASE,this);
    m_aUpperCase->setData(UpperCase);
    connect(m_aUpperCase,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aUpperCase);

    m_aLowerCase = new QAction(Core::LBL_LOWERCASE,this);
    m_aLowerCase->setData(LowerCase);
    connect(m_aLowerCase,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aLowerCase);

    m_aDigit = new QAction(Core::LBL_DIGIT,this);
    m_aDigit->setData(DigitOnly);
    connect(m_aDigit,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aDigit);

    addSeparator();

    m_aOptions = new QAction("Settings",this);
    m_aOptions->setData(Options);
    connect(m_aOptions,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aOptions);

    m_aNewWord = new QAction("New Word",this);
    m_aNewWord->setData(NewWord);
    connect(m_aNewWord,SIGNAL(triggered()),this, SLOT(actionPerformed()));
    addAction(m_aNewWord);
    //

    //Synchronize with active kb
    if(settings.value(Core::SETTING_CURRENT_KEYBOARD) == (Core::Qwerty))
        qwertyEnabled();
    else
        alfanumEnabled();
}

SettingsMenu* SettingsMenu::instance(QWidget *parent)
{
    if(!m_instance)
        m_instance = new SettingsMenu(parent);

    return m_instance;
}

void SettingsMenu::drop()
{
    delete m_instance;
    m_instance = 0;
}

SettingsMenu::~SettingsMenu()
{
    if(!m_instance)
        drop();
}

void SettingsMenu::actionPerformed()
{
    QAction *action = qobject_cast<QAction *>(sender());

    int nAction = action->data().toInt();

    switch (nAction)
    {
    case AutoCapitalize:
        break;
    case UpperCase:
        break;
    case LowerCase:
        break;
    case DigitOnly:
        break;
    case FastWriteOn:
        m_aFastWrite->setText(Core::LBL_FASTWRITE_OFF);
        m_aFastWrite->setData(SettingsMenu::FastWriteOff);
        break;
    case FastWriteOff:
        m_aFastWrite->setText(Core::LBL_FASTWRITE_ON);
        m_aFastWrite->setData(SettingsMenu::FastWriteOn);
        break;
    case QwertyOn:
        qwertyEnabled();
        break;
    case AlfanumOn:
        alfanumEnabled();
        break;
    case Options:
        break;
    case NewWord:
        break;
    }

    emit inputStyleChanged(nAction);
}

void SettingsMenu::qwertyEnabled()
{
    m_aEnableAlfanum->setVisible(true);
    m_aEnableQwerty->setVisible(false);
    m_aDigit->setVisible(false);
    m_aFastWrite->setVisible(false);
    m_aUpperCase->setVisible(false);
}

void SettingsMenu::alfanumEnabled()
{
    m_aEnableAlfanum->setVisible(false);
    m_aEnableQwerty->setVisible(true);
    m_aDigit->setVisible(true);
    m_aFastWrite->setVisible(true);
    m_aUpperCase->setVisible(true);
}

void SettingsMenu::updateMenu(int nActiveKeyboard)
{
    if(nActiveKeyboard == Core::Qwerty)
        qwertyEnabled();
    else
        alfanumEnabled();
}

